/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_eventlog6.h"

/* eventlog6 - dcerpc server boilerplate generated by pidl */


static NTSTATUS eventlog6__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface, uint32_t if_version)
{
#ifdef DCESRV_INTERFACE_EVENTLOG6_BIND
	return DCESRV_INTERFACE_EVENTLOG6_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void eventlog6__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_EVENTLOG6_UNBIND
	DCESRV_INTERFACE_EVENTLOG6_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS eventlog6__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_eventlog6.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_eventlog6.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_eventlog6.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_eventlog6.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_eventlog6, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS eventlog6__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct eventlog6_EvtRpcRegisterRemoteSubscription *r2 = (struct eventlog6_EvtRpcRegisterRemoteSubscription *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRegisterRemoteSubscription, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcRegisterRemoteSubscription(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRegisterRemoteSubscription will reply async\n"));
		}
		break;
	}
	case 1: {
		struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r2 = (struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRemoteSubscriptionNextAsync, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcRemoteSubscriptionNextAsync(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRemoteSubscriptionNextAsync will reply async\n"));
		}
		break;
	}
	case 2: {
		struct eventlog6_EvtRpcRemoteSubscriptionNext *r2 = (struct eventlog6_EvtRpcRemoteSubscriptionNext *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRemoteSubscriptionNext, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcRemoteSubscriptionNext(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRemoteSubscriptionNext will reply async\n"));
		}
		break;
	}
	case 3: {
		struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r2 = (struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRemoteSubscriptionWaitAsync, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcRemoteSubscriptionWaitAsync(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRemoteSubscriptionWaitAsync will reply async\n"));
		}
		break;
	}
	case 4: {
		struct eventlog6_EvtRpcRegisterControllableOperation *r2 = (struct eventlog6_EvtRpcRegisterControllableOperation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRegisterControllableOperation, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcRegisterControllableOperation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRegisterControllableOperation will reply async\n"));
		}
		break;
	}
	case 5: {
		struct eventlog6_EvtRpcRegisterLogQuery *r2 = (struct eventlog6_EvtRpcRegisterLogQuery *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRegisterLogQuery, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcRegisterLogQuery(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRegisterLogQuery will reply async\n"));
		}
		break;
	}
	case 6: {
		struct eventlog6_EvtRpcClearLog *r2 = (struct eventlog6_EvtRpcClearLog *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcClearLog, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcClearLog(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcClearLog will reply async\n"));
		}
		break;
	}
	case 7: {
		struct eventlog6_EvtRpcExportLog *r2 = (struct eventlog6_EvtRpcExportLog *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcExportLog, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcExportLog(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcExportLog will reply async\n"));
		}
		break;
	}
	case 8: {
		struct eventlog6_EvtRpcLocalizeExportLog *r2 = (struct eventlog6_EvtRpcLocalizeExportLog *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcLocalizeExportLog, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcLocalizeExportLog(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcLocalizeExportLog will reply async\n"));
		}
		break;
	}
	case 9: {
		struct eventlog6_EvtRpcMessageRender *r2 = (struct eventlog6_EvtRpcMessageRender *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcMessageRender, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcMessageRender(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcMessageRender will reply async\n"));
		}
		break;
	}
	case 10: {
		struct eventlog6_EvtRpcMessageRenderDefault *r2 = (struct eventlog6_EvtRpcMessageRenderDefault *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcMessageRenderDefault, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcMessageRenderDefault(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcMessageRenderDefault will reply async\n"));
		}
		break;
	}
	case 11: {
		struct eventlog6_EvtRpcQueryNext *r2 = (struct eventlog6_EvtRpcQueryNext *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcQueryNext, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcQueryNext(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcQueryNext will reply async\n"));
		}
		break;
	}
	case 12: {
		struct eventlog6_EvtRpcQuerySeek *r2 = (struct eventlog6_EvtRpcQuerySeek *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcQuerySeek, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcQuerySeek(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcQuerySeek will reply async\n"));
		}
		break;
	}
	case 13: {
		struct eventlog6_EvtRpcClose *r2 = (struct eventlog6_EvtRpcClose *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcClose, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcClose(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcClose will reply async\n"));
		}
		break;
	}
	case 14: {
		struct eventlog6_EvtRpcCancel *r2 = (struct eventlog6_EvtRpcCancel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcCancel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcCancel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcCancel will reply async\n"));
		}
		break;
	}
	case 15: {
		struct eventlog6_EvtRpcAssertConfig *r2 = (struct eventlog6_EvtRpcAssertConfig *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcAssertConfig, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcAssertConfig(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcAssertConfig will reply async\n"));
		}
		break;
	}
	case 16: {
		struct eventlog6_EvtRpcRetractConfig *r2 = (struct eventlog6_EvtRpcRetractConfig *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRetractConfig, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcRetractConfig(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRetractConfig will reply async\n"));
		}
		break;
	}
	case 17: {
		struct eventlog6_EvtRpcOpenLogHandle *r2 = (struct eventlog6_EvtRpcOpenLogHandle *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcOpenLogHandle, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcOpenLogHandle(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcOpenLogHandle will reply async\n"));
		}
		break;
	}
	case 18: {
		struct eventlog6_EvtRpcGetLogFileInfo *r2 = (struct eventlog6_EvtRpcGetLogFileInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetLogFileInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetLogFileInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetLogFileInfo will reply async\n"));
		}
		break;
	}
	case 19: {
		struct eventlog6_EvtRpcGetChannelList *r2 = (struct eventlog6_EvtRpcGetChannelList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetChannelList, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetChannelList(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetChannelList will reply async\n"));
		}
		break;
	}
	case 20: {
		struct eventlog6_EvtRpcGetChannelConfig *r2 = (struct eventlog6_EvtRpcGetChannelConfig *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetChannelConfig, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetChannelConfig(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetChannelConfig will reply async\n"));
		}
		break;
	}
	case 21: {
		struct eventlog6_EvtRpcPutChannelConfig *r2 = (struct eventlog6_EvtRpcPutChannelConfig *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcPutChannelConfig, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcPutChannelConfig(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcPutChannelConfig will reply async\n"));
		}
		break;
	}
	case 22: {
		struct eventlog6_EvtRpcGetPublisherList *r2 = (struct eventlog6_EvtRpcGetPublisherList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetPublisherList, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetPublisherList(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetPublisherList will reply async\n"));
		}
		break;
	}
	case 23: {
		struct eventlog6_EvtRpcGetPublisherListForChannel *r2 = (struct eventlog6_EvtRpcGetPublisherListForChannel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetPublisherListForChannel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetPublisherListForChannel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetPublisherListForChannel will reply async\n"));
		}
		break;
	}
	case 24: {
		struct eventlog6_EvtRpcGetPublisherMetadata *r2 = (struct eventlog6_EvtRpcGetPublisherMetadata *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetPublisherMetadata, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetPublisherMetadata(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetPublisherMetadata will reply async\n"));
		}
		break;
	}
	case 25: {
		struct eventlog6_EvtRpcGetPublisherResourceMetadata *r2 = (struct eventlog6_EvtRpcGetPublisherResourceMetadata *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetPublisherResourceMetadata, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetPublisherResourceMetadata(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetPublisherResourceMetadata will reply async\n"));
		}
		break;
	}
	case 26: {
		struct eventlog6_EvtRpcGetEventMetadataEnum *r2 = (struct eventlog6_EvtRpcGetEventMetadataEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetEventMetadataEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetEventMetadataEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetEventMetadataEnum will reply async\n"));
		}
		break;
	}
	case 27: {
		struct eventlog6_EvtRpcGetNextEventMetadata *r2 = (struct eventlog6_EvtRpcGetNextEventMetadata *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetNextEventMetadata, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetNextEventMetadata(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetNextEventMetadata will reply async\n"));
		}
		break;
	}
	case 28: {
		struct eventlog6_EvtRpcGetClassicLogDisplayName *r2 = (struct eventlog6_EvtRpcGetClassicLogDisplayName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetClassicLogDisplayName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_eventlog6_EvtRpcGetClassicLogDisplayName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetClassicLogDisplayName will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_eventlog6, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS eventlog6__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct eventlog6_EvtRpcRegisterRemoteSubscription *r2 = (struct eventlog6_EvtRpcRegisterRemoteSubscription *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRegisterRemoteSubscription replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRegisterRemoteSubscription, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcRegisterRemoteSubscription\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r2 = (struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRemoteSubscriptionNextAsync replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRemoteSubscriptionNextAsync, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcRemoteSubscriptionNextAsync\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct eventlog6_EvtRpcRemoteSubscriptionNext *r2 = (struct eventlog6_EvtRpcRemoteSubscriptionNext *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRemoteSubscriptionNext replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRemoteSubscriptionNext, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcRemoteSubscriptionNext\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r2 = (struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRemoteSubscriptionWaitAsync replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRemoteSubscriptionWaitAsync, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcRemoteSubscriptionWaitAsync\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct eventlog6_EvtRpcRegisterControllableOperation *r2 = (struct eventlog6_EvtRpcRegisterControllableOperation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRegisterControllableOperation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRegisterControllableOperation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcRegisterControllableOperation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct eventlog6_EvtRpcRegisterLogQuery *r2 = (struct eventlog6_EvtRpcRegisterLogQuery *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRegisterLogQuery replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRegisterLogQuery, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcRegisterLogQuery\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct eventlog6_EvtRpcClearLog *r2 = (struct eventlog6_EvtRpcClearLog *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcClearLog replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcClearLog, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcClearLog\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct eventlog6_EvtRpcExportLog *r2 = (struct eventlog6_EvtRpcExportLog *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcExportLog replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcExportLog, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcExportLog\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct eventlog6_EvtRpcLocalizeExportLog *r2 = (struct eventlog6_EvtRpcLocalizeExportLog *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcLocalizeExportLog replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcLocalizeExportLog, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcLocalizeExportLog\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct eventlog6_EvtRpcMessageRender *r2 = (struct eventlog6_EvtRpcMessageRender *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcMessageRender replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcMessageRender, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcMessageRender\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct eventlog6_EvtRpcMessageRenderDefault *r2 = (struct eventlog6_EvtRpcMessageRenderDefault *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcMessageRenderDefault replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcMessageRenderDefault, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcMessageRenderDefault\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct eventlog6_EvtRpcQueryNext *r2 = (struct eventlog6_EvtRpcQueryNext *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcQueryNext replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcQueryNext, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcQueryNext\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct eventlog6_EvtRpcQuerySeek *r2 = (struct eventlog6_EvtRpcQuerySeek *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcQuerySeek replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcQuerySeek, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcQuerySeek\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct eventlog6_EvtRpcClose *r2 = (struct eventlog6_EvtRpcClose *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcClose replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcClose, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcClose\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct eventlog6_EvtRpcCancel *r2 = (struct eventlog6_EvtRpcCancel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcCancel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcCancel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcCancel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct eventlog6_EvtRpcAssertConfig *r2 = (struct eventlog6_EvtRpcAssertConfig *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcAssertConfig replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcAssertConfig, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcAssertConfig\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct eventlog6_EvtRpcRetractConfig *r2 = (struct eventlog6_EvtRpcRetractConfig *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcRetractConfig replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcRetractConfig, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcRetractConfig\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct eventlog6_EvtRpcOpenLogHandle *r2 = (struct eventlog6_EvtRpcOpenLogHandle *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcOpenLogHandle replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcOpenLogHandle, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcOpenLogHandle\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct eventlog6_EvtRpcGetLogFileInfo *r2 = (struct eventlog6_EvtRpcGetLogFileInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetLogFileInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetLogFileInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetLogFileInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct eventlog6_EvtRpcGetChannelList *r2 = (struct eventlog6_EvtRpcGetChannelList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetChannelList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetChannelList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetChannelList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct eventlog6_EvtRpcGetChannelConfig *r2 = (struct eventlog6_EvtRpcGetChannelConfig *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetChannelConfig replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetChannelConfig, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetChannelConfig\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct eventlog6_EvtRpcPutChannelConfig *r2 = (struct eventlog6_EvtRpcPutChannelConfig *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcPutChannelConfig replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcPutChannelConfig, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcPutChannelConfig\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct eventlog6_EvtRpcGetPublisherList *r2 = (struct eventlog6_EvtRpcGetPublisherList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetPublisherList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetPublisherList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetPublisherList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct eventlog6_EvtRpcGetPublisherListForChannel *r2 = (struct eventlog6_EvtRpcGetPublisherListForChannel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetPublisherListForChannel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetPublisherListForChannel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetPublisherListForChannel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct eventlog6_EvtRpcGetPublisherMetadata *r2 = (struct eventlog6_EvtRpcGetPublisherMetadata *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetPublisherMetadata replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetPublisherMetadata, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetPublisherMetadata\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct eventlog6_EvtRpcGetPublisherResourceMetadata *r2 = (struct eventlog6_EvtRpcGetPublisherResourceMetadata *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetPublisherResourceMetadata replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetPublisherResourceMetadata, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetPublisherResourceMetadata\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct eventlog6_EvtRpcGetEventMetadataEnum *r2 = (struct eventlog6_EvtRpcGetEventMetadataEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetEventMetadataEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetEventMetadataEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetEventMetadataEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct eventlog6_EvtRpcGetNextEventMetadata *r2 = (struct eventlog6_EvtRpcGetNextEventMetadata *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetNextEventMetadata replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetNextEventMetadata, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetNextEventMetadata\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct eventlog6_EvtRpcGetClassicLogDisplayName *r2 = (struct eventlog6_EvtRpcGetClassicLogDisplayName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function eventlog6_EvtRpcGetClassicLogDisplayName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(eventlog6_EvtRpcGetClassicLogDisplayName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in eventlog6_EvtRpcGetClassicLogDisplayName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_eventlog6, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS eventlog6__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_eventlog6.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_eventlog6_interface = {
	.name		= "eventlog6",
	.syntax_id  = {{0xf6beaff7,0x1e19,0x4fbb,{0x9f,0x8f},{0xb8,0x9e,0x20,0x18,0x33,0x7c}},1.0},
	.bind		= eventlog6__op_bind,
	.unbind		= eventlog6__op_unbind,
	.ndr_pull	= eventlog6__op_ndr_pull,
	.dispatch	= eventlog6__op_dispatch,
	.reply		= eventlog6__op_reply,
	.ndr_push	= eventlog6__op_ndr_push
};


static NTSTATUS eventlog6__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_eventlog6.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_eventlog6.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_eventlog6_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("eventlog6_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool eventlog6__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_eventlog6_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_eventlog6_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_eventlog6_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool eventlog6__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_eventlog6_interface.name, name)==0) {
		memcpy(iface, &dcesrv_eventlog6_interface, sizeof(*iface));
		return true;
	}

	return false;	
}
	
NTSTATUS dcerpc_server_eventlog6_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "eventlog6";

	/* fill in all the operations */
	ep_server.init_server = eventlog6__op_init_server;

	ep_server.interface_by_uuid = eventlog6__op_interface_by_uuid;
	ep_server.interface_by_name = eventlog6__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'eventlog6' endpoint server!\n"));
		return ret;
	}

	return ret;
}

