/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "ntdomain.h"
#include "librpc/gen_ndr/srv_remact.h"

static bool api_RemoteActivation(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct RemoteActivation *r;

	call = &ndr_table_IRemoteActivation.calls[NDR_REMOTEACTIVATION];

	r = talloc(talloc_tos(), struct RemoteActivation);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemoteActivation, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.that = talloc_zero(r, struct ORPCTHAT);
	if (r->out.that == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pOxid = talloc_zero(r, uint64_t);
	if (r->out.pOxid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pdsaOxidBindings = talloc_zero(r, struct DUALSTRINGARRAY);
	if (r->out.pdsaOxidBindings == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ipidRemUnknown = talloc_zero(r, struct GUID);
	if (r->out.ipidRemUnknown == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.AuthnHint = talloc_zero(r, uint32_t);
	if (r->out.AuthnHint == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ServerVersion = talloc_zero(r, struct COMVERSION);
	if (r->out.ServerVersion == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.hr = talloc_zero(r, WERROR);
	if (r->out.hr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ifaces = talloc_zero_array(r, struct MInterfacePointer *, r->in.Interfaces);
	if (r->out.ifaces == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.results = talloc_zero_array(r, WERROR, r->in.Interfaces);
	if (r->out.results == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemoteActivation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(RemoteActivation, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IRemoteActivation_cmds[] = 
{
	{"REMOTEACTIVATION", NDR_REMOTEACTIVATION, api_RemoteActivation},
};

void IRemoteActivation_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IRemoteActivation_cmds;
	*n_fns = sizeof(api_IRemoteActivation_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IRemoteActivation_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IRemoteActivation", "IRemoteActivation", &ndr_table_IRemoteActivation, api_IRemoteActivation_cmds, sizeof(api_IRemoteActivation_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_IRemoteActivation_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_IRemoteActivation);
}
