/* header auto-generated by pidl */

#include <stdint.h>

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/nbt.h"
#ifndef _HEADER_netlogon
#define _HEADER_netlogon

#define DSGETDC_VALID_FLAGS	( (DS_FORCE_REDISCOVERY|DS_DIRECTORY_SERVICE_REQUIRED|DS_DIRECTORY_SERVICE_PREFERRED|DS_GC_SERVER_REQUIRED|DS_PDC_REQUIRED|DS_BACKGROUND_ONLY|DS_IP_REQUIRED|DS_KDC_REQUIRED|DS_TIMESERV_REQUIRED|DS_WRITABLE_REQUIRED|DS_GOOD_TIMESERV_PREFERRED|DS_AVOID_SELF|DS_ONLY_LDAP_NEEDED|DS_IS_FLAT_NAME|DS_IS_DNS_NAME|DS_RETURN_FLAT_NAME|DS_RETURN_DNS_NAME) )
#define DS_GFTI_UPDATE_TDO	( 0x1 )
struct netr_UasInfo {
	const char *account_name;/* [unique,charset(UTF16)] */
	uint32_t priv;
	uint32_t auth_flags;
	uint32_t logon_count;
	uint32_t bad_pw_count;
	time_t last_logon;
	time_t last_logoff;
	time_t logoff_time;
	time_t kickoff_time;
	uint32_t password_age;
	time_t pw_can_change;
	time_t pw_must_change;
	const char *computer;/* [unique,charset(UTF16)] */
	const char *domain;/* [unique,charset(UTF16)] */
	const char *script_path;/* [unique,charset(UTF16)] */
	uint32_t unknown;
};

struct netr_UasLogoffInfo {
	uint32_t duration;
	uint16_t logon_count;
};

struct netr_AcctLockStr {
	int64_t lockout_duration;
	uint64_t reset_count;
	uint32_t bad_attempt_lockout;
	uint32_t dummy;
}/* [public] */;

/* bitmap netr_LogonParameterControl */
#define MSV1_0_CLEARTEXT_PASSWORD_ALLOWED ( 0x00000002 )
#define MSV1_0_UPDATE_LOGON_STATISTICS ( 0x00000004 )
#define MSV1_0_RETURN_USER_PARAMETERS ( 0x00000008 )
#define MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT ( 0x00000020 )
#define MSV1_0_RETURN_PROFILE_PATH ( 0x00000200 )
#define MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT ( 0x00000800 )

struct netr_IdentityInfo {
	struct lsa_String domain_name;
	uint32_t parameter_control;
	uint32_t logon_id_low;
	uint32_t logon_id_high;
	struct lsa_String account_name;
	struct lsa_String workstation;
};

struct netr_PasswordInfo {
	struct netr_IdentityInfo identity_info;
	struct samr_Password lmpassword;
	struct samr_Password ntpassword;
};

struct netr_ChallengeResponse {
	uint16_t length;
	uint16_t size;/* [value(length)] */
	uint8_t *data;/* [unique,length_is(length),size_is(length)] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_NetworkInfo {
	struct netr_IdentityInfo identity_info;
	uint8_t challenge[8];
	struct netr_ChallengeResponse nt;
	struct netr_ChallengeResponse lm;
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

union netr_LogonInfo {
	struct netr_PasswordInfo *password;/* [unique,case] */
	struct netr_NetworkInfo *network;/* [unique,case(2)] */
}/* [public,switch_type(uint16)] */;

struct netr_UserSessionKey {
	uint8_t key[16];
}/* [public,flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_LMSessionKey {
	uint8_t key[8];
}/* [public,flag(LIBNDR_PRINT_ARRAY_HEX)] */;

/* bitmap netr_UserFlags */
#define NETLOGON_GUEST ( 0x00000001 )
#define NETLOGON_NOENCRYPTION ( 0x00000002 )
#define NETLOGON_CACHED_ACCOUNT ( 0x00000004 )
#define NETLOGON_USED_LM_PASSWORD ( 0x00000008 )
#define NETLOGON_EXTRA_SIDS ( 0x00000020 )
#define NETLOGON_SUBAUTH_SESSION_KEY ( 0x00000040 )
#define NETLOGON_SERVER_TRUST_ACCOUNT ( 0x00000080 )
#define NETLOGON_NTLMV2_ENABLED ( 0x00000100 )
#define NETLOGON_RESOURCE_GROUPS ( 0x00000200 )
#define NETLOGON_PROFILE_PATH_RETURNED ( 0x00000400 )
#define NETLOGON_GRACE_LOGON ( 0x01000000 )

struct netr_SamBaseInfo {
	NTTIME last_logon;
	NTTIME last_logoff;
	NTTIME acct_expiry;
	NTTIME last_password_change;
	NTTIME allow_password_change;
	NTTIME force_password_change;
	struct lsa_String account_name;
	struct lsa_String full_name;
	struct lsa_String logon_script;
	struct lsa_String profile_path;
	struct lsa_String home_directory;
	struct lsa_String home_drive;
	uint16_t logon_count;
	uint16_t bad_password_count;
	uint32_t rid;
	uint32_t primary_gid;
	struct samr_RidWithAttributeArray groups;
	uint32_t user_flags;
	struct netr_UserSessionKey key;
	struct lsa_StringLarge logon_server;
	struct lsa_StringLarge domain;
	struct dom_sid2 *domain_sid;/* [unique] */
	struct netr_LMSessionKey LMSessKey;
	uint32_t acct_flags;
	uint32_t unknown[7];
};

struct netr_SamInfo2 {
	struct netr_SamBaseInfo base;
};

struct netr_SidAttr {
	struct dom_sid2 *sid;/* [unique] */
	uint32_t attributes;
};

struct netr_SamInfo3 {
	struct netr_SamBaseInfo base;
	uint32_t sidcount;
	struct netr_SidAttr *sids;/* [unique,size_is(sidcount)] */
}/* [public] */;

struct netr_SamInfo6 {
	struct netr_SamBaseInfo base;
	uint32_t sidcount;
	struct netr_SidAttr *sids;/* [unique,size_is(sidcount)] */
	struct lsa_String forest;
	struct lsa_String principle;
	uint32_t unknown4[20];
};

struct netr_PacInfo {
	uint32_t pac_size;
	uint8_t *pac;/* [unique,size_is(pac_size)] */
	struct lsa_String logon_domain;
	struct lsa_String logon_server;
	struct lsa_String principal_name;
	uint32_t auth_size;
	uint8_t *auth;/* [unique,size_is(auth_size)] */
	struct netr_UserSessionKey user_session_key;
	uint32_t expansionroom[10];
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
};

union netr_Validation {
	struct netr_SamInfo2 *sam2;/* [unique,case(2)] */
	struct netr_SamInfo3 *sam3;/* [unique,case(3)] */
	struct netr_PacInfo *pac;/* [unique,case(4)] */
	struct netr_SamInfo6 *sam6;/* [unique,case(6)] */
}/* [public,switch_type(uint16)] */;

struct netr_Credential {
	uint8_t data[8];
}/* [public,flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_Authenticator {
	struct netr_Credential cred;
	time_t timestamp;
}/* [public] */;

enum netr_LogonLevel
#ifndef USE_UINT_ENUMS
 {
	INTERACTIVE_LOGON_TYPE=1,
	NET_LOGON_TYPE=2
}
#else
 { __donnot_use_enum_netr_LogonLevel=0x7FFFFFFF}
#define INTERACTIVE_LOGON_TYPE ( 1 )
#define NET_LOGON_TYPE ( 2 )
#endif
;

enum netr_SchannelType;

enum netr_SamDatabaseID;

struct netr_DELTA_DELETE_USER {
	const char *account_name;/* [unique,charset(UTF16)] */
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_USER_KEY16 {
	uint16_t length;
	uint16_t size;/* [value(length)] */
	uint32_t flags;
	struct samr_Password pwd;
};

struct netr_PasswordHistory {
	uint16_t nt_length;
	uint16_t nt_size;/* [value(nt_length)] */
	uint32_t nt_flags;
	uint16_t lm_length;
	uint16_t lm_size;/* [value(lm_length)] */
	uint32_t lm_flags;
	uint8_t *nt_history;
	uint8_t *lm_history;
};

struct netr_USER_KEYS2 {
	struct netr_USER_KEY16 lmpassword;
	struct netr_USER_KEY16 ntpassword;
	struct netr_PasswordHistory history;
};

struct netr_USER_KEY_UNION {
	struct netr_USER_KEYS2 keys2;
};

struct netr_USER_KEYS {
	uint32_t version;
	struct netr_USER_KEY_UNION keys;
}/* [public] */;

struct netr_USER_PRIVATE_INFO {
	uint8_t SensitiveDataFlag;
	uint32_t DataLength;
	uint8_t *SensitiveData;/* [unique,flag(LIBNDR_PRINT_ARRAY_HEX),size_is(DataLength)] */
};

struct netr_DELTA_USER {
	struct lsa_String account_name;
	struct lsa_String full_name;
	uint32_t rid;
	uint32_t primary_gid;
	struct lsa_String home_directory;
	struct lsa_String home_drive;
	struct lsa_String logon_script;
	struct lsa_String description;
	struct lsa_String workstations;
	NTTIME last_logon;
	NTTIME last_logoff;
	struct samr_LogonHours logon_hours;
	uint16_t bad_password_count;
	uint16_t logon_count;
	NTTIME last_password_change;
	NTTIME acct_expiry;
	uint32_t acct_flags;
	struct samr_Password lmpassword;
	struct samr_Password ntpassword;
	uint8_t nt_password_present;
	uint8_t lm_password_present;
	uint8_t password_expired;
	struct lsa_String comment;
	struct lsa_String parameters;
	uint16_t country_code;
	uint16_t code_page;
	struct netr_USER_PRIVATE_INFO user_private_info;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String profile_path;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_DOMAIN {
	struct lsa_String domain_name;
	struct lsa_String comment;
	int64_t force_logoff_time;
	uint16_t min_password_length;
	uint16_t password_history_length;
	int64_t max_password_age;
	int64_t min_password_age;
	uint64_t sequence_num;
	NTTIME domain_create_time;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_BinaryString account_lockout;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t logon_to_chgpass;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_GROUP {
	struct lsa_String group_name;
	uint32_t rid;
	uint32_t attributes;
	struct lsa_String description;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_RENAME {
	struct lsa_String OldName;
	struct lsa_String NewName;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_GROUP_MEMBER {
	uint32_t *rids;/* [unique,size_is(num_rids)] */
	uint32_t *attribs;/* [unique,size_is(num_rids)] */
	uint32_t num_rids;
	uint32_t unknown1;
	uint32_t unknown2;
	uint32_t unknown3;
	uint32_t unknown4;
};

struct netr_DELTA_ALIAS {
	struct lsa_String alias_name;
	uint32_t rid;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String description;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_ALIAS_MEMBER {
	struct lsa_SidArray sids;
	uint32_t unknown1;
	uint32_t unknown2;
	uint32_t unknown3;
	uint32_t unknown4;
};

struct netr_QUOTA_LIMITS {
	uint32_t pagedpoollimit;
	uint32_t nonpagedpoollimit;
	uint32_t minimumworkingsetsize;
	uint32_t maximumworkingsetsize;
	uint32_t pagefilelimit;
	NTTIME timelimit;
};

struct netr_DELTA_POLICY {
	uint32_t maxlogsize;
	NTTIME auditretentionperiod;
	uint8_t auditingmode;
	uint32_t maxauditeventcount;
	uint32_t *eventauditoptions;/* [unique,size_is(maxauditeventcount+1)] */
	struct lsa_String primary_domain_name;
	struct dom_sid2 *sid;/* [unique] */
	struct netr_QUOTA_LIMITS quota_limits;
	uint64_t sequence_num;
	NTTIME db_create_time;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_TRUSTED_DOMAIN {
	struct lsa_String domain_name;
	uint32_t num_controllers;
	struct lsa_String *controller_names;/* [unique,size_is(num_controllers)] */
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t posix_offset;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_DELETE_TRUST {
	uint16_t unknown;
};

struct netr_DELTA_ACCOUNT {
	uint32_t privilege_entries;
	uint32_t privilege_control;
	uint32_t *privilege_attrib;/* [unique,size_is(privilege_entries)] */
	struct lsa_String *privilege_name;/* [unique,size_is(privilege_entries)] */
	struct netr_QUOTA_LIMITS quotalimits;
	uint32_t system_flags;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_DELETE_ACCOUNT {
	uint16_t unknown;
};

struct netr_DELTA_DELETE_SECRET {
	uint16_t unknown;
};

struct netr_CIPHER_VALUE {
	uint32_t len;
	uint32_t maxlen;
	uint8_t *cipher_data;/* [unique,length_is(len),size_is(maxlen)] */
};

struct netr_DELTA_SECRET {
	struct netr_CIPHER_VALUE current_cipher;
	NTTIME current_cipher_set_time;
	struct netr_CIPHER_VALUE old_cipher;
	NTTIME old_cipher_set_time;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

enum netr_DeltaEnum
#ifndef USE_UINT_ENUMS
 {
	NETR_DELTA_DOMAIN=1,
	NETR_DELTA_GROUP=2,
	NETR_DELTA_DELETE_GROUP=3,
	NETR_DELTA_RENAME_GROUP=4,
	NETR_DELTA_USER=5,
	NETR_DELTA_DELETE_USER=6,
	NETR_DELTA_RENAME_USER=7,
	NETR_DELTA_GROUP_MEMBER=8,
	NETR_DELTA_ALIAS=9,
	NETR_DELTA_DELETE_ALIAS=10,
	NETR_DELTA_RENAME_ALIAS=11,
	NETR_DELTA_ALIAS_MEMBER=12,
	NETR_DELTA_POLICY=13,
	NETR_DELTA_TRUSTED_DOMAIN=14,
	NETR_DELTA_DELETE_TRUST=15,
	NETR_DELTA_ACCOUNT=16,
	NETR_DELTA_DELETE_ACCOUNT=17,
	NETR_DELTA_SECRET=18,
	NETR_DELTA_DELETE_SECRET=19,
	NETR_DELTA_DELETE_GROUP2=20,
	NETR_DELTA_DELETE_USER2=21,
	NETR_DELTA_MODIFY_COUNT=22
}
#else
 { __donnot_use_enum_netr_DeltaEnum=0x7FFFFFFF}
#define NETR_DELTA_DOMAIN ( 1 )
#define NETR_DELTA_GROUP ( 2 )
#define NETR_DELTA_DELETE_GROUP ( 3 )
#define NETR_DELTA_RENAME_GROUP ( 4 )
#define NETR_DELTA_USER ( 5 )
#define NETR_DELTA_DELETE_USER ( 6 )
#define NETR_DELTA_RENAME_USER ( 7 )
#define NETR_DELTA_GROUP_MEMBER ( 8 )
#define NETR_DELTA_ALIAS ( 9 )
#define NETR_DELTA_DELETE_ALIAS ( 10 )
#define NETR_DELTA_RENAME_ALIAS ( 11 )
#define NETR_DELTA_ALIAS_MEMBER ( 12 )
#define NETR_DELTA_POLICY ( 13 )
#define NETR_DELTA_TRUSTED_DOMAIN ( 14 )
#define NETR_DELTA_DELETE_TRUST ( 15 )
#define NETR_DELTA_ACCOUNT ( 16 )
#define NETR_DELTA_DELETE_ACCOUNT ( 17 )
#define NETR_DELTA_SECRET ( 18 )
#define NETR_DELTA_DELETE_SECRET ( 19 )
#define NETR_DELTA_DELETE_GROUP2 ( 20 )
#define NETR_DELTA_DELETE_USER2 ( 21 )
#define NETR_DELTA_MODIFY_COUNT ( 22 )
#endif
;

union netr_DELTA_UNION {
	struct netr_DELTA_DOMAIN *domain;/* [unique,case(NETR_DELTA_DOMAIN)] */
	struct netr_DELTA_GROUP *group;/* [unique,case(NETR_DELTA_GROUP)] */
	struct netr_DELTA_RENAME *rename_group;/* [unique,case(NETR_DELTA_RENAME_GROUP)] */
	struct netr_DELTA_USER *user;/* [unique,case(NETR_DELTA_USER)] */
	struct netr_DELTA_RENAME *rename_user;/* [unique,case(NETR_DELTA_RENAME_USER)] */
	struct netr_DELTA_GROUP_MEMBER *group_member;/* [unique,case(NETR_DELTA_GROUP_MEMBER)] */
	struct netr_DELTA_ALIAS *alias;/* [unique,case(NETR_DELTA_ALIAS)] */
	struct netr_DELTA_RENAME *rename_alias;/* [unique,case(NETR_DELTA_RENAME_ALIAS)] */
	struct netr_DELTA_ALIAS_MEMBER *alias_member;/* [unique,case(NETR_DELTA_ALIAS_MEMBER)] */
	struct netr_DELTA_POLICY *policy;/* [unique,case(NETR_DELTA_POLICY)] */
	struct netr_DELTA_TRUSTED_DOMAIN *trusted_domain;/* [unique,case(NETR_DELTA_TRUSTED_DOMAIN)] */
	struct netr_DELTA_DELETE_TRUST delete_trust;/* [case(NETR_DELTA_DELETE_TRUST)] */
	struct netr_DELTA_ACCOUNT *account;/* [unique,case(NETR_DELTA_ACCOUNT)] */
	struct netr_DELTA_DELETE_ACCOUNT delete_account;/* [case(NETR_DELTA_DELETE_ACCOUNT)] */
	struct netr_DELTA_SECRET *secret;/* [unique,case(NETR_DELTA_SECRET)] */
	struct netr_DELTA_DELETE_SECRET delete_secret;/* [case(NETR_DELTA_DELETE_SECRET)] */
	struct netr_DELTA_DELETE_USER *delete_group;/* [unique,case(NETR_DELTA_DELETE_GROUP2)] */
	struct netr_DELTA_DELETE_USER *delete_user;/* [unique,case(NETR_DELTA_DELETE_USER2)] */
	uint64_t *modified_count;/* [unique,case(NETR_DELTA_MODIFY_COUNT)] */
}/* [switch_type(netr_DeltaEnum)] */;

union netr_DELTA_ID_UNION {
	uint32_t rid;/* [case(NETR_DELTA_DOMAIN)] */
	struct dom_sid2 *sid;/* [unique,case(NETR_DELTA_POLICY)] */
	const char *name;/* [unique,charset(UTF16),case(NETR_DELTA_SECRET)] */
}/* [switch_type(netr_DeltaEnum)] */;

struct netr_DELTA_ENUM {
	enum netr_DeltaEnum delta_type;
	union netr_DELTA_ID_UNION delta_id_union;/* [switch_is(delta_type)] */
	union netr_DELTA_UNION delta_union;/* [switch_is(delta_type)] */
};

struct netr_DELTA_ENUM_ARRAY {
	uint32_t num_deltas;
	struct netr_DELTA_ENUM *delta_enum;/* [unique,size_is(num_deltas)] */
};

struct netr_UAS_INFO_0 {
	uint8_t computer_name[16];
	uint32_t timecreated;
	uint32_t serial_number;
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_AccountBuffer {
	DATA_BLOB blob;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

/* bitmap netr_InfoFlags */
#define NETLOGON_CTRL_REPL_NEEDED ( 0x0001 )
#define NETLOGON_CTRL_REPL_IN_PROGRESS ( 0x0002 )
#define NETLOGON_CTRL_REPL_FULL_SYNC ( 0x0004 )

struct netr_NETLOGON_INFO_1 {
	uint32_t flags;
	uint32_t pdc_connection_status;
};

struct netr_NETLOGON_INFO_2 {
	uint32_t flags;
	uint32_t pdc_connection_status;
	const char *trusted_dc_name;/* [unique,charset(UTF16)] */
	uint32_t tc_connection_status;
};

struct netr_NETLOGON_INFO_3 {
	uint32_t flags;
	uint32_t logon_attempts;
	uint32_t unknown1;
	uint32_t unknown2;
	uint32_t unknown3;
	uint32_t unknown4;
	uint32_t unknown5;
};

union netr_CONTROL_QUERY_INFORMATION {
	struct netr_NETLOGON_INFO_1 *info1;/* [unique,case] */
	struct netr_NETLOGON_INFO_2 *info2;/* [unique,case(2)] */
	struct netr_NETLOGON_INFO_3 *info3;/* [unique,case(3)] */
};

enum netr_LogonControlCode
#ifndef USE_UINT_ENUMS
 {
	NETLOGON_CONTROL_SYNC=2,
	NETLOGON_CONTROL_REDISCOVER=5,
	NETLOGON_CONTROL_TC_QUERY=6,
	NETLOGON_CONTROL_TRANSPORT_NOTIFY=7,
	NETLOGON_CONTROL_SET_DBFLAG=65534
}
#else
 { __donnot_use_enum_netr_LogonControlCode=0x7FFFFFFF}
#define NETLOGON_CONTROL_SYNC ( 2 )
#define NETLOGON_CONTROL_REDISCOVER ( 5 )
#define NETLOGON_CONTROL_TC_QUERY ( 6 )
#define NETLOGON_CONTROL_TRANSPORT_NOTIFY ( 7 )
#define NETLOGON_CONTROL_SET_DBFLAG ( 65534 )
#endif
;

union netr_CONTROL_DATA_INFORMATION {
	const char *domain;/* [unique,charset(UTF16),case(NETLOGON_CONTROL_REDISCOVER)] */
	uint32_t debug_level;/* [case(NETLOGON_CONTROL_SET_DBFLAG)] */
};

/* bitmap netr_NegotiateFlags */
#define NETLOGON_NEG_ACCOUNT_LOCKOUT ( 0x00000001 )
#define NETLOGON_NEG_PERSISTENT_SAMREPL ( 0x00000002 )
#define NETLOGON_NEG_ARCFOUR ( 0x00000004 )
#define NETLOGON_NEG_PROMOTION_COUNT ( 0x00000008 )
#define NETLOGON_NEG_CHANGELOG_BDC ( 0x00000010 )
#define NETLOGON_NEG_FULL_SYNC_REPL ( 0x00000020 )
#define NETLOGON_NEG_MULTIPLE_SIDS ( 0x00000040 )
#define NETLOGON_NEG_REDO ( 0x00000080 )
#define NETLOGON_NEG_PASSWORD_CHANGE_REFUSAL ( 0x00000100 )
#define NETLOGON_NEG_SEND_PASSWORD_INFO_PDC ( 0x00000200 )
#define NETLOGON_NEG_GENERIC_PASSTHROUGH ( 0x00000400 )
#define NETLOGON_NEG_CONCURRENT_RPC ( 0x00000800 )
#define NETLOGON_NEG_AVOID_ACCOUNT_DB_REPL ( 0x00001000 )
#define NETLOGON_NEG_AVOID_SECURITYAUTH_DB_REPL ( 0x00002000 )
#define NETLOGON_NEG_128BIT ( 0x00004000 )
#define NETLOGON_NEG_TRANSITIVE_TRUSTS ( 0x00008000 )
#define NETLOGON_NEG_DNS_DOMAIN_TRUSTS ( 0x00010000 )
#define NETLOGON_NEG_PASSWORD_SET2 ( 0x00020000 )
#define NETLOGON_NEG_GETDOMAININFO ( 0x00040000 )
#define NETLOGON_NEG_CROSS_FOREST_TRUSTS ( 0x00080000 )
#define NETLOGON_NEG_NEUTRALIZE_NT4_EMULATION ( 0x00100000 )
#define NETLOGON_NEG_RODC_PASSTHROUGH ( 0x00200000 )
#define NETLOGON_NEG_AUTHENTICATED_RPC_LSASS ( 0x20000000 )
#define NETLOGON_NEG_SCHANNEL ( 0x40000000 )

struct netr_Blob {
	uint32_t length;
	uint8_t *data;/* [unique,size_is(length)] */
};

/* bitmap netr_DsRGetDCName_flags */
#define DS_FORCE_REDISCOVERY ( 0x00000001 )
#define DS_DIRECTORY_SERVICE_REQUIRED ( 0x00000010 )
#define DS_DIRECTORY_SERVICE_PREFERRED ( 0x00000020 )
#define DS_GC_SERVER_REQUIRED ( 0x00000040 )
#define DS_PDC_REQUIRED ( 0x00000080 )
#define DS_BACKGROUND_ONLY ( 0x00000100 )
#define DS_IP_REQUIRED ( 0x00000200 )
#define DS_KDC_REQUIRED ( 0x00000400 )
#define DS_TIMESERV_REQUIRED ( 0x00000800 )
#define DS_WRITABLE_REQUIRED ( 0x00001000 )
#define DS_GOOD_TIMESERV_PREFERRED ( 0x00002000 )
#define DS_AVOID_SELF ( 0x00004000 )
#define DS_ONLY_LDAP_NEEDED ( 0x00008000 )
#define DS_IS_FLAT_NAME ( 0x00010000 )
#define DS_IS_DNS_NAME ( 0x00020000 )
#define DS_TRY_NEXTCLOSEST_SITE ( 0x00040000 )
#define DS_DIRECTORY_SERVICE_6_REQUIRED ( 0x00080000 )
#define DS_RETURN_DNS_NAME ( 0x40000000 )
#define DS_RETURN_FLAT_NAME ( 0x80000000 )

enum netr_DsRGetDCNameInfo_AddressType
#ifndef USE_UINT_ENUMS
 {
	DS_ADDRESS_TYPE_INET=1,
	DS_ADDRESS_TYPE_NETBIOS=2
}
#else
 { __donnot_use_enum_netr_DsRGetDCNameInfo_AddressType=0x7FFFFFFF}
#define DS_ADDRESS_TYPE_INET ( 1 )
#define DS_ADDRESS_TYPE_NETBIOS ( 2 )
#endif
;

/* bitmap netr_DsR_DcFlags */
#define DS_SERVER_PDC ( NBT_SERVER_PDC )
#define DS_SERVER_GC ( NBT_SERVER_GC )
#define DS_SERVER_LDAP ( NBT_SERVER_LDAP )
#define DS_SERVER_DS ( NBT_SERVER_DS )
#define DS_SERVER_KDC ( NBT_SERVER_KDC )
#define DS_SERVER_TIMESERV ( NBT_SERVER_TIMESERV )
#define DS_SERVER_CLOSEST ( NBT_SERVER_CLOSEST )
#define DS_SERVER_WRITABLE ( NBT_SERVER_WRITABLE )
#define DS_SERVER_GOOD_TIMESERV ( NBT_SERVER_GOOD_TIMESERV )
#define DS_SERVER_NDNC ( NBT_SERVER_NDNC )
#define DS_SERVER_SELECT_SECRET_DOMAIN_6 ( NBT_SERVER_SELECT_SECRET_DOMAIN_6 )
#define DS_SERVER_FULL_SECRET_DOMAIN_6 ( NBT_SERVER_FULL_SECRET_DOMAIN_6 )
#define DS_DNS_CONTROLLER ( 0x20000000 )
#define DS_DNS_DOMAIN ( 0x40000000 )
#define DS_DNS_FOREST ( 0x80000000 )

struct netr_DsRGetDCNameInfo {
	const char *dc_unc;/* [unique,charset(UTF16)] */
	const char *dc_address;/* [unique,charset(UTF16)] */
	enum netr_DsRGetDCNameInfo_AddressType dc_address_type;
	struct GUID domain_guid;
	const char *domain_name;/* [unique,charset(UTF16)] */
	const char *forest_name;/* [unique,charset(UTF16)] */
	uint32_t dc_flags;
	const char *dc_site_name;/* [unique,charset(UTF16)] */
	const char *client_site_name;/* [unique,charset(UTF16)] */
}/* [public] */;

union netr_Capabilities {
	uint32_t server_capabilities;/* [case] */
}/* [switch_type(uint32)] */;

struct netr_BinaryString {
	uint16_t length;
	uint16_t size;
	uint16_t *data;/* [unique,length_is(length/2),size_is(size/2)] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_DomainQuery1 {
	struct netr_Blob blob;
	const char *workstation_domain;/* [unique,charset(UTF16)] */
	const char *workstation_site;/* [unique,charset(UTF16)] */
	const char *unknown1;/* [unique,charset(UTF16)] */
	const char *unknown2;/* [unique,charset(UTF16)] */
	const char *unknown3;/* [unique,charset(UTF16)] */
	const char *unknown4;/* [unique,charset(UTF16)] */
	struct netr_BinaryString blob2;
	struct lsa_String product;
	struct lsa_String unknown5;
	struct lsa_String unknown6;
	uint32_t unknown7[4];
};

union netr_DomainQuery {
	struct netr_DomainQuery1 *query1;/* [unique,case] */
};

struct netr_DomainTrustInfo {
	struct lsa_String domainname;
	struct lsa_String fulldomainname;
	struct lsa_String forest;
	struct GUID guid;
	struct dom_sid2 *sid;/* [unique] */
	struct netr_BinaryString unknown1[4];
	uint32_t unknown[4];
};

struct netr_DomainInfo1 {
	struct netr_DomainTrustInfo domaininfo;
	uint32_t num_trusts;
	struct netr_DomainTrustInfo *trusts;/* [unique,size_is(num_trusts)] */
	uint32_t unknown[14];
};

union netr_DomainInfo {
	struct netr_DomainInfo1 *info1;/* [unique,case] */
};

struct netr_CryptPassword {
	uint8_t data[512];
	uint32_t length;
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_DsRAddressToSitenamesWCtr {
	uint32_t count;
	struct lsa_String *sitename;/* [unique,size_is(count)] */
};

struct netr_DsRAddress {
	uint8_t *buffer;/* [unique,size_is(size)] */
	uint32_t size;
};

/* bitmap netr_TrustFlags */
#define NETR_TRUST_FLAG_IN_FOREST ( 0x00000001 )
#define NETR_TRUST_FLAG_OUTBOUND ( 0x00000002 )
#define NETR_TRUST_FLAG_TREEROOT ( 0x00000004 )
#define NETR_TRUST_FLAG_PRIMARY ( 0x00000008 )
#define NETR_TRUST_FLAG_NATIVE ( 0x00000010 )
#define NETR_TRUST_FLAG_INBOUND ( 0x00000020 )

enum netr_TrustType
#ifndef USE_UINT_ENUMS
 {
	NETR_TRUST_TYPE_DOWNLEVEL=1,
	NETR_TRUST_TYPE_UPLEVEL=2,
	NETR_TRUST_TYPE_MIT=3,
	NETR_TRUST_TYPE_DCE=4
}
#else
 { __donnot_use_enum_netr_TrustType=0x7FFFFFFF}
#define NETR_TRUST_TYPE_DOWNLEVEL ( 1 )
#define NETR_TRUST_TYPE_UPLEVEL ( 2 )
#define NETR_TRUST_TYPE_MIT ( 3 )
#define NETR_TRUST_TYPE_DCE ( 4 )
#endif
;

/* bitmap netr_TrustAttributes */
#define NETR_TRUST_ATTRIBUTE_NON_TRANSITIVE ( 0x00000001 )
#define NETR_TRUST_ATTRIBUTE_UPLEVEL_ONLY ( 0x00000002 )
#define NETR_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN ( 0x00000004 )
#define NETR_TRUST_ATTRIBUTE_FOREST_TRANSITIVE ( 0x00000008 )
#define NETR_TRUST_ATTRIBUTE_CROSS_ORGANIZATION ( 0x00000010 )
#define NETR_TRUST_ATTRIBUTE_WITHIN_FOREST ( 0x00000020 )
#define NETR_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL ( 0x00000040 )

struct netr_DomainTrust {
	const char *netbios_name;/* [unique,charset(UTF16)] */
	const char *dns_name;/* [unique,charset(UTF16)] */
	uint32_t trust_flags;
	uint32_t parent_index;
	enum netr_TrustType trust_type;
	uint32_t trust_attributes;
	struct dom_sid2 *sid;/* [unique] */
	struct GUID guid;
};

struct netr_DomainTrustList {
	uint32_t count;
	struct netr_DomainTrust *array;/* [unique,size_is(count)] */
};

struct netr_DsRAddressToSitenamesExWCtr {
	uint32_t count;
	struct lsa_String *sitename;/* [unique,size_is(count)] */
	struct lsa_String *subnetname;/* [unique,size_is(count)] */
};

struct DcSitesCtr {
	uint32_t num_sites;
	struct lsa_String *sites;/* [unique,size_is(num_sites)] */
};


struct netr_LogonUasLogon {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		const char *workstation;/* [charset(UTF16)] */
	} in;

	struct {
		struct netr_UasInfo *info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonUasLogoff {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		const char *workstation;/* [charset(UTF16)] */
	} in;

	struct {
		struct netr_UasLogoffInfo *info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonSamLogon {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *computer_name;/* [unique,charset(UTF16)] */
		struct netr_Authenticator *credential;/* [unique] */
		enum netr_LogonLevel logon_level;
		union netr_LogonInfo *logon;/* [ref,switch_is(logon_level)] */
		uint16_t validation_level;
		struct netr_Authenticator *return_authenticator;/* [unique] */
	} in;

	struct {
		union netr_Validation *validation;/* [ref,switch_is(validation_level)] */
		uint8_t *authoritative;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [unique] */
		NTSTATUS result;
	} out;

};


struct netr_LogonSamLogoff {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *computer_name;/* [unique,charset(UTF16)] */
		struct netr_Authenticator *credential;/* [unique] */
		enum netr_LogonLevel logon_level;
		union netr_LogonInfo logon;/* [switch_is(logon_level)] */
		struct netr_Authenticator *return_authenticator;/* [unique] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [unique] */
		NTSTATUS result;
	} out;

};


struct netr_ServerReqChallenge {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *computer_name;/* [charset(UTF16)] */
		struct netr_Credential *credentials;/* [ref] */
	} in;

	struct {
		struct netr_Credential *return_credentials;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerAuthenticate {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16)] */
		struct netr_Credential *credentials;/* [ref] */
	} in;

	struct {
		struct netr_Credential *return_credentials;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerPasswordSet {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
		struct samr_Password *new_password;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DatabaseDeltas {
	struct {
		const char *logon_server;/* [charset(UTF16)] */
		const char *computername;/* [charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
		enum netr_SamDatabaseID database_id;
		uint32_t preferredmaximumlength;
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint64_t *sequence_num;/* [ref] */
	} in;

	struct {
		struct netr_DELTA_ENUM_ARRAY **delta_enum_array;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint64_t *sequence_num;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DatabaseSync {
	struct {
		const char *logon_server;/* [charset(UTF16)] */
		const char *computername;/* [charset(UTF16)] */
		struct netr_Authenticator credential;
		enum netr_SamDatabaseID database_id;
		uint32_t preferredmaximumlength;
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint32_t *sync_context;/* [ref] */
	} in;

	struct {
		struct netr_DELTA_ENUM_ARRAY *delta_enum_array;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint32_t *sync_context;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_AccountDeltas {
	struct {
		const char *logon_server;/* [unique,charset(UTF16)] */
		const char *computername;/* [charset(UTF16)] */
		struct netr_Authenticator credential;
		struct netr_UAS_INFO_0 uas;
		uint32_t count;
		uint32_t level;
		uint32_t buffersize;
		struct netr_Authenticator *return_authenticator;/* [ref] */
	} in;

	struct {
		struct netr_AccountBuffer *buffer;/* [ref,subcontext(4)] */
		uint32_t *count_returned;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		struct netr_UAS_INFO_0 *recordid;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_AccountSync {
	struct {
		const char *logon_server;/* [unique,charset(UTF16)] */
		const char *computername;/* [charset(UTF16)] */
		struct netr_Authenticator credential;
		uint32_t reference;
		uint32_t level;
		uint32_t buffersize;
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct netr_UAS_INFO_0 *recordid;/* [ref] */
	} in;

	struct {
		struct netr_AccountBuffer *buffer;/* [ref,subcontext(4)] */
		uint32_t *count_returned;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *next_reference;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct netr_UAS_INFO_0 *recordid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_GetDcName {
	struct {
		const char *logon_server;/* [charset(UTF16)] */
		const char *domainname;/* [unique,charset(UTF16)] */
	} in;

	struct {
		const char **dcname;/* [ref,charset(UTF16)] */
		WERROR result;
	} out;

};


struct netr_LogonControl {
	struct {
		const char *logon_server;/* [unique,charset(UTF16)] */
		enum netr_LogonControlCode function_code;
		uint32_t level;
	} in;

	struct {
		union netr_CONTROL_QUERY_INFORMATION *info;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct netr_GetAnyDCName {
	struct {
		const char *logon_server;/* [unique,charset(UTF16)] */
		const char *domainname;/* [unique,charset(UTF16)] */
	} in;

	struct {
		const char **dcname;/* [ref,charset(UTF16)] */
		WERROR result;
	} out;

};


struct netr_LogonControl2 {
	struct {
		const char *logon_server;/* [unique,charset(UTF16)] */
		enum netr_LogonControlCode function_code;
		uint32_t level;
		union netr_CONTROL_DATA_INFORMATION *data;/* [ref,switch_is(function_code)] */
	} in;

	struct {
		union netr_CONTROL_QUERY_INFORMATION *query;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct netr_ServerAuthenticate2 {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16)] */
		struct netr_Credential *credentials;/* [ref] */
		uint32_t *negotiate_flags;/* [ref] */
	} in;

	struct {
		struct netr_Credential *return_credentials;/* [ref] */
		uint32_t *negotiate_flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DatabaseSync2 {
	struct {
		const char *logon_server;/* [charset(UTF16)] */
		const char *computername;/* [charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
		enum netr_SamDatabaseID database_id;
		uint16_t restart_state;
		uint32_t preferredmaximumlength;
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint32_t *sync_context;/* [ref] */
	} in;

	struct {
		struct netr_DELTA_ENUM_ARRAY **delta_enum_array;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint32_t *sync_context;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DatabaseRedo {
	struct {
		const char *logon_server;/* [charset(UTF16)] */
		const char *computername;/* [charset(UTF16)] */
		struct netr_Authenticator credential;
		uint8_t *change_log_entry;/* [unique,size_is(change_log_entry_size)] */
		uint32_t change_log_entry_size;
		struct netr_Authenticator *return_authenticator;/* [ref] */
	} in;

	struct {
		struct netr_DELTA_ENUM_ARRAY *delta_enum_array;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_LogonControl2Ex {
	struct {
		const char *logon_server;/* [unique,charset(UTF16)] */
		uint32_t function_code;
		uint32_t level;
		union netr_CONTROL_DATA_INFORMATION data;/* [switch_is(function_code)] */
	} in;

	struct {
		union netr_CONTROL_QUERY_INFORMATION *query;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct netr_NetrEnumerateTrustedDomains {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
	} in;

	struct {
		struct netr_Blob *trusted_domains_blob;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsRGetDCName {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *domain_name;/* [unique,charset(UTF16)] */
		struct GUID *domain_guid;/* [unique] */
		struct GUID *site_guid;/* [unique] */
		uint32_t flags;
	} in;

	struct {
		struct netr_DsRGetDCNameInfo **info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonGetCapabilities {
	struct {
		const char *server_name;/* [charset(UTF16)] */
		const char *computer_name;/* [unique,charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
		uint32_t query_level;
		struct netr_Authenticator *return_authenticator;/* [ref] */
	} in;

	struct {
		union netr_Capabilities *capabilities;/* [ref,switch_is(query_level)] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_NETRLOGONSETSERVICEBITS {
	struct {
		WERROR result;
	} out;

};


struct netr_LogonGetTrustRid {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *domain_name;/* [unique,charset(UTF16)] */
	} in;

	struct {
		uint32_t *rid;/* [ref] */
		WERROR result;
	} out;

};


struct netr_NETRLOGONCOMPUTESERVERDIGEST {
	struct {
		WERROR result;
	} out;

};


struct netr_NETRLOGONCOMPUTECLIENTDIGEST {
	struct {
		WERROR result;
	} out;

};


struct netr_ServerAuthenticate3 {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16)] */
		struct netr_Credential *credentials;/* [ref] */
		uint32_t *negotiate_flags;/* [ref] */
	} in;

	struct {
		uint32_t *rid;/* [ref] */
		struct netr_Credential *credentials;/* [ref] */
		uint32_t *negotiate_flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DsRGetDCNameEx {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *domain_name;/* [unique,charset(UTF16)] */
		struct GUID *domain_guid;/* [unique] */
		const char *site_name;/* [unique,charset(UTF16)] */
		uint32_t flags;
	} in;

	struct {
		struct netr_DsRGetDCNameInfo **info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsRGetSiteName {
	struct {
		const char *computer_name;/* [unique,charset(UTF16)] */
	} in;

	struct {
		const char **site;/* [ref,charset(UTF16)] */
		WERROR result;
	} out;

};


struct netr_LogonGetDomainInfo {
	struct {
		const char *server_name;/* [charset(UTF16)] */
		const char *computer_name;/* [unique,charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
		uint32_t level;
		union netr_DomainQuery query;/* [switch_is(level)] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
	} in;

	struct {
		union netr_DomainInfo *info;/* [ref,switch_is(level)] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerPasswordSet2 {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
		struct netr_CryptPassword *new_password;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerPasswordGet {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct samr_Password *password;/* [ref] */
		WERROR result;
	} out;

};


struct netr_NETRLOGONSENDTOSAM {
	struct {
		WERROR result;
	} out;

};


struct netr_DsRAddressToSitenamesW {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		uint32_t count;/* [range(0,32000)] */
		struct netr_DsRAddress *addresses;/* [ref,size_is(count)] */
	} in;

	struct {
		struct netr_DsRAddressToSitenamesWCtr **ctr;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsRGetDCNameEx2 {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *client_account;/* [unique,charset(UTF16)] */
		uint32_t mask;
		const char *domain_name;/* [unique,charset(UTF16)] */
		struct GUID *domain_guid;/* [unique] */
		const char *site_name;/* [unique,charset(UTF16)] */
		uint32_t flags;
	} in;

	struct {
		struct netr_DsRGetDCNameInfo **info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN {
	struct {
		WERROR result;
	} out;

};


struct netr_NetrEnumerateTrustedDomainsEx {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
	} in;

	struct {
		struct netr_DomainTrustList *dom_trust_list;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsRAddressToSitenamesExW {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		uint32_t count;/* [range(0,32000)] */
		struct netr_DsRAddress *addresses;/* [ref,size_is(count)] */
	} in;

	struct {
		struct netr_DsRAddressToSitenamesExWCtr **ctr;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsrGetDcSiteCoverageW {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
	} in;

	struct {
		struct DcSitesCtr *ctr;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonSamLogonEx {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *computer_name;/* [unique,charset(UTF16)] */
		enum netr_LogonLevel logon_level;
		union netr_LogonInfo *logon;/* [ref,switch_is(logon_level)] */
		uint16_t validation_level;
		uint32_t *flags;/* [ref] */
	} in;

	struct {
		union netr_Validation *validation;/* [ref,switch_is(validation_level)] */
		uint8_t *authoritative;/* [ref] */
		uint32_t *flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DsrEnumerateDomainTrusts {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		uint32_t trust_flags;
	} in;

	struct {
		struct netr_DomainTrustList *trusts;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsrDeregisterDNSHostRecords {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *domain;/* [unique,charset(UTF16)] */
		struct GUID *domain_guid;/* [unique] */
		struct GUID *dsa_guid;/* [unique] */
		const char *dns_host;/* [ref,charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct netr_ServerTrustPasswordsGet {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *account_name;/* [charset(UTF16)] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct samr_Password *password;/* [ref] */
		struct samr_Password *password2;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DsRGetForestTrustInformation {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *trusted_domain_name;/* [unique,charset(UTF16)] */
		uint32_t flags;
	} in;

	struct {
		struct lsa_ForestTrustInformation **forest_trust_info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_GetForestTrustInformation {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *trusted_domain_name;/* [ref,charset(UTF16)] */
		struct netr_Authenticator *credential;/* [ref] */
		uint32_t flags;
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct lsa_ForestTrustInformation **forest_trust_info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonSamLogonWithFlags {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		const char *computer_name;/* [unique,charset(UTF16)] */
		struct netr_Authenticator *credential;/* [unique] */
		enum netr_LogonLevel logon_level;
		union netr_LogonInfo logon;/* [switch_is(logon_level)] */
		uint16_t validation_level;
		struct netr_Authenticator *return_authenticator;/* [unique] */
		uint32_t *flags;/* [ref] */
	} in;

	struct {
		union netr_Validation *validation;/* [ref,switch_is(validation_level)] */
		uint8_t *authoritative;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [unique] */
		uint32_t *flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_NETRSERVERGETTRUSTINFO {
	struct {
		WERROR result;
	} out;

};

#endif /* _HEADER_netlogon */
