/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LongestCommonSubsequence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class LongestCommonSubsequenceTest {
    private static LongestCommonSubsequence subject;

    @BeforeAll
    public static void setup() {
        subject = new LongestCommonSubsequence();
    }

    @Test
    public void testGettingLogestCommonSubsequenceNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.logestCommonSubsequence(null, null));
    }

    @Test
    public void testGettingLogestCommonSubsequenceNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.logestCommonSubsequence(null, (CharSequence)"right"));
    }

    @Test
    public void testGettingLogestCommonSubsequenceStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.logestCommonSubsequence((CharSequence)" ", null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceApplyNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.apply(null, null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceApplyNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.apply(null, (CharSequence)"right"));
    }

    @Test
    public void testGettingLongestCommonSubsequenceApplyStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.apply((CharSequence)" ", null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.longestCommonSubsequence(null, null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.longestCommonSubsequence(null, (CharSequence)"right"));
    }

    @Test
    public void testGettingLongestCommonSubsequenceStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.longestCommonSubsequence((CharSequence)" ", null));
    }

    @Test
    @Deprecated
    public void testLogestCommonSubsequence() {
        Assertions.assertEquals((Object)"", (Object)subject.logestCommonSubsequence((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((Object)"", (Object)subject.logestCommonSubsequence((CharSequence)"left", (CharSequence)""));
        Assertions.assertEquals((Object)"", (Object)subject.logestCommonSubsequence((CharSequence)"", (CharSequence)"right"));
        Assertions.assertEquals((Object)"fog", (Object)subject.logestCommonSubsequence((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((Object)"", (Object)subject.logestCommonSubsequence((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((Object)"h", (Object)subject.logestCommonSubsequence((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((Object)"ABC Corp", (Object)subject.logestCommonSubsequence((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assertions.assertEquals((Object)"D  H Enterprises Inc", (Object)subject.logestCommonSubsequence((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assertions.assertEquals((Object)"My Gym Childrens Fitness", (Object)subject.logestCommonSubsequence((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assertions.assertEquals((Object)"PENNSYLVNIA", (Object)subject.logestCommonSubsequence((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assertions.assertEquals((Object)"t", (Object)subject.logestCommonSubsequence((CharSequence)"left", (CharSequence)"right"));
        Assertions.assertEquals((Object)"tttt", (Object)subject.logestCommonSubsequence((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assertions.assertEquals((Object)"the same string", (Object)subject.logestCommonSubsequence((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test
    public void testLongestCommonSubsequence() {
        Assertions.assertEquals((Object)"", (Object)subject.longestCommonSubsequence((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((Object)"", (Object)subject.longestCommonSubsequence((CharSequence)"left", (CharSequence)""));
        Assertions.assertEquals((Object)"", (Object)subject.longestCommonSubsequence((CharSequence)"", (CharSequence)"right"));
        Assertions.assertEquals((Object)"fog", (Object)subject.longestCommonSubsequence((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((Object)"", (Object)subject.longestCommonSubsequence((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((Object)"h", (Object)subject.longestCommonSubsequence((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((Object)"ABC Corp", (Object)subject.longestCommonSubsequence((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assertions.assertEquals((Object)"D  H Enterprises Inc", (Object)subject.longestCommonSubsequence((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assertions.assertEquals((Object)"My Gym Childrens Fitness", (Object)subject.longestCommonSubsequence((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assertions.assertEquals((Object)"PENNSYLVNIA", (Object)subject.longestCommonSubsequence((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assertions.assertEquals((Object)"t", (Object)subject.longestCommonSubsequence((CharSequence)"left", (CharSequence)"right"));
        Assertions.assertEquals((Object)"tttt", (Object)subject.longestCommonSubsequence((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assertions.assertEquals((Object)"the same string", (Object)subject.longestCommonSubsequence((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test
    public void testLongestCommonSubsequenceApply() {
        Assertions.assertEquals((int)0, (Integer)subject.apply((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)0, (Integer)subject.apply((CharSequence)"left", (CharSequence)""));
        Assertions.assertEquals((int)0, (Integer)subject.apply((CharSequence)"", (CharSequence)"right"));
        Assertions.assertEquals((int)3, (Integer)subject.apply((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((int)0, (Integer)subject.apply((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((int)1, (Integer)subject.apply((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((int)8, (Integer)subject.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assertions.assertEquals((int)20, (Integer)subject.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assertions.assertEquals((int)24, (Integer)subject.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assertions.assertEquals((int)11, (Integer)subject.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assertions.assertEquals((int)1, (Integer)subject.apply((CharSequence)"left", (CharSequence)"right"));
        Assertions.assertEquals((int)4, (Integer)subject.apply((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assertions.assertEquals((int)15, (Integer)subject.apply((CharSequence)"the same string", (CharSequence)"the same string"));
    }
}

