/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.awt.BDFontMetrics;
import java.awt.BDToolkit;
import java.util.Vector;
import javax.media.PackageManager;
import javax.tv.service.SIManagerImpl;
import javax.tv.service.selection.ServiceContextFactory;
import org.bluray.bdplus.Status;
import org.bluray.ti.DiscManager;
import org.bluray.ti.TitleImpl;
import org.bluray.ti.selection.TitleContext;
import org.dvb.event.EventManager;
import org.dvb.io.ixc.IxcRegistry;
import org.dvb.ui.FontFactory;
import org.videolan.BDJActionManager;
import org.videolan.BDJLoader;
import org.videolan.GUIManager;
import org.videolan.MountManager;
import org.videolan.PlaylistInfo;
import org.videolan.TitleInfo;
import org.videolan.bdjo.Bdjo;
import org.videolan.media.content.PlayerManager;

public class Libbluray {
    private static final int BDJ_EVENT_CHAPTER = 1;
    private static final int BDJ_EVENT_PLAYITEM = 2;
    private static final int BDJ_EVENT_ANGLE = 3;
    private static final int BDJ_EVENT_SUBTITLE = 4;
    private static final int BDJ_EVENT_PIP = 5;
    private static final int BDJ_EVENT_END_OF_PLAYLIST = 6;
    private static final int BDJ_EVENT_PTS = 7;
    private static final int BDJ_EVENT_VK_KEY = 8;
    private static final int BDJ_EVENT_MARK = 9;
    private static final int BDJ_EVENT_PSR102 = 10;
    private static final int BDJ_EVENT_PLAYLIST = 11;
    private static final int BDJ_EVENT_START = 12;
    private static final int BDJ_EVENT_STOP = 13;
    private static final int BDJ_EVENT_RATE = 14;
    public static final int PSR_IG_STREAM_ID = 0;
    public static final int PSR_PRIMARY_AUDIO_ID = 1;
    public static final int PSR_PG_STREAM = 2;
    public static final int PSR_ANGLE_NUMBER = 3;
    public static final int PSR_TITLE_NUMBER = 4;
    public static final int PSR_CHAPTER = 5;
    public static final int PSR_PLAYLIST = 6;
    public static final int PSR_PLAYITEM = 7;
    public static final int PSR_TIME = 8;
    public static final int PSR_NAV_TIMER = 9;
    public static final int PSR_SELECTED_BUTTON_ID = 10;
    public static final int PSR_MENU_PAGE_ID = 11;
    public static final int PSR_STYLE = 12;
    public static final int PSR_PARENTAL = 13;
    public static final int PSR_SECONDARY_AUDIO_VIDEO = 14;
    public static final int PSR_AUDIO_CAP = 15;
    public static final int PSR_AUDIO_LANG = 16;
    public static final int PSR_PG_AND_SUB_LANG = 17;
    public static final int PSR_MENU_LANG = 18;
    public static final int PSR_COUNTRY = 19;
    public static final int PSR_REGION = 20;
    public static final int PSR_VIDEO_CAP = 29;
    public static final int PSR_TEXT_CAP = 30;
    public static final int PSR_PROFILE_VERSION = 31;
    public static final int PSR_BACKUP_PSR4 = 36;
    public static final int PSR_BACKUP_PSR5 = 37;
    public static final int PSR_BACKUP_PSR6 = 38;
    public static final int PSR_BACKUP_PSR7 = 39;
    public static final int PSR_BACKUP_PSR8 = 40;
    public static final int PSR_BACKUP_PSR10 = 42;
    public static final int PSR_BACKUP_PSR11 = 43;
    public static final int PSR_BACKUP_PSR12 = 44;
    public static final int AACS_DISC_ID = 1;
    public static final int AACS_MEDIA_VID = 2;
    public static final int AACS_MEDIA_PMSN = 3;
    public static final int AACS_DEVICE_BINDING_ID = 4;
    public static final int AACS_DEVICE_NONCE = 5;
    protected static long nativePointer = 0L;

    protected static void init(long nativePointer, String discID, String discRoot) {
        System.setProperty("bluray.vfs.root", discRoot);
        Libbluray.nativePointer = nativePointer;
        DiscManager.getDiscManager().setCurrentDisc(discID);
        BDJActionManager.createInstance();
        Vector<String> prefix = new Vector<String>();
        prefix.add("org.videolan");
        PackageManager.setContentPrefixList(prefix);
        PackageManager.setProtocolPrefixList(prefix);
        PackageManager.commitContentPrefixList();
        PackageManager.commitProtocolPrefixList();
        BDFontMetrics.init();
        FontFactory.loadDiscFonts();
        System.setProperty("mhp.profile.enhanced_broadcast", "YES");
        System.setProperty("mhp.profile.interactive_broadcast", "YES");
        System.setProperty("mhp.profile.internet_access", "YES");
        System.setProperty("mhp.eb.version.major", "1");
        System.setProperty("mhp.eb.version.minor", "0");
        System.setProperty("mhp.eb.version.micro", "3");
        System.setProperty("mhp.ia.version.major", "1");
        System.setProperty("mhp.ia.version.minor", "0");
        System.setProperty("mhp.ia.version.micro", "3");
        System.setProperty("mhp.ib.version.major", "1");
        System.setProperty("mhp.ib.version.minor", "0");
        System.setProperty("mhp.ib.version.micro", "3");
        System.setProperty("mhp.option.ip.multicast", "UNSUPPORTED");
        System.setProperty("mhp.option.dsmcc.uu", "UNSUPPORTED");
        System.setProperty("mhp.option.dvb.html", "UNSUPPORTED");
        System.setProperty("dvb.returnchannel.timeout", "30");
        System.setProperty("bluray.profile.1", "YES");
        System.setProperty("bluray.p1.version.major", "1");
        System.setProperty("bluray.p1.version.minor", "1");
        System.setProperty("bluray.p1.version.micro", "0");
        System.setProperty("bluray.profile.2", "YES");
        System.setProperty("bluray.p2.version.major", "1");
        System.setProperty("bluray.p2.version.minor", "0");
        System.setProperty("bluray.p2.version.micro", "0");
        System.setProperty("bluray.disc.avplayback.readcapability", "NO");
        System.setProperty("bluray.video.fullscreenSD", "YES");
        System.setProperty("bluray.video.fullscreenSDPG", "YES");
        System.setProperty("aacs.bluray.online.capability", "YES");
        System.setProperty("aacs.bluray.mc.capability", "NO");
        System.setProperty("bluray.prefetchedplaylistloading", "NO");
        System.setProperty("bluray.video.autoresume", "NO");
        System.setProperty("bluray.mediaselect", "NO");
        System.setProperty("bluray.event.extension", "YES");
        System.setProperty("bluray.jmf.subtitlestyle", "YES");
        System.setProperty("bluray.rccapability.release", "No");
        System.setProperty("bluray.rccapability.holdandrelease", "NO");
        System.setProperty("bluray.rccapability.repeatonhold", "NO");
        System.setProperty("bluray.localstorage.level", "5");
        System.setProperty("bluray.localstorage.maxlevel", "5");
        System.setProperty("bluray.localstorage.removable", "NO");
        System.setProperty("bluray.localstorage.upgradable", "NO");
        System.setProperty("bluray.localstorage.name", "HDD");
        System.setProperty("bluray.memory.images", "65536");
        System.setProperty("bluray.memory.audio", "8192");
        System.setProperty("bluray.memory.audio_plus_img", "73728");
        System.setProperty("bluray.memory.java_heap", "32768");
        System.setProperty("bluray.memory.font_cache", "4096");
        System.setProperty("bluray.network.connected", "YES");
    }

    public static void shutdown() {
        try {
            BDJLoader.shutdown();
            BDJActionManager.shutdown();
            MountManager.unmountAll();
            GUIManager.shutdown();
            BDToolkit.shutdownDisc();
            BDFontMetrics.shutdown();
            SIManagerImpl.shutdown();
            IxcRegistry.shutdown();
            EventManager.shutdown();
            Status.shutdown();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        nativePointer = 0L;
    }

    public static byte[] getAacsData(int type) {
        return Libbluray.getAacsDataN(nativePointer, type);
    }

    public static int getTitles() {
        return Libbluray.getTitlesN(nativePointer);
    }

    public static TitleInfo getTitleInfo(int titleNum) {
        if (titleNum < 0) {
            throw new IllegalArgumentException();
        }
        return Libbluray.getTitleInfoN(nativePointer, titleNum);
    }

    public static PlaylistInfo getPlaylistInfo(int playlist) {
        return Libbluray.getPlaylistInfoN(nativePointer, playlist);
    }

    public static long seek(long pos) {
        return Libbluray.seekN(nativePointer, pos);
    }

    public static long seekTime(long tick) {
        return Libbluray.seekTimeN(nativePointer, tick);
    }

    public static long seekChapter(int chapter) {
        if (chapter < 0) {
            throw new IllegalArgumentException("Chapter cannot be negative");
        }
        return Libbluray.seekChapterN(nativePointer, chapter);
    }

    public static long chapterPos(int chapter) {
        if (chapter < 0) {
            throw new IllegalArgumentException("Chapter cannot be negative");
        }
        return Libbluray.chapterPosN(nativePointer, chapter);
    }

    public static int getCurrentChapter() {
        return Libbluray.getCurrentChapterN(nativePointer);
    }

    public static long seekMark(int mark) {
        if (mark < 0) {
            throw new IllegalArgumentException("Mark cannot be negative");
        }
        long result = Libbluray.seekMarkN(nativePointer, mark);
        if (result == -1L) {
            throw new IllegalArgumentException("Seek error");
        }
        return result;
    }

    public static long seekPlayItem(int clip) {
        if (clip < 0) {
            throw new IllegalArgumentException("Mark cannot be negative");
        }
        long result = Libbluray.seekPlayItemN(nativePointer, clip);
        if (result == -1L) {
            throw new IllegalArgumentException("Seek error");
        }
        return result;
    }

    public static boolean selectPlaylist(int playlist, int playitem, int playmark, long time) {
        if (playlist < 0) {
            throw new IllegalArgumentException("Playlist cannot be negative");
        }
        return Libbluray.selectPlaylistN(nativePointer, playlist, playitem, playmark, time) == 1;
    }

    public static boolean selectPlaylist(int playlist) {
        return Libbluray.selectPlaylist(playlist, -1, -1, -1L);
    }

    public static void stopPlaylist() {
        Libbluray.selectPlaylistN(nativePointer, -1, -1, -1, -1L);
    }

    public static boolean selectTitle(TitleImpl title) {
        TitleInfo ti = title.getTitleInfo();
        if (ti.isBdj()) {
            try {
                ((TitleContext)ServiceContextFactory.getInstance().getServiceContext(null)).select(title);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return Libbluray.selectTitleN(nativePointer, title.getTitleNum()) == 1;
    }

    public static boolean selectAngle(int angle) {
        if (angle < 0) {
            throw new IllegalArgumentException("Angle cannot be negative");
        }
        return Libbluray.selectAngleN(nativePointer, angle) == 1;
    }

    public static void seamlessAngleChange(int angle) {
        if (angle < 0) {
            throw new IllegalArgumentException("Angle cannot be negative");
        }
        Libbluray.seamlessAngleChangeN(nativePointer, angle);
    }

    public static long getTitleSize() {
        return Libbluray.getTitleSizeN(nativePointer);
    }

    public static int getCurrentTitle() {
        return Libbluray.readPSR(4);
    }

    public static int getCurrentAngle() {
        return Libbluray.getCurrentAngleN(nativePointer);
    }

    public static long getUOMask() {
        return Libbluray.getUOMaskN(nativePointer);
    }

    public static long tell() {
        return Libbluray.tellN(nativePointer);
    }

    public static long tellTime() {
        return Libbluray.tellTimeN(nativePointer);
    }

    public static boolean selectRate(float rate) {
        return Libbluray.selectRateN(nativePointer, rate, 0) == 1;
    }

    public static boolean selectRate(float rate, boolean start) {
        return Libbluray.selectRateN(nativePointer, rate, start ? 1 : 2) == 1;
    }

    public static void writeGPR(int num, int value) {
        int ret = Libbluray.writeGPRN(nativePointer, num, value);
        if (ret == -1) {
            throw new IllegalArgumentException("Invalid GPR");
        }
    }

    public static void writePSR(int num, int value) {
        Libbluray.writePSR(num, value, -1);
    }

    public static void writePSR(int num, int value, int psr_value_mask) {
        int ret = Libbluray.writePSRN(nativePointer, num, value, psr_value_mask);
        if (ret == -1) {
            throw new IllegalArgumentException("Invalid PSR");
        }
    }

    public static int readGPR(int num) {
        if (num < 0 || num >= 4096) {
            throw new IllegalArgumentException("Invalid GPR");
        }
        return Libbluray.readGPRN(nativePointer, num);
    }

    public static int readPSR(int num) {
        if (num < 0 || num >= 128) {
            throw new IllegalArgumentException("Invalid PSR");
        }
        return Libbluray.readPSRN(nativePointer, num);
    }

    public static Bdjo getBdjo(String name) {
        return Libbluray.getBdjoN(nativePointer, name);
    }

    public static void updateGraphic(int width, int height, int[] rgbArray) {
        Libbluray.updateGraphicN(nativePointer, width, height, rgbArray, 0, 0, width - 1, height - 1);
    }

    public static void updateGraphic(int width, int height, int[] rgbArray, int x0, int y0, int x1, int y1) {
        Libbluray.updateGraphicN(nativePointer, width, height, rgbArray, x0, y0, x1, y1);
    }

    public static boolean processEvent(int event, int param) {
        boolean result = true;
        int key = 0;
        switch (event) {
            case 12: {
                return BDJLoader.load(param);
            }
            case 13: {
                return BDJLoader.unload();
            }
            case 1: {
                PlayerManager.getInstance().onChapterReach(param);
                break;
            }
            case 9: {
                PlayerManager.getInstance().onMarkReach(param);
                break;
            }
            case 2: {
                PlayerManager.getInstance().onPlayItemReach(param);
                break;
            }
            case 11: {
                PlayerManager.getInstance().onPlaylistStart(param);
                break;
            }
            case 3: {
                PlayerManager.getInstance().onAngleChange(param);
                break;
            }
            case 4: {
                PlayerManager.getInstance().onSubtitleChange(param);
                break;
            }
            case 5: {
                PlayerManager.getInstance().onPiPChange(param);
                break;
            }
            case 14: {
                float rate = (float)param / 90000.0f;
                if (rate < 0.0f) {
                    rate = -rate;
                }
                if (rate < 0.01f) {
                    rate = 0.0f;
                }
                if (rate > 0.99f && rate < 1.01f) {
                    rate = 1.0f;
                }
                PlayerManager.getInstance().onRateChange(rate);
            }
            case 6: {
                PlayerManager.getInstance().onPlaylistEnd(param);
                break;
            }
            case 10: {
                Status.getInstance().receive(param);
                break;
            }
            case 7: {
                PlayerManager.getInstance().onPlaylistTime(param);
                break;
            }
            case 8: {
                switch (param) {
                    case 0: {
                        key = 48;
                        break;
                    }
                    case 1: {
                        key = 49;
                        break;
                    }
                    case 2: {
                        key = 50;
                        break;
                    }
                    case 3: {
                        key = 51;
                        break;
                    }
                    case 4: {
                        key = 52;
                        break;
                    }
                    case 5: {
                        key = 53;
                        break;
                    }
                    case 6: {
                        key = 54;
                        break;
                    }
                    case 7: {
                        key = 55;
                        break;
                    }
                    case 8: {
                        key = 56;
                        break;
                    }
                    case 9: {
                        key = 57;
                        break;
                    }
                    case 11: {
                        key = 461;
                        break;
                    }
                    case 12: {
                        key = 38;
                        break;
                    }
                    case 13: {
                        key = 40;
                        break;
                    }
                    case 14: {
                        key = 37;
                        break;
                    }
                    case 15: {
                        key = 39;
                        break;
                    }
                    case 16: {
                        key = 10;
                        break;
                    }
                    case 403: {
                        key = 403;
                        break;
                    }
                    case 404: {
                        key = 404;
                        break;
                    }
                    case 405: {
                        key = 405;
                        break;
                    }
                    case 406: {
                        key = 406;
                        break;
                    }
                    default: {
                        key = -1;
                        result = false;
                    }
                }
                if (key <= 0) break;
                result = EventManager.getInstance().receiveKeyEventN(401, 0, key) || EventManager.getInstance().receiveKeyEventN(402, 0, key) || EventManager.getInstance().receiveKeyEventN(400, 0, key);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static void setUOMask(boolean menuCallMask, boolean titleSearchMask) {
        Libbluray.setUOMaskN(nativePointer, menuCallMask, titleSearchMask);
    }

    private static native byte[] getAacsDataN(long var0, int var2);

    private static native TitleInfo getTitleInfoN(long var0, int var2);

    private static native PlaylistInfo getPlaylistInfoN(long var0, int var2);

    private static native int getTitlesN(long var0);

    private static native long seekN(long var0, long var2);

    private static native long seekTimeN(long var0, long var2);

    private static native long seekChapterN(long var0, int var2);

    private static native long chapterPosN(long var0, int var2);

    private static native int getCurrentChapterN(long var0);

    private static native long seekMarkN(long var0, int var2);

    private static native long seekPlayItemN(long var0, int var2);

    private static native int selectPlaylistN(long var0, int var2, int var3, int var4, long var5);

    private static native int selectTitleN(long var0, int var2);

    private static native int selectAngleN(long var0, int var2);

    private static native void seamlessAngleChangeN(long var0, int var2);

    private static native long getTitleSizeN(long var0);

    private static native long getUOMaskN(long var0);

    private static native void setUOMaskN(long var0, boolean var2, boolean var3);

    private static native int getCurrentAngleN(long var0);

    private static native long tellN(long var0);

    private static native long tellTimeN(long var0);

    private static native int selectRateN(long var0, float var2, int var3);

    private static native int writeGPRN(long var0, int var2, int var3);

    private static native int writePSRN(long var0, int var2, int var3, int var4);

    private static native int readGPRN(long var0, int var2);

    private static native int readPSRN(long var0, int var2);

    private static native Bdjo getBdjoN(long var0, String var2);

    private static native void updateGraphicN(long var0, int var2, int var3, int[] var4, int var5, int var6, int var7, int var8);
}

