---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices de caractères, encodage des caractères
---

# Que sont les fontes *European Computer* (EC) ?

Une police de caractères fournit un certain nombre de *glyphes*. 
Pour que les glyphes puissent être imprimés, ils sont [encodés](/2_programmation/encodage/notion_d_encodage), 
et l'encodage est utilisé comme index dans les tables de caractères de la police. 
Pour diverses raisons, Donald Knuth a choisi des encodages profondément excentriques 
pour sa famille de polices *Computer Modern* ; en particulier, 
il a choisi des encodages différents pour des polices différentes, 
de sorte que l'application qui utilise ces polices doit se rappeler 
quelle police de la famille elle utilise avant de sélectionner un glyphe particulier.

Lorsque la version 3 de TeX est arrivée, 
la plupart des raisons de l'excentricité des encodages de Knuth ont disparu, 
et, lors de la réunion de Cork du TUG, un encodage pour un ensemble de 256 glyphes 
a été défini pour être utilisé dans le texte TeX. 
L'intention était que ces glyphes couvrent "la plupart" des langues européennes 
qui utilisent des alphabets latins, en incluant toutes les lettres accentuées nécessaires. 
Les polices *Computer Modern Roman* de Knuth manquaient, par exemple, des éléments nécessaires 
pour l'islandais et le polonais, ce que les polices dites "de Cork" possèdent 
(mais même la couverture de l'encodage de Cork est incomplète). 
LaTeX se réfère à l'encodage Cork comme T1 et fournit les moyens d'utiliser les polices 
ainsi encodées pour éviter les problèmes d'interaction entre les accents et la césure 
(voir la question "[](/3_composition/langues/cesure/coupures_de_mots_accentues)").

La première fonte MetaFont à se conformer à l'encodage de Cork 
a été la fonte *European Computer*. Elle ressemble à la fonte *Computer Modern*, 
bien que ses métriques diffèrent de celles de *Computer Modern* dans plusieurs domaines. 
Elle a longtemps été considérée comme "stable" 
(dans le même sens que la fonte *Computer Modern* est stable : 
il est peu probable que ses métriques changent). 
Chaque police *European Computer* est environ deux fois plus grande 
que la police *Computer Modern* correspondante. 
Il y a aussi beaucoup plus de polices *Computer Modern* 
et le simple nombre de polices s'est avéré problématique 
pour la production de versions Type 1 ou TrueType (ces dernières ne provenant 
que de [fournisseurs commerciaux](/6_distributions/installation/implementations_commerciales)).
Des [versions auto-tracées](/5_fichiers/formats/fontes/tracer_les_contours_d_une_police_metafont), 
les polices *CM-super*, *LGC* et *Latin Modern* 
(plutôt directement générée à partir des sources Metafont), sont disponibles.

Notez que l'encodage de Cork ne couvre pas les mathématiques 
de sorte qu'aucune famille de polices encodée T1 ne peut les prendre en charge. 
Si vous utilisez la fonte *Computer Modern*, cela n'a pas vraiment d'importance : 
votre système disposera des polices mathématiques associées 
(ou de celles distribuées avec *Latin Modern*), qui couvrent les mathématiques TeX "de base".
Les mathématiques plus avancées nécessiteront probablement des polices séparées de toute façon. 
Les polices mathématiques appropriées à utiliser avec d'autres fontes sont évoquées 
dans la question "[](/5_fichiers/formats/fontes/fontes_t1_pour_les_mathematiques)".

Les polices *European Computer* sont distribuées avec un ensemble de polices 
"Text Companion" (TC) qui fournissent des glyphes pour les symboles couramment utilisés dans le texte. 
Les polices TC sont encodées selon l'encodage LaTeX TS1, 
et ne sont pas nécessairement aussi "stables" que les polices *European Computer*. 
Notez que les distributions modernes ont tendance à ne pas distribuer les polices *European Computer*
mais plutôt à fournir *Latin Modern* pour les polices de style *Computer Modern* encodées en T1. 
Cela peut parfois prêter à confusion lorsque les utilisateurs recompilent de vieux documents.

L'encodage de Cork est également mis en œuvre par les polices virtuelles fournies 
dans le système PSNFSS, pour les polices Adobe Type 1, 
ainsi que par la plupart des autres polices de ce type qui ont été développées 
(ou mises à disposition) pour être utilisées avec (La)TeX.

Notez que T1 (et d'autres encodages de polices sur huit bits) sont remplacés 
dans les moteurs [XeTeX](/1_generalites/glossaire/xetex) et [LuaTeX](/1_generalites/glossaire/luatex) 
qui utilisent Unicode comme encodage de base. Ces moteurs utilisent des polices codées en Unicode 
(typiquement aux formats `ttf` ou `otf`). 
Les polices <ctanpkg:cm-unicode> participent de cette évolution, tout comme l'ensemble *Latin Modern*.


:::{sources}
[What are the EC fonts?](faquk:FAQ-ECfonts)
:::
