---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, imprimerie, traits de coupe, hirondelles,
              massicotage
---

# Comment tracer des hirondelles ?

Si vous préparez un document (livre, flyer, affiche...) pour un imprimeur,
il est probable que celui-ci prévoie de l'imprimer sur du papier plus grand
que le format final. Pour le calage des différentes machines
lors de la fabrication et la découpe au bon format, il aura besoin
de repères imprimés dans les marges :
[les hirondelles](wpfr:Hirondelle_(imprimerie)) et traits de coupes.


## Avec l'extension <ctanpkg:crop>

Pour placer ces repères d'alignement dans la marge, vous pourrez utiliser
l'extension <ctanpkg:crop>, dédiée à ce sujet.

```
\documentclass[a5paper,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux-texte
  \usepackage[cam,a4,center]{crop}

\begin{document}
\lipsum[1-3]
\end{document}
```

Dans l'exemple ci-dessus, la page pour le lecteur final est disposée
dans un format A5 tandis que les traits de coupe sont disposés sur une page
au format A4. Plus généralement, vous aurez intérêt à combiner
l'extension <ctanpkg:crop> avec l'extension <ctanpkg:geometry> pour définir
la taille de votre papier et celle de la surface imprimée.


## Avec la classe <ctanpkg:memoir>

Si vous utilisez la classe <ctanpkg:memoir>,
elle contient déjà les commandes nécessaires pour préparer les traits de coupe,
et l’option de classe `showtrims` pour les afficher :

```
\documentclass[showtrims,french]{memoir}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}

  \setstocksize{216mm}{146mm}
  \settrimmedsize{210mm}{140mm}{*}
  \settrims{3mm}{3mm}
  \setlrmarginsandblock{20mm}{15mm}{*}
  \setulmarginsandblock{20mm}{20mm}{*}
  % \trimLmarks
  \checkandfixthelayout

\begin{document}
\lipsum[1-3]
\end{document}
```


:::{sources}
- [How to create crop marks](faquk:FAQ-crop),
- [How to adjust memoir crop marks line length](https://tex.stackexchange.com/q/232543),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::
