---
myst:
  html_meta:
    keywords: LaTeX, composition, document, brouillon, filigrane, postscript
---
# Comment identifier une version provisoire ?

## Avec l'extension <ctanpkg:draftwatermark>

L'extension <ctanpkg:draftwatermark> permet de signaler une version provisoire en mettant, dans la sortie du document, un mot (par défaut, "*draft*" pour "brouillon") en grisé, en travers de la feuille. L'exemple ci-dessous montre le résultat d'une telle opération :

```
\documentclass{report}
  \usepackage{lmodern}   % Caractères plus lisibles
  \usepackage{draftwatermark}

\begin{document}
Voici une version provisoire de mon texte, que je crois inspiré.
Pourriez-vous la relire et me faire part de vos commentaires 
avant la fin de la semaine ?

Merci d'avance.

\paragraph{Proposition.}
Au voleur ! au voleur ! à l’assassin ! au meurtrier ! Justice, 
juste ciel ! Je suis perdu, je suis assassiné ; on m’a coupé 
la gorge : on m’a dérobé mon argent. Qui peut-ce être ? Qu’est-il 
devenu ? Où est-il ? Où se cache-t-il ? Que ferai-je pour le 
trouver ? Où courir ? Où ne pas courir ? N’est-il point là ? 
N’est-il point ici ? Qui est-ce ? Arrête. (À lui-même, se prenant 
par le bras.) Rends-moi mon argent, coquin… Ah ! c’est moi ! Mon
esprit est troublé, et j’ignore où je suis, qui je suis, et ce que 
je fais. Hélas ! mon pauvre argent ! mon pauvre argent ! mon cher 
ami ! on m’a privé de toi ; et puisque tu m’es enlevé, j’ai perdu 
mon support, ma consolation, ma joie : tout est fini pour moi, et 
je n’ai plus que faire au monde. Sans toi, il m’est impossible de 
vivre. C’en est fait ; je n’en puis plus ; je me meurs ; je suis 
mort ; je suis enterré. N’y a-t-il personne qui veuille me 
ressusciter, en me rendant mon cher argent, ou en m’apprenant qui 
l’a pris. Euh ! que dites-vous ? Ce n’est personne. Il faut, qui 
que ce soit qui ait fait le coup, qu’avec beaucoup de soin on ait 
épié l’heure ; et l’on a choisi justement le temps que je parlais 
à mon traître de fils. Sortons. Je veux aller quérir la justice, 
et faire donner la question à toute ma maison ; à servantes, à 
valets, à fils, à fille, et à moi aussi. 
\end{document}
```

## Avec l'extension <ctanpkg:prelim2e>

L'extension <ctanpkg:prelim2e> permet d'insérer, en bas de la page, différentes informations. Si elle est en anglais par défaut, elle dispose d'une option `french` permettant d'indiquer "Version préliminaire" (mais ne change pas le format de la date affichée).

```
\documentclass[french]{report}
  \usepackage{lmodern}   % Caractères plus lisibles
  \usepackage{prelim2e}

\begin{document}
Voici une version provisoire de mon texte, que je crois inspiré.
Pourriez-vous la relire et me faire part de vos commentaires 
avant la fin de la semaine ?

Merci d'avance.

\paragraph{Proposition.}
Au voleur ! au voleur ! à l’assassin ! au meurtrier ! Justice, 
juste ciel ! Je suis perdu, je suis assassiné ; on m’a coupé 
la gorge : on m’a dérobé mon argent. Qui peut-ce être ? Qu’est-il 
devenu ? Où est-il ? Où se cache-t-il ? Que ferai-je pour le 
trouver ? Où courir ? Où ne pas courir ? N’est-il point là ? 
N’est-il point ici ? Qui est-ce ? Arrête. (À lui-même, se prenant 
par le bras.) Rends-moi mon argent, coquin… Ah ! c’est moi ! Mon
esprit est troublé, et j’ignore où je suis, qui je suis, et ce que 
je fais. Hélas ! mon pauvre argent ! mon pauvre argent ! mon cher 
ami ! on m’a privé de toi ; et puisque tu m’es enlevé, j’ai perdu 
mon support, ma consolation, ma joie : tout est fini pour moi, et 
je n’ai plus que faire au monde. Sans toi, il m’est impossible de 
vivre. C’en est fait ; je n’en puis plus ; je me meurs ; je suis 
mort ; je suis enterré. N’y a-t-il personne qui veuille me 
ressusciter, en me rendant mon cher argent, ou en m’apprenant qui 
l’a pris. Euh ! que dites-vous ? Ce n’est personne. Il faut, qui 
que ce soit qui ait fait le coup, qu’avec beaucoup de soin on ait 
épié l’heure ; et l’on a choisi justement le temps que je parlais 
à mon traître de fils. Sortons. Je veux aller quérir la justice, 
et faire donner la question à toute ma maison ; à servantes, à 
valets, à fils, à fille, et à moi aussi. 
\end{document}
```

Si vous souhaitez modifier le texte de bas de page, vous pouvez redéfinir les deux commandes de l'extension qui le génèrent : 
- `\PrelimWords` qui définit le texte (comme le "Version préliminaire" du français) ;
- `\PrelimText` qui agrège `\PrelimWords` ainsi que les éléments de date.

La [documentation](texdoc:prelim2e) de l'extension illustre ce type de modification.

## Avec l'extension <ctanpkg:draftcopy>

L'extension <ctanpkg:draftcopy> a les mêmes fonctionnalités de base que <ctanpkg:draftwatermark>, mais est limité à une sortie en Postscript (pas pour les PDF).

## Avec l'extension <ctanpkg:drafthead>

:::{warning}
L’extension <ctanpkg:drafthead> est utilisable avec LaTeX 2.09 et est, à ce titre, non recommandée. Ce qui suit est informatif.
:::

L'extension <ctanpkg:drafthead> ajoute un en-tête contenant le mot *draft*, ainsi que la date et l'heure de compilation du document.

## Avec les commandes de base

Si vous générez une sortie Postscript, il existe enfin une solution qui consiste à insérer directement du code Postscript dans le document à l'aide de la commande `\special`. On inclura par exemple le code suivant dans le préambule :

```{noedit}
\special{
! userdict begin /bop-hook{
stroke
gsave 240 100 translate
65 rotate /Times-Roman findfont 220 scalefont setfont
0 0 moveto 0.9 setgray (DRAFT) show grestore
}def end}
```
