/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex2latex;

import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXAppAdapter;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex2latex.LaTeX2LaTeX;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class LaTeXPreambleListener
extends LaTeX2LaTeX {
    private Writer writer;

    public LaTeXPreambleListener(TeXApp teXApp, Writer writer) throws IOException {
        super(teXApp, null, false);
        this.writer = writer;
    }

    public static String readPreamble(File file, final Charset charset) throws IOException {
        TeXAppAdapter teXAppAdapter = new TeXAppAdapter(){

            @Override
            public Charset getDefaultCharset() {
                return charset == null ? Charset.defaultCharset() : charset;
            }
        };
        return LaTeXPreambleListener.readPreamble(file, teXAppAdapter);
    }

    public static String readPreamble(File file, TeXApp teXApp) throws IOException {
        StringWriter stringWriter = new StringWriter();
        LaTeXPreambleListener laTeXPreambleListener = new LaTeXPreambleListener(teXApp, stringWriter);
        TeXParser teXParser = new TeXParser(laTeXPreambleListener);
        teXParser.parse(file);
        return stringWriter.toString();
    }

    @Override
    public void beginDocument(TeXObjectList teXObjectList) throws IOException {
        throw new EOFException();
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
        this.getParser().message("message.reading", file.toString());
        if (charset != null) {
            this.getParser().message("message.charset", charset.name());
        }
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public LaTeXSty requirepackage(KeyValList keyValList, String string, boolean bl, TeXObjectList teXObjectList) throws IOException {
        LaTeXSty laTeXSty = this.getLaTeXSty(keyValList, string, bl, teXObjectList);
        this.addFileReference(laTeXSty);
        this.loadedPackages.add(laTeXSty);
        this.writeCodePoint(this.parser.getEscChar());
        this.write("RequirePackage");
        if (keyValList != null) {
            this.write('[');
            this.write(keyValList.toString(this.parser));
            this.write(']');
        }
        this.writeCodePoint(this.parser.getBgChar());
        this.write(string);
        this.writeCodePoint(this.parser.getEgChar());
        return laTeXSty;
    }

    @Override
    public LaTeXSty usepackage(KeyValList keyValList, String string, boolean bl, TeXObjectList teXObjectList) throws IOException {
        LaTeXSty laTeXSty = this.getLaTeXSty(keyValList, string, bl, teXObjectList);
        this.addFileReference(laTeXSty);
        this.loadedPackages.add(laTeXSty);
        this.writeCodePoint(this.parser.getEscChar());
        this.write("usepackage");
        if (keyValList != null) {
            this.write('[');
            this.write(keyValList.toString(this.parser));
            this.write(']');
        }
        this.writeCodePoint(this.parser.getBgChar());
        this.write(string);
        this.writeCodePoint(this.parser.getEgChar());
        return laTeXSty;
    }

    @Override
    public void includegraphics(TeXObjectList teXObjectList, KeyValList keyValList, String string) throws IOException {
        this.writeCodePoint(this.parser.getEscChar());
        this.write("includegraphics");
        if (keyValList != null && keyValList.size() > 0) {
            this.write('[');
            this.write(keyValList.toString(this.parser));
            this.write(']');
        }
        this.writeCodePoint(this.parser.getBgChar());
        this.write(string);
        this.writeCodePoint(this.parser.getEgChar());
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
        if (this.writer != null) {
            if (n <= 65535) {
                this.writer.write((char)n);
            } else {
                for (char c : Character.toChars(n)) {
                    this.writer.write(c);
                }
            }
        } else {
            this.getParser().warning("null writer");
        }
    }

    @Override
    public void write(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(c);
        } else {
            this.getParser().warning("null writer");
        }
    }

    @Override
    public void write(String string) throws IOException {
        if (this.writer != null) {
            this.writer.write(string);
        } else {
            this.getParser().warning("null writer");
        }
    }

    @Override
    public void writeln(String string) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.format("%s%n", string));
        } else {
            this.getParser().warning("null writer");
        }
    }

    @Override
    public void writeliteral(String string) throws IOException {
        this.write(string);
    }

    @Override
    public void writeliteralln(String string) throws IOException {
        this.writeln(string);
    }

    @Override
    public void writeln(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.format("%c%n", Character.valueOf(c)));
        } else {
            this.getParser().warning("null writer");
        }
    }

    @Override
    public void writeln() throws IOException {
        if (this.writer != null) {
            this.writer.write(String.format("%n", new Object[0]));
        } else {
            this.getParser().warning("null writer");
        }
    }
}

