/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.flowfram;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.MissingValue;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFramSty;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameData;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameType;
import java.io.IOException;

public class SetFrameAttrs
extends ControlSequence {
    FlowFramSty sty;
    FlowFrameType type;

    public SetFrameAttrs(String string, FlowFrameType flowFrameType, FlowFramSty flowFramSty) {
        super(string);
        this.type = flowFrameType;
        this.sty = flowFramSty;
    }

    @Override
    public Object clone() {
        return new SetFrameAttrs(this.getName(), this.type, this.sty);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    protected void applySettings(TeXParser teXParser, TeXObjectList teXObjectList, FlowFrameData flowFrameData, KeyValList keyValList) throws IOException {
        Object object;
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObject teXObject = null;
        Object object2 = keyValList.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            TeXObject teXObject2 = (TeXObject)keyValList.get(object);
            if (teXObject2 instanceof MissingValue) {
                teXObject2 = null;
            }
            try {
                String string;
                TeXDimension teXDimension;
                if (((String)object).equals("width")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setWidth(teXDimension);
                    continue;
                }
                if (((String)object).equals("height")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setHeight(teXDimension);
                    continue;
                }
                if (((String)object).equals("x")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setX(teXDimension);
                    continue;
                }
                if (((String)object).equals("y")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setY(teXDimension);
                    continue;
                }
                if (((String)object).equals("evenx")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setEvenX(teXDimension);
                    continue;
                }
                if (((String)object).equals("eveny")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setEvenY(teXDimension);
                    continue;
                }
                if (((String)object).equals("oddx")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setOddX(teXDimension);
                    continue;
                }
                if (((String)object).equals("oddy")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setOddY(teXDimension);
                    continue;
                }
                if (((String)object).equals("offset")) {
                    if (teXObject2 instanceof TeXDimension) {
                        teXDimension = (TeXDimension)teXObject2;
                    } else {
                        teXDimension = TeXParserUtils.toTeXDimension(teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXDimension);
                    }
                    flowFrameData.setOffset(teXDimension);
                    continue;
                }
                if (((String)object).equals("valign")) {
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    if (string.length() != 1) {
                        throw new LaTeXSyntaxException(teXParser, "latex.invalid.option.value", object, string);
                    }
                    flowFrameData.setVAlign(string.charAt(0));
                    continue;
                }
                if (((String)object).equals("label")) {
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    this.sty.setFrameLabel(flowFrameData, string);
                    continue;
                }
                if (((String)object).equals("style")) {
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    flowFrameData.setStyle(string);
                    continue;
                }
                if (((String)object).equals("border")) {
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    flowFrameData.setFrameBorderCsName(string);
                    continue;
                }
                if (((String)object).equals("bordercolor")) {
                    flowFrameData.setBorderColor(this.sty.getColor(teXObject2));
                    continue;
                }
                if (((String)object).equals("textcolor")) {
                    flowFrameData.setTextColor(this.sty.getColor(teXObject2));
                    continue;
                }
                if (((String)object).equals("backcolor")) {
                    flowFrameData.setBackColor(this.sty.getColor(teXObject2));
                    continue;
                }
                if (((String)object).equals("pages")) {
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    flowFrameData.setPageList(string);
                    continue;
                }
                if (((String)object).equals("excludepages")) {
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    flowFrameData.setExcludedPageList(string);
                    continue;
                }
                if (((String)object).equals("hide")) {
                    if (teXObject2 == null || teXObject2.isEmpty()) {
                        flowFrameData.setHidden(true);
                        continue;
                    }
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    flowFrameData.setHidden(Boolean.parseBoolean(string));
                    continue;
                }
                if (((String)object).equals("hidethis")) continue;
                if (((String)object).equals("clear")) {
                    if (teXObject2 == null || teXObject2.isEmpty()) {
                        flowFrameData.setClear(true);
                        continue;
                    }
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    flowFrameData.setClear(Boolean.parseBoolean(string));
                    continue;
                }
                if (((String)object).equals("margin")) {
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    flowFrameData.setMarginSide(string);
                    continue;
                }
                if (((String)object).equals("style")) {
                    if (teXObject2 instanceof DataObjectList) {
                        string = teXObject2.toString(teXParser);
                    } else {
                        string = teXParser.expandToString(teXObject2, teXObjectList).trim();
                        keyValList.put((String)object, new DataObjectList(teXParserListener, string));
                    }
                    flowFrameData.setStyle(string);
                    continue;
                }
                if (((String)object).equals("shape")) {
                    if (teXObject2 == null || teXObject2.isEmpty() || TeXParserUtils.isControlSequence(teXObject2, "relax")) {
                        flowFrameData.setShape(null);
                        continue;
                    }
                    flowFrameData.setShape((TeXObject)teXObject2.clone());
                    continue;
                }
                if (((String)object).equals("angle")) {
                    TeXNumber teXNumber;
                    if (teXObject2 instanceof TeXNumber) {
                        teXNumber = (TeXNumber)teXObject2;
                    } else {
                        teXNumber = TeXParserUtils.toTeXNumber(false, teXObject2, teXParser, teXObjectList);
                        keyValList.put((String)object, teXNumber);
                    }
                    flowFrameData.setAngle(teXNumber);
                    continue;
                }
                if (!((String)object).equals("html")) continue;
                teXObject = (TeXObject)teXObject2.clone();
            }
            catch (NullPointerException nullPointerException) {
                throw new LaTeXSyntaxException((Throwable)nullPointerException, teXParser, "latex.error.missing_key_value", object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (teXObject2 == null) {
                    throw new LaTeXSyntaxException((Throwable)illegalArgumentException, teXParser, "flowfram.invalid_frame_noval_setting", new Object[]{object, this.type});
                }
                throw new LaTeXSyntaxException((Throwable)illegalArgumentException, teXParser, "flowfram.invalid_frame_setting", new Object[]{object, teXObject2.toString(teXParser), this.type});
            }
        }
        if (teXObject != null && (object = ((KeyValList)(object2 = TeXParserUtils.toKeyValList(teXObject, teXParser))).getBoolean("show", teXParser, teXObjectList)) != null && ((Boolean)object).booleanValue()) {
            flowFrameData.showContent(teXParser, teXObjectList, (KeyValList)object2);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        boolean bl = this.popModifier(teXParser, teXObjectList, 42) == 42;
        String[] stringArray = this.popLabelString(teXParser, teXObjectList).trim().split(" *, *");
        KeyValList keyValList = TeXParserUtils.popKeyValList(teXParser, teXObjectList);
        if (bl) {
            for (String string : stringArray) {
                FlowFrameData flowFrameData = this.sty.getFrame(this.type, string);
                this.applySettings(teXParser, teXObjectList, flowFrameData, keyValList);
            }
        } else {
            for (String string : stringArray) {
                try {
                    int n = Integer.parseInt(string);
                    FlowFrameData flowFrameData = this.sty.getFrame(this.type, n);
                    this.applySettings(teXParser, teXObjectList, flowFrameData, keyValList);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", string);
                }
            }
        }
    }
}

