#ifndef W32SNPRINTF_H
#define W32SNPRINTF_H

#ifdef WIN32
#ifdef __cplusplus
extern "C" {
#endif
#include <stdio.h>
#include <stdarg.h>
#undef snprintf
#undef vsnprintf

static __inline int
kpse_vsnprintf (char *str, size_t size, const char *format, va_list ap)
{
  int ret = _vsnprintf (str, size, format, ap);
  if (size > 0 && (unsigned)ret >= (unsigned)size)
    str [size - 1] = '\0';
  return ret;
}

static __inline int
kpse_snprintf (char *str, size_t size, const char *format, ...)
{
  int ret;
  va_list ap;

  va_start (ap, format);
  ret = kpse_vsnprintf (str, size, format, ap);
  va_end (ap);
  return ret;
}

#define snprintf kpse_snprintf
#define vsnprintf kpse_vsnprintf
#ifdef __cplusplus
}
#endif
#endif

#endif
