import xbmc
import xbmcaddon

PREFIXES = ['ANOVA', 'VIPSS', 'LIM2', 'NATH', 'NICE', 'SHUB', 'PREM', 'GIZ', 'GSPRTS', 'GEH', 'TVK', 'MTXIE', 'XTC', 'SCTV', 'SUP', 'UKT', 'LIMIT', 'FAB', 'ACE', 'HORIZ', 'ROOT2', 'FREE', 'MEGA', 'IPTS', 'JINX2', 'ROOT', 'IPLAY', 'MAXI', 'END', 'VDRTV', 'SPRM', 'MCKTV', 'TWIST', 'PREST', 'MATS', 'BLKI']

import dixie

def resolve(url, recording=False):
    if not url:
        return  None, None

    for prefix in PREFIXES:
        if url.startswith(prefix):
            import linkloader
            stream = linkloader.getURL(url)
            # if recording:
            #     stream = 'url=' + stream
            play   = 'IPLAYD' not in url
            return stream, play

    stream = None
    play   = None

    if url.startswith('HDTV'):
        import smh
        stream = smh.getURL(url)
        play   = True

    if url.startswith('LIVETV'):
        import livetv
        stream = livetv.getLIVETV(url)
        play   = True

    if url.startswith('FLA'):
        ADDONID = 'plugin.video.FlawlessTv'
        ADDON   =  xbmcaddon.Addon(ADDONID)

        path    =  ADDON.getAddonInfo('path')

        import sys
        sys.path.insert(0, path)

        import iptv2
        url    = url.split(':', 1)[-1]
        stream = iptv2.GetStreamURLByChannelID(url)
        if recording:
            stream = 'url=' + stream
        play   = True


    return stream, play