#
#      Copyright (C) 2014 Richard Dean
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with XBMC; see the file COPYING.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#


def mapChannelName(name):
    channel = name.strip().upper()

    if channel == 'BBCNEWS' : return 'BBC NEWS'
    if channel == 'BBC1L' : return 'BBC ONE LONDON'
    if channel == 'BBC1SOUTH' : return 'BBC ONE SOUTH'
    if channel == 'BBC1WALES' : return 'BBC ONE WALES'
    if channel == 'BBC2' : return 'BBC TWO'
    if channel == 'BBC2HD' : return 'BBC TWO HD'
    if channel == 'BBC1 HD' : return 'BBC ONE HD UK'

    if channel == 'BBC 1' : return 'BBC ONE'
    if channel == 'BBC 1  HD' : return 'BBC ONE HD'
    if channel == 'BBC 1 HD' : return 'BBC ONE HD'
    if channel == 'BBC 1 LONDON' : return 'BBC 1 LONDON'
    if channel == 'BBC 1 NORTHEN IRELAND' : return 'BBC ONE NORTHEN IRELAND'
    if channel == 'BBC 1 SCOTLAND' : return 'BBC ONE SCOTLAND'
    if channel == 'BBC 1 WALES' : return 'BBC ONE WALES'
    if channel == 'BBC1' : return 'BBC ONE'
    if channel == 'BBC1  HD' : return 'BBC ONE HD'
    if channel == 'BBC1 HD' : return 'BBC ONE HD'
    if channel == 'BBC1 LONDON' : return 'BBC 1 LONDON'
    if channel == 'BBC1 NORTHEN IRELAND' : return 'BBC ONE NORTHEN IRELAND'
    if channel == 'BBC1 SCOTLAND' : return 'BBC ONE SCOTLAND'
    if channel == 'BBC1 WALES' : return 'BBC ONE WALES'

    if channel == 'BBC 2' : return 'BBC TWO'
    if channel == 'BBC 2 HD' : return 'BBC TWO HD'
    if channel == 'BBC 2 NORTHEN IRELAND' : return 'BBC TWO NORTHEN IRELAND'
    if channel == 'BBC 2 SCOTLAND' : return 'BBC TWO SCOTLAND'
    if channel == 'BBC 2 WALES' : return 'BBC TWO WALES'
    if channel == 'BBC2' : return 'BBC TWO'
    if channel == 'BBC2 HD' : return 'BBC TWO HD'
    if channel == 'BBC2 NORTHEN IRELAND' : return 'BBC TWO NORTHEN IRELAND'
    if channel == 'BBC2 SCOTLAND' : return 'BBC TWO SCOTLAND'
    if channel == 'BBC2 WALES' : return 'BBC TWO WALES'

    if channel == 'BBC 1 [SD]' : return 'BBC ONE [SD]'
    if channel == 'BBC 1 [HD]' : return 'BBC ONE [HD]'
    if channel == 'BBC 2 [SD]' : return 'BBC TWO [SD]'
    if channel == 'BBC 2 [HD]' : return 'BBC TWO [HD]'
    if channel == 'BBC 1 HD' : return 'BBC ONE HD'
    if channel == 'BBC 1 SD' : return 'BBC ONE SD'
    if channel == 'BBC 2 HD' : return 'BBC TWO HD'
    if channel == 'BBC 2 SD' : return 'BBC TWO SD'
    if channel == 'BBC HD 2' : return 'BBC TWO [HD]'
    if channel == 'C4 [SD]' : return 'CHANNEL 4 [SD]'
    if channel == 'C4 [HD]' : return 'CHANNEL 4 [HD]'
    if channel == 'FIVE' : return 'CHANNEL 5'
    if channel == 'FIVE [SD]' : return 'CHANNEL 5 [SD]'
    if channel == 'FIVE [HD]' : return 'CHANNEL 5 [HD]'
    if channel == 'BBC 4 HD [SD]' : return 'BBC FOUR [SD]'
    if channel == 'BBC 4 HD [HD]' : return 'BBC FOUR [HD]'
    if channel == 'BBC 4 HD' : return 'BBC FOUR HD'
    if channel == 'BBC 4' : return 'BBC FOUR UK'
    if channel == 'BBC4 HD [SD]' : return 'BBC FOUR [SD]'
    if channel == 'BBC4 HD [HD]' : return 'BBC FOUR [HD]'
    if channel == 'BBC4 HD' : return 'BBC FOUR HD'
    if channel == 'BBC4' : return 'BBC FOUR UK'
    if channel == 'BBC HD 4 / CBEEBIES HD' : return 'BBC FOUR [HD]'
    if channel == '3 ITV' : return '3 ITV1'
    if channel == '103 ITV HD' : return '103 ITV1 HD'
    if channel == 'ITV' : return 'ITV1'
    if channel == 'ITV HD' : return 'ITV1 HD'
    if channel == 'ITV SD' : return 'ITV1 SD'
    if channel == 'ITV 2 [SD]' : return 'ITV2 [SD]'
    if channel == 'ITV 2 [HD]' : return 'ITV2 [HD]'
    if channel == 'ITV 3 [SD]' : return 'ITV3 [SD]'
    if channel == 'ITV 3 [HD]' : return 'ITV3 [HD]'
    if channel == 'ITV 4 [SD]' : return 'ITV4 [SD]'
    if channel == 'ITV 4 [HD]' : return 'ITV4 [HD]'

    if channel == 'ITV 1 SD' : return 'ITV1 SD'
    if channel == 'ITV 2 SD' : return 'ITV2 SD'
    if channel == 'ITV 3 SD' : return 'ITV3 SD'
    if channel == 'ITV 4 SD' : return 'ITV4 SD'

    if channel == 'ITV 1 HD' : return 'ITV1 HD'
    if channel == 'ITV 1' : return 'ITV1'
    if channel == 'ITV 2 HD' : return 'ITV2 HD'
    if channel == 'ITV 2' : return 'ITV2'
    if channel == 'ITV 3' : return 'ITV3'
    if channel == 'ITV 3 HD' : return 'ITV3 HD'
    if channel == 'ITV 4 HD' : return 'ITV4 HD'
    if channel == 'ITV 4' : return 'ITV4'

    if channel == 'ITV BE' : return 'ITV BE'
    if channel == 'ITVBE' : return 'ITV BE'
    if channel == 'ITVBE HD' : return 'ITV BE HD'
    if channel == 'MORE 4' : return 'MORE4'
    if channel == '4 SEVEN' : return '4SEVEN'
    if channel == '4 SEVEN' : return '4SEVEN'
    if channel == 'MY 5' : return '5+24'
    if channel == 'MY5' : return '5+24'
    if channel == 'BBC RED BUTTON 1' : return 'BBC RED BUTTON'
    if channel == 'BBC 1 NORTHEN IRELAND [SD]' : return 'BBC ONE NORTHEN IRELAND [SD]'
    if channel == 'BBC 1 NORTHEN IRELAND [HD]' : return 'BBC ONE NORTHEN IRELAND [HD]'
    if channel == 'BBC 1 SCOTLAND [SD]' : return 'BBC ONE SCOTLAND [SD]'
    if channel == 'BBC 1 SCOTLAND [HD]' : return 'BBC ONE SCOTLAND [HD]'
    if channel == 'BBC 1 WALES [SD]' : return 'BBC ONE WALES [SD]'
    if channel == 'BBC 1 WALES [HD]' : return 'BBC ONE WALES [HD]'
    if channel == 'BBC 1 LONDON [SD]' : return 'BBC ONE LONDON [SD]'
    if channel == 'BBC 1 LONDON [HD]' : return 'BBC ONE LONDON [HD]'
    if channel == 'BBC 2 NORTHEN IRELAND [SD]' : return 'BBC TWO NORTHEN IRELAND [SD]'
    if channel == 'BBC 2 NORTHEN IRELAND [HD]' : return 'BBC TWO NORTHEN IRELAND [HD]'
    if channel == 'BBC 2 SCOTLAND [SD]' : return 'BBC TWO SCOTLAND [SD]'
    if channel == 'BBC 2 SCOTLAND [HD]' : return 'BBC TWO SCOTLAND [HD]'
    if channel == 'BBC 2 WALES [SD]' : return 'BBC TWO WALES [SD]'
    if channel == 'BBC 2 WALES [HD]' : return 'BBC TWO WALES [HD]'
    if channel == 'RTE1' : return 'RTE ONE'
    if channel == 'RTE2' : return 'RTE TWO'
    if channel == 'RTE 1' : return 'RTE ONE'
    if channel == 'RTE 1 HD' : return 'RTE ONE HD'
    if channel == 'RTE 2' : return 'RTE TWO'
    if channel == 'RTE JUNIOR' : return 'RTE JR'
    if channel == 'TV3' : return 'TV3'
    if channel == '3E' : return '3E'
    if channel == 'SKY 12' : return 'SKY 1'
    if channel == 'SKY ONE HD' : return 'SKY 1 HD'
    if channel == 'SKY ONE SD' : return 'SKY 1 SD'
    if channel == 'SKY TWO SD' : return 'SKY 2 SD'
    if channel == 'SKY ONE' : return 'SKY 1'
    if channel == 'SKY TWO' : return 'SKY 2'
    if channel == 'SKY1' : return 'SKY 1'
    if channel == 'SKY2' : return 'SKY 2'
    if channel == 'SKY1' : return 'SKY 1'
    if channel == 'SKY2' : return 'SKY 2'
    if channel == 'SKYLIVING' : return 'SKY LIVING'
    if channel == 'W HD UK' : return 'WATCH HD'

    if channel == 'VICELAND HD' : return 'VICELAND UK'
    if channel == 'FOX UK' : return 'FOX UK'
    if channel == 'FOX GB' : return 'FOX UK'
    if channel == 'FOX US' : return 'FOX'
    if channel == 'SYFY UK' : return 'SYFY UK'
    if channel == 'UNIVERSAL' : return 'UK UNIVERSAL CHANNEL'
    if channel == 'DAVEJAVU' : return 'DAVE JA VU'
    if channel == 'UK GOLD' : return 'GOLD'
    if channel == 'COMEDY CENTRAL XTRA' : return 'COMEDY CENTRAL EXTRA'
    if channel == 'COMEDY CENTRAL EXTRA SD' : return 'COMEDY CENTRAL EXTRA'
    if channel == 'COMEDY CENTRAL GB' : return 'COMEDY CENTRAL'
    if channel == 'COMEDYXTRA 1' : return 'COMEDY CENTRAL EXTRA UK'
    if channel == 'COMEDYCENT 1' : return 'COMEDY CENTRAL UK'
    if channel == 'COMEDY CENTRAL US' : return 'COMEDY CENTRAL HD'
    if channel == 'COMEDYCENTRAL' : return 'COMEDY CENTRAL US'
    if channel == '&HD' : return 'AND TV'

    if channel == 'PBS UK' : return 'UK PBS'
    if channel == 'SONY ENTERTAINMENT' : return 'SONY CHANNEL'
    if channel == 'E! UK' : return 'ENTERTAINMENT HD'
    if channel == 'E! +1' : return 'ENTERTAINMENT HD +1'
    if channel == 'E!' : return 'ENTERTAINMENT HD'
    if channel == 'SKY REAL LIVES' : return 'REAL LIVES'
    if channel == 'AMC UK [SD]' : return 'UK AMC'
    if channel == 'TLC UK' : return 'TLC'
    if channel == 'PICK TV' : return 'PICK'
    if channel == 'SKY ARTS' : return 'SKY ARTS 1'
    if channel == 'GOLD' : return 'GOLD'
    if channel == 'LIFETIME UK' : return 'UK LIFETIME'
    if channel == 'YESTERDAY TV' : return 'YESTERDAY'
    if channel == 'HOME TV' : return 'HOME'
    if channel == 'TRU TV' : return 'TRUTV UK'
    if channel == 'CHALLENGE TV' : return 'CHALLENGE'

    if channel == 'SKY SPORT NEWS HQ' : return 'SKY SPORTS NEWS HQ'
    if channel == 'SKY SP NEWS IRELANDHQ' : return 'SKY SPORTS NEWS IRE'
    if channel == 'SKY SP NEWSHQ' : return 'SKY SPORTS NEWS'
    if channel == 'SKY SPORT S 1' : return 'SKY SPORTS 1'
    if channel == 'SKY SPORTS FHD 2' : return 'SKY SPORTS 2 FHD'
    if channel == 'SKY SPORTS FHD 3' : return 'SKY SPORTS 3 FHD'
    if channel == 'SKY SPORTS FHD 4' : return 'SKY SPORTS 4 FHD'
    if channel == 'SKY SPORTS FHD 5' : return 'SKY SPORTS 5 FHD'
    if channel == 'SKY SPORTS FHD F1' : return 'SKY SPORTS F1 FHD'
    if channel == 'SKY SPORT 1 SD' : return 'SKY SPORTS 1 SD'
    if channel == 'SKY SPORT 1 HD' : return 'SKY SPORTS 1 HD'
    if channel == 'SKY SPORT 2 SD' : return 'SKY SPORTS 2 SD'
    if channel == 'SKY SPORT 2 HD' : return 'SKY SPORTS 2 HD'
    if channel == 'SKY SPORT 3 SD' : return 'SKY SPORTS 3 SD'
    if channel == 'SKY SPORT 3 HD' : return 'SKY SPORTS 3 HD'
    if channel == 'SKY SPORT 4 SD' : return 'SKY SPORTS 4 SD'
    if channel == 'SKY SPORT 4 HD' : return 'SKY SPORTS 4 HD'
    if channel == 'SKY SPORT 5 SD' : return 'SKY SPORTS 5 SD'
    if channel == 'SKY SPORT 5 HD' : return 'SKY SPORTS 5 HD'

    if channel == 'BT SPORT / ESPN' : return 'BT SPORT-ESPN 2'
    if channel == 'BT SPORT / ESPN' : return 'BT SPORT-ESPN 2'
    if channel == 'BT SPORT//ESPN' : return 'BT SPORT-ESPN'
    if channel == 'BT SPORT ESPNHD' : return 'BT SPORT-ESPN HQ'
    if channel == 'BT SPORT ESPN HD' : return 'BT SPORT-ESPN HD'
    if channel == 'BT SPORT ESPN' : return 'BT SPORT-ESPN'

    if channel == 'BT SPORT 3 FHD' : return 'BT SPORT EUROPE FHD'
    if channel == 'BT SPORT 3 HD' : return 'BT SPORT EUROPE HD'
    if channel == 'BT SPORT 3 SD' : return 'BT SPORT EUROPE SD'
    if channel == 'BT SPORT 3' : return 'BT SPORT EUROPE'
    if channel == 'BT SPORT ESPN HD' : return 'BT SPORT-ESPN HD'

    if channel == 'BT SPORT 3 HD' : return 'BT SPORT EUROPE HD'
    if channel == 'BT SPORT 3 HQ' : return 'BT SPORT EUROPE HQ'
    if channel == 'BT SPORT 3' : return 'BT SPORT EUROPE'
    if channel == 'BT SPORT 3 (EX EUROPE)' : return 'BT SPORT EUROPE'

    if channel == 'BT SPORTS 1 HD' : return 'BT SPORT 1 HD'
    if channel == 'BT SPORTS 2 HD' : return 'BT SPORT 2 HD'
    if channel == 'BT SPORTS ESPN' : return 'BT SPORT-ESPN'
    if channel == 'BT SPORTS EUROPE' : return 'BT SPORT EUROPE'

    if channel == 'LIVERPOOL TV' : return 'LFC TV'
    if channel == 'LIVERPOOL TV HD' : return 'LFC TV HD'

    if channel == 'EUROSPORT 1 UK [SD]' : return 'EUROSPORT [SD]'
    if channel == 'EUROSPORT 1 UK [HD]' : return 'EUROSPORT [HD]'
    if channel == 'EUROSPORTS 2 UK [SD]' : return 'EUROSPORT 2 [SD]'
    if channel == 'EUROSPORTS 2 UK [HD]' : return 'EUROSPORT 2 [HD]'

    if channel == 'EUROSPORT 1 HD' : return 'EUROSPORT'
    if channel == 'EUROSPORT 2 HD' : return 'EUROSPORT 2'
    if channel == 'EUROSPORT 1' : return 'EUROSPORT'

    if channel == 'EIR SPORT 1 [SD]' : return 'SETANTA IRELAND'
    if channel == 'EIR SPORT 2 [SD]' : return 'SETANTA SPORTS 1'
    if channel == 'EIR SPORTS 1' : return 'SETANTA IRELAND'
    if channel == 'EIR SPORTS 2' : return 'SETANTA SPORTS 1'
    if channel == 'PREMIER SPORTS [SD]' : return 'PREMIER SPORT [SD]'
    if channel == 'PREMIER SPORTS [HD]' : return 'PREMIER SPORT [HD]'

    if channel == 'SKY PREM 1' : return 'SKY PREMIERE UK'
    if channel == 'SKY PREMIERE [SD]' : return 'SKY PREMIERE'
    if channel == 'SKY PREMIERE [SD]' : return 'SKY PREMIERE'
    if channel == 'SKY DISNEY [SD]' : return 'SKY DISNEY'
    if channel == 'SKY SHOWCASE' : return 'SKY SHOWCASE'
    if channel == 'SKY ACTION & ADVENTURE' : return 'SKY ACTION'
    if channel == 'SKY GREATS' : return 'SKY MODERN GREATS'
    if channel == 'SKY DRAMA & ROMANCE' : return 'SKY DRAMA'
    if channel == 'SKYDRAMAROM' : return 'SKY DRAMA UK'
    if channel == 'SKY DRAMA &AMP; ROMANCE' : return 'SKY DRAMA SD'
    if channel == 'SKY DRAMA & ROM HD' : return 'SKY DRAMA HD'
    if channel == 'SKY SCIFI & HORROR' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY SCFI HORROR' : return 'SKY SCI-FIHORROR SD'
    if channel == 'SKY SCFI/HORROR' : return 'SKY SCI-FIHORROR UK'
    if channel == 'SKY CRIME & THRILLER' : return 'SKY THRILLER'
    if channel == 'SKY ACTION & ADVENTURE [SD]' : return 'SKY ACTION'
    if channel == 'SKY DRAMA & ROMANCE [SD]' : return 'SKY DRAMA'
    if channel == 'SKY CRIME & THRILLER [SD]' : return 'SKY THRILLER'

    if channel == 'SKY CINEMA ACTION HD' : return 'SKY ACTION HD'
    if channel == 'SKY MOVIES ACTION HD' : return 'SKY ACTION HD'
    if channel == 'SKY MOVIES ACTION & ADVENTURE HD' : return 'SKY ACTION HD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE' : return 'SKY ACTION'
    if channel == 'SKY MOVIES ACTION & ADVENTURE' : return 'SKY ACTION'
    if channel == 'SKY MOVIES ACTION & ADVENTURE' : return 'SKY ACTION'
    if channel == 'SKY MOVIES COMEDY HD' : return 'SKY COMEDY HD'
    if channel == 'SKY MOVIES COMEDY' : return 'SKY COMEDY'
    if channel == 'SKY MOVIES COMEDY' : return 'SKY COMEDY'
    if channel == 'SKY MOVIES THRILLER HD' : return 'SKY THRILLER HD'
    if channel == 'SKY MOVIES THRILLER HD' : return 'SKY THRILLER HD'
    if channel == 'SKY MOVIES THRILLER' : return 'SKY THRILLER'
    if channel == 'SKY MOVIES CRIME' : return 'SKY THRILLER'
    if channel == 'SKY MOVIES CRIME & THRILLER HD' : return 'SKY THRILLER HD'
    if channel == 'SKY MOVIES CRIME & THRILLER' : return 'SKY THRILLER'
    if channel == 'SKY MOVIES DISNEY HD' : return 'SKY DISNEY HD'
    if channel == 'SKY MOVIES DISNEY HD' : return 'SKY DISNEY HD'
    if channel == 'SKY MOVIES DISNEY' : return 'SKY DISNEY'
    if channel == 'SKY MOVIES DRAMA&ROMANCE HD' : return 'SKY DRAMA HD'
    if channel == 'SKY MOVIES DRAMA & ROMANCE HD' : return 'SKY DRAMA HD'
    if channel == 'SKY MOVIES DRAMA & ROMANCE' : return 'SKY DRAMA'
    if channel == 'SKY MOVIES DRAMA' : return 'SKY DRAMA'
    if channel == 'SKY MOVIES DRAMA HD' : return 'SKY DRAMA HD'
    if channel == 'SKY MOVIES CHRISTMAS' : return 'SKY DRAMA'
    if channel == 'SKY MOVIES FAMILY HD' : return 'SKY FAMILY HD'
    if channel == 'SKY MOVIES FAMILY' : return 'SKY FAMILY'
    if channel == 'SKY MOVIES GREATS HD' : return 'SKY MODERN GREATS HD'
    if channel == 'SKY MOVIES GREATS' : return 'SKY MODERN GREATS'
    if channel == 'SKY MOVIES PREMIER HD' : return 'SKY PREMIERE HD'
    if channel == 'SKY MOVIES PREMIER' : return 'SKY PREMIERE'
    if channel == 'SKY MOVIES PREMIERE' : return 'SKY PREMIERE'
    if channel == 'SKY MOVIES SCI-FI HORROR' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY MOVIES SCI-FI/HORROR HD' : return 'SKY SCI-FIHORROR HD'
    if channel == 'SKY MOVIES SCI-FI HORROR HD' : return 'SKY SCI-FIHORROR HD'
    if channel == 'SKY MOVIES SCIFI & HORROR HD' : return 'SKY SCI-FIHORROR HD'
    if channel == 'SKY MOVIES SCIFI & HORROR' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY MOVIES SCIFI AND HORROR HD' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY MOVIES SCFI-HORROR' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY MOVIES HORROR' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY MOVIES SELECT HD' : return 'SKY SELECT HD'
    if channel == 'SKY MOVIES SELECT' : return 'SKY SELECT'
    if channel == 'SKY MOVIES SHOWCASE HD' : return 'SKY SHOWCASE HD'
    if channel == 'SKY MOVIES SHOWCASE' : return 'SKY SHOWCASE'

    if channel == 'SKY CINEMA COMEDY' : return 'SKY COMEDY'
    if channel == 'SKY CINEMA COMEDY SD' : return 'SKY COMEDY SD'
    if channel == 'SKY CINEMA COMEDY HD' : return 'SKY COMEDY HD'
    if channel == 'SKY CINEMA PREMIERE' : return 'SKY PREMIERE'
    if channel == 'SKY CINEMA PREMIERE HD' : return 'SKY PREMIERE HD'
    if channel == 'SKY CINEMA PREMIERE +1' : return 'SKY PREMIERE +1'
    if channel == 'SKY CINEMA PREMIERE' : return 'SKY PREMIERE'
    if channel == 'SKY CINEMA DISNEY' : return 'SKY DISNEY'
    if channel == 'SKY CINEMA DISNEY HD' : return 'SKY DISNEY HD'
    if channel == 'SKY CINEMA SHOWCASE' : return 'SKY SHOWCASE'
    if channel == 'SKY CINEMA SHOWCASE HD' : return 'SKY SHOWCASE HD'
    if channel == 'SKY CINEMA ACTION AND ADVENTURE' : return 'SKY ACTION'
    if channel == 'SKY CINEMA ACTION AND ADVENTURE HD' : return 'SKY ACTION HD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE SD' : return 'SKY ACTION SD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE HD' : return 'SKY ACTION HD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE' : return 'SKY ACTION'
    if channel == 'SKY CINEMA ACTION&ADVENTURE' : return 'SKY ACTION'
    if channel == 'SKY CINEMA CRIME AND THRILLER HD' : return 'SKY THRILLER'
    if channel == 'SKY CINEMA MODERN GREATS' : return 'SKY MODERN GREATS'
    if channel == 'SKY CINEMA SUPERHERO SD' : return 'SKY MODERN GREATS SD'
    if channel == 'SKY CINEMA SUPERHERO HD' : return 'SKY MODERN GREATS HD'
    if channel == 'SKY CINEMA GREATS SD' : return 'SKY MODERN GREATS SD'
    if channel == 'SKY CINEMA GREATS HD' : return 'SKY MODERN GREATS HD'
    if channel == 'SKY CINEMA GREATS' : return 'SKY MODERN GREATS'
    if channel == 'SKY CINEMA HITS' : return 'SKY HITS'
    if channel == 'SKY CINEMA HITS SD' : return 'SKY HITS SD'
    if channel == 'SKY CINEMA HITS SD' : return 'SKY HITS SD'
    if channel == 'SKY CINEMA DRAMA AND ROMANCE' : return 'SKY DRAMA'
    if channel == 'SKY CINEMA DRAMA AND ROMANCE SD' : return 'SKY DRAMA SD'
    if channel == 'SKY CINEMA DRAMA AND ROMANCE HD' : return 'SKY DRAMA HD'
    if channel == 'SKY CINEMA DRAMA & ROMANCE SD' : return 'SKY DRAMA SD'
    if channel == 'SKY CINEMA DRAMA & ROMANCE HD' : return 'SKY DRAMA HD'
    if channel == 'SKY CINEMA DRAMA & ROMANCE' : return 'SKY DRAMA'
    if channel == 'SKY CINEMA CHRISTMAS HD' : return 'SKY DRAMA [XMAS] HD'
    if channel == 'SKY CINEMA CHRISTMAS' : return 'SKY DRAMA [XMAS]'
    if channel == 'SKY CINEMA FAMILY' : return 'SKY FAMILY'
    if channel == 'SKY CINEMA FAMILY SD' : return 'SKY FAMILY SD'
    if channel == 'SKY CINEMA FAMILY HD' : return 'SKY FAMILY HD'
    if channel == 'SKY CINEMA SCFI & HORROR' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY CINEMA SCI-FI AND HORROR' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY CINEMA SCI FI & HORROR SD' : return 'SKY SCI-FIHORROR SD'
    if channel == 'SKY CINEMA SCI FI & HORROR HD' : return 'SKY SCI-FIHORROR HD'
    if channel == 'SKY CINEMA SCIFI & HORROR SD' : return 'SKY SCI-FIHORROR SD'
    if channel == 'SKY CINEMA SCIFI & HORROR HD' : return 'SKY SCI-FIHORROR HD'
    if channel == 'SKY CINEMA SCI-FI AND HORROR HD' : return 'SKY SCI-FIHORROR HD'
    if channel == 'SKY CINEMA CRIME AND THRILLER' : return 'SKY THRILLER'
    if channel == 'SKY CINEMA CRIME & THRILLER' : return 'SKY THRILLER'
    if channel == 'SKY CINEMA CRIME & THRILLER HD' : return 'SKY THRILLER HD'
    if channel == 'SKY CINEMA CRIME & THRILLER SD' : return 'SKY THRILLER SD'
    if channel == 'SKY CINEMA THRILLER' : return 'SKY THRILLER'
    if channel == 'SKY CINEMA THRILLER HD' : return 'SKY THRILLER HD'
    if channel == 'SKY CINEMA DISNEY SD' : return 'SKY DISNEY SD'
    if channel == 'SKY CINEMA SELECT' : return 'SKY SELECT'
    if channel == 'SKY CINEMA SELECT SD' : return 'SKY SELECT SD'
    if channel == 'SKY CINEMA SELECT HD' : return 'SKY SELECT HD'

    if channel == 'SKY CINEMA CHRISTMAS HD' : return 'SKY DRAMA [XMAS] HD'
    if channel == 'SKY CINEMA CHRISTMAS SD' : return 'SKY DRAMA [XMAS] SD'
    if channel == 'SKY CINEMA CHRISTMAS HD' : return 'SKY DRAMA [XMAS] HD'
    if channel == 'SKY CINEMA CHRISTMAS SD' : return 'SKY DRAMA [XMAS] SD'
    if channel == 'SKY CINEMA CHRISTMAS' : return 'SKY DRAMA [XMAS]'

    if channel == 'SHOWCASE' : return 'SKY SHOWCASE'
    if channel == 'CRIME & THRILLER' : return 'SKY THRILLER SD'
    if channel == 'MOVIES CRIME & THRILLER' : return 'SKY THRILLER HD'
    if channel == 'SKY CINEMA COMEDY' : return 'SKY COMEDY'
    if channel == 'MOVIES DISNEY' : return 'SKY DISNEY'

    if channel == 'SKY CINEMA GREATS' : return 'SKY MODERN GREATS'
    if channel == 'SKY CINEMA GREATS SD' : return 'SKY MODERN GREATS SD'
    if channel == 'SKY CINEMA GREATS HD' : return 'SKY MODERN GREATS HD'
    if channel == 'SKY CINEMA MODERN GREATS HD' : return 'SKY MODERN GREATS HD'
    if channel == 'SKY CINEMA COMEDY' : return 'SKY COMEDY'
    if channel == 'SKY CINEMA COMEDY HD' : return 'SKY COMEDY HD'
    if channel == 'SKY CINEMA COMEDY SD' : return 'SKY COMEDY SD'
    if channel == 'SKY CINEMA HITS HD' : return 'SKY HITS HD'
    if channel == 'SKY CINEMA HITS SD' : return 'SKY HITS SD'
    if channel == 'SKY CINEMA SELECT' : return 'SKY SELECT'
    if channel == 'SKY CINEMA SELECT HD' : return 'SKY SELECT HD'
    if channel == 'SKY CINEMA SELECT SD' : return 'SKY SELECT SD'
    if channel == 'SKY CINEMA PREMIER HD' : return 'SKY PREMIERE'
    if channel == 'SKY CINEMA PREMIERE' : return 'SKY PREMIERE'
    if channel == 'SKY CINEMA PREMIERE HD' : return 'SKY PREMIERE HD'
    if channel == 'SKY CINEMA PREMIERE SD' : return 'SKY PREMIERE SD'
    if channel == 'SKY CINEMA DISNEY' : return 'SKY DISNEY'
    if channel == 'SKY CINEMA DISNEY SD' : return 'SKY DISNEY SD'
    if channel == 'SKY CINEMA DISNEY HD' : return 'SKY DISNEY HD'
    if channel == 'SKY CINEMA SHOWCASE SD' : return 'SKY SHOWCASE SD'
    if channel == 'SKY CINEMA SHOWCASE HD' : return 'SKY SHOWCASE HD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE' : return 'SKY ACTION'
    if channel == 'SKY CINEMA ACTION & ADVENTURE HD' : return 'SKY ACTION HD'
    if channel == 'SKY CINEMA ACTION&ADVENTURE HD' : return 'SKY ACTION HD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE SD' : return 'SKY ACTION SD'
    if channel == 'SKY CINEMA HARRY POTTER HD' : return 'SKY MODERN GREATS HD'
    if channel == 'SKY CINEMA HARRY POTTER SD' : return 'SKY MODERN GREATS SD'
    if channel == 'SKY CINEMA DRAMA & ROMANCE SD' : return 'SKY DRAMA SD'
    if channel == 'SKY CINEMA DRAMA & ROMANCE HD' : return 'SKY DRAMA HD'
    if channel == 'SKY CINEMA DRAMA&ROMANCE HD' : return 'SKY DRAMA HD'
    if channel == 'SKY CINEMA FAMILY' : return 'SKY FAMILY'
    if channel == 'SKY CINEMA FAMILY SD' : return 'SKY FAMILY SD'
    if channel == 'SKY CINEMA FAMILY HD' : return 'SKY FAMILY HD'
    if channel == 'SKY CINEMA SCI-FI & HORROR SD' : return 'SKY SCI-FIHORROR SD'
    if channel == 'SKY CINEMA SCI-FI & HORROR HD' : return 'SKY SCI-FIHORROR HD'
    if channel == 'SKY CINEMA SCI-FI/HORROR' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY CINEMA SCI-FI/HORROR HD' : return 'SKY SCI-FIHORROR HD'
    if channel == 'SKY CINEMA CRIME & THRILLER SD' : return 'SKY THRILLER SD'
    if channel == 'SKY CINEMA CRIME & THRILLER HD' : return 'SKY THRILLER HD'
    if channel == 'SKY CINEMA CRIME&THRILLER HD' : return 'SKY THRILLER HD'
    if channel == 'SKY CINEMA CRIME & THRILLER' : return 'SKY THRILLER'

    if channel == 'SKY CINEMA ACTION' : return 'SKY ACTION'
    if channel == 'SKY CINEMA DRAMA' : return 'SKY DRAMA'
    if channel == 'SKY CINEMA SCI-FI' : return 'SKY SCI-FIHORROR'
    if channel == 'SKY CINEMA CRIME' : return 'SKY THRILLER'
    if channel == 'SKY CINEMA COMEDY HD' : return 'SKY COMEDY HD'
    if channel == 'SKY CINEMA COMEDY' : return 'SKY COMEDY'
    if channel == 'SKY CINEMA HITS' : return 'SKY HITS'
    if channel == 'SKY CINEMA HITS HD' : return 'SKY HITS HD'
    if channel == 'SKY CINEMA SELECT' : return 'SKY SELECT'
    if channel == 'SKY CINEMA SELECT HD' : return 'SKY SELECT HD'
    if channel == 'SKY CINEMA COMEDY' : return 'SKY COMEDY'

    if channel == 'SKY CINEMA ACTION & ADVENTURE' : return 'SKY ACTION UK'
    if channel == 'SKY CINEMA PREMIERE' : return 'SKY PREMIERE UK'
    if channel == 'SKY CINEMA CRIME & THRILLER' : return 'SKY THRILLER UK'
    if channel == 'SKY CINEMA COMEDY' : return 'SKY COMEDY UK'
    if channel == 'SKY CINEMA FAMILY' : return 'SKY FAMILY UK'
    if channel == 'SKY CINEMA GREATS' : return 'SKY MODERN GREATS UK'
    if channel == 'SKY CINEMA SELECT' : return 'SKY SELECT UK'
    if channel == 'SKY CINEMA DISNEY' : return 'SKY DISNEY UK'

    if channel == 'SKY FILM 4 HD' : return 'FILM4 HD'
    if channel == 'FILM 4' : return 'FILM4 UK'
    if channel == 'SONY MOVIES' : return 'SONY MOVIE CHANNEL'
    if channel == 'MOVIES 4 MEN' : return 'MOVIES4MEN'

    if channel == '5STAR' : return '5 STAR SD'
    if channel == '5USA' : return '5 USA SD'
    if channel == 'DISCOVERY' : return 'DISCOVERY CHANNEL UK'
    if channel == 'DISCOVERY 1' : return 'DISCOVERY CHANNEL UK'
    if channel == 'DISCOVERY CHANNEL GB' : return 'DISCOVERY CHANNEL'
    if channel == 'DISCOVERY CHANNEL US' : return 'DISCOVERY US'
    if channel == 'DISCOVERY UK HD' : return 'DISCOVERY CHANNEL HD'
    if channel == 'DISCOVERY UK' : return 'DISCOVERY CHANNEL'
    if channel == 'DISCOVERY HD' : return 'DISCOVERY US'
    if channel == 'DISCOVERY SHED.' : return 'DISCOVERY SHED'
    if channel == 'DISC.HISTORY' : return 'DISCOVERY HISTORY GB'
    if channel == 'DISC.SCIENCE' : return 'DISCOVERY SCIENCE UK'
    if channel == 'DISC.TURBO' : return 'DISCOVERY TURBO UK'
    if channel == 'DISCOVERY INVESTIGATION' : return 'DISCOVERY ID'
    if channel == 'INVESTIGATION DISCOVERY HD' : return 'DISCOVERY ID HD'
    if channel == 'INVESTIGATION DISCOVERY' : return 'DISCOVERY ID'
    if channel == 'DISCOVERY UK [SD]' : return 'DISCOVERY CHANNEL'

    if channel == 'NAT GEO UK' : return 'NAT GEO CHANNEL UK'
    if channel == 'NATGEO WILD' : return 'NAT GEO WILD'

    if channel == 'HISTORY UK [SD]' : return 'HISTORY'
    if channel == 'HISTORY GB' : return 'HISTORY'
    if channel == 'HISTORY US' : return 'HISTORY US'
    if channel == 'H2 UK' : return 'H2'
    if channel == 'ANIMAL UK' : return 'ANIMAL PLANET'
    if channel == 'CRIME & INVESTIGIATION' : return 'CRIME AND INVESTIGATION'
    if channel == 'CRIME INVESTIGATION +1' : return 'CRIME AND INVESTIGATION +1'
    if channel == 'CRIME & INVESTIGATION' : return 'CRIME AND INVESTIGATION'
    if channel == 'CRIME INVESTIGATION' : return 'CRIME AND INVESTIGATION'
    if channel == 'DISCOVERY SCIENCE UK' : return 'DISCOVERY SCIENCE'
    if channel == 'DISCOVERY TURBO UK' : return 'DISCOVERY TURBO'
    if channel == 'HOME AND HEALTH' : return 'DISCOVERY HOME'
    if channel == 'HOME & HEALTH' : return 'DISCOVERY HOME'
    if channel == 'I.D.' : return 'DISCOVERY ID'
    if channel == 'ID HD' : return 'DISCOVERY ID'

    if channel == 'CARTOON NETWORK' : return 'CARTOON NETWORK UK'
    if channel == 'CARTOON NETWORK USA' : return 'CARTOON NETWORK US'

    if channel == 'DISNEY CHNL' : return 'DISNEY CHANNEL UK'
    if channel == 'DISNEY HD UK' : return 'DISNEY CHANNEL'
    if channel == 'DISNEY HD' : return 'DISNEY CHANNEL US'
    if channel == 'DISNEY JR. UK' : return 'DISNEY JUNIOR'
    if channel == 'DISNEY JR. HD' : return 'DISNEY JUNIOR US'
    if channel == 'E! HD' : return 'ENTERTAINMENT HD'
    if channel == 'E! ENTERTAINMENT HD' : return 'ENTERTAINMENT HD'
    if channel == 'E! ENTERTAINMENT SD' : return 'ENTERTAINMENT SD'

    if channel == 'DISNEY UK [SD]' : return 'DISNEY CHANNEL [SD]'
    if channel == 'DISNEY UK [HD]' : return 'DISNEY CHANNEL [HD]'
    if channel == 'DISNEY XD UK' : return 'DISNEY XD'
    if channel == 'DISNEYJR UK' : return 'DISNEY JUNIOR'
    if channel == 'NICKOLODEON UK ' : return 'NICKELODEON'
    if channel == 'NICKELODEON USA' : return 'NICKELODEON US'
    if channel == 'NICK JR UK' : return 'NICK JR'
    if channel == 'NICK JR TOO' : return 'NICK JR TOO'
    if channel == 'NICKTOONS' : return 'NICKTOONS'

    if channel == 'NICKELODEON UK HD' : return 'NICKELODEON HD'
    if channel == 'NICK HD' : return 'NICKELODEON US'

    if channel == 'NICK JR. SD' : return 'NICK JR'
    if channel == 'NICK JR. TOO SD' : return 'NICK JR TOO'
    if channel == 'NICK JR.' : return 'NICK JR'
    if channel == 'NICK JR. HD' : return 'NICK JR HD'
    if channel == 'NICK JR TOO' : return 'NICK JR TOO'
    if channel == 'NICKTOON UK' : return 'NICKTOONS'
    if channel == 'BOOMERANG KIDS' : return 'BOOMERANG'
    if channel == 'BOOMERANG HD' : return 'BOOMERANG US'
    if channel == 'BOOMERANG UK' : return 'BOOMERANG'
    if channel == 'CBBC HD [SD]' : return 'CBBC [SD]'
    if channel == 'CBBC HD [HD]' : return 'CBBC [HD]'
    if channel == 'BBC HD 3 / CBBC HD' : return 'CBBC [HD]'
    if channel == 'CBEEBIES HD [SD]' : return 'CBEEBIES [SD]'
    if channel == 'CBEEBIES HD [HD]' : return 'CBEEBIES [HD]'
    if channel == 'BBC HD 4 / CBEEBIES HD' : return 'CBEEBIES [HD]'
    if channel == 'RTE JNR' : return 'RTE JR'
    if channel == 'MTV UK [SD]' : return 'MTV [SD]'
    if channel == 'MTV UK [HD]' : return 'MTV [HD]'
    if channel == 'MTV UK HD' : return 'MTV'
    if channel == 'MTV HITS' : return 'MTV HITS'
    if channel == 'MTV DANCE' : return 'MTV DANCE'
    if channel == 'MTV BAS E' : return 'MTV BASE'
    if channel == 'MTV CLASSICS' : return 'MTV CLASSIC'
    if channel == 'NOW MUSIC' : return 'NOW MUSIC'
    if channel == 'HEARTTV HD' : return 'HEART TV HD'
    if channel == 'HEARTTV' : return 'HEART TV'

    if channel == 'A AND E USA HD *' : return 'AE USA HD'
    if channel == 'A AND E USA SD' : return 'AE USA SD'
    if channel == 'W +1' : return 'WATCH +1'
    if channel == 'W' : return 'WATCH'
    if channel == 'W HD' : return 'WATCH HD'
    if channel == 'W SD' : return 'WATCH SD'
    if channel == 'SKY ARTS SD' : return 'SKY ARTS 1'
    if channel == 'UK :SKY NEWS SD' : return 'SKY NEWS SD'
    if channel == 'SKY NEWS[COLOR GREEN]*[COLOR]' : return 'SKY NEWS'
    if channel == 'SKY NEWS |*|' : return 'SKY NEWS'
    if channel == 'BBC NEWS 24 [SD]' : return 'BBC NEWS [SD]'
    if channel == 'BBC NEWS 24 [HD]' : return 'BBC NEWS [HD]'
    if channel == 'FOX NEWS' : return 'FOX NEWS'
    if channel == 'RTE NEWS' : return 'RTE NEWS NOW'
    if channel == 'RT UK' : return 'RUSSIA TODAY'
    if channel == 'ALJAZEERA NEWS' : return 'AL JAZEERA ENGLISH'
    if channel == 'ARY QTV' : return 'ARY QTV'
    if channel == 'ARY DIGITAL' : return 'ARY DIGITAL'
    if channel == 'GEO UK' : return 'GEO UK'
    if channel == 'GEO NEWS' : return 'GEO NEWS'
    if channel == 'SONY SET ASIA' : return 'SONY TV ASIA'
    if channel == 'SONY SAB' : return 'SONY SAB'
    if channel == '&TV [SD]' : return 'ANDTV'
    if channel == '&TV HD' : return 'ANDTV HD'
    if channel == '&TV HD' : return 'ANDTV HD'
    if channel == 'MYTV 33 [HD]' : return 'MY9'
    if channel == 'USA NETWORK [HD]' : return 'USA NETWORK'
    if channel == 'USA HD' : return 'USA NETWORK'
    if channel == 'BRAVO US [HD]' : return 'BRAVO HD'
    if channel == 'FX US [SD]' : return 'FX SD]'
    if channel == 'FX US [HD]' : return 'FX [HD]'
    if channel == 'FXX US [SD]' : return 'FXX [SD]'
    if channel == 'FXX US [HD]' : return 'FXX [HD]'
    if channel == 'SYFY US [HD]' : return 'SYFY HD'
    if channel == 'LIFETIME US [HD]' : return 'LIFE'
    if channel == 'SPIKE US [HD]' : return 'SPIKE HD'
    if channel == 'AMC US [HD]' : return 'AMC HD'
    if channel == 'TNT US [HD]' : return 'TNT HD'
    if channel == 'TBS US [HD]' : return 'TBS HD'
    if channel == 'COMEDY CENTRAL US [HD]' : return 'COMEDY CENTRAL HD'
    if channel == 'HBO2 HD' : return 'HBO2'
    if channel == 'HBOFAMILY HD' : return 'HBO FAMILY'
    if channel == 'HBOSIGNATURE HD' : return 'HBO SIGNATURE'
    if channel == 'HBOZONE HD' : return 'HBO ZONE'
    if channel == 'STARZ KIDS & FAMILY HD' : return 'STARZ KIDS AND FAMILY'

    if channel == 'NBCSN' : return 'NBC SPORTS'
    if channel == 'NBCSN SD' : return 'NBC SPORTS SD'
    if channel == 'NBCSN HD' : return 'NBC SPORTS HD'
    if channel == 'NBC SPORTS NETWORK [SD]' : return 'NBC SPORTS HD [SD]'
    if channel == 'NBC SPORTS NETWORK [HD]' : return 'NBC SPORTS HD [HD]'
    if channel == 'NBC EXTRA TIME EPL 1  [SD]' : return 'NBC SPORTS ET1 [SD]'
    if channel == 'NBC EXTRA TIME EPL 1  [HD]' : return 'NBC SPORTS ET1 [HD]'
    if channel == 'NBC EXTRA TIME EPL 2  [SD]' : return 'NBC SPORTS ET2 [SD]'
    if channel == 'NBC EXTRA TIME EPL 2  [HD]' : return 'NBC SPORTS ET2 [HD]'
    if channel == 'NBC EXTRA TIME EPL 3  [SD]' : return 'NBC SPORTS ET3 [SD]'
    if channel == 'NBC EXTRA TIME EPL 3  [HD]' : return 'NBC SPORTS ET3 [HD]'
    if channel == 'NBC EXTRA TIME EPL 4  [SD]' : return 'NBC SPORTS ET4 [SD]'
    if channel == 'NBC EXTRA TIME EPL 4  [HD]' : return 'NBC SPORTS ET4 [HD]'
    if channel == 'NBC EXTRA TIME EPL 5  [SD]' : return 'NBC SPORTS ET5 [SD]'
    if channel == 'NBC EXTRA TIME EPL 5  [HD]' : return 'NBC SPORTS ET5 [HD]'

    if channel == 'NBC EXTRA TIME EPL 1' : return 'NBC SPORTS ET1'
    if channel == 'NBC EXTRA TIME EPL 2' : return 'NBC SPORTS ET2'
    if channel == 'NBC EXTRA TIME EPL 3' : return 'NBC SPORTS ET3'
    if channel == 'NBC EXTRA TIME EPL 4' : return 'NBC SPORTS ET4'
    if channel == 'NBC EXTRA TIME EPL 5' : return 'NBC SPORTS ET5'
    if channel == 'NBC SPORTS 1' : return 'NBC SPORTS ET1'
    if channel == 'NBC SPORTS 2' : return 'NBC SPORTS ET2'
    if channel == 'NBC SPORTS 3' : return 'NBC SPORTS ET3'
    if channel == 'NBC SPORTS 4' : return 'NBC SPORTS ET4'
    if channel == 'NBC SPORTS 5' : return 'NBC SPORTS ET5'
    if channel == 'NBC SPORTS 6 (NET)' : return 'NBC SPORTS ET6'

    if channel == 'NBC EXTRA TIME HD (LIVE ON MATCHES ONLY)' : return 'NBC SPORTS ET1'
    if channel == 'NBC EXTRA TIME HD2 (LIVE ON MATCHES ONLY)' : return 'NBC SPORTS ET2'
    if channel == 'NBC EXTRA TIME HD3 (LIVE ON MATCHES ONLY)' : return 'NBC SPORTS ET3'
    if channel == 'NBC EXTRA TIME HD4 (LIVE ON MATCHES ONLY0' : return 'NBC SPORTS ET4'
    if channel == 'NBC EXTRA TIME HD5 (LIVE ON MATCHES ONLY)' : return 'NBC SPORTS ET5'
    if channel == 'NBC EXTRA TIME HD6 (LIVE ON MATCHES ONLY)' : return 'NBC SPORTS ET6'
    if channel == 'NBC EXTRA TIME HD7 (LIVE ON MATCHES ONLY)' : return 'NBC SPORTS ET7'
    if channel == 'NBC EXTRA TIME HD 2 (ON MATCHES ONLY)' : return 'NBC SPORTS ET2'
    if channel == 'NBC EXTRA TIME HD 3 (ON MATCHES ONLY)' : return 'NBC SPORTS ET3'
    if channel == 'NBC EXTRA TIME HD 4 (ON MATCHES ONLY)' : return 'NBC SPORTS ET4'
    if channel == 'NBC EXTRA TIME HD 5 (ON MATCHES ONLY)' : return 'NBC SPORTS ET5'
    if channel == 'NBC EXTRA TIME HD 6 (ON MATCHES ONLY)' : return 'NBC SPORTS ET6'
    if channel == 'NBC EXTRA TIME HD 7 (ON MATCHES ONLY)' : return 'NBC SPORTS ET7'

    if channel == 'CNBC US [HD]' : return 'CNBC'
    if channel == 'NBC GOLF [SD]' : return 'GOLF CHANNEL [SD]'
    if channel == 'NBC GOLF [HD]' : return 'GOLF CHANNEL [HD]'
    if channel == 'GOLF HD' : return 'GOLF CHANNEL HD'
    if channel == 'GOLF' : return 'GOLF CHANNEL'
    if channel == 'ESPN1 [SD]' : return 'ESPN USA [SD]'
    if channel == 'ESPN1 [HD]' : return 'ESPN USA [HD]'
    if channel == 'ESPN2 [SD]' : return 'ESPN2 USA [SD]'
    if channel == 'ESPN2 [HD]' : return 'ESPN2 USA [HD]'
    if channel == 'ESPN UNIVERSITY [SD]' : return 'ESPNU [SD]'
    if channel == 'ESPN UNIVERSITY [HD]' : return 'ESPNU [HD]'

    if channel == 'ESPN HD' : return 'ESPN USA'
    if channel == 'ESPN 2 HD' : return 'ESPN2 USA'
    if channel == 'ESPN U HD' : return 'ESPNU'

    if channel == 'NHL' : return 'NHL NETWORK HD'
    if channel == 'NFL' : return 'NFL TV'
    if channel == 'NFL NETWORK  HD' : return 'NFL TV'
    if channel == 'NFL NOW [SD]' : return 'NFL TV [SD]'
    if channel == 'NFL NOW [HD]' : return 'NFL TV [HD]'
    if channel == 'NFL FEED 1 [SD]' : return 'NFL 1 [SD]'
    if channel == 'NFL FEED 1 [HD]' : return 'NFL 1 [HD]'
    if channel == 'NFL FEED 2 [SD]' : return 'NFL 2 [SD]'
    if channel == 'NFL FEED 2 [HD]' : return 'NFL 2 [HD]'
    if channel == 'NFL FEED 3 [SD]' : return 'NFL 3 [SD]'
    if channel == 'NFL FEED 3 [HD]' : return 'NFL 3 [HD]'
    if channel == 'NFL FEED 4 [SD]' : return 'NFL 4 [SD]'
    if channel == 'NFL FEED 4 [HD]' : return 'NFL 4 [HD]'
    if channel == 'NFL FEED 5 [SD]' : return 'NFL 5 [SD]'
    if channel == 'NFL FEED 5 [HD]' : return 'NFL 5 [HD]'
    if channel == 'NFL FEED 6 [SD]' : return 'NFL 6 [SD]'
    if channel == 'NFL FEED 6 [HD]' : return 'NFL 6 [HD]'
    if channel == 'NFL FEED 7 [SD]' : return 'NFL 7 [SD]'
    if channel == 'NFL FEED 7 [HD]' : return 'NFL 7 [HD]'
    if channel == 'NFL FEED 8 [SD]' : return 'NFL 8 [SD]'
    if channel == 'NFL FEED 8 [HD]' : return 'NFL 8 [HD]'

    if channel == 'NFL LIVE 1' : return 'NFL 1'
    if channel == 'NFL LIVE 2' : return 'NFL 2'
    if channel == 'NFL LIVE 3' : return 'NFL 3'
    if channel == 'NFL LIVE 4' : return 'NFL 4'
    if channel == 'NFL LIVE 5' : return 'NFL 5'
    if channel == 'NFL LIVE 6' : return 'NFL 6'
    if channel == 'NFL LIVE 7' : return 'NFL 7'
    if channel == 'NFL LIVE 8' : return 'NFL 8'
    if channel == 'NFL LIVE 9' : return 'NFL 9'
    if channel == 'NFL LIVE 10' : return 'NFL 10'
    if channel == 'NFL LIVE 11' : return 'NFL 11'
    if channel == 'NFL LIVE 12' : return 'NFL 12'
    if channel == 'NFL LIVE 13' : return 'NFL 13'

    if channel == 'NFL01' : return 'NFL 1'
    if channel == 'NFL02' : return 'NFL 2'
    if channel == 'NFL03' : return 'NFL 3'
    if channel == 'NFL04' : return 'NFL 4'
    if channel == 'NFL05' : return 'NFL 5'
    if channel == 'NFL06' : return 'NFL 6'
    if channel == 'NFL07' : return 'NFL 7'
    if channel == 'NFL08' : return 'NFL 8'
    if channel == 'NFL09' : return 'NFL 9'
    if channel == 'NFL10' : return 'NFL 10'
    if channel == 'NFL11' : return 'NFL 11'
    if channel == 'NFL12' : return 'NFL 12'
    if channel == 'NFL13' : return 'NFL 13'

    if channel == 'NFL SUNDAY TICKET 1' : return 'NFL 1'
    if channel == 'NFL SUNDAY TICKET 2' : return 'NFL 2'
    if channel == 'NFL SUNDAY TICKET 3' : return 'NFL 3'
    if channel == 'NFL SUNDAY TICKET 4' : return 'NFL 4'
    if channel == 'NFL SUNDAY TICKET 5' : return 'NFL 5'
    if channel == 'NFL SUNDAY TICKET 6' : return 'NFL 6'
    if channel == 'NFL SUNDAY TICKET 7' : return 'NFL 7'
    if channel == 'NFL SUNDAY TICKET 8' : return 'NFL 8'
    if channel == 'NFL SUNDAY TICKET 9' : return 'NFL 9'
    if channel == 'NFL SUNDAY TICKET 10' : return 'NFL 10'
    if channel == 'NFL SUNDAY TICKET 11' : return 'NFL 11'
    if channel == 'NFL SUNDAY TICKET 12' : return 'NFL 12'
    if channel == 'NFL SUNDAY TICKET 13' : return 'NFL 13'

    if channel == 'NFL SUNDAY TICKET 1 SD' : return 'NFL 1 SD'
    if channel == 'NFL SUNDAY TICKET 2 SD' : return 'NFL 2 SD'
    if channel == 'NFL SUNDAY TICKET 3 SD' : return 'NFL 3 SD'
    if channel == 'NFL SUNDAY TICKET 4 SD' : return 'NFL 4 SD'
    if channel == 'NFL SUNDAY TICKET 5 SD' : return 'NFL 5 SD'
    if channel == 'NFL SUNDAY TICKET 6 SD' : return 'NFL 6 SD'
    if channel == 'NFL SUNDAY TICKET 7 SD' : return 'NFL 7 SD'
    if channel == 'NFL SUNDAY TICKET 8 SD' : return 'NFL 8 SD'
    if channel == 'NFL SUNDAY TICKET 9 SD' : return 'NFL 9 SD'
    if channel == 'NFL SUNDAY TICKET 10 SD' : return 'NFL 10 SD'
    if channel == 'NFL SUNDAY TICKET 11 SD' : return 'NFL 11 SD'
    if channel == 'NFL SUNDAY TICKET 12 SD' : return 'NFL 12 SD'
    if channel == 'NFL SUNDAY TICKET 13 SD' : return 'NFL 13 SD'

    if channel == 'NFL SUNDAY TICKET 1 HD' : return 'NFL 1 HD'
    if channel == 'NFL SUNDAY TICKET 2 HD' : return 'NFL 2 HD'
    if channel == 'NFL SUNDAY TICKET 3 HD' : return 'NFL 3 HD'
    if channel == 'NFL SUNDAY TICKET 4 HD' : return 'NFL 4 HD'
    if channel == 'NFL SUNDAY TICKET 5 HD' : return 'NFL 5 HD'
    if channel == 'NFL SUNDAY TICKET 6 HD' : return 'NFL 6 HD'
    if channel == 'NFL SUNDAY TICKET 7 HD' : return 'NFL 7 HD'
    if channel == 'NFL SUNDAY TICKET 8 HD' : return 'NFL 8 HD'
    if channel == 'NFL SUNDAY TICKET 9 HD' : return 'NFL 9 HD'
    if channel == 'NFL SUNDAY TICKET 10 HD' : return 'NFL 10 HD'
    if channel == 'NFL SUNDAY TICKET 11 HD' : return 'NFL 11 HD'
    if channel == 'NFL SUNDAY TICKET 12 HD' : return 'NFL 12 HD'
    if channel == 'NFL SUNDAY TICKET 13 HD' : return 'NFL 13 HD'

    if channel == 'NBA LEAGUE PASS 1' : return 'NBA 1 HD'
    if channel == 'NBA LEAGUE PASS 2' : return 'NBA 2 HD'
    if channel == 'NBA LEAGUE PASS 3' : return 'NBA 3 HD'
    if channel == 'NBA LEAGUE PASS 4' : return 'NBA 4 HD'
    if channel == 'NBA LEAGUE PASS 5' : return 'NBA 5 HD'
    if channel == 'NBA LEAGUE PASS 6' : return 'NBA 6 HD'

    if channel == 'NBA LEAGUE PASS 1 HD' : return 'NBA 1 HD'
    if channel == 'NBA LEAGUE PASS 2 HD' : return 'NBA 2 HD'
    if channel == 'NBA LEAGUE PASS 3 HD' : return 'NBA 3 HD'
    if channel == 'NBA LEAGUE PASS 4 HD' : return 'NBA 4 HD'
    if channel == 'NBA LEAGUE PASS 5 HD' : return 'NBA 5 HD'
    if channel == 'NBA LEAGUE PASS 6 HD' : return 'NBA 6 HD'
    if channel == 'NBA LEAGUE PASS 7 HD' : return 'NBA 1 HD'
    if channel == 'NBA LEAGUE PASS 8 HD' : return 'NBA 2 HD'
    if channel == 'NBA LEAGUE PASS 9 HD' : return 'NBA 3 HD'
    if channel == 'NBA LEAGUE PASS 10 HD' : return 'NBA 4 HD'
    if channel == 'NBA LEAGUE PASS 11 HD' : return 'NBA 5 HD'
    if channel == 'NBA LEAGUE PASS 12 HD' : return 'NBA 6 HD'
    if channel == 'NBA LEAGUE PASS 13 HD' : return 'NBA 1 HD'
    if channel == 'NBA LEAGUE PASS 14 HD' : return 'NBA 2 HD'
    if channel == 'NBA LEAGUE PASS 15 HD' : return 'NBA 3 HD'

    if channel == 'BEIN USA [SD]' : return 'BEIN SPORTS [SD]'
    if channel == 'BEIN USA [HD]' : return 'BEIN SPORTS [HD]'
    if channel == 'FXM US [SD]' : return 'FX MOVIE CHANNEL [SD]'
    if channel == 'FXM US [HD]' : return 'FX MOVIE CHANNEL [HD]'
    if channel == 'ANIMAL PLANET US [HD]' : return 'ANIMAL PLANET HD'
    if channel == 'NAT GEO HD' : return 'NAT GEO US'
    if channel == 'NAT GEO WILD HD' : return 'NAT GEO WILD US'
    if channel == 'HISTORY US [HD]' : return 'HISTORY US'
    if channel == 'A&E US [HD]' : return 'AE US'
    if channel == 'A&E' : return 'AE'
    if channel == 'A AND E' : return 'AE'
    if channel == 'A&E HD' : return 'AE HD'
    if channel == 'NICKELODEON US [HD]' : return 'NICKELODEON US'
    if channel == 'CARTOON NETWORKS US [HD]' : return 'CARTOON NETWORK US'
    if channel == 'CNBC US [HD]' : return 'CNBC'
    if channel == 'MSNBC US [SD]' : return 'MSNBC [SD]'
    if channel == 'MSNBC US [HD]' : return 'MSNBC [HD]'
    if channel == 'FOX NEWS US [HD]' : return 'FOX NEWS'
    if channel == 'LIFETIME HD' : return 'LIFE'
    if channel == 'STARZKIDS & FAMILY HD' : return 'STARZ KIDS AND FAMILY'
    if channel == 'CINEMAX MOREMAX HD' : return 'MOREMAX'
    if channel == 'CINEMAX THRILLERMAX HD' : return 'THRILLERMAX'
    if channel == 'CINEMAX MOREMAX HD' : return 'MOREMAX'
    if channel == 'CINEMAX THRILLERMAX HD' : return 'THRILLERMAX'
    if channel == 'HALLMARK HD' : return 'HALLMARK CHANNEL'
    if channel == 'HALLMARK MOVIES & MYSTERIES HD' : return 'HALLMARK MOVIES'
    if channel == 'UNIVERSAL HD' : return 'UNIVERSAL CHANNEL'
    if channel == 'UNIVERSAL CHANNEL UK' : return 'UK UNIVERSAL CHANNEL'
    if channel == 'DIY HD' : return 'DIY NETWORK'
    if channel == 'CRIME & INVESTIGATION HD' : return 'US CRIME AND INVESTIGATION'
    if channel == 'TRAVEL CHANNEL HD' : return 'TRAVEL CHANNEL US'
    if channel == 'LIFETIME UK HD' : return 'UK LIFETIME HD'
    if channel == 'LIFETIME UK' : return 'UK LIFETIME'

    if channel == 'CNN US [HD]' : return 'CNN HD'
    if channel == 'SN ONTARIO [SD]' : return 'SPORTSNET ONTARIO [SD]'
    if channel == 'SN ONTARIO [HD]' : return 'SPORTSNET ONTARIO [HD]'
    if channel == 'SN WORLD [SD]' : return 'SPORTSNET WORLD [SD]'
    if channel == 'SN WORLD [HD]' : return 'SPORTSNET WORLD [HD]'
    if channel == 'SN ONE [SD]' : return 'SPORTSNET ONE [SD]'
    if channel == 'SN ONE [HD]' : return 'SPORTSNET ONE [HD]'
    if channel == 'SN 360 [SD]' : return 'SPORTSNET 360 [SD]'
    if channel == 'SN 360 [HD]' : return 'SPORTSNET 360 [HD]'

    if channel == 'SPORTS NET ONTARIO HD' : return 'SPORTSNET ONTARIO'
    if channel == 'SPORTS NET WORLD HD' : return 'SPORTSNET WORLD'
    if channel == 'SPORTS NET ONE HD' : return 'SPORTSNET ONE'
    if channel == 'SPORTS NET 360' : return 'SPORTSNET 360'

    if channel == 'SPORTSNET 360 (EPL 3PM)' : return 'SPORTSNET 360'
    if channel == 'SPORTSNET ONE (EPL 3PM)' : return 'SPORTSNET ONE'
    if channel == 'SPORTSNET ONTARIO (EPL 3PM)' : return 'SPORTSNET ONTARIO'
    if channel == 'SPORTSNET WORLD (EPL 3PM)' : return 'SPORTSNET WORLD'

    if channel == 'TSN1 HD' : return 'TSN HD'
    if channel == 'TSN3' : return 'TSN 3 HD'
    if channel == 'TSN4 HD' : return 'TSN 4 HD'
    if channel == 'TSN 1' : return 'TSN HD'
    if channel == 'TSN 2' : return 'TSN 2 HD'
    if channel == 'TSN 3' : return 'TSN 3 HD'
    if channel == 'TSN 4' : return 'TSN 4 HD'
    if channel == 'TSN 5' : return 'TSN 5 HD'
    if channel == 'TSN 1 HD' : return 'TSN HD'

    if channel == 'BEIN HD 10' : return 'BEIN SPORTS 10 HD'
    if channel == 'BEIN HD 11' : return 'BEIN SPORTS 11 HD'
    if channel == 'BEIN HD 12' : return 'BEIN SPORTS 12 HD'
    if channel == 'BEIN HD 1' : return 'BEIN SPORTS 1 HD'
    if channel == 'BEIN HD 2' : return 'BEIN SPORTS 2 HD'
    if channel == 'BEIN HD 3' : return 'BEIN SPORTS 3 HD'
    if channel == 'BEIN HD 4' : return 'BEIN SPORTS 4 HD'
    if channel == 'BEIN HD 5' : return 'BEIN SPORTS 5 HD'
    if channel == 'BEIN HD 6' : return 'BEIN SPORTS 6 HD'
    if channel == 'BEIN HD 7' : return 'BEIN SPORTS 7 HD'
    if channel == 'BEIN HD 8' : return 'BEIN SPORTS 8 HD'
    if channel == 'BEIN HD 9' : return 'BEIN SPORTS 9 HD'

    if channel == 'FOX SPORTS ASIA 1 HD' : return 'TH FOX SPORTS 1'
    if channel == 'FOX SPORTS ASIA 2 HD' : return 'TH FOX SPORTS 2'
    if channel == 'FOX SPORTS ASIA 3 HD' : return 'TH FOX SPORTS 3'

    if channel == 'TENNIS CHANNEL HD' : return 'THE TENNIS CHANNEL'

    if channel == 'SVT 1' : return 'SVT 1'
    if channel == 'SVT 2' : return 'SVT 2'
    if channel == 'KANAL 5' : return 'KANAL 5 SE'
    if channel == 'TV6' : return 'TV 6 SVERIGE'
    if channel == 'TV8' : return 'TV 8 SE'
    if channel == 'KANAL 9' : return 'KANAL 9 SE'
    if channel == 'TV10' : return 'TV 10 SE'
    if channel == 'TV4 FAKTA' : return 'TV 4 FAKTA'
    if channel == 'TV4 GULD' : return 'TV 4 GULD'
    if channel == 'TV4 KOMEDI' : return 'TV 4 KOMEDI'
    if channel == 'TV3 SPORT SE' : return 'TV 3 SPORT 1'
    if channel == 'TV4 SPORT SE' : return 'TV 4 SPORT'
    if channel == 'DISCOVERY SE' : return 'DISCOVERY SE'
    if channel == 'DISNEY SE' : return 'DISNEY KANALEN SE'
    if channel == 'DR1' : return 'DR 1'
    if channel == 'DR2' : return 'DR 2'
    if channel == 'DR3' : return 'DR 3'
    if channel == 'SVT1' : return 'SVT 1'
    if channel == 'SVT2' : return 'SVT 2'
    if channel == 'DK4' : return 'DK 4'
    if channel == 'DRK' : return 'DR K'
    if channel == 'TV2 ZULU' : return 'TV 2 ZULU'
    if channel == 'TV2 CHARLI ' : return 'TV 2 CHARLIE'
    if channel == 'TV2 FRI ' : return 'TV 2 FRI'
    if channel == 'KANAL 5' : return 'KANAL 5 DK'
    if channel == '6EREN' : return '6EREN DK'
    if channel == 'CANAL9' : return 'CANAL 9 DK'
    if channel == 'TV3+ ' : return 'TV 3 PLUS'
    if channel == 'TV3 PULS' : return 'TV 3 PULS'
    if channel == 'TV3 SPORTS 1' : return 'TV 3 SPORT 1'
    if channel == 'TV3 SPORTS 2' : return 'TV 3 SPORT 2'
    if channel == 'DR RAMASJANG' : return 'DR RAMASJANG'
    if channel == 'TV2 NEWS ' : return 'TV 2 NEWS'
    if channel == 'TV2 [SD]' : return 'TV 2 NO [SD]'
    if channel == 'TV2 [HD]' : return 'TV 2 NO [HD]'
    if channel == 'TV2 ZEBRA [SD]' : return 'TV 2 ZEBRA [SD]'
    if channel == 'TV2 ZEBRA [HD]' : return 'TV 2 ZEBRA [HD]'
    if channel == 'TV2 NYHETS KANALEN [SD]' : return 'TV 2 NYHETSSKANALEN [SD]'
    if channel == 'TV2 NYHETS KANALEN [HD]' : return 'TV 2 NYHETSSKANALEN [HD]'
    if channel == 'ASTRO SUPERSPORT 1 [SD]' : return 'ASTRO SUPERSPORT 1 HD'
    if channel == 'ASTRO SUPERSPORT 2 [SD]' : return 'ASTRO SUPERSPORT 2 HD'
    if channel == 'ASTRO SUPERSPORT 3 [SD]' : return 'ASTRO SUPERSPORT 3 HD'
    if channel == 'ASTRO SUPERSPORT 4 [SD]' : return 'ASTRO SUPERSPORT 4 HD'

    if channel == 'ASTRO SPORTS HD 1' : return 'ASTRO SUPERSPORT 1 HD'
    if channel == 'ASTRO SPORTS HD 2' : return 'ASTRO SUPERSPORT 2 HD'
    if channel == 'ASTRO SPORTS HD 3' : return 'ASTRO SUPERSPORT 3 HD'
    if channel == 'ASTRO SPORTS HD 4' : return 'ASTRO SUPERSPORT 4 HD'
    if channel == 'SUPER SPORT 1' : return 'ASTRO SUPERSPORT 1 HD'
    if channel == 'SUPER SPORT 2' : return 'ASTRO SUPERSPORT 2 HD'
    if channel == 'SUPER SPORT 3' : return 'ASTRO SUPERSPORT 3 HD'
    if channel == 'SUPER SPORT 4' : return 'ASTRO SUPERSPORT 4 HD'

    if channel == 'CELTIC TV (LIVE MATCHDAY ONLY)' : return 'CELTIC TV'
    if channel == 'BRITISH EUROSPORT' : return 'EUROSPORT'
    if channel == 'BRITISH EUROSPORT 2' : return 'EUROSPORT 2'

    if channel == 'EUROSPORT 1 UK (SW) [SD]' : return 'EUROSPORT (SW) [SD]'
    if channel == 'EUROSPORT 1 UK (SW) [HD]' : return 'EUROSPORT (SW) [HD]'
    if channel == 'EUROSPORTS 2 UK (SW) [SD]' : return 'EUROSPORT 2 (SW) [SD]'
    if channel == 'EUROSPORTS 2 UK (SW) [HD]' : return 'EUROSPORT 2 (SW) [HD]'
    if channel == 'EIR SPORT 1 (SW) [SD]' : return 'SETANTA IRELAND (SW)'
    if channel == 'EIR SPORT 2 (SW) [SD]' : return 'SETANTA SPORTS 1 (SW)'
    if channel == 'EIR SPORT 1' : return 'SETANTA IRELAND'
    if channel == 'EIR SPORT 2' : return 'SETANTA SPORTS 1'
    if channel == 'EIR SPORTS 1' : return 'SETANTA IRELAND'
    if channel == 'EIR SPORTS 2' : return 'SETANTA SPORTS 1'
    if channel == 'NBC SPORTS NETWORK (SW) [SD]' : return 'NBC SPORTS HD (SW) [SD]'
    if channel == 'NBC SPORTS NETWORK (SW) [HD]' : return 'NBC SPORTS HD (SW) [HD]'
    if channel == 'NBC EXTRA TIME EPL 1 (SW)  [SD]' : return 'NBC SPORTS ET1 (SW) [SD]'
    if channel == 'NBC EXTRA TIME EPL 1 (SW)  [HD]' : return 'NBC SPORTS ET1 (SW) [HD]'
    if channel == 'NBC EXTRA TIME EPL 2 (SW)  [SD]' : return 'NBC SPORTS ET2 (SW) [SD]'
    if channel == 'NBC EXTRA TIME EPL 2 (SW)  [HD]' : return 'NBC SPORTS ET2 (SW) [HD]'
    if channel == 'NBC EXTRA TIME EPL 3 (SW)  [SD]' : return 'NBC SPORTS ET3 (SW) [SD]'
    if channel == 'NBC EXTRA TIME EPL 3 (SW)  [HD]' : return 'NBC SPORTS ET3 (SW) [HD]'
    if channel == 'NBC EXTRA TIME EPL 4 (SW)  [SD]' : return 'NBC SPORTS ET4 (SW) [SD]'
    if channel == 'NBC EXTRA TIME EPL 4 (SW)  [HD]' : return 'NBC SPORTS ET4 (SW) [HD]'
    if channel == 'NBC EXTRA TIME EPL 5 (SW)  [SD]' : return 'NBC SPORTS ET5 (SW) [SD]'
    if channel == 'NBC EXTRA TIME EPL 5 (SW)  [HD]' : return 'NBC SPORTS ET5 (SW) [HD]'

    if channel == 'NBC SPORT' : return 'NBC SPORTS'
    if channel == 'NBC SPORTS NETWORK' : return 'NBC SPORTS HD'
    if channel == 'NBC EXTRA TIME HD' : return 'NBC SPORTS ET1'
    if channel == 'NBC EXTRA TIME 2 HD' : return 'NBC SPORTS ET2'
    if channel == 'NBC EXTRA TIME 3 HD' : return 'NBC SPORTS ET3'
    if channel == 'NBC EXTRA TIME 4 HD' : return 'NBC SPORTS ET4'
    if channel == 'NBC EXTRA TIME 5 HD' : return 'NBC SPORTS ET5'

    if channel == 'NBC EXTRA TIME 1' : return 'NBC SPORTS ET1'
    if channel == 'NBC EXTRA TIME 2' : return 'NBC SPORTS ET2'
    if channel == 'NBC EXTRA TIME 3' : return 'NBC SPORTS ET3'
    if channel == 'NBC EXTRA TIME 4' : return 'NBC SPORTS ET4'
    if channel == 'NBC EXTRA TIME 5' : return 'NBC SPORTS ET5'
    if channel == 'NBC EXTRA TIME 6' : return 'NBC SPORTS ET6'

    if channel == 'NBC GOLF (SW) [SD]' : return 'GOLF CHANNEL (SW) [SD]'
    if channel == 'NBC GOLF (SW) [HD]' : return 'GOLF CHANNEL (SW) [HD]'

    if channel == 'BEIN USA (SW) [SD]' : return 'BEIN SPORTS (SW) [SD]'
    if channel == 'BEIN USA (SW) [HD]' : return 'BEIN SPORTS (SW) [HD]'
    if channel == 'SN ONTARIO (SW) [SD]' : return 'SPORTSNET ONTARIO (SW) [SD]'
    if channel == 'SN ONTARIO (SW) [HD]' : return 'SPORTSNET ONTARIO (SW) [HD]'
    if channel == 'SN WORLD (SW) [SD]' : return 'SPORTSNET WORLD (SW) [SD]'
    if channel == 'SN WORLD (SW) [HD]' : return 'SPORTSNET WORLD (SW) [HD]'
    if channel == 'SN ONE (SW) [SD]' : return 'SPORTSNET ONE (SW) [SD]'
    if channel == 'SN ONE (SW) [HD]' : return 'SPORTSNET ONE (SW) [HD]'
    if channel == 'SN 360 (SW) [SD]' : return 'SPORTSNET 360 (SW) [SD]'
    if channel == 'SN 360 (SW) [HD]' : return 'SPORTSNET 360 (SW) [HD]'
    if channel == 'TSN 1 (SW)' : return 'TSN (SW) HD'
    if channel == 'TSN 2 (SW)' : return 'TSN 2 (SW) HD'
    if channel == 'TSN 3 (SW)' : return 'TSN 3 (SW) HD'
    if channel == 'TSN 4 (SW)' : return 'TSN 4 (SW) HD'
    if channel == 'TSN 5 (SW)' : return 'TSN 5 (SW) HD'

    if channel == 'SPORTS NET 360 HD' : return 'SPORTSNET 360'
    if channel == 'SPORTS NET ONTARIO HD' : return 'SPORTSNET ONTARIO'
    if channel == 'SPORTS NET WORLD HD' : return 'SPORTSNET WORLD'
    if channel == 'SPORTS NET EAST HD' : return 'SPORTSNET EAST HD'
    if channel == 'SPORTS NET PACIFIC HD' : return 'SPORTSNET PACIFIC HD'
    if channel == 'SPORTS NET WEST HD' : return 'SPORTSNET WEST HD'

    if channel == 'SN ONE HD(L)' : return 'SPORTSNET ONE HD'
    if channel == 'SN 360 HD(L)' : return 'SPORTSNET 360 HD'
    if channel == 'SN ONTARIO HD(L)' : return 'SPORTSNET ONTARIO HD'
    if channel == 'SNW HD(L)' : return 'SPORTSNET WORLD HD'
    if channel == 'SN EAST HD(L)' : return 'SPORTSNET EAST HD'
    if channel == 'SN PACIFIC HD(L)' : return 'SPORTSNET PACIFIC HD'
    if channel == 'SN WEST HD(L)' : return 'SPORTSNET WEST HD'

    if channel == 'SN ONE' : return 'SPORTSNET ONE HD'
    if channel == 'SN 360' : return 'SPORTSNET 360 HD'
    if channel == 'SN ONTARIO' : return 'SPORTSNET ONTARIO HD'
    if channel == 'SN WORLD' : return 'SPORTSNET WORLD HD'
    if channel == 'SN EAST' : return 'SPORTSNET EAST HD'
    if channel == 'SN PACIFIC' : return 'SPORTSNET PACIFIC HD'
    if channel == 'SN WEST' : return 'SPORTSNET WEST HD'

    if channel == 'NHL CENTER ICE 1' : return 'NHL 1 MLB 1'
    if channel == 'NHL CENTER ICE 2' : return 'NHL 2 MLB 2'
    if channel == 'NHL CENTER ICE 3' : return 'NHL 3 MLB 3'
    if channel == 'NHL CENTER ICE 4' : return 'NHL 4 MLB 4'
    if channel == 'NHL CENTER ICE 5' : return 'NHL 5 MLB 5'
    if channel == 'NHL CENTER ICE 6' : return 'NHL 6 MLB 6'

    if channel == 'NHL 1' : return 'NHL 1 MLB 1'
    if channel == 'NHL 2' : return 'NHL 2 MLB 2'
    if channel == 'NHL 3' : return 'NHL 3 MLB 3'
    if channel == 'NHL 4' : return 'NHL 4 MLB 4'
    if channel == 'NHL 5' : return 'NHL 5 MLB 5'
    if channel == 'NHL 6' : return 'NHL 6 MLB 6'
    if channel == 'NHL 7' : return 'NHL 7 MLB 7'
    if channel == 'NHL 8' : return 'NHL 8 MLB 8'
    if channel == 'NHL 9' : return 'NHL 9 MLB 9'
    if channel == 'NHL 10' : return 'NHL 10 MLB 10'
    if channel == 'NHL 11' : return 'NHL 11 MLB 11'
    if channel == 'NHL 12' : return 'NHL 12 MLB 12'
    if channel == 'NHL 13' : return 'NHL 13 MLB 13'
    if channel == 'MLB 1' : return 'NHL 1 MLB 1'
    if channel == 'MLB 2' : return 'NHL 2 MLB 2'
    if channel == 'MLB 3' : return 'NHL 3 MLB 3'
    if channel == 'MLB 4' : return 'NHL 4 MLB 4'
    if channel == 'MLB 5' : return 'NHL 5 MLB 5'
    if channel == 'MLB 6' : return 'NHL 6 MLB 6'
    if channel == 'MLB 7' : return 'NHL 7 MLB 7'
    if channel == 'MLB 8' : return 'NHL 8 MLB 8'
    if channel == 'MLB 9' : return 'NHL 9 MLB 9'
    if channel == 'MLB 10' : return 'NHL 10 MLB 10'
    if channel == 'MLB 11' : return 'NHL 11 MLB 11'
    if channel == 'MLB 12' : return 'NHL 12 MLB 12'
    if channel == 'MLB 13' : return 'NHL 13 MLB 13'

    if channel == 'NHL01' : return 'NHL 1 MLB 1'
    if channel == 'NHL02' : return 'NHL 2 MLB 2'
    if channel == 'NHL03' : return 'NHL 3 MLB 3'
    if channel == 'NHL04' : return 'NHL 4 MLB 4'
    if channel == 'NHL05' : return 'NHL 5 MLB 5'
    if channel == 'NHL06' : return 'NHL 6 MLB 6'
    if channel == 'NHL07' : return 'NHL 7 MLB 7'
    if channel == 'NHL08' : return 'NHL 8 MLB 8'
    if channel == 'NHL09' : return 'NHL 9 MLB 9'
    if channel == 'NHL10' : return 'NHL 10 MLB 10'
    if channel == 'NHL11' : return 'NHL 11 MLB 11'
    if channel == 'NHL12' : return 'NHL 12 MLB 12'

    return channel
