#
#      Copyright (C) 2014 Richard Dean
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with XBMC; see the file COPYING.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#

import os
import dixie
import urllib

import download
import extract

ADDON    = dixie.ADDON
FTVINI   = ADDON.getSetting('ftv.ini')
datapath = dixie.PROFILE
inipath  = os.path.join(datapath, 'ini')


def getIni():
    if dixie.isDSF():
        return

    # cmd = 'XBMC.RunScript(special://home/addons/script.tvguidedixie/playini.py)'
    # dixie.log ('Update playini')
    # xbmc.executebuiltin(cmd)
###################################################################
    # try:
    #     cmd = 'XBMC.RunScript(special://home/addons/script.tvguidedixie/plugins.py)'
    #     dixie.log ('Update plugins')
    #     xbmc.executebuiltin(cmd)
    # except: pass
    #
    # try:
    #     cmd = 'XBMC.RunScript(special://home/addons/script.tvguidedixie/hdtv.py)'
    #     dixie.log ('Update hdtv')
    #     xbmc.executebuiltin(cmd)
    # except: pass
    #
    # try:
    #     cmd = 'XBMC.RunScript(special://home/addons/script.tvguidedixie/iplayer.py)'
    #     dixie.log ('Update iplayer')
    #     xbmc.executebuiltin(cmd)
    # except: pass
    #
    # try:
    #     cmd = 'XBMC.RunScript(special://home/addons/script.tvguidedixie/smh.py)'
    #     dixie.log ('Update smh')
    #     xbmc.executebuiltin(cmd)
    # except: pass
    #
    # try:
    #     cmd = 'XBMC.RunScript(special://home/addons/script.tvguidedixie/uktv.py)'
    #     dixie.log ('Update uktv')
    #     xbmc.executebuiltin(cmd)
    # except: pass
    #
    # try:
    #     cmd = 'XBMC.RunScript(special://home/addons/script.tvguidedixie/livetv.py)'
    #     dixie.log ('Update livetv')
    #     xbmc.executebuiltin(cmd)
    # except: pass
###################################################################

    # try:
    #     dTempFile = os.path.join(datapath, 'dtemp')
    #     if os.path.exists(dTempFile):
    #         os.remove(dTempFile)
    # except: pass
    #
    # try:
    #     fTempFile = os.path.join(datapath, 'ftemp')
    #     if os.path.exists(fTempFile):
    #         os.remove(fTempFile)
    # except: pass
    #
    # try:
    #     shpath = os.path.join(datapath, 'shtemp')
    #     if os.path.exists(shpath):
    #         os.remove(shpath)
    # except: pass
    #
    # try:
    #     rupath = os.path.join(datapath, 'rutemp')
    #     if os.path.exists(rupath):
    #         os.remove(rupath)
    # except: pass

    try:
        import playini
        playini.checkAddons()
    except: pass

    try:
        import iplayer
        iplayer.checkAddons()
    except: pass

    try:
        import smh
        smh.checkAddons()
    except: pass

    try:
        import hdtv
        smh.checkAddons()
    except: pass

    try:
        import uktv
        uktv.checkAddons()
    except: pass

    try:
        import livetv
        livetv.checkAddons()
    except: pass

    try:
        import plugins
        plugins.checkAddons()
    except: pass

    try:
        import pvr
        pvr.createPVRINI()
    except: pass

    try:
        import hdhr
        hdhr.createHDHRINI()
    except: pass

    if not os.path.exists(inipath):
        os.makedirs(inipath)

    iniurl = dixie.GetExtraUrl() + 'resources/ini.zip'
    inizip = os.path.join(inipath, 'ini.zip')

    try:
        download.download(iniurl, inizip)
        extract.all(inizip, inipath)
        os.remove(inizip)
    except: pass


def ftvIni():
    import xbmcaddon

    if FTVINI == 'UK Links':
        ftv = 'uk.ini'
    else:
        ftv = 'nongeo.ini'

    path = os.path.join(datapath, ftv)

    try:
        url = dixie.GetExtraUrl() + 'resources/' + ftv
        download.download(url, path)
    except:
        pass

    AVAILABLE = False
    if not AVAILABLE:
        try:
            addon = xbmcaddon.Addon('plugin.video.F.T.V')
            if FTVINI == 'Non-Geolocked UK Links':
                BASE      = addon.setSetting('root_channel', '3092')
                AVAILABLE = BASE
            else:
                BASE      = addon.setSetting('root_channel', '689')
                AVAILABLE = BASE
        except:
            AVAILABLE = False


def checkRuya():
    import xbmcaddon
    import dixie

    datapath =  dixie.PROFILE
    inipath  =  os.path.join(datapath, 'ini')
    RUYA     = 'plugin.video.ruyaiptv'


    if xbmc.getCondVisibility('System.HasAddon(%s)' % RUYA) == 1:
        try:
            if xbmcaddon.Addon('plugin.video.ruyaiptv').getAddonInfo('name') == 'IPTV Subs':
                files = ['ruyaiptv.ini', 'ruyaiptv-sw.ini']

            else:
                files = ['iptvsubs.ini']

                for file in files:
                    path = os.path.join(inipath, file)
                    if os.path.exists(path):
                        os.remove(path)
        except: pass

    files2 = ['smarthub-sw.ini']

    for file in files2:
        path = os.path.join(inipath, file)
        if os.path.exists(path):
            os.remove(path)


if __name__ == '__main__':
    getIni()
    ftvIni()
    checkRuya()
