#
#      Copyright (C) 2014 Richard Dean
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with XBMC; see the file COPYING.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#

import xbmc
import xbmcaddon
import xbmcgui
import os
import re
import verify
import requests
import requests.packages.urllib3
requests.packages.urllib3.disable_warnings()

import cookielib
import pickle
import time
import datetime

import sfile

ooOOOoo = ''
def ttTTtt(i, t1, t2=[]):
 t = ooOOOoo
 for c in t1:
  t += chr(c)
  i += 1
  if i > 1:
   t = t[:-1]
   i = 0  
 for c in t2:
  t += chr(c)
  i += 1
  if i > 1:
   t = t[:-1]
   i = 0
 return t


ADDONID     = 'script.tvguidedixie'
ADDON       =  xbmcaddon.Addon(ADDONID)
HOME        =  ADDON.getAddonInfo('path')
ICON        =  os.path.join(HOME, 'icon.png')
ICON        =  xbmc.translatePath(ICON)
PROFILE     =  xbmc.translatePath(ADDON.getAddonInfo('profile'))
RESOURCES   =  os.path.join(HOME, 'resources')
PVRACTIVE   = (xbmc.getCondVisibility('Pvr.HasTVChannels')) or (xbmc.getCondVisibility('Pvr.HasRadioChannels')) == True
IGNORESTRM  =  ADDON.getSetting('ignore.stream') == 'true'

try:
    OTT_ADDONID = 'script.on-tapp.tv'
    OTT_ADDON   =  xbmcaddon.Addon(OTT_ADDONID)
    OTT_HOME    =  xbmc.translatePath(OTT_ADDON.getAddonInfo('path'))
    OTT_PROFILE =  xbmc.translatePath(OTT_ADDON.getAddonInfo('profile'))
except: pass

resource    = 'http://files.on-tapp.tv/'
baseurl     = 'https://www.on-tapp.tv/files/update/'
loginurl    =  ttTTtt(393,[72,104,176,116],[194,116,1,112,40,115,24,58,196,47,96,47,160,119,10,119,73,119,153,46,156,111,245,110,246,45,163,116,51,97,57,112,60,112,217,46,1,116,38,118,110,47,202,119,147,112,232,45,135,108,73,111,70,103,215,105,209,110,244,46,121,112,128,104,196,112])
verifyurl   =  ttTTtt(211,[136,104,34,116,82,116,10,112,216,115,105,58,30,47,240,47,201,111,178,110,160,45],[121,116,0,97,232,112,168,112,107,46,147,116,137,118,134,47,9,118,43,101,218,114,147,105,8,102,130,121,253,47,127,105,138,110,242,100,123,101,139,120,232,46,154,112,251,104,194,112])

try:
    DSFID   =  ttTTtt(0,[112,13,108,120,117],[115,103,45,105,212,110,32,46,233,118,53,105,75,100,34,101,38,111,148,46,218,103,216,118,30,97,110,120])
    DSF     =  xbmcaddon.Addon(DSFID)
    DSFVER  =  DSF.getAddonInfo('version')
except: pass

OPEN_OTT  = '_OTT['
CLOSE_OTT = ']OTT_'


def SetSetting(param, value):
    value = str(value)

    if GetSetting(param) == value:
        return

    xbmcaddon.Addon(ADDONID).setSetting(param, value)


def GetSetting(param):
    return xbmcaddon.Addon(ADDONID).getSetting(param)


def GetXBMCVersion():
    version = xbmcaddon.Addon('xbmc.addon').getAddonInfo('version')
    version = version.split('.')
    return int(version[0]), int(version[1]) #major, minor eg, 13.9.902


MAJOR, MINOR = GetXBMCVersion()
FRODO        = (MAJOR == 12) and (MINOR < 9)


DIXIELOGOS  =  GetSetting('dixie.logo.folder')
SKIN        =  GetSetting('dixie.skin')
FILMON      =  GetSetting('FILMON')
VERSION     =  ADDON.getAddonInfo('version')
TITLE       = 'On-Tapp.EPG'
LOGOPACK    = 'Colour Logo Pack'
DEBUG       =  GetSetting('DEBUG') == 'true'
KEYMAP_HOT  = 'ottv_hot.xml'

CATCHUP     =  GetSetting('CATCHUP') == 'true'
ADULT       = 'Adultos'
SWISS       = 'Swisscom+IPTV'

datapath    = xbmc.translatePath(ADDON.getAddonInfo('profile'))
extras      = os.path.join(datapath, 'extras')
logos       = os.path.join(extras,   'logos')
cookiepath  = os.path.join(datapath, 'cookies')
cookiefile  = os.path.join(cookiepath, 'cookie')


def log(text):
    try:
        output = '%s V%s : %s' % (TITLE, VERSION, str(text))
        if DEBUG:
            xbmc.log(output)
        else:
            xbmc.log(output, xbmc.LOGDEBUG)
    except:
        pass


def getDSFVersion():
    try:
        version = int(DSFVER.replace('.', ''))
        return version
    except:
        version = 999
        return version


def isProtected():
    try:    return DSF.getSetting('PROTECTED') == 'true'
    except: return False

def isSwiss():
    try:    return DSF.getSetting('SWISSCOM') == 'true'
    except: return False

def isLimited():
    return xbmcgui.Window(10000).getProperty('DSF_LIMITED').lower() == 'true'


def getCategories():
    if isLimited():
        return ['Ni%C3%B1os']

    return GetSetting('categories').split('|')


def getCategoryList(path):
    import StringIO
    from xml.etree import ElementTree

    xml  = None
    cat  = dict()
    try:
        if sfile.exists(path):
            xml = sfile.read(path)
    except:
        pass

    if not xml:
        return {}

    xml = StringIO.StringIO(xml)
    xml = ElementTree.iterparse(xml, events=("start", "end"))

    for event, elem in xml:
        try:
            if event == 'end':
               if elem.tag == 'cats':
                   channel  = elem.findtext('channel')
                   category = elem.findtext('category')
                   if channel != '' and category != '':
                       cat[channel] = category
        except:
            pass

    return cat


def CloseBusy():
    try: xbmc.executebuiltin('Dialog.Close(busydialog)')
    except: pass

def ShowBusy():
    try: xbmc.executebuiltin('ActivateWindow(busydialog)')
    except: pass

    return None


def notify(message, length=5000):
    # CloseBusy()
    cmd = 'XBMC.notification(%s,%s,%d,%s)' % (TITLE, message, length, ICON)
    xbmc.executebuiltin(cmd)


def loadKeymap():
    try:
        file = 'zOTT_Keymap.xml'
        src  = os.path.join(HOME, 'resources', file)
        dst  = os.path.join('special://profile/keymaps', file)

        if not sfile.exists(dst):
            sfile.copy(src, dst)
            xbmc.sleep(1000)

        xbmc.executebuiltin('Action(reloadkeymaps)')
    except Exception, e:
        pass


def removeKeymap():
    try:
        file = 'zOTT_Keymap.xml'
        dst  = os.path.join('special://profile/keymaps', file)

        if sfile.exists(dst):
            sfile.remove(dst)
            xbmc.sleep(1000)

        xbmc.executebuiltin('Action(reloadkeymaps)')
    except Exception, e:
        pass


def patchSkins():
    skinPath = os.path.join(extras, 'skins')

    srcImage = os.path.join(RESOURCES, 'changer.png')
    srcFile  = os.path.join(RESOURCES, 'script-tvguide-changer.xml')

    current, dirs, files = sfile.walk(skinPath)

    for dir in dirs:
        dstImage = os.path.join(current, dir, 'resources', 'skins', 'Default', 'media', 'changer.png')
        dstFile  = os.path.join(current, dir, 'resources', 'skins', 'Default', '720p', 'script-tvguide-changer.xml')

        sfile.copy(srcImage, dstImage, overWrite=False)
        sfile.copy(srcFile,  dstFile,  overWrite=False)


def WriteKeymap(start, end, filename, cmd):
    filename = os.path.join('special://profile/keymaps', filename)
    theFile  = sfile.file(filename, 'w')
    cmd      = '\t\t\t<%s>%s</%s>\n'  % (start, cmd, end)

    theFile.write('<keymap>\n')
    theFile.write('\t<global>\n')
    theFile.write('\t\t<keyboard>\n')

    theFile.write(cmd)

    theFile.write('\t\t</keyboard>\n')
    theFile.write('\n')
    theFile.write('\t\t<remote>\n')

    theFile.write(cmd)

    theFile.write('\t\t</remote>\n')
    theFile.write('\t</global>\n')
    theFile.write('</keymap>\n')

    theFile.close()

    return True


def GetDixieUrl():
    if isDSF():
        if getSubSystem() == '80906':
            return baseurl + 'swi/'

        if getSubSystem() == '348821':
            return baseurl + 'spa/'

        if getSubSystem() == '809010':
            return baseurl + 'ita/'

    return baseurl + 'all/'


def getSubSystem():
    return DSF.getSetting('GVAX-SUBSYS')


def GetKey():
    if isDSF():
        return 'OTHER'

    return 'ALL CHANNELS'


def isDSF():
    if xbmc.getCondVisibility('System.HasAddon(%s)' % DSFID) == 1:
        log(DSFID)
        return True

    return False


def GetExtraUrl():
    return resource


def GetLoginUrl():
    return loginurl


def GetVerifyUrl():
    return verifyurl


def GetChannelType():
    return GetSetting('chan.type')


def GetChannelFolder():
    CUSTOM = '1'

    channelType = GetChannelType()

    if channelType == CUSTOM:
        path = GetSetting('user.chan.folder')
        MigrateChannels(path)
    else:
        path = datapath

    return path


def GetGMTOffset():
    offset = 0
    return datetime.timedelta(hours = offset)


def saveCookies(requests_cookiejar, filename):
    if not os.path.isfile(cookiefile):
        try: os.makedirs(cookiepath)
        except: pass

    with open(cookiefile, 'wb') as f:
        pickle.dump(requests_cookiejar, f)


def loadCookies(filename):
    if not os.path.isfile(cookiefile):
        try: os.makedirs(cookiepath)
        except: pass
        
        open(cookiefile, 'a').close()
        
    try:
        with open(cookiefile, 'rb') as f:
            return pickle.load(f)
    except: pass
        
    return ''


def resetCookies():
    try:
        if os.path.isfile(cookiefile):
            os.remove(cookiefile)
    except: pass


def BackupCats():
    currcat = os.path.join(PROFILE, 'cats.xml')
    bakcat  = os.path.join(PROFILE, 'cats-bak.xml')

    try:    sfile.copy(currcat, bakcat)
    except: pass


def MigrateChannels(dst):
    dst = os.path.join(dst, 'channels')
    src = os.path.join(datapath, 'channels')

    if not sfile.exists(dst):
        try:    sfile.copytree(src, dst)
        except: pass


def FirstRun():
    if GetUser() != '' and GetPass() != '':
        return True

    if not isDSF():
        if DialogYesNo('Would you like to choose from one of our Channel Line-ups?', 
                        'These are customised listings all set up to save you time.',
                        'You can change this later using On-Tapp.TV Tools'):

            import extras

            URL      = 'http://files.on-tapp.tv/'
            baseurl  =  URL + 'lineups/'
            jsonurl  =  baseurl + 'lineups.json'
            response =  extras.getList(jsonurl, 'lineups', 'lineup')

            lineups  = []
            for result in response:
                label  = result['-name']
                url    = baseurl + result['-url']
                sfZip  = baseurl + result['-sfzip']
                isSF   = result['-sf']

                lineups.append((label, url, isSF, sfZip))

            menu = []
            for lineup in lineups:
                menu.append(lineup[0])

            title  = 'Please select a Channel Line-up'
            option =  xbmcgui.Dialog().select(title, menu)
            extras.installLineup(lineups[option])

    if DialogYesNo('On-Tapp.TV requires a subscription.', '', 'Would you like to enter your account details now?'):
        username = DialogKB('', 'Enter Your On-Tapp.TV Username')
        if isDSF():
            xbmcaddon.Addon(DSFID).setSetting('username', username)
        else:
            SetSetting('username', username)

        password = DialogKB('', 'Enter Your On-Tapp.TV Password')
        if isDSF():
            xbmcaddon.Addon(DSFID).setSetting('password', password)
        else:
            SetSetting('password', password)

    if verify.CheckCredentials():
        return True

    return False


def ShowSettings():
    ADDON.openSettings()


def getPreviousTime(setting):
    try:
        time_object = GetSetting(setting)
        previousTime = parseTime(time_object)
        return previousTime

    except:
        time_object  = '2001-01-01 00:00:00'
        previousTime = parseTime(time_object)
        return previousTime


def parseTime(when):
    if type(when) in [str, unicode]:
        dt = when.split(' ')
        d  = dt[0]
        t  = dt[1]
        ds = d.split('-')
        ts = t.split(':')
        when = datetime.datetime(int(ds[0]), int(ds[1]) ,int(ds[2]), int(ts[0]), int(ts[1]), int(ts[2].split('.')[0]))

    return when


def validTime(setting, maxAge):
    previousTime = getPreviousTime(setting)
    now          = datetime.datetime.today()
    delta        = now - previousTime
    nSeconds     = (delta.days * 86400) + delta.seconds

    return nSeconds <= maxAge


def validToRun(silent=False):
    # try:    count = int(GetSetting('LOGIN_COUNT'))
    # except: count = -1
    #
    # count += 1
    #
    # SetSetting('LOGIN_COUNT', str(count))
    #
    # if count % 3 > 0:
    #     return True

    setting      = 'LOGIN_TIME'
    previousTime = getPreviousTime(setting)
    now          = datetime.datetime.today()
    delta        = now - previousTime
    nSeconds     = (delta.days * 86400) + delta.seconds
    
    if nSeconds > 70 * 60:
        cmd = 'XBMC.RunScript(special://home/addons/script.tvguidedixie/getIni.py)'
        log('-------- OTT UPDATE INI FILES --------')
        xbmc.executebuiltin(cmd)

        if not doLogin(silent):
            return False

        SetSetting('LOGIN_TIME', str(now))

    return True


def doLogin(silent=False):
    log ('************ On-Tapp.EPG Login ************')
    with requests.Session() as s:
        if not silent:
            message = 'Logging into On-Tapp.TV'
            # notify(message)
            log(message)
        try:
            s.get(GetLoginUrl(), verify=False)
        except: 
            return False

        PAYLOAD  = { 'log' : GetUser(), 'pwd' : GetPass(), 'wp-submit' : 'Log In' }
        response = 'login_error'
        code     =  0

        if GetUser() and GetPass():
            login    = s.post(GetLoginUrl(), data=PAYLOAD, verify=False)
            response = login.content
            code     = login.status_code
            # saveCookies(s.cookies, cookiefile)
            log(code)

        if 'no-access-redirect' in response:
            error   = '301 - No Access.'
            message = 'It appears that your subscription has expired.'
            log(message + ' : ' + error)
            if not silent:
                DialogOK(message, error, 'Please check your account at www.on-tapp.tv')
            return False

        areLost    = 'Are you lost' in response
        loginError = 'login_error' in response
        okay       =  (not areLost) and (not loginError)

        if okay:
            message = 'Logged into On-Tapp.TV'
            log(message)
            # if not silent:
            #     notify(message)
            return True

        try:
            error = re.compile('<div id="login_error">(.+?)<br />').search(response).groups(1)[0]
            error = error.replace('<strong>',  '')
            error = error.replace('</strong>', '')
            error = error.replace('<a href="https://www.on-tapp.tv/wp-login.php?action=lostpassword">Lost your password?</a>', '')
            error = error.strip()
        except:
            error = ''
        
        message = 'There was a problem logging into On-Tapp.TV.'
        log(message + ' : ' + error)
        if not silent:
            DialogOK(message, error, 'Please check your account at www.on-tapp.tv')
        return False


def GetUser():
    if isDSF():
       username = xbmcaddon.Addon(DSFID).getSetting('username')
       return username

    username = GetSetting('username')
    return username


def GetPass():
    if isDSF():
       password = xbmcaddon.Addon(DSFID).getSetting('password')
       return password

    password = GetSetting('password')
    return password


def GetCats():
    path = os.path.join(PROFILE, 'cats.xml')


def GetChannels():
    path = os.path.join(PROFILE , 'chan.xml')

    return path


def selectMenu(title, menu):
    options = []
    for option in menu:
        options.append(option[0])

    option = xbmcgui.Dialog().select(title, options)

    if option < 0:
        return -1

    return menu[option][1]


def DialogOK(line1, line2='', line3=''):
    d = xbmcgui.Dialog()
    d.ok(TITLE + ' - ' + VERSION, line1, line2 , line3)


def DialogKB(value = '', heading = ''):
    kb = xbmc.Keyboard('', '')
    kb.setHeading(heading)
    kb.doModal()
    if (kb.isConfirmed()):
        value = kb.getText()
    return value


def DialogYesNo(line1, line2='', line3='', noLabel=None, yesLabel=None):
    d = xbmcgui.Dialog()
    if noLabel == None or yesLabel == None:
        return d.yesno(TITLE + ' - ' + VERSION, line1, line2 , line3) == True
    else:
        return d.yesno(TITLE + ' - ' + VERSION, line1, line2 , line3, noLabel, yesLabel) == True


def Progress(line1 = '', line2 = '', line3 = '', hide = False):
    dp = xbmcgui.DialogProgress()
    dp.create(TITLE, line1, line2, line3)
    dp.update(0)

    if hide:
        try:
            xbmc.sleep(250)
            WINDOW_PROGRESS = xbmcgui.Window(10101)
            CANCEL_BUTTON   = WINDOW_PROGRESS.getControl(10)
            CANCEL_BUTTON.setVisible(False)
        except:
            pass

    return dp


def openSettings(focus=None):
    addonID = ADDONID
    if not focus: 
        return xbmcaddon.Addon(addonID).openSettings()
    
    try:
        xbmc.executebuiltin('Addon.OpenSettings(%s)' % addonID)

        value1, value2 = str(focus).split('.')

        if FRODO:
            xbmc.executebuiltin('SetFocus(%d)' % (int(value1) + 200))
            xbmc.executebuiltin('SetFocus(%d)' % (int(value2) + 100))
        else:
            xbmc.executebuiltin('SetFocus(%d)' % (int(value1) + 100))
            xbmc.executebuiltin('SetFocus(%d)' % (int(value2) + 200))

    except Exception, e:
        log(str(e))
        return


def mapChannelName(channel):
    channel = channel.upper()

    if channel == 'BBC 1 [SD]' : return 'BBC One [SD]'
    if channel == 'BBC 1 [HD]' : return 'BBC One [HD]'
    if channel == 'BBC 2 [SD]' : return 'BBC Two [SD]'
    if channel == 'BBC 2 [HD]' : return 'BBC Two [HD]'
    if channel == 'BBC 1 HD' : return 'BBC One HD'
    if channel == 'BBC 1 SD' : return 'BBC One SD'
    if channel == 'BBC 2 HD' : return 'BBC Two HD'
    if channel == 'BBC 2 SD' : return 'BBC Two SD'
    if channel == 'BBC HD 2' : return 'BBC Two [HD]'
    if channel == 'C4 [SD]' : return 'Channel 4 [SD]'
    if channel == 'C4 [HD]' : return 'Channel 4 [HD]'
    if channel == 'Five [SD]' : return 'Channel 5 [SD]'
    if channel == 'Five [HD]' : return 'Channel 5 [HD]'
    if channel == 'BBC 4 HD [SD]' : return 'BBC FOUR [SD]'
    if channel == 'BBC 4 HD [HD]' : return 'BBC FOUR [HD]'
    if channel == 'BBC HD 4 / CBEEBIES HD' : return 'BBC FOUR [HD]'
    if channel == 'ITV' : return 'ITV1'
    if channel == 'ITV HD' : return 'ITV1 HD'
    if channel == 'ITV SD' : return 'ITV1 SD'
    if channel == 'ITV 2 [SD]' : return 'ITV2 [SD]'
    if channel == 'ITV 2 [HD]' : return 'ITV2 [HD]'
    if channel == 'ITV 3 [SD]' : return 'ITV3 [SD]'
    if channel == 'ITV 3 [HD]' : return 'ITV3 [HD]'
    if channel == 'ITV 4 [SD]' : return 'ITV4 [SD]'
    if channel == 'ITV 4 [HD]' : return 'ITV4 [HD]'

    if channel == 'ITV 1 HD' : return 'ITV1 HD'
    if channel == 'ITV 1' : return 'ITV1'
    if channel == 'ITV 2 HD' : return 'ITV2 HD'
    if channel == 'ITV 2' : return 'ITV2'
    if channel == 'ITV 3' : return 'ITV3'
    if channel == 'ITV 4 HD' : return 'ITV4 HD'
    if channel == 'ITV 4' : return 'ITV4'

    if channel == 'ITV BE' : return 'ITV Be'
    if channel == 'ITVBE' : return 'ITV Be'
    if channel == 'ITVBE HD' : return 'ITV Be HD'
    if channel == 'More 4' : return 'More4'
    if channel == '4 Seven' : return '4seven'
    if channel == '4 SEVEN' : return '4seven'
    if channel == 'My 5' : return '5+24'
    if channel == 'BBC Red Button 1' : return 'BBC Red Button'
    if channel == 'BBC 1 Northen Ireland [SD]' : return 'BBC One Northen Ireland [SD]'
    if channel == 'BBC 1 Northen Ireland [HD]' : return 'BBC One Northen Ireland [HD]'
    if channel == 'BBC 1 Scotland [SD]' : return 'BBC One Scotland [SD]'
    if channel == 'BBC 1 Scotland [HD]' : return 'BBC One Scotland [HD]'
    if channel == 'BBC 1 Wales [SD]' : return 'BBC One Wales [SD]'
    if channel == 'BBC 1 Wales [HD]' : return 'BBC One Wales [HD]'
    if channel == 'BBC 1 London [SD]' : return 'BBC One London [SD]'
    if channel == 'BBC 1 London [HD]' : return 'BBC One London [HD]'
    if channel == 'BBC 2 Northen Ireland [SD]' : return 'BBC Two Northen Ireland [SD]'
    if channel == 'BBC 2 Northen Ireland [HD]' : return 'BBC Two Northen Ireland [HD]'
    if channel == 'BBC 2 Scotland [SD]' : return 'BBC Two Scotland [SD]'
    if channel == 'BBC 2 Scotland [HD]' : return 'BBC Two Scotland [HD]'
    if channel == 'BBC 2 Wales [SD]' : return 'BBC Two Wales [SD]'
    if channel == 'BBC 2 Wales [HD]' : return 'BBC Two Wales [HD]'
    if channel == 'RTE1' : return 'RTE One'
    if channel == 'RTE2' : return 'RTE Two'
    if channel == 'RTE 1' : return 'RTE One'
    if channel == 'RTE 1 HD' : return 'RTE One HD'
    if channel == 'RTE 2' : return 'RTE Two'
    if channel == 'RTE Junior' : return 'RTE Jr'
    if channel == 'TV3' : return 'TV3'
    if channel == '3E' : return '3e'
    if channel == 'SKY ONE HD' : return 'Sky 1 HD'
    if channel == 'SKY ONE SD' : return 'Sky 1 SD'
    if channel == 'SKY TWO SD' : return 'Sky 2 SD'
    if channel == 'Sky One' : return 'Sky 1'
    if channel == 'Sky Two' : return 'Sky 2'
    if channel == 'Sky1' : return 'Sky 1'
    if channel == 'Sky2' : return 'Sky 2'
    if channel == 'SKY1' : return 'Sky 1'
    if channel == 'SKY2' : return 'Sky 2'
    if channel == 'SkyLiving' : return 'Sky Living'
    if channel == 'W HD UK' : return 'Watch HD'

    if channel == 'Fox UK' : return 'FOX UK'
    if channel == 'Fox GB' : return 'FOX UK'
    if channel == 'Fox US' : return 'FOX'
    if channel == 'SyFy UK' : return 'SYFY UK'
    if channel == 'Universal' : return 'UK Universal Channel'
    if channel == 'Davejavu' : return 'Dave ja vu'
    if channel == 'UK Gold' : return 'GOLD'
    if channel == 'Comedy Central Xtra' : return 'Comedy Central Extra'
    if channel == 'COMEDY CENTRAL EXTRA SD' : return 'Comedy Central Extra'
    if channel == 'Comedy Central GB' : return 'Comedy Central'
    if channel == 'Comedy Central US' : return 'Comedy Central HD'
    if channel == 'COMEDYCENTRAL' : return 'Comedy Central US'
    if channel == '&HD' : return 'AND TV'

    if channel == 'PBS UK' : return 'UK PBS'
    if channel == 'Sony Entertainment' : return 'Sony Channel'
    if channel == 'E! UK' : return 'Entertainment HD'
    if channel == 'Sky Real Lives' : return 'Real Lives'
    if channel == 'AMC UK [SD]' : return 'UK AMC'
    if channel == 'TLC UK' : return 'TLC'
    if channel == 'Pick TV' : return 'Pick'
    if channel == 'Sky Arts' : return 'Sky Arts 1'
    if channel == 'Gold' : return 'GOLD'
    if channel == 'LifeTime UK' : return 'UK Lifetime'
    if channel == 'Yesterday TV' : return 'Yesterday'
    if channel == 'Home TV' : return 'Home'
    if channel == 'Tru TV' : return 'TruTV UK'
    if channel == 'Challenge TV' : return 'Challenge'

    if channel == 'BT SPORT / ESPN' : return 'BT Sport-ESPN 2'
    if channel == 'BT SPORT//ESPN' : return 'BT Sport-ESPN'
    if channel == 'BT Sport ESPNHD' : return 'BT Sport-ESPN HQ'
    if channel == 'BT Sport ESPN HD' : return 'BT Sport-ESPN HD'
    if channel == 'BT Sport ESPN' : return 'BT Sport-ESPN'

    if channel == 'BT Sport 3 HD' : return 'BT Sport Europe HD'
    if channel == 'BT Sport 3 HQ' : return 'BT Sport Europe HQ'
    if channel == 'BT Sport 3' : return 'BT Sport Europe'

    if channel == 'Liverpool TV' : return 'LFC TV'
    if channel == 'Liverpool TV HD' : return 'LFC TV HD'

    if channel == 'EuroSport 1 UK [SD]' : return 'Eurosport [SD]'
    if channel == 'EuroSport 1 UK [HD]' : return 'Eurosport [HD]'
    if channel == 'EuroSports 2 UK [SD]' : return 'Eurosport 2 [SD]'
    if channel == 'EuroSports 2 UK [HD]' : return 'Eurosport 2 [HD]'

    if channel == 'Eurosport 1 HD' : return 'Eurosport'
    if channel == 'Eurosport 2 HD' : return 'Eurosport 2'
    if channel == 'Eurosport 1' : return 'Eurosport'

    if channel == 'eir Sport 1 [SD]' : return 'Setanta Ireland'
    if channel == 'eir Sport 2 [SD]' : return 'Setanta Sports 1'
    if channel == 'Eir Sports 1' : return 'Setanta Ireland'
    if channel == 'Eir Sports 2' : return 'Setanta Sports 1'
    if channel == 'Premier Sports [SD]' : return 'Premier Sport [SD]'
    if channel == 'Premier Sports [HD]' : return 'Premier Sport [HD]'

    if channel == 'Sky Premiere [SD]' : return 'Sky Premiere'
    if channel == 'Sky Disney [SD]' : return 'Sky Disney'
    if channel == 'Sky ShowCase' : return 'Sky Showcase'
    if channel == 'Sky Action & Adventure' : return 'Sky Action'
    if channel == 'Sky Greats' : return 'Sky Modern Greats'
    if channel == 'Sky Drama & Romance' : return 'Sky Drama'
    if channel == 'Sky Scifi & Horror' : return 'Sky Sci-fiHorror'
    if channel == 'Sky Crime & Thriller' : return 'Sky Thriller'

    if channel == 'Sky Movies Action HD' : return 'Sky Action HD'
    if channel == 'Sky Movies Action & Adventure HD' : return 'Sky Action HD'
    if channel == 'Sky Cinema Action & Adventure' : return 'Sky Action'
    if channel == 'Sky Movies Action & Adventure' : return 'Sky Action'
    if channel == 'SKY MOVIES ACTION & ADVENTURE' : return 'Sky Action'
    if channel == 'Sky Movies Comedy HD' : return 'Sky Comedy HD'
    if channel == 'Sky Movies Comedy' : return 'Sky Comedy'
    if channel == 'SKY MOVIES COMEDY' : return 'Sky Comedy'
    if channel == 'Sky Movies Thriller HD' : return 'Sky Thriller HD'
    if channel == 'Sky Movies Crime & Thriller HD' : return 'Sky Thriller HD'
    if channel == 'Sky Movies Crime & Thriller' : return 'Sky Thriller'
    if channel == 'Sky Movies Disney HD' : return 'Sky Disney HD'
    if channel == 'Sky Movies Disney' : return 'Sky Disney'
    if channel == 'Sky Movies Drama & Romance HD' : return 'Sky Drama HD'
    if channel == 'Sky Movies Drama & Romance' : return 'Sky Drama'
    if channel == 'Sky Movies Drama HD' : return 'Sky Drama'
    if channel == 'Sky Movies Family HD' : return 'Sky Family HD'
    if channel == 'Sky Movies Family' : return 'Sky Family'
    if channel == 'Sky Movies Greats HD' : return 'Sky Modern Greats'
    if channel == 'Sky Movies Premier HD' : return 'Sky Premiere HD'
    if channel == 'Sky Movies Premiere' : return 'Sky Premiere'
    if channel == 'Sky Movies Sci-Fi Horror HD' : return 'Sky Sci-fiHorror HD'
    if channel == 'Sky Movies Scifi & Horror HD' : return 'Sky Sci-fiHorror HD'
    if channel == 'Sky Movies Scifi & Horror' : return 'Sky Sci-fiHorror'
    if channel == 'SKY MOVIES SCIFI AND HORROR HD' : return 'Sky Sci-fiHorror'
    if channel == 'Sky Movies ScFi-Horror' : return 'Sky Sci-fiHorror'
    if channel == 'Sky Movies Select HD' : return 'Sky Select HD'
    if channel == 'Sky Movies Select' : return 'Sky Select'
    if channel == 'Sky Movies Showcase HD' : return 'Sky Showcase HD'
    if channel == 'Sky Movies Showcase' : return 'Sky Showcase'

    if channel == 'Sky Cinema Premiere HD' : return 'Sky Premiere'
    if channel == 'Sky Cinema Premiere' : return 'Sky Premiere'
    if channel == 'Sky Cinema Disney' : return 'Sky Disney'
    if channel == 'Sky Cinema Disney HD' : return 'Sky Disney HD'
    if channel == 'Sky Cinema ShowCase' : return 'Sky Showcase'
    if channel == 'Sky Cinema Showcase HD' : return 'Sky Showcase HD'
    if channel == 'Sky Cinema Action and Adventure' : return 'Sky Action'
    if channel == 'Sky Cinema Action & Adventure HD' : return 'Sky Action HD'
    if channel == 'Sky Cinema Action & Adventure' : return 'Sky Action'
    if channel == 'Sky Cinema Greats' : return 'Sky Modern Greats'
    if channel == 'SKY CINEMA GREATS' : return 'Sky Modern Greats'
    if channel == 'Sky Cinema Drama and Romance' : return 'Sky Drama'
    if channel == 'Sky Cinema Drama & Romance' : return 'Sky Drama'
    if channel == 'Sky Cinema Drama & Romance HD' : return 'Sky Drama HD'
    if channel == 'Sky Cinema Family' : return 'Sky Family'
    if channel == 'Sky Cinema Family HD' : return 'Sky Family HD'
    if channel == 'Sky Cinema Sci-Fi and Horror' : return 'Sky Sci-fiHorror'
    if channel == 'Sky Cinema Sci-Fi & Horror HD' : return 'Sky Sci-fiHorror HD'
    if channel == 'Sky Cinema Crime and Thriller' : return 'Sky Thriller'
    if channel == 'Sky Cinema Thriller HD' : return 'Sky Thriller HD'

    if channel == 'SKY CINEMA COMEDY' : return 'Sky Comedy HD'
    if channel == 'SKY CINEMA COMEDY HD' : return 'Sky Comedy HD'
    if channel == 'SKY CINEMA COMEDY SD' : return 'Sky Comedy SD'
    if channel == 'SKY CINEMA HITS HD' : return 'Sky Hits HD'
    if channel == 'SKY CINEMA HITS SD' : return 'Sky Hits SD'
    if channel == 'SKY CINEMA SELECT' : return 'Sky Select HD'
    if channel == 'SKY CINEMA SELECT HD' : return 'Sky Select HD'
    if channel == 'SKY CINEMA SELECT SD' : return 'Sky Select SD'
    if channel == 'SKY CINEMA PREMIERE' : return 'Sky Premiere HD'
    if channel == 'SKY CINEMA PREMIERE HD' : return 'Sky Premiere HD'
    if channel == 'SKY CINEMA PREMIERE SD' : return 'Sky Premiere SD'
    if channel == 'SKY CINEMA DISNEY' : return 'Sky Disney SD'
    if channel == 'SKY CINEMA DISNEY SD' : return 'Sky Disney SD'
    if channel == 'SKY CINEMA DISNEY HD' : return 'Sky Disney HD'
    if channel == 'SKY CINEMA SHOWCASE SD' : return 'Sky Showcase SD'
    if channel == 'SKY CINEMA SHOWCASE HD' : return 'Sky Showcase HD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE' : return 'Sky Action HD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE HD' : return 'Sky Action HD'
    if channel == 'SKY CINEMA ACTION & ADVENTURE SD' : return 'Sky Action SD'
    if channel == 'SKY CINEMA HARRY POTTER HD' : return 'Sky Modern Greats HD'
    if channel == 'SKY CINEMA HARRY POTTER SD' : return 'Sky Modern Greats SD'
    if channel == 'SKY CINEMA DRAMA & ROMANCE SD' : return 'Sky Drama SD'
    if channel == 'SKY CINEMA DRAMA & ROMANCE HD' : return 'Sky Drama HD'
    if channel == 'SKY CINEMA FAMILY' : return 'Sky Family SD'
    if channel == 'SKY CINEMA FAMILY SD' : return 'Sky Family SD'
    if channel == 'SKY CINEMA FAMILY HD' : return 'Sky Family HD'
    if channel == 'SKY CINEMA SCI-FI & HORROR SD' : return 'Sky Sci-fiHorror SD'
    if channel == 'SKY CINEMA SCI-FI & HORROR HD' : return 'Sky Sci-fiHorror HD'
    if channel == 'SKY CINEMA CRIME & THRILLER SD' : return 'Sky Thriller SD'
    if channel == 'SKY CINEMA CRIME & THRILLER HD' : return 'Sky Thriller HD'
    if channel == 'SKY CINEMA CRIME & THRILLER' : return 'Sky Thriller HD'

    if channel == 'Sky Cinema Action' : return 'Sky Action'
    if channel == 'Sky Cinema Drama' : return 'Sky Drama'
    if channel == 'Sky Cinema Sci-Fi' : return 'Sky Sci-fiHorror'
    if channel == 'Sky Cinema Crime' : return 'Sky Thriller'
    if channel == 'Sky Cinema Comedy HD' : return 'Sky Comedy HD'
    if channel == 'Sky Cinema Comedy' : return 'Sky Comedy'
    if channel == 'Sky Cinema Hits' : return 'Sky Hits'
    if channel == 'Sky Cinema Hits HD' : return 'Sky Hits HD'
    if channel == 'Sky Cinema Select' : return 'Sky Select'
    if channel == 'Sky Cinema Select HD' : return 'Sky Select HD'
    if channel == 'Sky Cinema Comedy' : return 'Sky Comedy'

    if channel == 'Film 4' : return 'Film4'
    if channel == 'Sony Movies' : return 'Sony Movie Channel'
    if channel == 'Movies 4 Men' : return 'Movies4Men'

    if channel == 'Discovery Channel GB' : return 'Discovery Channel'
    if channel == 'Discovery Channel US' : return 'Discovery US'
    if channel == 'Discovery UK HD' : return 'Discovery Channel HD'
    if channel == 'Discovery UK' : return 'Discovery Channel'
    if channel == 'Discovery HD' : return 'Discovery US'
    if channel == 'Discovery Shed.' : return 'Discovery Shed'
    if channel == 'Discovery Investigation' : return 'Discovery ID'
    if channel == 'Discovery UK [SD]' : return 'Discovery Channel'
    if channel == 'Nat Geo UK' : return 'Nat Geo Channel UK'
    if channel == 'NatGeo Wild' : return 'Nat Geo Wild'
    if channel == 'History UK [SD]' : return 'History'
    if channel == 'History GB' : return 'History'
    if channel == 'History US' : return 'History US'
    if channel == 'H2 UK' : return 'H2'
    if channel == 'Animal UK' : return 'Animal Planet'
    if channel == 'Crime & Investigation' : return 'Crime and Investigation'
    if channel == 'Discovery Science UK' : return 'Discovery Science'
    if channel == 'Discovery Turbo UK' : return 'Discovery Turbo'
    if channel == 'Home and Health' : return 'Discovery Home'
    if channel == 'I.D.' : return 'Discovery ID'
    if channel == 'ID HD' : return 'Discovery ID'

    if channel == 'Cartoon Network' : return 'Cartoon Network UK'
    if channel == 'Cartoon Network USA' : return 'Cartoon Network US'

    if channel == 'Disney HD UK' : return 'Disney Channel'
    if channel == 'Disney HD' : return 'Disney Channel US'
    if channel == 'Disney Jr. UK' : return 'Disney Junior'
    if channel == 'Disney Jr. HD' : return 'Disney Junior US'
    if channel == 'E! HD' : return 'Entertainment HD'

    if channel == 'Disney UK [SD]' : return 'Disney Channel [SD]'
    if channel == 'Disney UK [HD]' : return 'Disney Channel [HD]'
    if channel == 'Disney Xd UK' : return 'Disney XD'
    if channel == 'DisneyJR UK' : return 'Disney Junior'
    if channel == 'Nickolodeon UK ' : return 'Nickelodeon'
    if channel == 'Nickelodeon USA' : return 'Nickelodeon US'
    if channel == 'Nick JR UK' : return 'Nick Jr'
    if channel == 'Nick JR Too' : return 'Nick Jr Too'
    if channel == 'NickToons' : return 'Nicktoons'

    if channel == 'Nickelodeon UK' : return 'Nickelodeon'
    if channel == 'Nickelodeon UK HD' : return 'Nickelodeon HD'
    if channel == 'Nick HD' : return 'Nickelodeon US'

    if channel == 'NICK JR. SD' : return 'Nick Jr'
    if channel == 'NICK JR. TOO SD' : return 'Nick Jr Too'
    if channel == 'Nick Jr.' : return 'Nick Jr'
    if channel == 'Nick Jr. HD' : return 'Nick Jr HD'
    if channel == 'Nick JR Too' : return 'Nick Jr Too'
    if channel == 'NickToon UK' : return 'Nicktoons'
    if channel == 'Boomerang Kids' : return 'Boomerang'
    if channel == 'Boomerang HD' : return 'Boomerang US'
    if channel == 'BOOMERANG UK' : return 'Boomerang'
    if channel == 'cbbc HD [SD]' : return 'CBBC [SD]'
    if channel == 'cbbc HD [HD]' : return 'CBBC [HD]'
    if channel == 'BBC HD 3 / CBBC HD' : return 'CBBC [HD]'
    if channel == 'cbeebies HD [SD]' : return 'CBeebies [SD]'
    if channel == 'cbeebies HD [HD]' : return 'CBeebies [HD]'
    if channel == 'BBC HD 4 / CBEEBIES HD' : return 'CBeebies [HD]'
    if channel == 'RTE Jnr' : return 'RTE Jr'
    if channel == 'MTV UK [SD]' : return 'MTV [SD]'
    if channel == 'MTV UK [HD]' : return 'MTV [HD]'
    if channel == 'MTV UK HD' : return 'MTV'
    if channel == 'MTV Hits' : return 'MTV HITS'
    if channel == 'MTV Dance' : return 'MTV DANCE'
    if channel == 'MTV Classics' : return 'MTV Classic'
    if channel == 'Now Music' : return 'NOW Music'
    if channel == 'HeartTV HD' : return 'Heart TV HD'
    if channel == 'HeartTV' : return 'Heart TV'

    if channel == 'W HD' : return 'Watch HD'
    if channel == 'W SD' : return 'Watch SD'
    if channel == 'SKY ARTS SD' : return 'Sky Arts 1'
    if channel == 'UK :SKY NEWS SD' : return 'Sky News SD'
    if channel == 'SKY NEWS[COLOR green]*[COLOR]' : return 'Sky News'
    if channel == 'BBC News 24 [SD]' : return 'BBC News [SD]'
    if channel == 'BBC News 24 [HD]' : return 'BBC News [HD]'
    if channel == 'Fox News' : return 'FOX News'
    if channel == 'RTE News' : return 'RTE News Now'
    if channel == 'RT UK' : return 'Russia Today'
    if channel == 'AlJazeera News' : return 'Al Jazeera English'
    if channel == 'Ary QTV' : return 'ARY QTV'
    if channel == 'Ary Digital' : return 'ARY Digital'
    if channel == 'Geo UK' : return 'GEO UK'
    if channel == 'Geo News' : return 'GEO News'
    if channel == 'Sony Set Asia' : return 'Sony TV Asia'
    if channel == 'Sony Sab' : return 'Sony SAB'
    if channel == '&TV [SD]' : return 'ANDTV'
    if channel == 'MYTV 33 [HD]' : return 'My9'
    if channel == 'USA Network [HD]' : return 'USA Network'
    if channel == 'USA HD' : return 'USA Network'
    if channel == 'Bravo US [HD]' : return 'BRAVO HD'
    if channel == 'FX US [SD]' : return 'FX SD]'
    if channel == 'FX US [HD]' : return 'FX [HD]'
    if channel == 'FXX US [SD]' : return 'FXX [SD]'
    if channel == 'FXX US [HD]' : return 'FXX [HD]'
    if channel == 'SyFy US [HD]' : return 'SYFY HD'
    if channel == 'Lifetime US [HD]' : return 'LIFE'
    if channel == 'Spike US [HD]' : return 'Spike HD'
    if channel == 'AMC US [HD]' : return 'AMC HD'
    if channel == 'TNT US [HD]' : return 'TNT HD'
    if channel == 'TBS US [HD]' : return 'TBS HD'
    if channel == 'Comedy Central US [HD]' : return 'Comedy Central HD'
    if channel == 'HBO2 HD' : return 'HBO2'
    if channel == 'HBOFamily HD' : return 'HBO Family'
    if channel == 'HBOSignature HD' : return 'HBO Signature'
    if channel == 'HBOZone HD' : return 'HBO Zone'
    if channel == 'Starz Kids & Family HD' : return 'Starz Kids and Family'

    if channel == 'NBC Sports Network [SD]' : return 'NBC Sports HD [SD]'
    if channel == 'NBC Sports Network [HD]' : return 'NBC Sports HD [HD]'
    if channel == 'NBC Extra Time EPL 1  [SD]' : return 'NBC Sports ET1 [SD]'
    if channel == 'NBC Extra Time EPL 1  [HD]' : return 'NBC Sports ET1 [HD]'
    if channel == 'NBC Extra Time EPL 2  [SD]' : return 'NBC Sports ET2 [SD]'
    if channel == 'NBC Extra Time EPL 2  [HD]' : return 'NBC Sports ET2 [HD]'
    if channel == 'NBC Extra Time EPL 3  [SD]' : return 'NBC Sports ET3 [SD]'
    if channel == 'NBC Extra Time EPL 3  [HD]' : return 'NBC Sports ET3 [HD]'
    if channel == 'NBC Extra Time EPL 4  [SD]' : return 'NBC Sports ET4 [SD]'
    if channel == 'NBC Extra Time EPL 4  [HD]' : return 'NBC Sports ET4 [HD]'
    if channel == 'NBC Extra Time EPL 5  [SD]' : return 'NBC Sports ET5 [SD]'
    if channel == 'NBC Extra Time EPL 5  [HD]' : return 'NBC Sports ET5 [HD]'
    
    if channel == 'NBC EXTRA TIME HD (LIVE ON MATCHES ONLY)' : return 'NBC Sports ET1'
    if channel == 'NBC EXTRA TIME HD2 (LIVE ON MATCHES ONLY)' : return 'NBC Sports ET2'
    if channel == 'NBC EXTRA TIME HD3 (LIVE ON MATCHES ONLY)' : return 'NBC Sports ET3'
    if channel == 'NBC EXTRA TIME HD4 (LIVE ON MATCHES ONLY0' : return 'NBC Sports ET4'
    if channel == 'NBC EXTRA TIME HD5 (LIVE ON MATCHES ONLY)' : return 'NBC Sports ET5'
    if channel == 'NBC EXTRA TIME HD6 (LIVE ON MATCHES ONLY)' : return 'NBC Sports ET6'
    if channel == 'NBC EXTRA TIME HD7 (LIVE ON MATCHES ONLY)' : return 'NBC Sports ET7'

    if channel == 'CNBC US [HD]' : return 'CNBC'
    if channel == 'NBC Golf [SD]' : return 'Golf Channel [SD]'
    if channel == 'NBC Golf [HD]' : return 'Golf Channel [HD]'
    if channel == 'Golf HD' : return 'Golf Channel HD'
    if channel == 'Golf' : return 'Golf Channel'
    if channel == 'ESPN1 [SD]' : return 'ESPN USA [SD]'
    if channel == 'ESPN1 [HD]' : return 'ESPN USA [HD]'
    if channel == 'ESPN2 [SD]' : return 'ESPN2 USA [SD]'
    if channel == 'ESPN2 [HD]' : return 'ESPN2 USA [HD]'
    if channel == 'ESPN University [SD]' : return 'ESPNU [SD]'
    if channel == 'ESPN University [HD]' : return 'ESPNU [HD]'

    if channel == 'ESPN HD' : return 'ESPN USA'
    if channel == 'ESPN 2 HD' : return 'ESPN2 USA'
    if channel == 'ESPN U HD' : return 'ESPNU'

    if channel == 'NFL Network  HD' : return 'NFL TV'
    if channel == 'NFL Now [SD]' : return 'NFL TV [SD]'
    if channel == 'NFL Now [HD]' : return 'NFL TV [HD]'
    if channel == 'NFL Feed 1 [SD]' : return 'NFL 1 [SD]'
    if channel == 'NFL Feed 1 [HD]' : return 'NFL 1 [HD]'
    if channel == 'NFL Feed 2 [SD]' : return 'NFL 2 [SD]'
    if channel == 'NFL Feed 2 [HD]' : return 'NFL 2 [HD]'
    if channel == 'NFL Feed 3 [SD]' : return 'NFL 3 [SD]'
    if channel == 'NFL Feed 3 [HD]' : return 'NFL 3 [HD]'
    if channel == 'NFL Feed 4 [SD]' : return 'NFL 4 [SD]'
    if channel == 'NFL Feed 4 [HD]' : return 'NFL 4 [HD]'
    if channel == 'NFL Feed 5 [SD]' : return 'NFL 5 [SD]'
    if channel == 'NFL Feed 5 [HD]' : return 'NFL 5 [HD]'
    if channel == 'NFL Feed 6 [SD]' : return 'NFL 6 [SD]'
    if channel == 'NFL Feed 6 [HD]' : return 'NFL 6 [HD]'
    if channel == 'NFL Feed 7 [SD]' : return 'NFL 7 [SD]'
    if channel == 'NFL Feed 7 [HD]' : return 'NFL 7 [HD]'
    if channel == 'NFL Feed 8 [SD]' : return 'NFL 8 [SD]'
    if channel == 'NFL Feed 8 [HD]' : return 'NFL 8 [HD]'

    if channel == 'NFL LIVE 1' : return 'NFL 1'
    if channel == 'NFL LIVE 2' : return 'NFL 2'
    if channel == 'NFL LIVE 3' : return 'NFL 3'
    if channel == 'NFL LIVE 4' : return 'NFL 4'
    if channel == 'NFL LIVE 5' : return 'NFL 5'
    if channel == 'NFL LIVE 6' : return 'NFL 6'
    if channel == 'NFL LIVE 7' : return 'NFL 7'
    if channel == 'NFL LIVE 8' : return 'NFL 8'
    if channel == 'NFL LIVE 9' : return 'NFL 9'
    if channel == 'NFL LIVE 10' : return 'NFL 10'
    if channel == 'NFL LIVE 11' : return 'NFL 11'
    if channel == 'NFL LIVE 12' : return 'NFL 12'
    if channel == 'NFL LIVE 13' : return 'NFL 13'

    if channel == 'BEIN USA [SD]' : return 'Bein Sports [SD]'
    if channel == 'BEIN USA [HD]' : return 'Bein Sports [HD]'
    if channel == 'FXM US [SD]' : return 'FX Movie Channel [SD]'
    if channel == 'FXM US [HD]' : return 'FX Movie Channel [HD]'
    if channel == 'Animal Planet US [HD]' : return 'Animal Planet HD'
    if channel == 'NAT GEO HD' : return 'Nat Geo US'
    if channel == 'NAT GEO Wild HD' : return 'Nat Geo Wild US'
    if channel == 'History US [HD]' : return 'History US'
    if channel == 'A&E US [HD]' : return 'AE'
    if channel == 'A and E' : return 'AE'
    if channel == 'A&E HD' : return 'AE'
    if channel == 'Nickelodeon US [HD]' : return 'Nickelodeon US'
    if channel == 'Cartoon Networks US [HD]' : return 'Cartoon Network US'
    if channel == 'CNBC US [HD]' : return 'CNBC'
    if channel == 'MSNBC US [SD]' : return 'MSNBC [SD]'
    if channel == 'MSNBC US [HD]' : return 'MSNBC [HD]'
    if channel == 'Fox News US [HD]' : return 'FOX News'
    if channel == 'Lifetime HD' : return 'LIFE'
    if channel == 'STARZKIDS & FAMILY HD' : return 'Starz Kids and Family'
    if channel == 'Cinemax MoreMax HD' : return 'MoreMax'
    if channel == 'Cinemax ThrillerMax HD' : return 'ThrillerMax'
    if channel == 'Hallmark HD' : return 'Hallmark Channel'
    if channel == 'Hallmark Movies & Mysteries HD' : return 'Hallmark Movies'
    if channel == 'Universal HD' : return 'Universal Channel'
    if channel == 'Universal Channel UK' : return 'UK Universal Channel'
    if channel == 'DIY HD' : return 'DIY Network'
    if channel == 'Crime & Investigation HD' : return 'US Crime and Investigation'
    if channel == 'Travel Channel HD' : return 'Travel Channel US'
    if channel == 'Lifetime UK HD' : return 'UK Lifetime HD'
    if channel == 'Lifetime UK' : return 'UK Lifetime'

    if channel == 'CNN US [HD]' : return 'CNN HD'
    if channel == 'SN Ontario [SD]' : return 'Sportsnet Ontario [SD]'
    if channel == 'SN Ontario [HD]' : return 'Sportsnet Ontario [HD]'
    if channel == 'SN World [SD]' : return 'Sportsnet World [SD]'
    if channel == 'SN World [HD]' : return 'Sportsnet World [HD]'
    if channel == 'SN One [SD]' : return 'Sportsnet One [SD]'
    if channel == 'SN One [HD]' : return 'Sportsnet One [HD]'
    if channel == 'SN 360 [SD]' : return 'Sportsnet 360 [SD]'
    if channel == 'SN 360 [HD]' : return 'Sportsnet 360 [HD]'

    if channel == 'Sports Net Ontario HD' : return 'Sportsnet Ontario'
    if channel == 'Sports Net World HD' : return 'Sportsnet World'
    if channel == 'Sports Net One HD' : return 'Sportsnet One'
    if channel == 'Sports Net 360' : return 'Sportsnet 360'

    if channel == 'TSN1 HD' : return 'TSN HD'
    if channel == 'TSN3' : return 'TSN 3 HD'
    if channel == 'TSN4 HD' : return 'TSN 4 HD'
    if channel == 'TSN 1' : return 'TSN HD'
    if channel == 'TSN 2' : return 'TSN 2 HD'
    if channel == 'TSN 3' : return 'TSN 3 HD'
    if channel == 'TSN 4' : return 'TSN 4 HD'
    if channel == 'TSN 5' : return 'TSN 5 HD'
    if channel == 'TSN 1 HD' : return 'TSN HD'

    if channel == 'BEIN HD 10' : return 'BeIN Sports 10 HD'
    if channel == 'BEIN HD 11' : return 'BeIN Sports 11 HD'
    if channel == 'BEIN HD 12' : return 'BeIN Sports 12 HD'
    if channel == 'BEIN HD 1' : return 'BeIN Sports 1 HD'
    if channel == 'BEIN HD 2' : return 'BeIN Sports 2 HD'
    if channel == 'BEIN HD 3' : return 'BeIN Sports 3 HD'
    if channel == 'BEIN HD 4' : return 'BeIN Sports 4 HD'
    if channel == 'BEIN HD 5' : return 'BeIN Sports 5 HD'
    if channel == 'BEIN HD 6' : return 'BeIN Sports 6 HD'
    if channel == 'BEIN HD 7' : return 'BeIN Sports 7 HD'
    if channel == 'BEIN HD 8' : return 'BeIN Sports 8 HD'
    if channel == 'BEIN HD 9' : return 'BeIN Sports 9 HD'

    if channel == 'FOX SPORTS ASIA 1 HD' : return 'TH Fox Sports 1'
    if channel == 'FOX SPORTS ASIA 2 HD' : return 'TH Fox Sports 2'
    if channel == 'FOX SPORTS ASIA 3 HD' : return 'TH Fox Sports 3'

    if channel == 'Tennis Channel HD' : return 'The Tennis Channel'

    if channel == 'svt 1' : return 'SVT 1'
    if channel == 'svt 2' : return 'SVT 2'
    if channel == 'Kanal 5' : return 'Kanal 5 SE'
    if channel == 'TV6' : return 'TV 6 Sverige'
    if channel == 'TV8' : return 'TV 8 SE'
    if channel == 'Kanal 9' : return 'Kanal 9 SE'
    if channel == 'TV10' : return 'TV 10 SE'
    if channel == 'TV4 Fakta' : return 'TV 4 Fakta'
    if channel == 'TV4 Guld' : return 'TV 4 Guld'
    if channel == 'TV4 Komedi' : return 'TV 4 Komedi'
    if channel == 'TV3 Sport SE' : return 'TV 3 Sport 1'
    if channel == 'TV4 Sport SE' : return 'TV 4 Sport'
    if channel == 'Discovery SE' : return 'Discovery SE'
    if channel == 'Disney SE' : return 'Disney Kanalen SE'
    if channel == 'DR1' : return 'DR 1'
    if channel == 'DR2' : return 'DR 2'
    if channel == 'DR3' : return 'DR 3'
    if channel == 'SVT1' : return 'SVT 1'
    if channel == 'SVT2' : return 'SVT 2'
    if channel == 'Dk4' : return 'DK 4'
    if channel == 'DRk' : return 'DR K'
    if channel == 'TV2 Zulu' : return 'TV 2 Zulu'
    if channel == 'TV2 Charli ' : return 'TV 2 Charlie'
    if channel == 'TV2 Fri ' : return 'TV 2 Fri'
    if channel == 'Kanal 5' : return 'Kanal 5 DK'
    if channel == '6eren' : return '6EREN DK'
    if channel == 'Canal9' : return 'Canal 9 DK'
    if channel == 'TV3+ ' : return 'TV 3 Plus'
    if channel == 'TV3 Puls' : return 'TV 3 Puls'
    if channel == 'TV3 Sports 1' : return 'TV 3 Sport 1'
    if channel == 'TV3 Sports 2' : return 'TV 3 Sport 2'
    if channel == 'DR RamaSjang' : return 'DR Ramasjang'
    if channel == 'TV2 News ' : return 'TV 2 News'
    if channel == 'Tv2 [SD]' : return 'TV 2 NO [SD]'
    if channel == 'Tv2 [HD]' : return 'TV 2 NO [HD]'
    if channel == 'Tv2 Zebra [SD]' : return 'TV 2 Zebra [SD]'
    if channel == 'Tv2 Zebra [HD]' : return 'TV 2 Zebra [HD]'
    if channel == 'Tv2 Nyhets Kanalen [SD]' : return 'TV 2 Nyhetsskanalen [SD]'
    if channel == 'Tv2 Nyhets Kanalen [HD]' : return 'TV 2 Nyhetsskanalen [HD]'
    if channel == 'Astro SuperSport 1 [SD]' : return 'Astro SuperSport 1 HD'
    if channel == 'Astro SuperSport 2 [SD]' : return 'Astro SuperSport 2 HD'
    if channel == 'Astro SuperSport 3 [SD]' : return 'Astro SuperSport 3 HD'
    if channel == 'Astro SuperSport 4 [SD]' : return 'Astro SuperSport 4 HD'

    if channel == 'ASTRO SPORTS HD 1' : return 'Astro SuperSport 1 HD'
    if channel == 'ASTRO SPORTS HD 2' : return 'Astro SuperSport 2 HD'
    if channel == 'ASTRO SPORTS HD 3' : return 'Astro SuperSport 3 HD'
    if channel == 'ASTRO SPORTS HD 4' : return 'Astro SuperSport 4 HD'

    if channel == 'Celtic TV (Live Matchday Only)' : return 'Celtic TV'
    if channel == 'British Eurosport' : return 'Eurosport'
    if channel == 'British Eurosport 2' : return 'Eurosport 2'

    if channel == 'EuroSport 1 UK (SW) [SD]' : return 'EuroSport (SW) [SD]'
    if channel == 'EuroSport 1 UK (SW) [HD]' : return 'EuroSport (SW) [HD]'
    if channel == 'EuroSports 2 UK (SW) [SD]' : return 'EuroSport 2 (SW) [SD]'
    if channel == 'EuroSports 2 UK (SW) [HD]' : return 'EuroSport 2 (SW) [HD]'
    if channel == 'eir Sport 1 (SW) [SD]' : return 'Setanta Ireland (SW)'
    if channel == 'eir Sport 2 (SW) [SD]' : return 'Setanta Sports 1 (SW)'
    if channel == 'NBC Sports Network (SW) [SD]' : return 'NBC Sports HD (SW) [SD]'
    if channel == 'NBC Sports Network (SW) [HD]' : return 'NBC Sports HD (SW) [HD]'
    if channel == 'NBC Extra Time EPL 1 (SW)  [SD]' : return 'NBC Sports ET1 (SW) [SD]'
    if channel == 'NBC Extra Time EPL 1 (SW)  [HD]' : return 'NBC Sports ET1 (SW) [HD]'
    if channel == 'NBC Extra Time EPL 2 (SW)  [SD]' : return 'NBC Sports ET2 (SW) [SD]'
    if channel == 'NBC Extra Time EPL 2 (SW)  [HD]' : return 'NBC Sports ET2 (SW) [HD]'
    if channel == 'NBC Extra Time EPL 3 (SW)  [SD]' : return 'NBC Sports ET3 (SW) [SD]'
    if channel == 'NBC Extra Time EPL 3 (SW)  [HD]' : return 'NBC Sports ET3 (SW) [HD]'
    if channel == 'NBC Extra Time EPL 4 (SW)  [SD]' : return 'NBC Sports ET4 (SW) [SD]'
    if channel == 'NBC Extra Time EPL 4 (SW)  [HD]' : return 'NBC Sports ET4 (SW) [HD]'
    if channel == 'NBC Extra Time EPL 5 (SW)  [SD]' : return 'NBC Sports ET5 (SW) [SD]'
    if channel == 'NBC Extra Time EPL 5 (SW)  [HD]' : return 'NBC Sports ET5 (SW) [HD]'

    if channel == 'NBC Sport' : return 'NBC Sports'
    if channel == 'NBC Sports Network' : return 'NBC Sports HD'
    if channel == 'NBC EXTRA TIME HD' : return 'NBC Sports ET1'
    if channel == 'NBC EXTRA TIME 2 HD' : return 'NBC Sports ET2'
    if channel == 'NBC EXTRA TIME 3 HD' : return 'NBC Sports ET3'
    if channel == 'NBC EXTRA TIME 4 HD' : return 'NBC Sports ET4'
    if channel == 'NBC EXTRA TIME 5 HD' : return 'NBC Sports ET5'

    if channel == 'NBC Golf (SW) [SD]' : return 'Golf Channel (SW) [SD]'
    if channel == 'NBC Golf (SW) [HD]' : return 'Golf Channel (SW) [HD]'

    if channel == 'BEIN USA (SW) [SD]' : return 'Bein Sports (SW) [SD]'
    if channel == 'BEIN USA (SW) [HD]' : return 'Bein Sports (SW) [HD]'
    if channel == 'SN Ontario (SW) [SD]' : return 'Sportsnet Ontario (SW) [SD]'
    if channel == 'SN Ontario (SW) [HD]' : return 'Sportsnet Ontario (SW) [HD]'
    if channel == 'SN World (SW) [SD]' : return 'Sportsnet World (SW) [SD]'
    if channel == 'SN World (SW) [HD]' : return 'Sportsnet World (SW) [HD]'
    if channel == 'SN One (SW) [SD]' : return 'Sportsnet One (SW) [SD]'
    if channel == 'SN One (SW) [HD]' : return 'Sportsnet One (SW) [HD]'
    if channel == 'SN 360 (SW) [SD]' : return 'Sportsnet 360 (SW) [SD]'
    if channel == 'SN 360 (SW) [HD]' : return 'Sportsnet 360 (SW) [HD]'
    if channel == 'TSN 1 (SW)' : return 'TSN (SW) HD'
    if channel == 'TSN 2 (SW)' : return 'TSN 2 (SW) HD'
    if channel == 'TSN 3 (SW)' : return 'TSN 3 (SW) HD'
    if channel == 'TSN 4 (SW)' : return 'TSN 4 (SW) HD'
    if channel == 'TSN 5 (SW)' : return 'TSN 5 (SW) HD'

    if channel == 'SPORTS NET 360 HD' : return 'Sportsnet 360'
    if channel == 'SPORTS NET ONTARIO HD' : return 'Sportsnet Ontario'
    if channel == 'SPORTS NET WORLD HD' : return 'Sportsnet World'
    if channel == 'SPORTS NET EAST HD' : return 'SPORTSNET EAST HD'
    if channel == 'SPORTS NET PACIFIC HD' : return 'SPORTSNET PACIFIC HD'
    if channel == 'SPORTS NET WEST HD' : return 'SPORTSNET WEST HD'

    return channel
