# coding: utf-8

import resources.lib.logger as logger
import resources.lib.untangle

from resources.lib.utils import *

movie_folder = xbmc.translatePath(get_setting('movie_folder'))
show_folder = xbmc.translatePath(get_setting('show_folder'))
anime_folder = xbmc.translatePath(get_setting('anime_folder'))
download_folder = xbmc.translatePath(get_setting('download_folder'))

if os.path.isdir(download_folder):
    list_filename = os.listdir(download_folder)
    total = float(len(list_filename))
    pDialog = xbmcgui.DialogProgressBG()
    pDialog.create("Sorting Files", "%d files left" % total)
    cm = 0
    for filename in list_filename:
        info = untangle.Untangle(filename, use_meta_info=False)
        folder_destination = movie_folder
        if info.type_video == "SHOW":
            folder_destination = show_folder
        elif info.type_video == "ANIME":
            folder_destination = anime_folder
        full_filename = os.path.join(download_folder, filename)
        full_new_filename = os.path.join(folder_destination, filename)
        move_anything(full_filename, full_new_filename)
        logger.log.info("%s is moved to %s" % (full_filename, full_new_filename))
        cm += 1
        if xbmc.getCondVisibility('Player.Playing'):
            pDialog.close()
        if not pDialog.isFinished():
            pDialog.update(int(cm / total * 100.0), "Sorting Files", "%d files left" % (total - cm))

    pDialog.close()
    if not xbmc.getCondVisibility('Library.IsScanningVideo') or not xbmc.getCondVisibility('Player.Playing'):
        xbmc.executebuiltin('XBMC.UpdateLibrary(video)')  # update the library with the new information
    del pDialog
