import sys
import math
import xbmc,xbmcgui
from threading import Thread
from dudehere.routines import *
from dudehere.routines import plugin
from dudehere.routines.trakt import TraktAPI
from dudehere.routines.windows import BaseWindow, WINDOW_ACTIONS
from dudehere.routines.premiumize import PremiumizeAPI

PM = PremiumizeAPI()

class Manager(BaseWindow):
	abort_polling = False
	current_id = -1
	def __init__(self, *args, **kwargs):
		xbmcgui.WindowXML.__init__(self)
	
	def poll_queue(self):
		while True:
			if self.abort_polling: break
			results = PM.poll()
			if results:
				if self._count != len(results['transfers']):
					self.update(results)
				else:
					t_status = False
					for f in results['transfers']:
						index = results['transfers'].index(f)
						progress = float(f['progress'])
						if progress > 0 and f['status'] == 'waiting' or f['eta'] > -2 and f['status'] == 'waiting':
							status = 'active'
							status_icon = 'active.png'
						else:	
							status = f['status']
							status_icon = "%s.png" % f['status']
						try:
							filename =  u"%s" % f['name']
						except UnicodeDecodeError:
							filename =  u"%s" % f['name'].decode("utf-8")	
						self.getControl(80000).getListItem(index).setLabel(status_icon)
						self.getControl(80000).getListItem(index).setProperty("status", status)
						self.getControl(80000).getListItem(index).setProperty("file_name", filename)
						self.getControl(80000).getListItem(index).setProperty("size", self.format_size(f['size']))
						self.getControl(80000).getListItem(index).setProperty("speed", self.format_speed(f['speed_down'], status))
						self.getControl(80000).getListItem(index).setProperty("eta", self.format_eta(f['eta'], status))
						self.getControl(80000).getListItem(index).setProperty("percent", self.format_progress(f['progress'], status))
						progress = "progress/%s.png" % int(float(f['progress']) * 100)
						self.getControl(80000).getListItem(index).setProperty("progress_img", progress)
						self.getControl(80000).getListItem(index).setProperty("progress", str(f['progress']))
						self.getControl(80000).getListItem(index).setProperty("width", str(500))
						self.getControl(80000).getListItem(index).setProperty("hash", str(f['hash']))
				xbmc.sleep(2500)
			else:
				break
			
	def onInit(self):
		results = PM.poll()
		self.update(results)
		monitor = Thread(target=self.poll_queue)
		monitor.start()
	
	def show_context(self, index, status):
		global CONTEX_ACTION
		CONTEX_ACTION = None
		items = []
		icon_root = vfs.join(ROOT_PATH, 'resources/skins/%s/media' % SKIN_PATH)
		if status == 'active':
			menu = ["Abort"]
			height = 70
			posY = 260
		elif status == 'finished':
			menu = ["Remove", "Play From Here", "Transmogrify"]
			height = 150
			posY = 260
		elif status == 'waiting':
			menu = ["Cancel"]
			height = 70
			posY = 260		

		for item in menu:
			icon = item.replace(" ", "_").lower()
			icon = vfs.join(icon_root, icon + '.png')
			liz = xbmcgui.ListItem(item, iconImage=icon)
			items.append(liz)
		
		
		class Context(xbmcgui.WindowXMLDialog):
	
			def __init__(self, *args, **kwargs):
				xbmcgui.WindowXML.__init__(self)
				
			def onInit(self):
				self.getControl(85002).setHeight(height)
				self.getControl(85002).setPosition(440, posY)
				self.getControl(85001).addItems(items)
				pass
			
			def onAction(self, action):
				action = action.getId()
				if action in [WINDOW_ACTIONS.ACTION_PREVIOUS_MENU, WINDOW_ACTIONS.ACTION_NAV_BACK]:
					self.close()
	
			def onClick(self, controlID):
				global CONTEX_ACTION
				obj = self.getFocus()
				CONTEX_ACTION = obj.getSelectedItem().getLabel().lower()
				self.close()
	
			def onFocus(self, controlID):
				pass
			
		ctx = Context("context.xml", ROOT_PATH, SKIN_PATH)
		ctx.doModal()
		del ctx
		return CONTEX_ACTION
	
	def format_size(self, size):
		if size is None: return ''
		size = int(size) / (1024 * 1024)
		if size > 2000:
			size = size / 1024
			unit = 'GB'
		else :
			unit = 'MB'
		size = "%s %s" % (size, unit)
		return size
	
	def format_eta(self, eta, status):
		if eta is None or status != 'active': return ''
		m, s = divmod(eta, 60)
		h, m = divmod(m, 60)
		return "%d:%02d:%02d" % (h, m, s)
		
	def format_speed(self, speed, status):
		if speed is None or status!='active': return ''
		speed = "%s KiB/s" % (speed / 1000)
		return speed
	
	def format_progress(self, progress, status):
		if progress is None or status!='active': return ''
		percent = progress * 100
		return "%2d %s" % (percent, '%')
		
	def update(self, queue):
		items = []
		for f in queue['transfers']:
			progress = float(f['progress'])
			if progress > 0 and f['status'] == 'waiting':
				status_icon = 'active.png'
				status = 'active'
			else:
				status = f['status']
				status_icon = "%s.png" % f['status']
			try:
				filename =  u"%s" % f['name']
			except UnicodeDecodeError:
				filename =  u"%s" % f['name'].decode("utf-8")
			liz = xbmcgui.ListItem(status_icon, iconImage="")
			liz.setProperty("status", status)
			liz.setProperty("file_name", filename)
			liz.setProperty("size", self.format_size(f['size']))
			liz.setProperty("speed", self.format_speed(f['speed_down'], status))
			liz.setProperty("eta", self.format_eta(f['eta'], status))
			liz.setProperty("percent", self.format_progress(f['progress'], status))
			liz.setProperty("progress", str(f['progress']))
			liz.setProperty("hash", str(f['hash']))
			items.append(liz)

		self.getControl(80000).reset()
		self.getControl(80000).addItems(items)
		self._count = len(items)
		
	def onAction(self, action):
		action = action.getId()
		if action in [WINDOW_ACTIONS.ACTION_PREVIOUS_MENU, WINDOW_ACTIONS.ACTION_NAV_BACK]:
			self.close()
		
		if True:#try:
			if action in [WINDOW_ACTIONS.ACTION_SHOW_INFO, WINDOW_ACTIONS.ACTION_CONTEXT_MENU]:
				controlID = self.getFocus().getId()
				if controlID == 80000:
					index = self.getControl(controlID).getSelectedPosition()
					liz = self.getControl(controlID).getListItem(index)
					status = liz.getProperty("status")
					event = self.show_context(index, status)
					filename = liz.getProperty('file_name')
					hash = liz.getProperty('hash')
					if event == 'remove':
						ok = do_Confirm('remove_transfer.png')
						#ok = plugin.dialog_confirm('Remove from transfer list?', filename)
						if ok:
							PM.delete_transfer(hash)
					elif event == 'abort':
						ok = do_Confirm('abort_transfer.png')
						#ok = plugin.dialog_confirm('Abort active transfer?', filename)
						if ok:
							PM.delete_transfer(hash)
					elif event == 'cancel':
						ok = do_Confirm('cancel_transfer.png')
						#ok = plugin.dialog_confirm('Cancel waiting transfer?', filename)
						if ok:
							PM.delete_transfer(hash)
					elif event == 'play from here':
						results = PM.browse(hash)
						url = PM.get_stream(results)
						self.close()
						play_file(filename, url)
					if event == 'transmogrify':
						if validate_transmogrifier() is False:
							plugin.dialog_ok('Transmogrifier is not installed', 'Please download and setup Transmogrifer to continue')
							return
						
						choice = plugin.dialog_select('Select a type for Transmogrifier', ['TV Show', 'Movie', 'Torrent'])
						if choice is False: return
						media =['tvshow', 'movie', 'torrent'][choice]
						hash = liz.getProperty('hash')
						results = PM.browse(hash)
						url = PM.get_stream(results)
						video = {
							"type": media,
							"filename": filename,
							"url": url,
							"addon": ADDON_ID,
							"host": 'premiumize.me'
						}
						TM = TransmogrifierAPI()
						response = TM.enqueue([video])
						
					
		#except:
		#	pass
		
	def onClick(self, controlID):
		if controlID in [82005, 82000]: 
			self.close()
		elif controlID==82001:
			ok = do_Confirm('clear_transfer.png')
			if ok:
				response = PM.clear_finished()
				if response['status'] == 'success':
					plugin.notify('Success', 'Transfer list cleared')
				else:
					plugin.notify('Failed', response['status'] + '. Please check your log for details')
		
		elif controlID==82003:
			query = plugin.dialog_input('Torrent Search')
			if not query: return
			plugin.log(query)
			#from dudehere.routines.kat import KatAPI
			#kat = KatAPI()
			#link = kat.search(query, finished=False)
			#if link:
			#	response = PM.queue(link, False)
			#	if response['status'] == 'success':
			#		plugin.notify('Success', 'Added to transfer queue')
			#	else:
			#		plugin.notify('Failed', response['status'] + '. Please check your log for details')
				
			
		elif controlID==82004:

			path = plugin.dialog_file_browser('Select a Torrent File', '.torrent|.magnet|.link')
			if path:
				torrent = vfs.read_file(path, mode='b')
				if torrent.endswith('\n'):
					torrent = torrent[:-1]
				response = PM.upload(torrent)
				if response['status'] == 'success':
					plugin.notify('Success', 'Added to transfer queue')
				else:
					plugin.notify('Failed', response['status'] + '. Please check your log for details')
		
		elif controlID == 82006:
			view_files()
			self.close()

	def onFocus(self, controlID):
		pass