#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import re
import sys
import math
import xbmc,xbmcgui
from threading import Thread
from dudehere.routines import *
from dudehere.routines.window import Window
from dudehere.routines.constants import WINDOW_ACTIONS
from dudehere.routines.transmogrifier import TransmogrifierAPI
from dudehere.routines import plugin
from dudehere.routines.premiumize import PremiumizeAPI
from dudehere.routines.scrapers import ScraperPool
from resources.lib.windows import confirm

	
WINDOW_PREFIX = 'transmogrifier'
CONTEX_ACTION = None
STATUS = enum(PENDING=1, ACTIVE=2, COMPLETE=3, PAUSED=4, FAILED=-1, SAVING=5)
IDS = enum(STATUS=80010)
status_icons = {1: "pending.png", 2: "active.png", 3: "complete.png", -1: "failed.png", 5: "saving.png"}
SKIN_PATH = plugin.get_setting('skin') if plugin.get_setting('skin') else 'Captain Red Beard' 

CONTROLS= enum(
	DELETE=82007
)

def do_Confirm(message):
	class transferConfirm(confirm.ConfirmWindow):
		def onInit(self):
			self.getControl(95003).setImage(message)
			
	c = transferConfirm("confirm.xml", ROOT_PATH, SKIN_PATH)
	ok = c.open()
	del c
	return ok

def format_size(bytes):
	size = float(bytes) / (1024 * 1024)
	if size > 2000:
		size = size / 1024
		size = "%.2f" % size
		unit = 'GB'
	else :
		size = int(size)
		unit = 'MB'
	size = "%s %s" % (size, unit)
	return size

def validate_transmogrifier():
	installed = plugin.get_condition_visiblity('System.HasAddon(service.transmogrifier)') == 1
	if installed:
		return plugin.get_setting('enable_transmogrifier', addon_id='service.transmogrifier') == "true" 
	else:
		return False

def reset_db():
	c = plugin.dialog_confirm("Reset Database", "Are you sure?", "You will have to restart kodi afterwards.")
	if c:
		DB_FILE = plugin.get_setting('database_sqlite_file')
		plugin.set_setting("database_sqlite_init", "false")
		vfs.rm(DB_FILE, quiet=True)

def make_info(name):
	info = {"cover_url":""}
	sxe_patterns = [
		'(.*?)[._ -]s([0-9]+)[._ -]*e([0-9]+)',
		'(.*?)[._ -]([0-9]+)x([0-9]+)',
		'(.*?)[._ -]?season[._ -]*([0-9]+)[._ -]*-?[._ -]*episode[._ -]*([0-9]+)',
		'(.*?)[._ -]\[s([0-9]+)\][._ -]*\[e([0-9]+)\]',
		'(.*?)[._ -]s([0-9]+)[._ -]*ep([0-9]+)']
	
	show_title = ''
	season = ''
	episode = ''
	airdate = ''
	for pattern in sxe_patterns:
		match = re.search(pattern, name, re.I)
		if match:
			show_title, season, episode = match.groups()
			break
	else:
		airdate_pattern = '(.*?)[. _](\d{4})[. _](\d{2})[. _](\d{2})[. _]'
		match = re.search(airdate_pattern, name)
		if match:
			show_title, year, month, day = match.groups()
			airdate = '%s-%s-%s' % (year, month, day)
	
	if show_title:
		show_title = re.sub('[._ -]', ' ', show_title)
		show_title = re.sub('\s\s+', ' ', show_title)
		info['title'] = name
		info['tvshowtitle'] = show_title
		info['season'] = str(int(season))
		info['episode'] = str(int(episode))
		if airdate: info['aired'] = info['premiered'] = airdate
	else:
		pattern = '(.*?)[._ -](\d{4})[._ -](.*?)'
		match = re.search(pattern, name)
		if match:
			title, year, _extra = match.groups()
			title = re.sub('[._ -]', ' ', title)
			title = re.sub('\s\s+', ' ', title)
			info['title'] = title
			info['year'] = year
		
	return info

def play_file(name, url):
	info = make_info(name)
	listitem = xbmcgui.ListItem(label=name, path=url)
	listitem.setPath(url)
	listitem.setInfo('video', info)
	listitem.setProperty('isPlayable', 'true')
	player = xbmc.Player(xbmc.PLAYER_CORE_AUTO)
	player.play(url, listitem)

def view_queue():
	PM = PremiumizeAPI()
	class Manager(xbmcgui.WindowXMLDialog):
		abort_polling = False
		current_id = -1
		def __init__(self, *args, **kwargs):
			xbmcgui.WindowXML.__init__(self)
		
		def poll_queue(self):
			while True:
				if self.abort_polling: break
				results = PM.poll()
				if results:
					if self._count != len(results['transfers']):
						self.update(results)
					else:
						t_status = False
						for f in results['transfers']:
							index = results['transfers'].index(f)
							progress = float(f['progress'])
							if progress > 0 and f['status'] == 'waiting' or f['eta'] > -2 and f['status'] == 'waiting':
								status = 'active'
								status_icon = 'active.png'
							else:	
								status = f['status']
								status_icon = "%s.png" % f['status']
								
							try:
								filename =  u"%s" % f['name']
							except UnicodeDecodeError:
								filename =  u"%s" % f['name'].decode("utf-8")	
							self.getControl(80000).getListItem(index).setLabel(status_icon)
							self.getControl(80000).getListItem(index).setProperty("status", status)
							self.getControl(80000).getListItem(index).setProperty("file_name", filename)
							self.getControl(80000).getListItem(index).setProperty("size", self.format_size(f['size']))
							self.getControl(80000).getListItem(index).setProperty("speed", self.format_speed(f['speed_down'], status))
							self.getControl(80000).getListItem(index).setProperty("eta", self.format_eta(f['eta'], status))
							self.getControl(80000).getListItem(index).setProperty("percent", self.format_progress(f['progress'], status))
							percent = int(float(f['progress']) * 100)
							if percent == 100:
								progress = ''
							else:
								progress = "progress/%s.png" % percent
							self.getControl(80000).getListItem(index).setProperty("progress_img", progress)
							self.getControl(80000).getListItem(index).setProperty("progress", str(f['progress']))
							self.getControl(80000).getListItem(index).setProperty("width", str(500))
							self.getControl(80000).getListItem(index).setProperty("hash", str(f['hash']))
					xbmc.sleep(2500)
				else:
					break
				
		def onInit(self):
			results = PM.poll()
			self.update(results)
			monitor = Thread(target=self.poll_queue)
			monitor.start()
		
		def show_context(self, index, status):
			global CONTEX_ACTION
			CONTEX_ACTION = None
			items = []
			icon_root = vfs.join(ROOT_PATH, 'resources/skins/%s/media' % SKIN_PATH)
			if status == 'active':
				menu = ["Abort"]
				height = 70
				posY = 260
			elif status == 'finished':
				menu = ["Remove", "Play From Here", "Transmogrify"]
				height = 150
				posY = 260
			elif status == 'waiting':
				menu = ["Cancel"]
				height = 70
				posY = 260		

			for item in menu:
				icon = item.replace(" ", "_").lower()
				icon = vfs.join(icon_root, icon + '.png')
				liz = xbmcgui.ListItem(item, iconImage=icon)
				items.append(liz)
			
			
			class Context(xbmcgui.WindowXMLDialog):
		
				def __init__(self, *args, **kwargs):
					xbmcgui.WindowXML.__init__(self)
					
				def onInit(self):
					self.getControl(85002).setHeight(height)
					self.getControl(85002).setPosition(440, posY)
					self.getControl(85001).addItems(items)
					pass
				
				def onAction(self, action):
					action = action.getId()
					if action in [WINDOW_ACTIONS.ACTION_PREVIOUS_MENU, WINDOW_ACTIONS.ACTION_NAV_BACK]:
						self.close()
		
				def onClick(self, controlID):
					global CONTEX_ACTION
					obj = self.getFocus()
					CONTEX_ACTION = obj.getSelectedItem().getLabel().lower()
					self.close()
		
				def onFocus(self, controlID):
					pass
				
			ctx = Context("context.xml", ROOT_PATH, SKIN_PATH)
			ctx.doModal()
			del ctx
			return CONTEX_ACTION
		
		def format_size(self, size):
			if size is None: return ''
			size = int(size) / (1024 * 1024)
			if size > 2000:
				size = size / 1024
				unit = 'GB'
			else :
				unit = 'MB'
			size = "%s %s" % (size, unit)
			return size
		
		def format_eta(self, eta, status):
			if eta is None or status != 'active': return ''
			m, s = divmod(eta, 60)
			h, m = divmod(m, 60)
			return "%d:%02d:%02d" % (h, m, s)
			
		def format_speed(self, speed, status):
			if speed is None or status!='active': return ''
			speed = "%s KiB/s" % (speed / 1000)
			return speed
		
		def format_progress(self, progress, status):
			if progress is None or status!='active': return ''
			percent = progress * 100
			return "%2d %s" % (percent, '%')
			
		def update(self, queue):
			items = []
			for f in queue['transfers']:
				progress = float(f['progress'])
				if progress > 0 and f['status'] == 'waiting':
					status_icon = 'active.png'
					status = 'active'
				else:
					status = f['status']
					status_icon = "%s.png" % f['status']
				try:
					filename =  u"%s" % f['name']
				except UnicodeDecodeError:
					filename =  u"%s" % f['name'].decode("utf-8")
				liz = xbmcgui.ListItem(status_icon, iconImage="")
				liz.setProperty("status", status)
				liz.setProperty("file_name", filename)
				liz.setProperty("size", self.format_size(f['size']))
				liz.setProperty("speed", self.format_speed(f['speed_down'], status))
				liz.setProperty("eta", self.format_eta(f['eta'], status))
				liz.setProperty("percent", self.format_progress(f['progress'], status))
				liz.setProperty("progress", str(f['progress']))
				liz.setProperty("hash", str(f['hash']))
				items.append(liz)

			self.getControl(80000).reset()
			self.getControl(80000).addItems(items)
			self._count = len(items)
			
		def onAction(self, action):
			action = action.getId()
			if action in [WINDOW_ACTIONS.ACTION_PREVIOUS_MENU, WINDOW_ACTIONS.ACTION_NAV_BACK]:
				self.close()
			
			if True:#try:
				if action in [WINDOW_ACTIONS.ACTION_SHOW_INFO, WINDOW_ACTIONS.ACTION_CONTEXT_MENU]:
					controlID = self.getFocus().getId()
					if controlID == 80000:
						index = self.getControl(controlID).getSelectedPosition()
						liz = self.getControl(controlID).getListItem(index)
						status = liz.getProperty("status")
						event = self.show_context(index, status)
						filename = liz.getProperty('file_name')
						hash = liz.getProperty('hash')
						if event == 'remove':
							ok = do_Confirm('remove_transfer.png')
							#ok = plugin.dialog_confirm('Remove from transfer list?', filename)
							if ok:
								PM.delete_transfer(hash)
						elif event == 'abort':
							ok = do_Confirm('abort_transfer.png')
							#ok = plugin.dialog_confirm('Abort active transfer?', filename)
							if ok:
								PM.delete_transfer(hash)
						elif event == 'cancel':
							ok = do_Confirm('cancel_transfer.png')
							#ok = plugin.dialog_confirm('Cancel waiting transfer?', filename)
							if ok:
								PM.delete_transfer(hash)
						elif event == 'play from here':
							results = PM.browse(hash)
							url = PM.get_stream(results)
							self.close()
							play_file(filename, url)
						if event == 'transmogrify':
							if validate_transmogrifier() is False:
								plugin.dialog_ok('Transmogrifier is not installed', 'Please download and setup Transmogrifer to continue')
								return
							
							choice = plugin.dialog_select('Select a type for Transmogrifier', ['TV Show', 'Movie', 'Torrent'])
							if choice is False: return
							media =['tvshow', 'movie', 'torrent'][choice]
							hash = liz.getProperty('hash')
							results = PM.browse(hash)
							url = PM.get_stream(results)
							video = {
								"type": media,
								"filename": filename,
								"url": url,
								"addon": ADDON_ID,
								"host": 'premiumize.me'
							}
							TM = TransmogrifierAPI()
							response = TM.enqueue([video])
							
						
			#except:
			#	pass
			
		def onClick(self, controlID):
			if controlID in [82005, 82000]: 
				self.close()
			elif controlID==82001:
				ok = do_Confirm('clear_transfer.png')
				if ok:
					response = PM.clear_finished()
					if response['status'] == 'success':
						plugin.notify('Success', 'Transfer list cleared')
					else:
						plugin.notify('Failed', response['status'] + '. Please check your log for details')
			
			elif controlID==82003:
				#s = SearchWindow("search.xml", ROOT_PATH, SKIN_PATH)
				#s.doModal()
				#del s
				MOVIE_SCRAPERS = ['tpb', 'yts', 'torrentapi', 'torrentdownloads']
				TV_SCRAPERS = ['tpb', 'torrentapi', 'torrentdownloads']
				
				media = plugin.dialog_confirm('Type?', m1='Select a media type', yes='TV Show', no='Movie')
				query = plugin.dialog_input('Torrent Search')
				if not query: return
				if media == 0:
					Scraper = ScraperPool(load=MOVIE_SCRAPERS, cache_results=plugin.get_setting('enable_result_caching')=="true")
					sources, raw_urls, results = Scraper.search_movies(query, False, return_sources=True)
				else:
					Scraper = ScraperPool(load=TV_SCRAPERS, cache_results=plugin.get_setting('enable_result_caching')=="true")
					sources, raw_urls, results = Scraper.search_tvshows(query, '', '', '', False, return_sources=True)
				choice = plugin.dialog_select('Select a torrent', sources)
				
			elif controlID==82004:

				path = plugin.dialog_file_browser('Select a Torrent File', '.torrent|.magnet|.link')
				if path:
					torrent = vfs.read_file(path, mode='b')
					if torrent.endswith('\n'):
						torrent = torrent[:-1]
					response = PM.upload(torrent)
					if response['status'] == 'success':
						plugin.notify('Success', 'Added to transfer queue')
					else:
						plugin.notify('Failed', response['status'] + '. Please check your log for details')
			
			elif controlID == 82006:
				view_files()
				self.close()
	
		def onFocus(self, controlID):
			pass

	m = Manager("manager.xml", ROOT_PATH, SKIN_PATH)
	m.doModal()
	m.abort_polling = True
	del m

def view_files():
	PM = PremiumizeAPI()
	class Manager(xbmcgui.WindowXMLDialog):
		abort_polling = False
		current_id = -1
		def __init__(self, *args, **kwargs):
			xbmcgui.WindowXML.__init__(self)
		
				
		def onInit(self):
			files = PM.file_list()
			self.update(files)
		
		def show_context(self, index, id, li=None):
			global CONTEX_ACTION
			CONTEX_ACTION = None
			items = []
			icon_root = vfs.join(ROOT_PATH, 'resources/skins/%s/media' % SKIN_PATH)
			ext = li.getProperty('ext')
			is_folder = li.getProperty("folder") == "true"
			plugin.log(ext)
			plugin.log(is_folder)
			if id == '..':
				return

			if is_folder:
				menu = ["Delete", "Play From Here", "Transmogrify"]
				height = 150
			elif is_folder is False and li.getProperty('ext') in ["avi", "mov", "mkv", "mp4", "flv"]:
				menu = ["Play From Here", "Transmogrify"]
				height = 105
			else:
				return

			posY = 260

			for item in menu:
				icon = item.replace(" ", "_").lower()
				icon = vfs.join(icon_root, icon + '.png')
				liz = xbmcgui.ListItem(item, iconImage=icon)
				items.append(liz)
			
			
			class Context(xbmcgui.WindowXMLDialog):
		
				def __init__(self, *args, **kwargs):
					xbmcgui.WindowXML.__init__(self)
					
				def onInit(self):
					self.getControl(85002).setHeight(height)
					self.getControl(85002).setPosition(440, posY)
					self.getControl(85001).addItems(items)
					pass
				
				def onAction(self, action):
					action = action.getId()
					if action in [WINDOW_ACTIONS.ACTION_PREVIOUS_MENU, WINDOW_ACTIONS.ACTION_NAV_BACK]:
						self.close()
		
				def onClick(self, controlID):
					global CONTEX_ACTION
					obj = self.getFocus()
					CONTEX_ACTION = obj.getSelectedItem().getLabel().lower()
					self.close()
		
				def onFocus(self, controlID):
					pass
				
			ctx = Context("context.xml", ROOT_PATH, SKIN_PATH)
			ctx.doModal()
			del ctx
			return CONTEX_ACTION
		
		def format_size(self, size):
			if size is None: return ''
			size = int(size) / (1024 * 1024)
			if size > 2000:
				size = size / 1024
				unit = 'GB'
			else :
				unit = 'MB'
			size = "%s %s" % (size, unit)
			return size
			
		def update(self, files):
			items = []
			if 'content' in files:
				for f in files['content']:
					try:
						filename =  u"%s" % f['name']
					except UnicodeDecodeError:
						filename =  u"%s" % f['name'].decode("utf-8")
					status_icon = 'finished.png'
					liz = xbmcgui.ListItem(status_icon, iconImage="")
					liz.setProperty("file_name", filename)
					liz.setProperty("size", self.format_size(f['size']))
					liz.setProperty("hash", str(f['hash']))
					liz.setProperty("file_id", str(f['id']))
					liz.setProperty("folder", "true")
					items.append(liz)
			else:
				types = ['mkv', 'mp4', 'txt', 'avi', 'mov']
				liz = xbmcgui.ListItem('', iconImage="")
				liz.setProperty("file_name", '..')
				liz.setProperty("hash", '..')
				liz.setProperty("file_id", '..')
				items.append(liz)	
				for f in files:
					if 'ext' in f:
						try:
							filename =  u"%s" % f['name']
						except UnicodeDecodeError:
							filename =  u"%s" % f['name'].decode("utf-8")	
						if f['ext'] in types:
							status_icon = "filetypes/%s.png" % f['ext']
						else:
							status_icon = "filetypes/file.png"
						liz = xbmcgui.ListItem(status_icon, iconImage="")
						liz.setProperty("file_name", filename)
						liz.setProperty("ext", str(f['ext']))
						liz.setProperty("size", self.format_size(f['size']))
						liz.setProperty("url", str(f['url']))
						liz.setProperty("folder", "false")
						items.append(liz)
					elif 'children' in f:
						for c in f['children'].keys():
							try:
								filename =  u"%s" % c
							except UnicodeDecodeError:
								filename =  u"%s" % c.decode("utf-8")
							c = f['children'][c]	
							if c['ext'] in types:
								status_icon = "filetypes/%s.png" % c['ext']
							else:
								status_icon = "filetypes/file.png"
							
							liz = xbmcgui.ListItem(status_icon, iconImage="")
							liz.setProperty("file_name", filename)
							liz.setProperty("ext", str(c['ext']))
							liz.setProperty("size", self.format_size(c['size']))
							liz.setProperty("url", str(c['url']))
							liz.setProperty("folder", "false")
							items.append(liz)


			self.getControl(80000).reset()
			self.getControl(80000).addItems(items)
			self._count = len(items)
			#if get_property('force_refresh'): clear_property('force_refresh')
			
		def onAction(self, action):
			action = action.getId()
			if action in [WINDOW_ACTIONS.ACTION_PREVIOUS_MENU, WINDOW_ACTIONS.ACTION_NAV_BACK]:
				self.close()
			
			try:
				if action in [WINDOW_ACTIONS.ACTION_SHOW_INFO, WINDOW_ACTIONS.ACTION_CONTEXT_MENU]:
					controlID = self.getFocus().getId()
					if controlID == 80000:
						index = self.getControl(controlID).getSelectedPosition()
						liz = self.getControl(controlID).getListItem(index)
						id = liz.getProperty("file_id")
						hash = liz.getProperty('hash')
						filename = liz.getProperty("file_name")
						event = self.show_context(index, id, liz)
						if event == 'delete':
							ok = do_Confirm('delete_file.png')
							#ok = plugin.dialog_confirm('Delete File?', filename)
							if ok:
								response = PM.clear(liz.getProperty("hash"))
								results = PM.file_list()
								self.update(results)
						elif event == 'play from here':
							url = liz.getProperty('url')
							if url == '':
								results = PM.browse(hash)
								url = PM.get_stream(results)
							self.close()
							play_file(filename, url)

						if event == 'transmogrify':
							if validate_transmogrifier() is False:
								plugin.dialog_ok('Transmogrifier is not installed', 'Please download and setup Transmogrifer to continue')
								return
							
							choice = plugin.dialog_select('Select a type for Transmogrifier', ['TV Show', 'Movie', 'File'])
							if choice is False: return
							media =['tvshow', 'movie', 'torrent'][choice]
							url = liz.getProperty('url')
							if url == '':
								hash = liz.getProperty('hash')
								results = PM.browse(hash)
								url = PM.get_stream(results)
							video = {
								"type": media,
								"filename": filename,
								"url": url,
								"addon": ADDON_ID,
								"host": 'premiumize.me'
							}
							TM = TransmogrifierAPI()
							response = TM.enqueue([video])
						
			except:
				pass
			
		def onClick(self, controlID):
			if controlID in [82005, 82000]: 
				self.close()
			elif controlID == 80000:
				index = self.getControl(controlID).getSelectedPosition()
				liz = self.getControl(controlID).getListItem(index)
				hash = liz.getProperty("hash")
				if hash == '..':
					results = PM.file_list()
				elif liz.getProperty("folder") == "true":
					results = PM.list_file(hash)
				else:
					return
				self.update(results)
				
			elif controlID==82007:

				ok = do_Confirm('delete_all_files.png')
				if ok:
					pass
					'''response = PM.clear_finished()
					if response['status'] == 'success':
						plugin.notify('Success', 'Transfer list cleared')
					else:
						plugin.notify('Failed', response['status'] + '. Please check your log for details')'''
			
			elif controlID == 82006:
				view_queue()
				self.close()
	
		def onFocus(self, controlID):
			pass

	m = Manager("files.xml", ROOT_PATH, SKIN_PATH)
	m.doModal()
	m.abort_polling = True
	del m

def first_run():
	plugin.set_setting('setup_run', 'true')
	plugin.set_setting('version', VERSION)
plugin.first_run = first_run

plugin.register('main', view_queue)
plugin.register('files', view_files)
plugin.register('reset_db', reset_db)
if __name__ == '__main__':
	plugin.run()
