<?php

/**
 * Debug logging. Echos html to the page
 * Complies with PSR-3
 */
class imdb_logger {

  protected $enabled;
  private $context;

  public function __construct($enabled = true) {
    $this->enabled = $enabled;
  }

  /**
   * System is unusable.
   *
   * @param string $message
   * @param array $context
   * @return null
   */
  public function emergency($message, array $context = array()) {
    $this->log('emergency', $message, $context);
  }

  /**
   * Action must be taken immediately.
   *
   * Example: Entire website down, database unavailable, etc. This should
   * trigger the SMS alerts and wake you up.
   *
   * @param string $message
   * @param array $context
   * @return null
   */
  public function alert($message, array $context = array()) {
    $this->log('alert', $message, $context);
  }

  /**
   * Critical conditions.
   *
   * Example: Application component unavailable, unexpected exception.
   *
   * @param string $message
   * @param array $context
   */
  public function critical($message, array $context = array()) {
    $this->log('critical', $message, $context);
  }

  /**
   * Runtime errors that do not require immediate action but should typically
   * be logged and monitored.
   *
   * @param string $message
   * @param array $context
   */
  public function error($message, array $context = array()) {
    $this->log('error', $message, $context);
  }

  /**
   * Exceptional occurrences that are not errors.
   *
   * Example: Use of deprecated APIs, poor use of an API, undesirable things
   * that are not necessarily wrong.
   *
   * @param string $message
   * @param array $context
   */
  public function warning($message, array $context = array()) {
    $this->log('debug', $message, $context);
  }

  /**
   * Normal but significant events.
   *
   * @param string $message
   * @param array $context
   */
  public function notice($message, array $context = array()) {
    $this->log('debug', $message, $context);
  }

  /**
   * Interesting events.
   *
   * Example: User logs in, SQL logs.
   *
   * @param string $message
   * @param array $context
   * @return null
   */
  public function info($message, array $context = array()) {
    $this->log('debug', $message, $context);
  }

  /**
   * Detailed debug information.
   *
   * @param string $message
   * @param array $context
   */
  public function debug($message, array $context = array()) {
    $this->log('debug', $message, $context);
  }

  /**
   * Logs with an arbitrary level.
   *
   * @param mixed $level
   * @param string $message
   * @param array $context
   */
  public function log($level, $message, array $context = array()) {
    if ($this->enabled) {
      $replace = array();
      foreach ($context as $key => $val) {
          $replace['{' . $key . '}'] = "<pre>" . print_r($val, true) . "</pre>";
      }

      $message = strtr($message, $replace);

      switch ($level) {
        case 'emergecy':
        case 'alert':
        case 'critical':
        case 'error':
        case 'warning':
          $colour = '#ff0000';
          break;
        default:
          $colour = '';
          break;
      }
      echo "<b><font color='$colour'>[$level] $message</font></b><br>\n";
    }
  }

}
