# -*- coding: utf-8 -*-

'''
	Exodus Add-on
	Copyright (C) 2016 Exodus

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
from requests import get

from resources.lib.modules import trakt
from resources.lib.modules import cleangenre
from resources.lib.modules import control
from resources.lib.modules import client
from resources.lib.modules import cache
from resources.lib.modules import metacache
from resources.lib.modules import playcount
from resources.lib.modules import workers
from resources.lib.modules import views

import os,sys,re,json,urllib,urlparse,base64,datetime

params = dict(urlparse.parse_qsl(sys.argv[2].replace('?','')))

action = params.get('action')

control.moderator()


class movies:
	def __init__(self):
		self.list = []
		
		self.imdb_link = 'http://www.imdb.com'
		self.trakt_link = 'http://api-v2launch.trakt.tv'
		self.datetime = (datetime.datetime.utcnow() - datetime.timedelta(hours = 5))
		self.systime = (self.datetime).strftime('%Y%m%d%H%M%S%f')

		self.trakt_user = control.setting('trakt.user').strip()

		self.imdb_user = control.setting('imdb.user').replace('ur', '')
		self.lang = control.apiLanguage()['trakt']

		self.search_link = control.apollo_link+'?action=search&type=movies&search='
		self.trakt_info_link = 'http://api-v2launch.trakt.tv/movies/%s?extended=images'
		self.trakt_lang_link = 'http://api-v2launch.trakt.tv/movies/%s/translations/%s'
		self.imdb_info_link = 'http://www.omdbapi.com/?i=%s&plot=full&r=json'

		self.persons_link = 'http://www.imdb.com/search/name?count=100&name='
		self.personlist_link = 'http://www.imdb.com/search/name?count=100&gender=male,female'
		self.popular_link = control.apollo_static_link+'movietv.meta/movie/movie.popular.json'
		self.views_link = control.apollo_static_link+'movietv.meta/movie/movie.views.json'
		self.all_link = control.apollo_static_link+'movietv.meta/movie/movie.all.json'
		self.featured_link = control.apollo_static_link+'movietv.meta/movie/movie.featured.json'
		self.person_link = 'http://www.imdb.com/search/title?title_type=feature,tv_movie&production_status=released&role=%s&sort=year,desc&count=40&start=1'
		self.genre_link = control.apollo_static_link+'movietv.meta/movie/movie.genre.%s.json'
		self.certification_link = control.apollo_static_link+'movietv.meta/movie/movie.certification.%s.json'
		self.year_link = control.apollo_static_link+'movietv.meta/movie/movie.year.%s.json'
		self.boxoffice_link = control.apollo_static_link+'movietv.meta/movie/movie.box.json'
		self.oscars_link = control.apollo_static_link+'movietv.meta/movie/movie.oscars.json'
		self.theaters_link = control.apollo_static_link+'movietv.meta/movie/movie.theaters.json'
		self.trending_link = control.apollo_static_link+'movietv.meta/movie/movie.trending.json'

		self.traktlists_link = 'http://api-v2launch.trakt.tv/users/me/lists'
		self.traktlikedlists_link = 'http://api-v2launch.trakt.tv/users/likes/lists?limit=1000000'
		self.traktlist_link = 'http://api-v2launch.trakt.tv/users/%s/lists/%s/items'
		self.traktcollection_link = 'http://api-v2launch.trakt.tv/users/me/collection/movies'
		self.traktwatchlist_link = 'http://api-v2launch.trakt.tv/users/me/watchlist/movies'
		self.traktfeatured_link = 'http://api-v2launch.trakt.tv/recommendations/movies?limit=40'
		self.trakthistory_link = 'http://api-v2launch.trakt.tv/users/me/history/movies?limit=40&page=1'
		self.imdblists_link = 'http://www.imdb.com/user/ur%s/lists?tab=all&sort=modified:desc&filter=titles' % self.imdb_user
		self.imdblist_link = 'http://www.imdb.com/list/%s/?view=detail&sort=title:asc&title_type=feature,short,tv_movie,tv_special,video,documentary,game&start=1'
		self.imdblist2_link = 'http://www.imdb.com/list/%s/?view=detail&sort=created:desc&title_type=feature,short,tv_movie,tv_special,video,documentary,game&start=1'
		self.imdbwatchlist_link = 'http://www.imdb.com/user/ur%s/watchlist?sort=alpha,asc' % self.imdb_user
		self.imdbwatchlist2_link = 'http://www.imdb.com/user/ur%s/watchlist?sort=date_added,desc' % self.imdb_user


	def get(self, url, idx=True):
		try:
			try: url = getattr(self, url + '_link')
			except: pass

			try: u = urlparse.urlparse(url).netloc.lower()
			except: pass


			if u in self.trakt_link and '/users/' in url:
				try:
					if url == self.trakthistory_link: raise Exception()
					if not '/users/me/' in url: raise Exception()
					if trakt.getActivity() > cache.timeout(self.trakt_list, url, self.trakt_user): raise Exception()
					self.list = cache.get(self.trakt_list, 720, url, self.trakt_user)
				except:
					self.list = cache.get(self.trakt_list, 0, url, self.trakt_user)

				if '/users/me/' in url and not '/watchlist/' in url:
					self.list = sorted(self.list, key=lambda k: re.sub('(^the |^a )', '', k['title'].lower()))

				if idx == True: self.worker()

			elif u in self.trakt_link and self.search_link in url:
				self.list = cache.get(self.trakt_list, 0, url, self.trakt_user)

			elif u in self.trakt_link:
				self.list = cache.get(self.trakt_list, 24, url, self.trakt_user)
				if idx == True: self.worker()


			elif u in self.imdb_link and ('/user/' in url or '/list/' in url):
				self.list = cache.get(self.imdb_list, 0, url)
				if idx == True: self.worker()

			elif u in self.imdb_link:
				self.list = cache.get(self.imdb_list, 24, url)
				if idx == True: self.worker()

			elif u in control.apollo_link or u in control.apollo_static_link:
				self.list = cache.get(self.apollo_list, 24, url)
				if idx == True: self.worker()

			if idx == True: self.movieDirectory(self.list)
			return self.list
		except:
			pass


	def widget(self):
		setting = control.setting('movie.widget')

		if setting == '2':
			self.get(self.trending_link)
		elif setting == '3':
			self.get(self.popular_link)
		elif setting == '4':
			self.get(self.theaters_link)
		else:
			self.get(self.featured_link)


	def search(self):
		try:
			control.idle()

			t = control.lang(32010).encode('utf-8')
			k = control.keyboard('', t) ; k.doModal()
			q = k.getText() if k.isConfirmed() else None

			if (q == None or q == ''): return

			url = self.search_link + urllib.quote_plus(q)
			url = '%s?action=movies&url=%s' % (sys.argv[0], urllib.quote_plus(url))
			control.execute('Container.Update(%s)' % url)
		except:
			return


	def person(self):
		try:
			control.idle()

			t = control.lang(32010).encode('utf-8')
			k = control.keyboard('', t) ; k.doModal()
			q = k.getText() if k.isConfirmed() else None

			if (q == None or q == ''): return

			url = self.persons_link + urllib.quote_plus(q)
			url = '%s?action=moviePersons&url=%s' % (sys.argv[0], urllib.quote_plus(url))
			control.execute('Container.Update(%s)' % url)
		except:
			return


	def genres(self):
		genres = [
		('Action', 'action'),
		('Adventure', 'adventure'),
		('Animation', 'animation'),
		('Biography', 'biography'),
		('Comedy', 'comedy'),
		('Crime', 'crime'),
		('Drama', 'drama'),
		('Family', 'family'),
		('Fantasy', 'fantasy'),
		('History', 'history'),
		('Horror', 'horror'),
		('Music ', 'music'),
		('Musical', 'musical'),
		('Mystery', 'mystery'),
		('Romance', 'romance'),
		('Science Fiction', 'sci_fi'),
		('Sport', 'sport'),
		('Thriller', 'thriller'),
		('War', 'war'),
		('Western', 'western')
		]

		for i in genres: self.list.append({'name': cleangenre.lang(i[0], self.lang), 'url': self.genre_link % i[1], 'image': 'genres.png', 'action': 'movies'})
		self.addDirectory(self.list)
		return self.list


	def languages(self):
		languages = [
		('Arabic', 'ar'),
		('Bulgarian', 'bg'),
		('Chinese', 'zh'),
		('Croatian', 'hr'),
		('Dutch', 'nl'),
		('English', 'en'),
		('Finnish', 'fi'),
		('French', 'fr'),
		('German', 'de'),
		('Greek', 'el'),
		('Hebrew', 'he'),
		('Hindi ', 'hi'),
		('Hungarian', 'hu'),
		('Icelandic', 'is'),
		('Italian', 'it'),
		('Japanese', 'ja'),
		('Korean', 'ko'),
		('Norwegian', 'no'),
		('Persian', 'fa'),
		('Polish', 'pl'),
		('Portuguese', 'pt'),
		('Punjabi', 'pa'),
		('Romanian', 'ro'),
		('Russian', 'ru'),
		('Spanish', 'es'),
		('Swedish', 'sv'),
		('Turkish', 'tr'),
		('Ukrainian', 'uk')
		]

		for i in languages: self.list.append({'name': str(i[0]), 'url': self.language_link % i[1], 'image': 'languages.png', 'action': 'movies'})
		self.addDirectory(self.list)
		return self.list


	def certifications(self):
		certificates = ['G', 'PG', 'PG-13', 'R', 'NC-17']

		for i in certificates: self.list.append({'name': str(i), 'url': self.certification_link % str(i).replace('-', '_').lower(), 'image': 'certificates.png', 'action': 'movies'})
		self.addDirectory(self.list)
		return self.list


	def years(self):
		year = (self.datetime.strftime('%Y'))

		for i in range(int(year)-0, int(year)-50, -1): self.list.append({'name': str(i), 'url': self.year_link % (str(i)), 'image': 'years.png', 'action': 'movies'})
		self.addDirectory(self.list)
		return self.list


	def persons(self, url):
		if url == None:
			self.list = cache.get(self.imdb_person_list, 24, self.personlist_link)
		else:
			self.list = cache.get(self.imdb_person_list, 0, url)

		for i in range(0, len(self.list)): self.list[i].update({'action': 'movies'})
		self.addDirectory(self.list)
		return self.list


	def userlists(self):
		try:
			userlists = []
			if trakt.getTraktCredentialsInfo() == False: raise Exception()
			activity = trakt.getActivity()
		except:
			pass

		try:
			if trakt.getTraktCredentialsInfo() == False: raise Exception()
			try:
				if activity > cache.timeout(self.trakt_user_list, self.traktlists_link, self.trakt_user): raise Exception()
				userlists += cache.get(self.trakt_user_list, 720, self.traktlists_link, self.trakt_user)
			except:
				userlists += cache.get(self.trakt_user_list, 0, self.traktlists_link, self.trakt_user)
		except:
			pass
		try:
			self.list = []
			if self.imdb_user == '': raise Exception()
			userlists += cache.get(self.imdb_user_list, 0, self.imdblists_link)
		except:
			pass
		try:
			self.list = []
			if trakt.getTraktCredentialsInfo() == False: raise Exception()
			try:
				if activity > cache.timeout(self.trakt_user_list, self.traktlikedlists_link, self.trakt_user): raise Exception()
				userlists += cache.get(self.trakt_user_list, 720, self.traktlikedlists_link, self.trakt_user)
			except:
				userlists += cache.get(self.trakt_user_list, 0, self.traktlikedlists_link, self.trakt_user)
		except:
			pass

		self.list = userlists
		for i in range(0, len(self.list)): self.list[i].update({'image': 'userlists.png', 'action': 'movies'})
		self.addDirectory(self.list, queue=True)
		return self.list


	def trakt_list(self, url, user):
		try:
			q = dict(urlparse.parse_qsl(urlparse.urlsplit(url).query))
			q.update({'extended': 'full,images'})
			q = (urllib.urlencode(q)).replace('%2C', ',')
			u = url.replace('?' + urlparse.urlparse(url).query, '') + '?' + q

			result = trakt.getTrakt(u)
			result = json.loads(result)

			items = []
			for i in result:
				try: items.append(i['movie'])
				except: pass
			if len(items) == 0:
				items = result
		except:
			return

		try:
			q = dict(urlparse.parse_qsl(urlparse.urlsplit(url).query))
			p = str(int(q['page']) + 1)
			if p == '5': raise Exception()
			q.update({'page': p})
			q = (urllib.urlencode(q)).replace('%2C', ',')
			next = url.replace('?' + urlparse.urlparse(url).query, '') + '?' + q
			next = next.encode('utf-8')
		except:
			next = ''

		for item in items:
			try:
				title = item['title']
				title = client.replaceHTMLCodes(title)
				title = title.encode('utf-8')

				year = item['year']
				year = re.sub('[^0-9]', '', str(year))
				year = year.encode('utf-8')

				if int(year) > int((self.datetime).strftime('%Y')): raise Exception()

				imdb = item['ids']['imdb']
				if imdb == None or imdb == '': raise Exception()
				imdb = 'tt' + re.sub('[^0-9]', '', str(imdb))
				imdb = imdb.encode('utf-8')

				poster = '0'
				try: poster = item['images']['poster']['medium']
				except: pass
				if poster == None or not '/posters/' in poster: poster = '0'
				poster = poster.rsplit('?', 1)[0]
				poster = poster.encode('utf-8')

				banner = poster
				try: banner = item['images']['banner']['full']
				except: pass
				if banner == None or not '/banners/' in banner: banner = '0'
				banner = banner.rsplit('?', 1)[0]
				banner = banner.encode('utf-8')

				fanart = '0'
				try: fanart = item['images']['fanart']['full']
				except: pass
				if fanart == None or not '/fanarts/' in fanart: fanart = '0'
				fanart = fanart.rsplit('?', 1)[0]
				fanart = fanart.encode('utf-8')

				try: premiered = item['released']
				except: premiered = '0'
				try: premiered = re.compile('(\d{4}-\d{2}-\d{2})').findall(premiered)[0]
				except: premiered = '0'
				premiered = premiered.encode('utf-8')
  
				try: genre = item['genres']
				except: genre = '0'
				genre = [i.title() for i in genre]
				if genre == []: genre = '0'
				genre = ' / '.join(genre)
				genre = genre.encode('utf-8')

				try: duration = str(item['runtime'])
				except: duration = '0'
				if duration == None: duration = '0'
				duration = duration.encode('utf-8')

				try: rating = str(item['rating'])
				except: rating = '0'
				if rating == None or rating == '0.0': rating = '0'
				rating = rating.encode('utf-8')

				try: votes = str(item['votes'])
				except: votes = '0'
				try: votes = str(format(int(votes),',d'))
				except: pass
				if votes == None: votes = '0'
				votes = votes.encode('utf-8')

				try: mpaa = item['certification']
				except: mpaa = '0'
				if mpaa == None: mpaa = '0'
				mpaa = mpaa.encode('utf-8')

				try: plot = item['overview']
				except: plot = '0'
				if plot == None: plot = '0'
				plot = client.replaceHTMLCodes(plot)
				plot = plot.encode('utf-8')

				self.list.append({'title': title, 'originaltitle': title, 'year': year, 'premiered': premiered, 'studio': '0', 'genre': genre, 'duration': duration, 'rating': rating, 'votes': votes, 'mpaa': mpaa, 'director': '0', 'writer': '0', 'cast': '0', 'plot': plot, 'code': imdb, 'imdb': imdb, 'tmdb': '0', 'tvdb': '0', 'poster': poster, 'banner': banner, 'fanart': fanart, 'next': next})
			except:
				pass

		return self.list


	def trakt_user_list(self, url, user):
		try:
			result = trakt.getTrakt(url)
			items = json.loads(result)
		except:
			pass

		for item in items:
			try:
				try: name = item['list']['name']
				except: name = item['name']
				name = client.replaceHTMLCodes(name)
				name = name.encode('utf-8')

				try: url = (trakt.slug(item['list']['user']['username']), item['list']['ids']['slug'])
				except: url = ('me', item['ids']['slug'])
				url = self.traktlist_link % url
				url = url.encode('utf-8')

				self.list.append({'name': name, 'url': url, 'context': url})
			except:
				pass

		self.list = sorted(self.list, key=lambda k: re.sub('(^the |^a )', '', k['name'].lower()))
		return self.list


	def imdb_list(self, url):
		try:
			for i in re.findall('date\[(\d+)\]', url):
				url = url.replace('date[%s]' % i, (self.datetime - datetime.timedelta(days = int(i))).strftime('%Y-%m-%d'))

			def imdb_watchlist_id(url):
				return client.parseDOM(client.request(url).decode('iso-8859-1').encode('utf-8'), 'meta', ret='content', attrs = {'property': 'pageId'})[0]

			if url == self.imdbwatchlist_link:
				url = cache.get(imdb_watchlist_id, 8640, url)
				url = self.imdblist_link % url

			elif url == self.imdbwatchlist2_link:
				url = cache.get(imdb_watchlist_id, 8640, url)
				url = self.imdblist2_link % url

			result = client.request(url)

			result = result.replace('\n','')
			result = result.decode('iso-8859-1').encode('utf-8')

			items = client.parseDOM(result, 'div', attrs = {'class': 'lister-item mode-advanced'})
			items += client.parseDOM(result, 'div', attrs = {'class': 'list_item.+?'})
		except:
			return

		try:
			next = client.parseDOM(result, 'a', ret='href', attrs = {'class': 'lister-page-next.+?'})

			if len(next) == 0:
				next = client.parseDOM(result, 'div', attrs = {'class': 'pagination'})[0]
				next = zip(client.parseDOM(next, 'a', ret='href'), client.parseDOM(next, 'a'))
				next = [i[0] for i in next if 'Next' in i[1]]

			next = url.replace(urlparse.urlparse(url).query, urlparse.urlparse(next[0]).query)
			next = client.replaceHTMLCodes(next)
			next = next.encode('utf-8')
		except:
			next = ''

		for item in items:
			try:
				title = client.parseDOM(item, 'a')[1]
				title = client.replaceHTMLCodes(title)
				title = title.encode('utf-8')

				year = client.parseDOM(item, 'span', attrs = {'class': 'lister-item-year.+?'})
				year += client.parseDOM(item, 'span', attrs = {'class': 'year_type'})
				year = re.findall('(\d{4})', year[0])[0]
				year = year.encode('utf-8')

				if int(year) > int((self.datetime).strftime('%Y')): raise Exception()

				imdb = client.parseDOM(item, 'a', ret='href')[0]
				imdb = re.findall('(tt\d*)', imdb)[0]
				imdb = imdb.encode('utf-8')

				try: poster = client.parseDOM(item, 'img', ret='loadlate')[0]
				except: poster = '0'
				poster = re.sub('(?:_SX\d+?|)(?:_SY\d+?|)(?:_UX\d+?|)_CR\d+?,\d+?,\d+?,\d*','_SX500', poster)
				poster = client.replaceHTMLCodes(poster)
				poster = poster.encode('utf-8')

				try: genre = client.parseDOM(item, 'span', attrs = {'class': 'genre'})[0]
				except: genre = '0'
				genre = ' / '.join([i.strip() for i in genre.split(',')])
				if genre == '': genre = '0'
				genre = client.replaceHTMLCodes(genre)
				genre = genre.encode('utf-8')

				try: duration = re.findall('(\d+?) min(?:s|)', item)[-1]
				except: duration = '0'
				duration = duration.encode('utf-8')

				rating = '0'
				try: rating = client.parseDOM(item, 'span', attrs = {'class': 'rating-rating'})[0]
				except: pass
				try: rating = client.parseDOM(rating, 'span', attrs = {'class': 'value'})[0]
				except: rating = '0'
				try: rating = client.parseDOM(item, 'div', ret='data-value', attrs = {'class': '.*?imdb-rating'})[0]
				except: pass
				if rating == '' or rating == '-': rating = '0'
				rating = client.replaceHTMLCodes(rating)
				rating = rating.encode('utf-8')

				try: votes = client.parseDOM(item, 'div', ret='title', attrs = {'class': '.*?rating-list'})[0]
				except: votes = '0'
				try: votes = re.findall('\((.+?) vote(?:s|)\)', votes)[0]
				except: votes = '0'
				if votes == '': votes = '0'
				votes = client.replaceHTMLCodes(votes)
				votes = votes.encode('utf-8')

				try: mpaa = client.parseDOM(item, 'span', attrs = {'class': 'certificate'})[0]
				except: mpaa = '0'
				if mpaa == '' or mpaa == 'NOT_RATED': mpaa = '0'
				mpaa = mpaa.replace('_', '-')
				mpaa = client.replaceHTMLCodes(mpaa)
				mpaa = mpaa.encode('utf-8')

				try: director = re.findall('Director(?:s|):(.+?)(?:\||</div>)', item)[0]
				except: director = '0'
				director = client.parseDOM(director, 'a')
				director = ' / '.join(director)
				if director == '': director = '0'
				director = client.replaceHTMLCodes(director)
				director = director.encode('utf-8')

				try: cast = re.findall('Stars(?:s|):(.+?)(?:\||</div>)', item)[0]
				except: cast = '0'
				cast = client.replaceHTMLCodes(cast)
				cast = cast.encode('utf-8')
				cast = client.parseDOM(cast, 'a')
				if cast == []: cast = '0'

				plot = '0'
				try: plot = client.parseDOM(item, 'p', attrs = {'class': 'text-muted'})[0]
				except: pass
				try: plot = client.parseDOM(item, 'div', attrs = {'class': 'item_description'})[0]
				except: pass
				plot = plot.rsplit('<span>', 1)[0].strip()
				if plot == '': plot = '0'
				plot = client.replaceHTMLCodes(plot)
				plot = plot.encode('utf-8')

				self.list.append({'title': title, 'originaltitle': title, 'year': year, 'premiered': '0', 'studio': '0', 'genre': genre, 'duration': duration, 'rating': rating, 'votes': votes, 'mpaa': mpaa, 'director': director, 'writer': '0', 'cast': cast, 'plot': plot, 'code': imdb, 'imdb': imdb, 'tmdb': '0', 'tvdb': '0', 'poster': poster, 'banner': '0', 'fanart': '0', 'next': next})
			except:
				pass

		return self.list


	def imdb_person_list(self, url):
		try:
			result = client.request(url)
			result = result.decode('iso-8859-1').encode('utf-8')
			items = client.parseDOM(result, 'tr', attrs = {'class': '.+? detailed'})
		except:
			return

		for item in items:
			try:
				name = client.parseDOM(item, 'a', ret='title')[0]
				name = client.replaceHTMLCodes(name)
				name = name.encode('utf-8')

				url = client.parseDOM(item, 'a', ret='href')[0]
				url = re.findall('(nm\d*)', url, re.I)[0]
				url = self.person_link % url
				url = client.replaceHTMLCodes(url)
				url = url.encode('utf-8')

				image = client.parseDOM(item, 'img', ret='src')[0]
				if not ('._SX' in image or '._SY' in image): raise Exception()
				image = re.sub('_SX\d*|_SY\d*|_CR\d+?,\d+?,\d+?,\d*','_SX500', image)
				image = client.replaceHTMLCodes(image)
				image = image.encode('utf-8')

				self.list.append({'name': name, 'url': url, 'image': image})
			except:
				pass

		return self.list


	def imdb_user_list(self, url):
		try:
			result = client.request(url)
			result = result.decode('iso-8859-1').encode('utf-8')
			items = client.parseDOM(result, 'div', attrs = {'class': 'list_name'})
		except:
			pass

		for item in items:
			try:
				name = client.parseDOM(item, 'a')[0]
				name = client.replaceHTMLCodes(name)
				name = name.encode('utf-8')

				url = client.parseDOM(item, 'a', ret='href')[0]
				url = url.split('/list/', 1)[-1].replace('/', '')
				url = self.imdblist_link % url
				url = client.replaceHTMLCodes(url)
				url = url.encode('utf-8')

				self.list.append({'name': name, 'url': url, 'context': url})
			except:
				pass

		self.list = sorted(self.list, key=lambda k: re.sub('(^the |^a )', '', k['name'].lower()))
		return self.list


	def worker(self):
		self.meta = []
		total = len(self.list)

		for i in range(0, total): self.list[i].update({'metacache': False})
		self.list = metacache.fetch(self.list, self.lang)

		for r in range(0, total, 40):
			threads = []
			for i in range(r, r+40):
				if i <= total: threads.append(workers.Thread(self.super_info, i))
			[i.start() for i in threads]
			[i.join() for i in threads]

			if len(self.meta) > 0: metacache.insert(self.meta)

		self.list = [i for i in self.list if not i['imdb'] == '0']

	def apollo_list(self, url):
		try:
			response = get(url)
			try:
				json_object = json.loads(response.text)
			except:
				print "### ERROR Load JSON: {0}".format(json.decoder.linecol(doc, pos))
				pass
			for data in json_object:
				poster = '0'
				try: poster = str(data['poster'])
				except: pass
				banner = '0'
				try: banner = str(data['banner'])
				except: pass
				fanart = '0'
				try: fanart = str(data['fanart'])
				except: pass
				try: 
					self.list.append({'imdb': str(data['imdb']),'infoset':"1",'title': str(data['title']), 'year': str(data['year']), 'code': str(data['imdb']), 'tmdb': str(data['tmdb']), 'poster': poster, 'banner': banner, 'fanart': fanart, 'premiered': str(data['premiered']), 'studio': str(data['studio']), 'genre': str(data['genre']),'cast': '0', 'duration': str(data['duration']), 'rating': str(data['rating']), 'votes': str(data['votes']), 'mpaa': str(data['mpaa']), 'director': str(data['director']), 'writer': str(data['writer']), 'plot': str(data['plot'])})
				except: 
					print "####### ERROR JSON Rec: {0}".format(data)
					pass
			return self.list
		except:
			pass

	def super_info(self, i):
		try:
			if self.list[i]['metacache'] == True: raise Exception()

			try: imdb = self.list[i]['imdb']
			except: imdb = '0'

			if not imdb == '0':
				try:
					if 'infoset' not in self.list[i]:
						response = get(control.apollo_link+'?action=meta&type=movie&id='+imdb)
						data = json.load(response)   
						self.list[i].update({'imdb': imdb, 'title': str(data['title']), 'year': str(data['year']), 'code': str(imdb), 'imdb': str(imdb), 'tmdb': str(data['tmdb']), 'poster': str(data['poster']), 'banner': str(data['banner']), 'fanart': str(data['fanart']), 'premiered': str(data['premiered']), 'studio': str(data['studio']), 'genre': str(data['genre']),'cast': '0', 'duration': str(data['duration']), 'rating': str(data['rating']), 'votes': str(data['votes']), 'mpaa': str(data['mpaa']), 'director': str(data['director']), 'writer': str(data['writer']), 'plot': str(data['plot'])})
					else:
						data = self.list[i]

					if not self.lang == 'en':
						try:
							url = self.trakt_lang_link % (imdb, self.lang)

							item = trakt.getTrakt(url)
							item = json.loads(item)[0]

							t = item['title']
							if not (t == None or t == ''): title = t
							try: title = title.encode('utf-8')
							except: pass
							if not title == '0': self.list[i].update({'title': title})

							t = item['overview']
							if not (t == None or t == ''): plot = t
							try: plot = plot.encode('utf-8')
							except: pass
							if not plot == '0': self.list[i].update({'plot': plot})
						except: pass
						
					self.meta.append({'imdb': imdb, 'tmdb': '0', 'tvdb': '0', 'lang': self.lang, 'item': {'title': str(data['title']), 'year': str(data['year']), 'code': str(imdb), 'imdb': str(imdb), 'tmdb': str(data['tmdb']), 'poster': str(data['poster']), 'banner': str(data['banner']), 'fanart': str(data['fanart']), 'premiered': str(data['premiered']), 'studio': str(data['studio']), 'genre': str(data['genre']),'cast': '0', 'duration': str(data['duration']), 'rating': str(data['rating']), 'votes': str(data['votes']), 'mpaa': str(data['mpaa']), 'director': str(data['director']), 'writer': str(data['writer']), 'plot': str(data['plot'])}})
				except:
					self.list[i]['imdb'] = "0"
		except:
			pass

	
	def super_info_(self, i):
		try:
			if self.list[i]['metacache'] == True: raise Exception()

			imdb = self.list[i]['imdb']

			url = self.imdb_info_link % imdb

			item = client.request(url, timeout='10')
			item = json.loads(item)

			title = item['Title']
			title = title.encode('utf-8')
			if not title == '0': self.list[i].update({'title': title})

			year = item['Year']
			year = year.encode('utf-8')
			if not year == '0': self.list[i].update({'year': year})

			imdb = item['imdbID']
			if imdb == None or imdb == '' or imdb == 'N/A': imdb = '0'
			imdb = imdb.encode('utf-8')
			if not imdb == '0': self.list[i].update({'imdb': imdb, 'code': imdb})

			premiered = item['Released']
			if premiered == None or premiered == '' or premiered == 'N/A': premiered = '0'
			premiered = re.findall('(\d*) (.+?) (\d*)', premiered)
			try: premiered = '%s-%s-%s' % (premiered[0][2], {'Jan':'01', 'Feb':'02', 'Mar':'03', 'Apr':'04', 'May':'05', 'Jun':'06', 'Jul':'07', 'Aug':'08', 'Sep':'09', 'Oct':'10', 'Nov':'11', 'Dec':'12'}[premiered[0][1]], premiered[0][0])
			except: premiered = '0'
			premiered = premiered.encode('utf-8')
			if not premiered == '0': self.list[i].update({'premiered': premiered})

			genre = item['Genre']
			if genre == None or genre == '' or genre == 'N/A': genre = '0'
			genre = genre.replace(', ', ' / ')
			genre = genre.encode('utf-8')
			if not genre == '0': self.list[i].update({'genre': genre})

			duration = item['Runtime']
			if duration == None or duration == '' or duration == 'N/A': duration = '0'
			duration = re.sub('[^0-9]', '', str(duration))
			duration = duration.encode('utf-8')
			if not duration == '0': self.list[i].update({'duration': duration})

			rating = item['imdbRating']
			if rating == None or rating == '' or rating == 'N/A' or rating == '0.0': rating = '0'
			rating = rating.encode('utf-8')
			if not rating == '0': self.list[i].update({'rating': rating})

			votes = item['imdbVotes']
			try: votes = str(format(int(votes),',d'))
			except: pass
			if votes == None or votes == '' or votes == 'N/A': votes = '0'
			votes = votes.encode('utf-8')
			if not votes == '0': self.list[i].update({'votes': votes})

			mpaa = item['Rated']
			if mpaa == None or mpaa == '' or mpaa == 'N/A': mpaa = '0'
			mpaa = mpaa.encode('utf-8')
			if not mpaa == '0': self.list[i].update({'mpaa': mpaa})

			director = item['Director']
			if director == None or director == '' or director == 'N/A': director = '0'
			director = director.replace(', ', ' / ')
			director = re.sub(r'\(.*?\)', '', director)
			director = ' '.join(director.split())
			director = director.encode('utf-8')
			if not director == '0': self.list[i].update({'director': director})

			writer = item['Writer']
			if writer == None or writer == '' or writer == 'N/A': writer = '0'
			writer = writer.replace(', ', ' / ')
			writer = re.sub(r'\(.*?\)', '', writer)
			writer = ' '.join(writer.split())
			writer = writer.encode('utf-8')
			if not writer == '0': self.list[i].update({'writer': writer})

			cast = item['Actors']
			if cast == None or cast == '' or cast == 'N/A': cast = '0'
			cast = [x.strip() for x in cast.split(',') if not x == '']
			try: cast = [(x.encode('utf-8'), '') for x in cast]
			except: cast = []
			if cast == []: cast = '0'
			if not cast == '0': self.list[i].update({'cast': cast})

			plot = item['Plot']
			if plot == None or plot == '' or plot == 'N/A': plot = '0'
			plot = client.replaceHTMLCodes(plot)
			plot = plot.encode('utf-8')
			if not plot == '0': self.list[i].update({'plot': plot})

			studio = self.list[i]['studio']


			url = self.trakt_info_link % imdb

			item = trakt.getTrakt(url)
			item = json.loads(item)

			poster = '0'
			try: poster = item['images']['poster']['medium']
			except: pass
			if poster == None or not '/posters/' in poster: poster = '0'
			poster = poster.rsplit('?', 1)[0]
			if poster == '0': poster = self.list[i]['poster']
			poster = poster.encode('utf-8')
			if not poster == '0': self.list[i].update({'poster': poster})

			banner = '0'
			try: banner = item['images']['banner']['full']
			except: pass
			if banner == None or not '/banners/' in banner: banner = '0'
			banner = banner.rsplit('?', 1)[0]
			banner = banner.encode('utf-8')
			if not banner == '0': self.list[i].update({'banner': banner})

			fanart = '0'
			try: fanart = item['images']['fanart']['full']
			except: pass
			if fanart == None or not '/fanarts/' in fanart: fanart = '0'
			fanart = fanart.rsplit('?', 1)[0]
			if fanart == '0': poster = self.list[i]['fanart']
			fanart = fanart.encode('utf-8')
			if not fanart == '0': self.list[i].update({'fanart': fanart})


			if not self.lang == 'en':
				url = self.trakt_lang_link % (imdb, self.lang)

				item = trakt.getTrakt(url)
				item = json.loads(item)[0]

				t = item['title']
				if not (t == None or t == ''): title = t
				try: title = title.encode('utf-8')
				except: pass
				if not title == '0': self.list[i].update({'title': title})

				t = item['overview']
				if not (t == None or t == ''): plot = t
				try: plot = plot.encode('utf-8')
				except: pass
				if not plot == '0': self.list[i].update({'plot': plot})

			self.meta.append({'imdb': imdb, 'tmdb': '0', 'tvdb': '0', 'lang': self.lang, 'item': {'title': title, 'year': year, 'code': imdb, 'imdb': imdb, 'tmdb': '0', 'poster': poster, 'banner': banner, 'fanart': fanart, 'premiered': premiered, 'studio': studio, 'genre': genre, 'duration': duration, 'rating': rating, 'votes': votes, 'mpaa': mpaa, 'director': director, 'writer': writer, 'cast': cast, 'plot': plot}})
		except:
			pass


	def movieDirectory(self, items):
		if items == None or len(items) == 0: control.idle() ; sys.exit()

		sysaddon = sys.argv[0]

		syshandle = int(sys.argv[1])

		addonPoster, addonBanner = control.addonPoster(), control.addonBanner()

		addonFanart, settingFanart = control.addonFanart(), control.setting('fanart')

		traktCredentials = trakt.getTraktCredentialsInfo()

		try: isOld = False ; control.item().getArt('type')
		except: isOld = True

		isEstuary = True if 'estuary' in control.skin else False

		isPlayable = 'true' if not 'plugin' in control.infoLabel('Container.PluginName') else 'false'

		indicators = playcount.getMovieIndicators(refresh=True) if action == 'movies' else playcount.getMovieIndicators()

		#playbackMenu = control.lang(32063).encode('utf-8') if control.setting('hosts.mode') == '2' else control.lang(32064).encode('utf-8')

		watchedMenu = control.lang(32068).encode('utf-8') if trakt.getTraktIndicatorsInfo() == True else control.lang(32066).encode('utf-8')

		unwatchedMenu = control.lang(32069).encode('utf-8') if trakt.getTraktIndicatorsInfo() == True else control.lang(32067).encode('utf-8')

		#queueMenu = control.lang(32065).encode('utf-8')

		traktManagerMenu = control.lang(32070).encode('utf-8')

		nextMenu = control.lang(32053).encode('utf-8')


		for i in items:
			try:
				label = '%s (%s)' % (i['title'], i['year'])
				imdb, title, year = i['imdb'], i['title'], i['year']
				sysname = urllib.quote_plus('%s (%s)' % (title, year))
				systitle = urllib.quote_plus(title)

				poster, banner, fanart = i['poster'], i['banner'], i['fanart']
				if banner == '0' and not fanart == '0': banner = fanart
				elif banner == '0' and not poster == '0': banner = poster
				if poster == '0': poster = addonPoster
				if banner == '0': banner = addonBanner


				meta = dict((k,v) for k, v in i.iteritems() if not v == '0')
				meta.update({'mediatype': 'movie'})
				meta.update({'trailer': '%s?action=trailer&name=%s' % (sysaddon, sysname)})
				#meta.update({'trailer': 'plugin://script.extendedinfo/?info=playtrailer&&id=%s' % imdb})
				if i['duration'] == '0': meta.update({'duration': '120'})
				try: meta.update({'duration': str(int(meta['duration']) * 60)})
				except: pass
				try: meta.update({'genre': cleangenre.lang(meta['genre'], self.lang)})
				except: pass
				if isEstuary == True:
					try: del meta['cast']
					except: pass

				sysmeta = urllib.quote_plus(json.dumps(meta))

				url = '%s?action=apollo&title=%s&year=%s&imdb=%s&meta=%s&t=%s' % (sysaddon, systitle, year, imdb, sysmeta, self.systime)
				sysurl = urllib.quote_plus(url)

				#path = '%s?action=play&title=%s&year=%s&imdb=%s' % (sysaddon, systitle, year, imdb)

				cm = []
				#cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))

				try:
					overlay = int(playcount.getMovieOverlay(indicators, imdb))
					if overlay == 7:
						cm.append((unwatchedMenu, 'RunPlugin(%s?action=moviePlaycount&imdb=%s&query=6)' % (sysaddon, imdb)))
						meta.update({'playcount': 1, 'overlay': 7})
					else:
						cm.append((watchedMenu, 'RunPlugin(%s?action=moviePlaycount&imdb=%s&query=7)' % (sysaddon, imdb)))
						meta.update({'playcount': 0, 'overlay': 6})
				except:
					pass

				if traktCredentials == True:
					cm.append((traktManagerMenu, 'RunPlugin(%s?action=traktManager&name=%s&imdb=%s&content=movie)' % (sysaddon, sysname, imdb)))

				#cm.append((playbackMenu, 'RunPlugin(%s?action=alterSources&url=%s&meta=%s)' % (sysaddon, sysurl, sysmeta)))

				if isOld == True:
					cm.append((control.lang2(19033).encode('utf-8'), 'Action(Info)'))


				item = control.item(label=label)

				item.setArt({'icon': poster, 'thumb': poster, 'poster': poster, 'banner': banner})

				if settingFanart == 'true' and not fanart == '0':
					item.setProperty('Fanart_Image', fanart)
				elif not addonFanart == None:
					item.setProperty('Fanart_Image', addonFanart)

				item.addContextMenuItems(cm)
				item.setProperty('IsPlayable', isPlayable)
				item.setInfo(type='Video', infoLabels = meta)

				control.addItem(handle=syshandle, url=url, listitem=item, isFolder=False)
			except:
				pass

		try:
			url = items[0]['next']
			if url == '': raise Exception()

			icon = control.addonNext()
			url = '%s?action=moviePage&url=%s' % (sysaddon, urllib.quote_plus(url))

			item = control.item(label=nextMenu)

			item.setArt({'icon': icon, 'thumb': icon, 'poster': icon, 'banner': icon})
			if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)

			control.addItem(handle=syshandle, url=url, listitem=item, isFolder=True)
		except:
			pass


		control.content(syshandle, 'movies')
		#control.do_block_check(False)
		control.directory(syshandle, cacheToDisc=True)
		views.setView('movies', {'skin.confluence': 500})


	def addDirectory(self, items, queue=False):
		if items == None or len(items) == 0: control.idle() ; sys.exit()

		sysaddon = sys.argv[0]

		syshandle = int(sys.argv[1])

		addonFanart, addonThumb, artPath = control.addonFanart(), control.addonThumb(), control.artPath()

		queueMenu = control.lang(32065).encode('utf-8')

		for i in items:
			try:
				name = i['name']

				if i['image'].startswith('http://'): thumb = i['image']
				elif not artPath == None: thumb = os.path.join(artPath, i['image'])
				else: thumb = addonThumb

				url = '%s?action=%s' % (sysaddon, i['action'])
				try: url += '&url=%s' % urllib.quote_plus(i['url'])
				except: pass

				cm = []

				if queue == True:
					cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))

				item = control.item(label=name)

				item.setArt({'icon': thumb, 'thumb': thumb})
				if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)

				item.addContextMenuItems(cm)

				control.addItem(handle=syshandle, url=url, listitem=item, isFolder=True)
			except:
				pass

		#control.do_block_check(False)
		control.directory(syshandle, cacheToDisc=True)


