# -*- coding: utf-8 -*-
# Name:        main.py
# Author:      Mancuniancol
# Created on:  28.01.2017
# Licence:     GPL v.3: http://www.gnu.org/copyleft/gpl.html
from parsers import *


def extract_torrents(html=None):
    """
    Parse the HTML to get Torrents
    :param html: html code of the page
    :type html: str or None
    :return: dict
    """
    if html is not None:
        dom = Html().feed(html)
        for item in dom.find_once('table', ('class', 'bordered'), order=2).find_all('tr'):
            name = item(tag='a')
            cm = 0
            serial = ''
            for i in item(tag='a', attribute='href').split('/'):
                serial = i
                cm += 1
                if cm == 3:
                    break
            magnet = '%s/down/%s.torrent' % (Settings.url, serial)
            size = item.find_once('td', ('class', 's'))()
            seeds = item.find_once('td', ('class', 'u'))()
            peers = item.find_once('td', ('class', 'd'))()
            yield (name, '', magnet, size, seeds, peers)  # name, info_hash, magnet, size, seeds, peers


def search(info):
    """
    General Search
    :param info: payload
    :type info: dict or None
    :return: torrents
    """
    Filtering.use_general(info)
    return process(generator=extract_torrents)


def search_movie(info):
    """
    Movie Search
    :param info: payload
    :type info: dict or None
    :return: torrents
    """
    Filtering.use_movie(info)
    return process(generator=extract_torrents)


def search_episode(info):
    """
    Episode Search
    :param info: payload
    :type info: dict or None
    :return: torrents
    """
    if info['absolute_number'] == 0:
        Filtering.use_tv(info)
    else:
        Filtering.use_anime(info)
    return process(generator=extract_torrents)


def search_season(info):
    """
    Season Search
    :param info: payload
    :type info: dict or None
    :return: torrents
    """
    Filtering.use_season(info)
    return process(generator=extract_torrents)


# This registers your module for use
register(search, search_movie, search_episode, search_season)
