# coding: utf-8
from provider import *

__author__ = 'mancuniancol'


def extract_torrents(html=None):
    if html is not None:
        dom = Html().feed(html)
        row_search = "dom." + get_setting('row_search')
        name_search = get_setting('name_search')
        magnet_search = get_setting('magnet_search')
        info_hash_search = get_setting('info_hash_search')
        size_search = get_setting('size_search')
        seeds_search = get_setting('seeds_search')
        peers_search = get_setting('peers_search')
        if dom is not None:
            for item in eval(row_search):
                if item is not None:
                    name = eval(name_search)  # name
                    magnet = eval(magnet_search) if len(magnet_search) > 0 else ""  # magnet
                    info_hash = eval(info_hash_search) if len(info_hash_search) > 0 else ""  # size
                    size = eval(size_search) if len(size_search) > 0 else ""  # size
                    seeds = eval(seeds_search) if len(seeds_search) > 0 else ""  # seeds
                    peers = eval(peers_search) if len(peers_search) > 0 else ""  # peers
                    yield (name, info_hash, magnet, size, seeds, peers)  # name, info_hash, magnet, size, seeds, peers


def search(info):
    Filtering.use_general(info)
    Filtering.post_data = {'categoria': '',
                           'subcategoria': '',
                           'idioma': '',
                           'calidad': '',
                           'ordenar': 'Fecha',
                           'ord': 'Descendente',
                           'search': 'QUERY',
                           'pg': ''}
    return process(generator=extract_torrents)


def search_movie(info):
    Filtering.use_movie(info)
    Filtering.post_data = {'categoria': '',
                           'subcategoria': '',
                           'idioma': '',
                           'calidad': '',
                           'ordenar': 'Fecha',
                           'ord': 'Descendente',
                           'search': 'QUERY',
                           'pg': ''}
    return process(generator=extract_torrents)


def search_episode(info):
    if info['absolute_number'] == 0:
        Filtering.use_tv(info)
    else:
        Filtering.use_anime(info)
    Filtering.post_data = {'categoria': '',
                           'subcategoria': '',
                           'idioma': '',
                           'calidad': '',
                           'ordenar': 'Fecha',
                           'ord': 'Descendente',
                           'search': 'QUERY',
                           'pg': ''}
    return process(generator=extract_torrents)


def search_season(info):
    Filtering.use_season(info)
    Filtering.post_data = {'categoria': '',
                           'subcategoria': '',
                           'idioma': '',
                           'calidad': '',
                           'ordenar': 'Fecha',
                           'ord': 'Descendente',
                           'search': 'QUERY',
                           'pg': ''}
    return process(generator=extract_torrents)


# This registers your module for use
register(search, search_movie, search_episode, search_season)
