#
# BackgroundPackInstaller Script by Phil65  (inspired by ThemeInstaller script by Dan Dar3)
# Installs background packs from local or remote zip files

import os
import re
#import glob
import fnmatch
import zipfile
import urllib
import xbmc, xbmcgui, xbmcaddon, xbmcvfs
import shutil
from xml.dom.minidom import parse

__addon__        = xbmcaddon.Addon()
__addonid__      = __addon__.getAddonInfo('id')
__addonversion__ = __addon__.getAddonInfo('version')
__cwd__          = __addon__.getAddonInfo('path').decode("utf-8")
__language__     = __addon__.getLocalizedString

SKIN_PATH = os.path.join( xbmc.translatePath("special://home/addons/skin.glassnox.svn"))
ADDON_DATA_PATH = os.path.join( xbmc.translatePath("special://profile/addon_data/%s" % __addonid__ ).decode("utf-8") )

def main() :
    # Global variables
    global ZIP_PATH_TAB
    global BACKGROUNDPACKS_REPO_TAB
    global INSTALL_PATH_TAB
    global download_mode
    # Init variables
    interactive_mode = True
    modeselect= []
    BACKGROUNDPACKS_REPO_TAB = []
    ZIP_PATH_TAB = []
    INSTALL_PATH_TAB = []
    DOWNLOAD_BUTTON_TAB = []
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/backgrounds/")
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/themes/")
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/genreart/icons/")
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/genreart/fanart/")
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/weather-fanart/")
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/Music/icons/")
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/Music/fanart/")
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/Mods/")
    BACKGROUNDPACKS_REPO_TAB.append("http://glassnox.googlecode.com/svn/trunk/backgroundpack/Scripts/")
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "backgroundpacks" ))
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "themes" ))
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "videogenreicons" ))
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "videogenrefanart" ))
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "weather-fanart" ))
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "musicgenreicons" ))
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "musicgenrefanart" ))
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "Mods" ))
    ZIP_PATH_TAB.append(os.path.join( ADDON_DATA_PATH, "Scripts" ))
    INSTALL_PATH_TAB.append(os.path.join( SKIN_PATH, "backgrounds" ))
    INSTALL_PATH_TAB.append(os.path.join( SKIN_PATH, "media" ))
    INSTALL_PATH_TAB.append(os.path.join( SKIN_PATH, "extras", "genre", "video", "icons" ))
    INSTALL_PATH_TAB.append(os.path.join( SKIN_PATH, "extras", "genre", "video", "fanart" ))
    INSTALL_PATH_TAB.append(os.path.join( SKIN_PATH, "extras" ))
    INSTALL_PATH_TAB.append(os.path.join( SKIN_PATH, "extras", "genre", "music", "icons" ))
    INSTALL_PATH_TAB.append(os.path.join( SKIN_PATH, "extras", "genre", "music", "fanart" ))
    INSTALL_PATH_TAB.append(SKIN_PATH)
    INSTALL_PATH_TAB.append(xbmc.translatePath("special://home/addons"))
    DOWNLOAD_BUTTON_TAB.append(__language__(32001))
    DOWNLOAD_BUTTON_TAB.append(__language__(32011))
    DOWNLOAD_BUTTON_TAB.append(__language__(32012))
    DOWNLOAD_BUTTON_TAB.append(__language__(32014))
    DOWNLOAD_BUTTON_TAB.append(__language__(32017))
    DOWNLOAD_BUTTON_TAB.append(__language__(32020))
    DOWNLOAD_BUTTON_TAB.append(__language__(32021))
    DOWNLOAD_BUTTON_TAB.append(__language__(32025))
    DOWNLOAD_BUTTON_TAB.append(__language__(32026))
    modeselect.append( __language__(32008) )
    modeselect.append( __language__(32009) )
    modeselect.append( __language__(32013) )
    modeselect.append( __language__(32015) )
    modeselect.append( __language__(32016) )
    modeselect.append( __language__(32019) )
    modeselect.append( __language__(32018) )
    modeselect.append( __language__(32024) )
    modeselect.append( __language__(32027) )
    # If program is called outside the skin then return
    if xbmc.getSkinDir() != "skin.glassnox.svn" :
        xbmcgui.Dialog().ok( __addonid__, "Skin not supported")        
        return
    # Parse parameters for batch mode or interactive mode
    try:
        params = dict( arg.split( "=" ) for arg in sys.argv[ 1 ].split( "&" ) )
    except:
        params = {}
    # Batch mode - reinstall all active items
    if params.get("reinstall"):
        interactive_mode = False
        # For each ZIP_PATH, check if Save.xml file exist
        for ZIP_PATH in ZIP_PATH_TAB:
            download_mode  =ZIP_PATH_TAB.index(ZIP_PATH)
            SavedXML = os.path.join( ZIP_PATH, "Save.xml")
            if os.path.isfile(SavedXML):
                DocXML = parse(SavedXML)
                for last in DocXML.getElementsByTagName('last'):
                    theme = last.childNodes[0].data
                    # Re-install local zip...
                    install_local_zip( theme, ZIP_PATH, INSTALL_PATH_TAB[download_mode], interactive_mode )
        return
    # Interactive mode
    checkDir(os.path.join( ADDON_DATA_PATH))
    dialogSelection = xbmcgui.Dialog()
    download_mode        = dialogSelection.select( __language__(32010), modeselect ) 
    if download_mode == -1 :
        return
    # Download more themes...
    themes = get_local_backgroundpacks( ZIP_PATH_TAB[download_mode] )
    themes.append( DOWNLOAD_BUTTON_TAB[download_mode] )
    checkDir( ZIP_PATH_TAB[download_mode] )    
    # Dialog to select local theme or download more...
    dialogThemes = xbmcgui.Dialog()
    index        = dialogThemes.select( __language__(32002), themes ) 
    # Cancel / Back...
    if index == -1 :
        return
    # Download more themes...
    elif index == len( themes ) - 1 :
        show_remote_themes( BACKGROUNDPACKS_REPO_TAB[download_mode], ZIP_PATH_TAB[download_mode] , INSTALL_PATH_TAB[download_mode], interactive_mode )
    # Install local theme...
    else :
        theme   = themes[ index ]
        install_local_zip( theme, ZIP_PATH_TAB[download_mode] , INSTALL_PATH_TAB[download_mode], interactive_mode )

def log(txt):
    if isinstance (txt,str):
        txt = txt.decode("utf-8")
    message = u'%s: %s' % (__addonid__, txt)
    xbmc.log(msg=message.encode("utf-8"), level=xbmc.LOGDEBUG)
 
def checkDir(path):
    if not xbmcvfs.exists(path):
        xbmcvfs.mkdir(path)
        
def get_local_backgroundpacks( ZIP_PATH ) :
    # Get a list of extra themes (local)      
    themes = []
    if os.path.isdir( ZIP_PATH ) :
        for entry in os.listdir( ZIP_PATH ) :
            if (fnmatch.fnmatch(entry, "*.zip") == True) :
                ( name, ext ) = os.path.splitext( entry )
                themes.append( name )
    return themes

def show_remote_themes( BACKGROUNDPACKS_REPO, ZIP_PATH, INSTALL_PATH, interactive_mode ) :
    file = urllib.urlopen( BACKGROUNDPACKS_REPO )
    html = file.read()
    # Parse HTML...
    regexp = re.compile( "<li><a href=\"(.*?)\">(.*?)</a></li>", re.DOTALL )
    items  = regexp.findall( html )
    # Build a list of remote themes...
    themes = []
    for item in items :
       if item[1] != ".." :
           ( name, ext ) = os.path.splitext( item[1] )
           themes.append( name )
    # No remote themes found...
    if len( themes ) == 0 :
        xbmcgui.Dialog().ok( __addonid__, __language__(32007) )
    # User to choose a remote theme...
    else :
        dialogThemes = xbmcgui.Dialog()
        index = dialogThemes.select( __language__(32006), themes )
        # Cancel...
        if index == -1 :
            return
        #  User chose remote theme...
        theme = themes[ index ]
        # Show progress dialog...
        dp = xbmcgui.DialogProgress()
        dp.create( __addonid__, __language__(32005), theme )
        # Download theme...
        remote_theme = os.path.join( BACKGROUNDPACKS_REPO, "%s.zip" % theme )
        local_theme  = os.path.join( ZIP_PATH, "%s.zip" % theme )
        urllib.urlretrieve( remote_theme, local_theme, lambda nb, bs, fs, url=remote_theme : download_progress_hook( nb, bs, fs, local_theme, dp ) )
        # Close progress dialog...
        dp.close()
        # Install local zip...
        install_local_zip( theme, ZIP_PATH, INSTALL_PATH, interactive_mode )

def download_progress_hook( numblocks, blocksize, filesize, url=None, dp=None, ratio=1.0 ):
    downloadedsize  = numblocks * blocksize
    percent         = int( downloadedsize * 100 / filesize )
    dp.update( percent )

def install_local_zip( theme, ZIP_PATH, INSTALL_PATH, interactive_mode ) :
    try :
        # Init
        if download_mode == 0 :
            contents = [os.path.join(INSTALL_PATH, i) for i in os.listdir(INSTALL_PATH)]
            [shutil.rmtree(i) if os.path.isdir(i) else os.unlink(i) for i in contents]
        if download_mode == 4 :
            xbmc.executebuiltin( 'Skin.SetString(WeatherFanartDir,special://skin/extras/Weather-Fanart/)')
            contents = [os.path.join(INSTALL_PATH, "Weather-Fanart", i) for i in os.listdir(os.path.join(INSTALL_PATH, "Weather-Fanart"))]
            [shutil.rmtree(i) if os.path.isdir(i) else os.unlink(i) for i in contents]
        DownloadedZip = os.path.join( ZIP_PATH, "%s.zip" % theme )
        SavedXML = os.path.join( ZIP_PATH, "Save.xml")
        # Create or overwrite Save.xml file to store latest ZIP installed
        file_xml = open(SavedXML,'w')
        file_xml.write("<last>%s</last>" % theme)
        file_xml.close()
        # Create or overwrite ReplaceFiles.xml file to know that extra backgrounds have to be reinstalled
        file_xml = open(os.path.join( SKIN_PATH, "1080i", "ReplaceFiles.xml"), 'w')
        file_xml.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n")
        file_xml.write("<includes>\n")
        file_xml.write("    <!-- fmronan and MikeBzh44 -->\n")
        file_xml.write("    <include name=\"ReplaceFiles\">\n")
        file_xml.write("        <onload>Skin.Reset(ReplaceFiles)</onload>\n")
        file_xml.write("    </include>\n")
        file_xml.write("</includes>\n")
        file_xml.close()
        # Set skin property
        xbmc.executebuiltin( 'Skin.SetBool(ExtraBackgrounds_IsInstall)')
        # Extract theme zip...
        zip = zipfile.ZipFile (DownloadedZip, "r")
        zip.extractall(INSTALL_PATH, filter(lambda f: not f.endswith('/'), zip.namelist()))
        zip.close()   
        if download_mode == 7 :
            xbmcgui.Dialog().ok( __addonid__, "Skin will reload now.")        
            xbmc.executebuiltin( 'XBMC.ReloadSkin()')
        if download_mode == 8 :
            xbmc.executebuiltin( 'XBMC.UpdateLocalAddons()')
        xbmcgui.Dialog().ok( __addonid__, __language__(32003))
        if interactive_mode:
            main()
    except :
        # Message...
        xbmcgui.Dialog().ok( __addonid__, __language__(32004))
        if interactive_mode:
            main()
main()
