#-*- coding: utf-8 -*-
import urllib,urllib2,re,uuid,time
import extract
import xbmcgui,xbmcplugin
import shutil
import os
import repoCheck

AddonTitle="DOKI Onderhoud"
thumbnailPath = xbmc.translatePath('special://thumbnails');
cachePath = os.path.join(xbmc.translatePath('special://home'), 'cache')
tempPath = xbmc.translatePath('special://temp')
addonPath = os.path.join(os.path.join(xbmc.translatePath('special://home'), 'addons'),'script.dokionderhoud')
mediaPath = os.path.join(addonPath, 'media')
dokifanart = os.path.join(addonPath, 'fanart.jpg')
databasePath = xbmc.translatePath('special://database')
kodiver = xbmc.getInfoLabel("System.BuildVersion").split(".")[0]
base='http://xml.dokitv.nl/'
dialog = xbmcgui.Dialog()

#######################################################################
#                          CLASSES
#######################################################################

class cacheEntry:
    def __init__(self, namei, pathi):
        self.name = namei
        self.path = pathi

        
#######################################################################
#						Define Menus
#######################################################################

def mainMenu():
        xbmc.executebuiltin("Container.SetViewMode(500)")
        repoCheck.UpdateRepo()
        addItem('[B][COLOR palegreen]C[/COLOR]ache Legen[/B]','url', 1,os.path.join(mediaPath, "1.png"))
        addItem('[B][COLOR palegreen]T[/COLOR]humbnails Verwijderen[/B]', 'url', 2,os.path.join(mediaPath, "2.png"))
        addItem('[B][COLOR palegreen]P[/COLOR]ackages Verwijderen[/B]', 'url', 3,os.path.join(mediaPath, "3.png"))  
        if int(kodiver) <= 16:    
            addItem('[B][COLOR palegreen]V[/COLOR]erwijder addons.db[/B]', 'url', 5,os.path.join(mediaPath, "4.png"))        
        addItem('[B][COLOR palegreen]K[/COLOR]odi Versie[/B]', 'url', 4,os.path.join(mediaPath, "5.png"))	
        addItem('[B][COLOR palegreen]F[/COLOR]abrieksInstellingen[/B]', 'url', 6,os.path.join(mediaPath, "6.png"))
        addItem('[B][COLOR palegreen]D[/COLOR]OKI Installer[/B]', 'url', 7,os.path.join(mediaPath, "7.png"))	
        addItem('[B][COLOR palegreen]D[/COLOR]OKI Nieuws Flits[/B]', 'url', 8,os.path.join(mediaPath, "8.png"))	        		


#######################################################################        
#						Add to menus
#######################################################################
    
def addItem(name,url,mode,iconimage):
        u=sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&name="+urllib.quote_plus(name)
        ok=True
        liz=xbmcgui.ListItem(name, iconImage="DefaultFolder.png", thumbnailImage=iconimage,)
        liz.setInfo( type="Video", infoLabels={ "Title": name } )
        liz.setArt({'fanart': dokifanart})
        ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
        return ok

#######################################################################
#						Parses Choice
#######################################################################
      
def get_params():
	param=[]
	paramstring=sys.argv[2]
	if len(paramstring)>=2:
			params=sys.argv[2]
			cleanedparams=params.replace('?','')
			if (params[len(params)-1]=='/'):
					params=params[0:len(params)-2]
			pairsofparams=cleanedparams.split('&')
			param={}
			for i in range(len(pairsofparams)):
					splitparams={}
					splitparams=pairsofparams[i].split('=')
					if (len(splitparams))==2:
							param[splitparams[0]]=splitparams[1]
							
	return param   

#######################################################################
#						Work Functions
#######################################################################
def setupCacheEntries():
    entries = 5 #make sure this refelcts the amount of entries you have
    dialogName = ["MP3 Streams", "4oD", "BBC iPlayer", "Simple Downloader", "ITV"]
    pathName = ["special://profile/addon_data/plugin.audio.mp3streams/temp_dl", "special://profile/addon_data/plugin.video.4od/cache",
					"special://profile/addon_data/plugin.video.iplayer/iplayer_http_cache","special://profile/addon_data/script.module.simple.downloader",
                    "special://profile/addon_data/plugin.video.itv/Images"]
                    
    cacheEntries = []
    
    for x in range(entries):
        cacheEntries.append(cacheEntry(dialogName[x],pathName[x]))
    
    return cacheEntries


def clearCache():
    
    if os.path.exists(cachePath)==True:    
        for root, dirs, files in os.walk(cachePath):
            file_count = 0
            file_count += len(files)
            if file_count > 0:

                dialog = xbmcgui.Dialog()
                if dialog.yesno("DOKI Onderhoud", str(file_count) + " bestanden gevonden", "Weet je zeker dat je ze wil verwijderen?"):
                
                    for f in files:
                        try:
                            if (f == "xbmc.log" or f == "xbmc.old.log"): continue
                            os.unlink(os.path.join(root, f))
                        except:
                            pass
                    for d in dirs:
                        try:
                            shutil.rmtree(os.path.join(root, d))
                        except:
                            pass
                        
            else:
                pass
    if os.path.exists(tempPath)==True:    
        for root, dirs, files in os.walk(tempPath):
            file_count = 0
            file_count += len(files)
            if file_count > 0:
                dialog = xbmcgui.Dialog()
                if dialog.yesno("DOKI Onderhoud", str(file_count) + " bestanden gevonden", "Weet je zeker dat je ze wil verwijderen?"):
                    for f in files:
                        try:
                            if (f == "xbmc.log" or f == "xbmc.old.log"): continue
                            os.unlink(os.path.join(root, f))
                        except:
                            pass
                    for d in dirs:
                        try:
                            shutil.rmtree(os.path.join(root, d))
                        except:
                            pass
                        
            else:
                pass
    if xbmc.getCondVisibility('system.platform.ATV2'):
        atv2_cache_a = os.path.join('/private/var/mobile/Library/Caches/AppleTV/Video/', 'Other')
        
        for root, dirs, files in os.walk(atv2_cache_a):
            file_count = 0
            file_count += len(files)
        
            if file_count > 0:

                dialog = xbmcgui.Dialog()
                if dialog.yesno("Delete ATV2 Cache Files", str(file_count) + " files found in 'Other'", "Do you want to delete them?"):
                
                    for f in files:
                        os.unlink(os.path.join(root, f))
                    for d in dirs:
                        shutil.rmtree(os.path.join(root, d))
                        
            else:
                pass
        atv2_cache_b = os.path.join('/private/var/mobile/Library/Caches/AppleTV/Video/', 'LocalAndRental')
        
        for root, dirs, files in os.walk(atv2_cache_b):
            file_count = 0
            file_count += len(files)
        
            if file_count > 0:

                dialog = xbmcgui.Dialog()
                if dialog.yesno("Delete ATV2 Cache Files", str(file_count) + " files found in 'LocalAndRental'", "Do you want to delete them?"):
                
                    for f in files:
                        os.unlink(os.path.join(root, f))
                    for d in dirs:
                        shutil.rmtree(os.path.join(root, d))
                        
            else:
                pass    
                
    cacheEntries = setupCacheEntries()
                                         
    for entry in cacheEntries:
        clear_cache_path = xbmc.translatePath(entry.path)
        if os.path.exists(clear_cache_path)==True:    
            for root, dirs, files in os.walk(clear_cache_path):
                file_count = 0
                file_count += len(files)
                if file_count > 0:

                    dialog = xbmcgui.Dialog()
                    if dialog.yesno("Raw Manager",str(file_count) + "%s cache files found"%(entry.name), "Do you want to delete them?"):
                        for f in files:
                            os.unlink(os.path.join(root, f))
                        for d in dirs:
                            shutil.rmtree(os.path.join(root, d))
                            
                else:
                    pass
                

    dialog = xbmcgui.Dialog()
    dialog.ok("Doki Onderhoud", "Je cache is geleegd!")

    
def deleteThumbnails():
    if os.path.exists(thumbnailPath)==True:  
            if dialog.yesno("DOKI Onderhoud", "Deze optie verwijderd alle thumbnails", "Weet u zeker dat u deze wilt verwijderen?"):
                for root, dirs, files in os.walk(thumbnailPath):
                    file_count = 0
                    file_count += len(files)
                    if file_count > 0:                
                        for f in files:
                            try:
                                os.unlink(os.path.join(root, f))
                            except:
                                pass
    else:
        pass
    
    text13 = os.path.join(databasePath,"Textures13.db")
    try:
        os.unlink(text13)
    except:
        try:
            dbcon = sqlite3.connect(text13)
            dbcur = dbcon.cursor()
            dbcur.execute('DROP TABLE IF EXISTS path')
            dbcur.execute('VACUUM')
            dbcon.commit()
            dbcur.execute('DROP TABLE IF EXISTS sizes')
            dbcur.execute('VACUUM')
            dbcon.commit()
            dbcur.execute('DROP TABLE IF EXISTS texture')
            dbcur.execute('VACUUM')
            dbcon.commit()
            dbcur.execute("""CREATE TABLE path (id integer, url text, type text, texture text, primary key(id))"""
                          )
            dbcon.commit()
            dbcur.execute("""CREATE TABLE sizes (idtexture integer,size integer, width integer, height integer, usecount integer, lastusetime text)"""
                          )
            dbcon.commit()
            dbcur.execute("""CREATE TABLE texture (id integer, url text, cachedurl text, imagehash text, lasthashcheck text, PRIMARY KEY(id))"""
                          )
            dbcon.commit()
        except:
            pass
        
    dialog.ok("DOKI Onderhoud", "Herstart uw systeem om de thumbnail map weer op te bouwen")
	        
def purgePackages():
    
    purgePath = xbmc.translatePath('special://home/addons/packages')
    dialog = xbmcgui.Dialog()
    for root, dirs, files in os.walk(purgePath):
            file_count = 0
            file_count += len(files)
    if dialog.yesno("DOKI Onderhoud", "%d packages gevonden."%file_count, "Wil je ze verwijderen?"):  
        for root, dirs, files in os.walk(purgePath):
            file_count = 0
            file_count += len(files)
            if file_count > 0:            
                for f in files:
                    os.unlink(os.path.join(root, f))
                for d in dirs:
                    shutil.rmtree(os.path.join(root, d))
                dialog = xbmcgui.Dialog()
                dialog.ok("DOKI Onderhoud", "Alle Packages zijn verwijderd.")
            else:
                dialog = xbmcgui.Dialog()
                dialog.ok("DOKI Onderhoud", "Geen Packages om te verwijderen.")
		
		
def KODIVERSION(url): xbmc_version=xbmc.getInfoLabel("System.BuildVersion"); version=xbmc_version[:4]; print version; dialog=xbmcgui.Dialog(); dialog.ok(AddonTitle, "Jouw Kodi Versie is : [COLOR palegreen][B]%s[/B][/COLOR]" % version)

def removeAddonsDatabase():
    dbList = os.listdir(databasePath)
    dbAddons = []
    removed = True
    for file in dbList:
        if re.findall('Addons(\d+)\.db', file):
            dbAddons.append(file)
    for file in dbAddons:
        dbFile = os.path.join(databasePath, file)
        try:
            os.unlink(dbFile)
        except:
            removed = False
    if removed:
        dialog.ok("DOKI Onderhoud", "Herstart uw systeem om addons database weer op te bouwen")
    else:
        dialog.ok("DOKI Onderhoud", "Het verwijderen is mislukt!", "U zou dit handmatig moeten doen")

def dokiinstall(url):
    pluginpath=os.path.exists(xbmc.translatePath(os.path.join('special://home','addons','plugin.program.dokitv')))
    if pluginpath: xbmc.executebuiltin("RunAddon(plugin.program.dokitv)")
    else:
        url=base+'plugin.program.dokitv.zip'; path=xbmc.translatePath(os.path.join('special://home','addons','packages')); lib=os.path.join(path,'plugin.program.dokitv.zip'); DownloaderClass(url,lib)
        time.sleep(3)
        addonfolder=xbmc.translatePath(os.path.join('special://home','addons','')); dp=xbmcgui.DialogProgress(); print '=== INSTALLING Fresh Start ==='; dp.create(AddonTitle,"Extracting Zip Please Wait")
        extract.all(lib,addonfolder,dp); xbmc.executebuiltin("XBMC.UpdateLocalAddons()"); xbmc.executebuiltin("RunAddon(plugin.program.dokitv)")	

def DownloaderClass(url,dest, useReq = False):
    dp = xbmcgui.DialogProgress()
    dp.create(AddonTitle,"Bestanden downloaden.",'')

    if useReq:
        import urllib2
        req = urllib2.Request(url)
        req.add_header('Referer', 'http://wallpaperswide.com/')
        f       = open(dest, mode='wb')
        resp    = urllib2.urlopen(req)
        content = int(resp.headers['Content-Length'])
        size    = content / 100
        total   = 0
        while True:
            if dp.iscanceled(): 
                raise Exception("Canceled")                
                dp.close()

            chunk = resp.read(size)
            if not chunk:            
                f.close()
                break

            f.write(chunk)
            total += len(chunk)
            percent = min(100 * total / content, 100)
            dp.update(percent)       
    else:
        urllib.urlretrieve(url,dest,lambda nb, bs, fs, url=url: _pbhook(nb,bs,fs,url,dp))

def _pbhook(numblocks, blocksize, filesize, url=None,dp=None):
    try:
        percent = min((numblocks*blocksize*100)/filesize, 100)
        dp.update(percent)
    except:
        percent = 100
        dp.update(percent)
    if dp.iscanceled(): 
        raise Exception("Canceled")
        dp.close()				

def Nieuws():
	text = ''
	twit = 'http://xml.dokitv.nl/nieuws.xml'
	req = urllib2.Request(twit)
	req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3')
	response = urllib2.urlopen(req)
	link=response.read()
	response.close()
	match=re.compile("<title>(.+?)</title><pubDate>(.+?)</pubDate>",re.DOTALL).findall(link)
	for status, dte in match:
	    try:
			    status = status.decode('ascii', 'ignore')
	    except:
			    status = status.decode('utf-8','ignore')
	    dte = dte[:-15]
	    status = status.replace('&amp;','')
	    dte = '[COLOR palegreen][B]'+dte+'[/B][/COLOR]'
	    text = text+dte+'\n'+status+'\n'+'\n'
	showText('[COLOR palegreen]Doki Nieuws Flits[/COLOR]', text)	

def showText(heading, text):
    id = 10147
    xbmc.executebuiltin('ActivateWindow(%d)' % id)
    xbmc.sleep(100)
    win = xbmcgui.Window(id)
    retry = 50
    while (retry > 0):
	try:
	    xbmc.sleep(10)
	    retry -= 1
	    win.getControl(1).setLabel(heading)
	    win.getControl(5).setText(text)
	    return
	except:
	    pass
        
def cleanStart():
    yes_pressed = dialog.yesno("[COLOR palegreen][B]Schone install[/COLOR][/B]", '[COLOR palegreen]Hiermee verwijderd je alles in Kodi[/COLOR]', '[COLOR snow]Weet u zeker dat u hiermee door wilt gaan?[/COLOR]', '', yeslabel='JA',nolabel='NEE')
    if yes_pressed:
        excludes = ['plugin.program.dokitv','script.dokionderhoud',]
        xbmcdir = xbmc.translatePath('special://home/')
        xbmcdir=os.path.abspath(xbmcdir)
        for root, dirs, files in os.walk(xbmcdir, topdown=True):
            dirs[:] = [d for d in dirs if d not in excludes]
            for name in files:
                try: os.remove(os.path.join(root, name))
                except: pass
            for name in dirs:
                if name not in ["addons", "addon_data", "userdata"]:
                    try: shutil.rmtree(os.path.join(root, name), ignore_errors=True, onerror=None)
                    except: pass        
        killxbmc()

def killxbmc():
    myplatform = platform()
    try: os._exit(1)
    except: pass
    print "Platform: " + str(myplatform)
    if myplatform == 'osx': # OSX
        print "############   try osx force close  #################"
        try: os.system('killall -9 XBMC')
        except: pass
        try: os.system('killall -9 Kodi')
        except: pass
        dialog.ok("[COLOR=red][B]WAARSCHUWING  !!![/COLOR][/B]", "Als je dit bericht ziet is het geforceerd sluiten", "mislukt. Sluit kodi geforceerd [COLOR=palegreen]NIET VIA[/COLOR] het menu afsluiten.",'')
    elif myplatform == 'linux': #Linux
        print "############   try linux force close  #################"
        try: os.system('killall XBMC')
        except: pass
        try: os.system('killall Kodi')
        except: pass
        try: os.system('killall -9 xbmc.bin')
        except: pass
        try: os.system('killall -9 kodi.bin')
        except: pass
        dialog.ok("[COLOR=red][B]WAARSCHUWING  !!![/COLOR][/B]", "Als je dit bericht ziet is het geforceerd sluiten", "mislukt. Sluit kodi geforceerd [COLOR=palegreen]NIET VIA[/COLOR] het menu afsluiten.",'')
    elif myplatform == 'android': # Android  
        print "############   try android force close  #################"
        try: os.system('adb shell am force-stop org.xbmc.kodi')
        except: pass
        try: os.system('adb shell am force-stop org.kodi')
        except: pass
        try: os.system('adb shell am force-stop org.xbmc.cemc')
        except: pass
        try: os.system('adb shell am force-stop org.xbmc.cemc_pro')
        except: pass
        try: os.system('adb shell am force-stop com.semperpax.spmc16') 
        except: pass
        try: os.system('adb shell am force-stop org.lodi.mobi') 
        except: pass
        try: os.system('adb shell am force-stop com.perfectzoneproductions.jesusboxmedia')
        except: pass
        try: os.system('adb shell am force-stop org.xbmc.xbmc') 
        except: pass
        try: os.system('adb shell am force-stop org.xbmc')
        except: pass
        try: os.system('adb shell kill org.xbmc.kodi')
        except: pass
        try: os.system('adb shell kill org.kodi')
        except: pass
        try: os.system('adb shell kill org.xbmc.xbmc')
        except: pass
        try: os.system('adb shell kill org.xbmc')
        except: pass
        try: os.system('adb shell kill com.semperpax.spmc16')
        except: pass
        try: os.system('adb shell kill com.semperpax')
        except: pass
        try: os.system('adb shell kill com.perfectzoneproductions.jesusboxmedia')
        except: pass
        try: os.system('adb shell kill org.xbmc.cemc')
        except: pass
        try: os.system('adb shell kill org.xbmc.cemc_pro')
        except: pass
        try: os.system('adb shell kill org.lodi.mobi')
        except: pass
        try: os.system('adb shell kill com.semperpax')
        except: pass
        try: os.system('Process.killProcess(android.os.Process.org.xbmc.kodi());')
        except: pass
        try: os.system('Process.killProcess(android.os.Process.org.kodi());')
        except: pass
        try: os.system('Process.killProcess(android.os.Process.org.xbmc.xbmc());')
        except: pass
        try: os.system('Process.killProcess(android.os.Process.org.xbmc());')
        except: pass
        dialog.ok("[COLOR=red][B]WAARSCHUWING  !!![/COLOR][/B]", "We hebben gedetecteerd dat er gebruik gemaakt word van Android, U ", "[COLOR=yellow][B]MOET[/COLOR][/B] kodi geforceerd sluiten. [COLOR=palegreen]NIET VIA[/COLOR] het menu afsluiten.","Of proces beëindigen met taakbeheer (Als je het niet zeker weet haal de stroom van de speler af).")
    elif myplatform == 'windows': # Windows
        print "############   try windows force close  #################"
        try:
            os.system('@ECHO off')
            os.system('tskill XBMC.exe')
        except: pass
        try:
            os.system('@ECHO off')
            os.system('tskill Kodi.exe')
        except: pass
        try:
            os.system('@ECHO off')
            os.system('tskill SMC.exe')
        except: pass
        try:
            os.system('@ECHO off')
            os.system('TASKKILL /im Kodi.exe /f')
        except: pass
        try:
            os.system('@ECHO off')
            os.system('TASKKILL /im SMC.exe /f')
        except: pass
        try:
            os.system('@ECHO off')
            os.system('TASKKILL /im XBMC.exe /f')
        except: pass
        dialog.ok("[COLOR=red][B]WAARSCHUWING  !!![/COLOR][/B]", "Als je dit bericht ziet is het geforceerd sluiten", "mislukt. Sluit kodi geforceerd [COLOR=palegreen]NIET VIA[/COLOR] het menu afsluiten.","gebruik taak beheer en geen ALT F4")
    else: #ATV
        print "############   try atv force close  #################"
        try: os.system('killall AppleTV')
        except: pass
        print "############   try raspbmc force close  #################" #OSMC / Raspbmc
        try: os.system('sudo initctl stop kodi')
        except: pass
        try: os.system('sudo initctl stop xbmc')
        except: pass
        dialog.ok("[COLOR=red][B]WAARSCHUWING  !!![/COLOR][/B]", "Als je dit bericht ziet is het geforceerd sluiten", "mislukt. Sluit kodi geforceerd [COLOR=palegreen]NIET VIA[/COLOR] het menu afsluiten.","het apparaat kon niet worden gedetecteerd dus verwijder de stroom kabel en start opnieuw.")

def platform():
    if xbmc.getCondVisibility('system.platform.android'): return 'android'
    elif xbmc.getCondVisibility('system.platform.linux'): return 'linux'
    elif xbmc.getCondVisibility('system.platform.windows'): return 'windows'
    elif xbmc.getCondVisibility('system.platform.osx'): return 'osx'
    elif xbmc.getCondVisibility('system.platform.atv2'): return 'atv2'
    elif xbmc.getCondVisibility('system.platform.ios'): return 'ios'					
		
		
		
#######################################################################
#						START MAIN
#######################################################################              


params=get_params()
url=None
name=None
mode=None
fanart=None

try:
        url=urllib.unquote_plus(params["url"])
except:
        pass
try:
        name=urllib.unquote_plus(params["name"])
except:
        pass
try:
        mode=int(params["mode"])
except:
        pass
try:    
		fanart=urllib.unquote_plus(params["fanart"])
except: 
		pass		

if mode==None or url==None or len(url)<1:
        mainMenu()
       
elif mode==1:
		clearCache()
        
elif mode==2:
        deleteThumbnails()

elif mode==3:
		purgePackages()	

elif mode==4:
		KODIVERSION(url)
		
elif mode==5:
    removeAddonsDatabase()		

elif mode==6:
    cleanStart()	

elif mode==7:
    dokiinstall(url)
	
elif mode==8:	
	Nieuws()		

xbmcplugin.endOfDirectory(int(sys.argv[1]))

