# -*- coding: utf-8 -*-

import urllib,urllib2,urlparse,xbmc,xbmcplugin,xbmcgui,xbmcaddon,sys,hashlib,time,base64
import HTTP

try:
	import json
except:
	import simplejson as json

try:
	import StorageServer
except:
	import storageserverdummy as StorageServer


PLUGIN_ID = 'plugin.video.vod.fptplay'

# CACHING
cache = StorageServer.StorageServer(PLUGIN_ID, 3)
cache.table_name = PLUGIN_ID


action              = None
settings            = xbmcaddon.Addon(id=PLUGIN_ID)
xbmcplugin.setContent(int(sys.argv[1]), 'movies')


class main:
	def __init__(self):
		global action
		params = {}
		splitparams = sys.argv[2][sys.argv[2].find('?') + 1:].split('&')
		for param in splitparams:
			if (len(param) > 0):
				splitparam = param.split('=')
				key = splitparam[0]
				try:    value = splitparam[1].encode("utf-8")
				except: value = splitparam[1]
				params[key] = value

		try:        action = urllib.unquote_plus(params["action"])
		except:     action = None
		try:        id = urllib.unquote_plus(params["id"])
		except:     id = None
		try:        page = urllib.unquote_plus(params["page"])
		except:     page = 1

		if action == None:                            self.main_menu()
		elif action == 'livetv':                      self.livetv()
		elif action == 'play_livetv':                 self.play_livetv(id)
		elif action == 'structure':                   self.structure(id)
		elif action == 'structure_contents':          self.structure_contents(id, page)
		elif action == 'structure_content_detail':    self.structure_content_detail(id)
		elif action == 'Search':					  self.Search()


	def get_proxy(self):
		proxy = None
		http_proxy = settings.getSetting('proxy')
		if http_proxy <> None and http_proxy <> '':
			proxy_username = settings.getSetting('proxy_username')
			proxy_password = settings.getSetting('proxy_password')
			if proxy_username <> None and proxy_username <> '':
				proxy = {'https': 'http://%s:%s@%s' %(urllib.quote(proxy_username), urllib.quote(proxy_password), http_proxy)}
			else:
				proxy = {'https': 'http://' + http_proxy }
		return proxy


	def __request__(self, path, params={}):
		headers = {'User-Agent': 'Dalvik/1.6.0 (Linux; U; Android 4.4.2; SGH-I337M Build/KOT49H) FPTPlay-Android-2.2', 'X-DID': 'e671fb1f264cd268', 'Accept-Encoding': 'gzip'}

		cache_path = path + urllib.urlencode(params)
		cached_result = cache.get(cache_path)
		if cached_result <> None and cached_result <> '':
			return json.loads(cached_result)

		url = self.__create_request_url__(path, params)

		result = HTTP.Retrieve(url, headers=headers, proxy=self.get_proxy())
		cache.set(cache_path, result)
		return json.loads(result)


	def __create_request_url__(self, path, data = {}):
		e = int(round(time.time()) + 14400L)
		md5 = hashlib.md5()
		path = "/api/v3.2_a/" + path
		md5.update("ADR3cmOiSMBKJKHlKJlv5JghoMXE/bb8%d%s" %(e, path))
		encode = base64.urlsafe_b64encode(md5.digest())
		for x in range(len(encode) - 1, 0, -1):
			if encode[x] != '=':
				encode = encode[:x+1]
				break;

		query = urllib.urlencode(data.items() + {'st': encode, 'e': e, 'version': 'fplay_1.08', 'device': 'phone', 'source': 'googleplay'}.items())
		return "https://api.fptplay.net%s?%s" %(path, query)


	def __build_url__(self, query):
		return sys.argv[0] + '?' + urllib.urlencode(query)


	def main_menu(self):
		xbmcplugin.setContent(int(sys.argv[1]), 'videos')

		#live tv
		item = xbmcgui.ListItem('Live TV')
		xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=self.__build_url__({'action': 'livetv'}),listitem=item,isFolder=True)

		#structures
		items = self.__request__('structure/vod')
		for i in items['result']:
			id = i['_id']
			icon = i['icon']
			name = i['name']
			u = self.__build_url__({'action': 'structure', 'id': id})
			item = xbmcgui.ListItem(name)
			item.setInfo(type="Video", infoLabels={"Label": name, "Title": name})
			item.setArt({'poster': icon, 'thumb': icon, 'landscape': icon})
			xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=item,isFolder=True)

		#search
		item = xbmcgui.ListItem(u'Tìm Kiếm')
		xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=self.__build_url__({'action': 'Search'}), listitem=item, isFolder=True)

		xbmcplugin.endOfDirectory(int(sys.argv[1]))


	def livetv(self):
		xbmcplugin.setContent(int(sys.argv[1]), 'episodes')
		channels = self.__request__('tv')
		for c in channels['Channels']:
			id = c['_id']
			name = c['name']
			thumb = c['thumb']
			description = c['description']
			item = xbmcgui.ListItem(name)
			item.setInfo(type="Video", infoLabels={"Label": name, "Title": name, 'Plot': description})
			item.setArt({'poster': thumb, 'thumb': thumb, 'landscape': thumb})
			u = self.__build_url__({'action': 'play_livetv', 'id': id})
			xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=item,isFolder=False)

		xbmcplugin.endOfDirectory(int(sys.argv[1]))


	def play_livetv(self, id):
		progress = xbmcgui.DialogProgress()
		progress.create(u'Đăng Tải Phim')
		try:
			headers = {'User-Agent': 'Dalvik/1.6.0 (Linux; U; Android 4.4.2; SGH-I337M Build/KOT49H) FPTPlay-Android-2.2', 'X-DID': 'e671fb1f264cd268', 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			post = {'id': id, 'quality': 3, 'mobile': 'web'}

			streams = json.loads(HTTP.Retrieve('http://fptplay.net/show/getlinklivetv', post=urllib.urlencode(post), headers=headers, proxy=self.get_proxy()))
			stream = streams['stream']
			query = stream[stream.index('?')+1:]
		finally:
			progress.close()
			del progress

		cq = settings.getSetting('playback_quality')
		url = None
		item = None

		print streams

		for c in streams['quality']:
			if unicode(c['name']) == unicode(cq):
				url = c['url']
				if "?" in url:
					url = url + "&" + query
				else:
					url = url + "?" + query
				break

		item = xbmcgui.ListItem(streams['name'])
		if url is None:
			url = stream
		xbmc.Player().play(url, item)


	def structure(self, id):
		genres = self.__request__('structure/vod', {'structure_id': id})
		for g in genres['result']:
			id = g['_id']
			description = g['description']
			icon = g['icon']
			name = g['name']
			if name != 'banner':
				item = xbmcgui.ListItem(name)
				item.setInfo(type="Video", infoLabels={"Label": name, "Title": name, 'Plot': description})
				item.setArt({'poster': icon, 'thumb': icon, 'landscape': icon})
				u = self.__build_url__({'action': 'structure_contents', 'id': id})
				xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=item,isFolder=True)
		xbmcplugin.endOfDirectory(int(sys.argv[1]))


	def structure_contents(self, id, page=1):
		xbmcplugin.setContent(int(sys.argv[1]), 'movies')
		contents = self.__request__('vod', {'structure_id': id, 'per_page': 20, 'page': page})
		total_page = contents['total_page']
		for g in contents['videos_list']:
			cid = g['_id']
			description = g['description']
			thumb = g['thumb']
			name = g['title']
			item = xbmcgui.ListItem(name)
			item.setInfo(type="Video", infoLabels={"Label": name, "Title": name, 'Plot': description})
			item.setArt({'poster': thumb, 'thumb': thumb, 'landscape': thumb})

			u = self.__build_url__({'action': 'structure_content_detail', 'id': cid})
			xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=item,isFolder=True)
		if page < total_page:
			u = self.__build_url__({'action': 'structure_contents', 'id': id, 'page': page+1})
			item = xbmcgui.ListItem("Xem Them")
			xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=item,isFolder=True)
		xbmcplugin.endOfDirectory(int(sys.argv[1]))


	def structure_content_detail(self, id):
		xbmcplugin.setContent(int(sys.argv[1]), 'episodes')

		details = self.__request__('vod/' + id)
		result = details['result']
		hasItems = False
		url = None
		thumb = None
		title = None
		for e in result['episodes']:
			thumb = e['thumb']
			title = e['title']
			if(len(e['url']) > 1):
				for u in e['url']:
					if u['name'] == 'Auto':
						url = u['url']
						break
			else:
				url = e['url'][0]['url']

			if "?" in url:
				url = url + "&" + settings.getSetting('token')
			else:
				url = url + "?" + settings.getSetting('token')

			if len(url) > 0:
				item = xbmcgui.ListItem(title)
				item.setInfo(type="Video", infoLabels={"Label": title, "Title": title})
				item.setArt({'poster': thumb, 'thumb': thumb, 'landscape': thumb})
				xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=url,listitem=item,isFolder=False)
				hasItems = True
		if len(result['episodes']) > 1 and hasItems:
			xbmcplugin.endOfDirectory(int(sys.argv[1]))
		elif len(result['episodes']) == 1 and url <> None and len(url) > 0:
			item = xbmcgui.ListItem(title)
			item.setInfo(type="Video", infoLabels={"Label": title, "Title": title})
			item.setArt({'poster': thumb, 'thumb': thumb, 'landscape': thumb})
			xbmc.Player().play(url, item)


main()
