from stream import plugin
from stream.utils import memoize
from stream.utils import memoize, get_api_language

API_KEY = "57983e31fb435df4df77afb854740ea9"
BASE_URL = "http://api.themoviedb.org/3"
HEADERS = {
    "Referer": BASE_URL,
}
LANG = get_api_language()

@memoize
def tmdb_config():
    from stream.utils import url_get_json
    return url_get_json("%s/configuration" % BASE_URL, params={"api_key": API_KEY}, headers=HEADERS, with_immunicity=False)


def image(rel_url, size="original"):
    return "%s/%s/%s" % (tmdb_config()["images"]["base_url"], size, rel_url)


def get(imdb_id):
    from stream.caching import shelf
    with shelf("com.imdb.%s" % imdb_id) as movie:
        if not movie:
            try:
                import urllib2
                from stream.utils import url_get_json
                movie.update(url_get_json("%s/movie/%s" % (BASE_URL, imdb_id), params={"api_key": API_KEY,"language": LANG, "append_to_response": "credits"}, headers=HEADERS, with_immunicity=False) or {})
                overview = movie.get('overview')
                if overview == None:
                    movie.update(url_get_json("%s/movie/%s" % (BASE_URL, imdb_id), params={"api_key": API_KEY,"language": "en", "append_to_response": "credits"}, headers=HEADERS, with_immunicity=False) or {})		
		else:
		   pass
            except urllib2.HTTPError:
                pass
        return dict(movie)


def search(query, **kwargs):
    from stream.utils import url_get_json

    kwargs["query"] = query
    return url_get_json("%s/search/movie" % BASE_URL, params=kwargs, headers=HEADERS, with_immunicity=False)


def get_list_item(meta):
    from stream.utils import first

    def img(key, size="original", default=""):
        return meta.get(key) and image(meta[key], size=size) or default
    def m(key, default=""):
        return meta.get(key) or default
    def m_crew(job):
        return first([crew["name"] for crew in (m("credits", default={}).get("crew") or []) if crew["job"] == job])
    def get_studio():
        return (first(sorted(m("production_companies") or [], key=lambda x: x["id"])) or {}).get("name") or ""

    return {
        "label": m("title"),
        "icon": img("poster_path", size="w500"),
        "thumbnail": img("poster_path", size="w500"),
        "is_playable": True,
        "info": {
            "count": m("id"),
            "title": m("title"),
            "genre": meta.get("genres") and " / ".join([genre["name"] for genre in meta["genres"]]) or "",
            "plot": m("overview"),
            "plot_outline": m("overview"),
            "tagline": m("tagline"),
            "rating": m("vote_average"),
            "duration": m("runtime"),
            "code": m("imdb_id"),
            "cast": [cast["name"] for cast in (m("credits", default={}).get("cast") or [])],
            "director": m_crew("Director"),
            "writer": m_crew("Writer") or m_crew("Novel") or m_crew("Screenplay"),
            "studio": get_studio(),
            "year": meta.get("release_date") and meta["release_date"].split("-")[0] or "",
        },
        "properties": {
            "fanart_image": img("backdrop_path"),
        },
    }
