from stream import plugin
from stream.scrapers import scraper
from stream.ga import tracked
from stream.caching import cached_route
from stream.utils import ensure_fanart
from stream.library import library_context


# Temporary, will be fixed later by them
IMMUNICITY_TPB_URL = "http://thepiratebay.pe"
BASE_URL = "%s/" % (plugin.get_setting("immunicity", bool) and IMMUNICITY_TPB_URL or plugin.get_setting("base_tpb"))
HEADERS = {
    "Referer": BASE_URL,
}


CATEGORIES = [
    ("Audio", 100, [
        ("Music", 101),
        ("Audiobooks", 102),
    ]),

    ("Video", 200, [
        ("Movies - SD", 201),
        ("Movies - DVDR", 202),
        ("Movies - HD", 207),
        ("Movie Clips", 204),
        ("Music Videos", 203),
        ("TV Shows - SD", 205),
        ("TV Shows - HD", 208),
    ]),
]

if plugin.get_setting("porn", bool):
    CATEGORIES += [
        ("Porn", 500, [
            ("Movies - SD", 501),
            ("Movies - HD", 505),
            ("Movie clips", 506),
        ]),
    ]

# Cache TTLs
DEFAULT_TTL = 24 * 3600 # 24 hours


@scraper("Misc")
@plugin.route("/tpb")
@tracked
def piratebay_index():
    yield {"label": "Search", "path": plugin.url_for("piratebay_search")}

    def make_cats(root, prefix=""):
        for cat in root:
            yield {
                "label": "%s%s" % (prefix, cat[0]),
                "path": plugin.url_for("piratebay_page", root="/browse/%d" % cat[1], page=0),
            }
            if len(cat) > 2:
                for entry in make_cats(cat[2], prefix="%s    " % prefix):
                    yield entry

    for cat in make_cats(CATEGORIES):
        yield cat


@plugin.route("/tpb/<root>/<page>")
@library_context
@ensure_fanart
@tracked
def piratebay_page(root, page):
    import re
    from bs4 import BeautifulSoup
    from urlparse import urljoin
    from stream.utils import url_get

    page = int(page)
    html_data = url_get(urljoin(BASE_URL, "%s/%d/7/100,200,500" % (root, page)), headers=HEADERS)
    soup = BeautifulSoup(html_data, "html5lib")
    nodes = soup.findAll("div", "detName")

    for node in nodes:
        seeds, peers = map(lambda x: x.text, node.parent.parent.findAll("td")[2:])
        magnet_node = node.parent.findAll("a")[1]
        desc_node = node.parent.findAll("font", "detDesc")[0]
        size = re.search("Size (.*?),", desc_node.text).group(1)
        text = "%s (%s S:%s P:%s)" % (node.a.text, size.replace("&nbsp;", " "), seeds, peers)
        yield {
            "label": text,
            "path": plugin.url_for("play", uri=magnet_node["href"]),
            "is_playable": True,
        }
    yield {
        "label": ">> Next page",
        "path": plugin.url_for("piratebay_page", root=root, page=page + 1),
        "is_playable": False,
    }


@plugin.route("/tpb/search")
@tracked
def piratebay_search():
    import urllib

    query = plugin.request.args.get("query")
    if query:
        query = query[0]
    else:
        query = plugin.keyboard("", "The Pirate Bay - Search")
    if query:
        plugin.redirect(plugin.url_for("piratebay_page", root="/search/%s" % urllib.quote(query, safe=""), page=0))
