from functools import wraps

MODULES = []

def scraper(name, image=None):
    def _decorator(fn):
        MODULES.append({"name": name, "image": image, "view": fn.__name__})
        return fn
    return _decorator


def ungenerate(fn):
    @wraps(fn)
    def _fn(*args, **kwargs):
        return list(fn(*args, **kwargs))
    return _fn
