import socket
from stream import plugin, magnet, scrapers, socks
from socks import wrapmodule
from stream.ga import tracked
from stream.utils import ensure_fanart
from stream.platform import PLATFORM
from stream.scrapers import \
    MODULES, \
    eztv, \
    yify, \
    tpb

if plugin.get_setting("use_socks", bool):
    socks.set_default_proxy(socks.SOCKS5, plugin.get_setting("proxy_url"), int(plugin.get_setting("proxy_port")), plugin.get_setting("proxy_user"), plugin.get_setting("proxy_pass"))
    socket.socket = socks.socksocket

@plugin.route("/")
@tracked(force=True)
def index():
    if PLATFORM["os"] not in ["android", "linux", "windows", "darwin"]:
        plugin.notify("Your system \"%(os)s_%(arch)s\" is not supported. Sorry about that." % PLATFORM, delay=15000)

    for module in MODULES:
        yield {
            "label": module["name"],
            "thumbnail": module["image"],
            "path": plugin.url_for(module["view"]),
        }
