import os
from stream import plugin


@plugin.route("/cmd/install")
def firstrun():
    clear_cache()
    plugin.notify("Please review your settings.")
    plugin.open_settings()


@plugin.route("/cmd/clear_cache")
def clear_cache():
    import os
    import glob
    from stream.caching import CACHE_DIR
    for directory in [CACHE_DIR, plugin.storage_path]:
        for dbfile in glob.glob(os.path.join(directory, "*.db")):
            os.remove(dbfile)
    plugin.notify("Cache cleared.")


firstrun_file = os.path.join(plugin.addon.getAddonInfo("path"), ".firstrun")
if not os.path.exists(firstrun_file):
    with open(firstrun_file, "w"):
        firstrun()
