
import xbmc
import xbmcaddon
import xbmcgui

import os
import datetime
import json

import sfile


ADDONID = 'plugin.video.ottplanner'
ADDON   = xbmcaddon.Addon(ADDONID)
HOME    = ADDON.getAddonInfo('path')
TITLE   = ADDON.getAddonInfo('name')
PROFILE = ADDON.getAddonInfo('profile')
VERSION = ADDON.getAddonInfo('version')
GETTEXT = ADDON.getLocalizedString
ICON    = os.path.join(HOME, 'icon.png')
FANART  = os.path.join(HOME, 'fanart.jpg')



RECORDINGS  = ADDON.getSetting('FOLDER')
INFORMATION = os.path.join(RECORDINGS, 'recordings.txt')


DEBUG = True
def log(text):
    try:
        output = '%s V%s : %s' % (TITLE, VERSION, str(text))
        if DEBUG:
            xbmc.log(output)
        else:
            xbmc.log(output, xbmc.LOGDEBUG)

        path = os.path.join(PROFILE, 'log.txt')
        now = str(datetime.datetime.now())
        output = '%s - %s\r\n' % (now, output)
        sfile.append(path, output)
        
    except:
        raise
        pass



def showText(heading, text, waitForClose=False):
    id = 10147

    xbmc.executebuiltin('ActivateWindow(%d)' % id)
    xbmc.sleep(100)

    win = xbmcgui.Window(id)

    retry = 50
    while (retry > 0):
        try:
            xbmc.sleep(10)
            win.getControl(1).setLabel(heading)
            win.getControl(5).setText(text)
            retry = 0
        except:
            DialogOK("ERROR")
            retry -= 1

    if waitForClose:
        while xbmc.getCondVisibility('Window.IsVisible(%d)' % id) == 1:
            xbmc.sleep(50)


def showChangelog():
    #call showChangeLog like this to workaround bug in Kodi
    script = os.path.join(HOME, 'showChangelog.py')
    cmd    = 'AlarmClock(%s,RunScript(%s),%d,True)' % ('changelog', script, 0)
    xbmc.executebuiltin(cmd)


def _showChangelog():
    try:
        path  = os.path.join(HOME, 'changelog.txt')
        text  = sfile.read(path)
        title = '%s - %s' % (xbmc.getLocalizedString(24054), TITLE)

        showText(title, text)

    except Exception, e:
        DialogOK(str(e))
        pass

def DialogOK(line1, line2='', line3=''):
    xbmcgui.Dialog().ok(TITLE + ' - ' + VERSION, str(line1), str(line2), str(line3))


def DialogYesNo(line1, line2='', line3='', noLabel=None, yesLabel=None):
    if noLabel == None or yesLabel == None:
        return xbmcgui.Dialog().yesno(TITLE + ' - ' + VERSION, str(line1), str(line2), str(line3)) == True
    else:
        return xbmcgui.Dialog().yesno(TITLE + ' - ' + VERSION, str(line1), str(line2), str(line3), noLabel, yesLabel) == True



def LoadRecordings():
    try   : return json.loads(sfile.read(INFORMATION))
    except: return {}


def SaveRecordings(recordings):
    try:    sfile.write(INFORMATION, json.dumps(recordings))
    except: pass

