import md5
import pickle
import os
import sys
import re
import urllib
import shutil
import xbmc
import xbmcgui
import xbmcaddon
import xbmcplugin
from BeautifulSoup import BeautifulSoup
from string import join
from resources.lib.utils import isCacheValid, debug, unescapeHTMLchar, is_number,\
	 Browser, info, _get_keyboard
from pickle import HIGHEST_PROTOCOL

__addonid__ = 'plugin.video.mangastv'
__settings__ = xbmcaddon.Addon(id=__addonid__)
__site_url__ = "http://mangas-tv.com/"
__version__ = "2.4"

lang = __settings__.getLocalizedString

CATEGORIE_LIST_MODE = 'categorielist'
ANIME_LIST_MODE = 'animelist'
MOST_VIEWED_MODE = 'mostviewed'
PROMOTED_LIST_MODE = 'promoted'
PLAY_VIDEO_MODE = 'playVideo'
SHOW_EPISODES_MODE = 'showEpisodes' 
LOGIN_TO_UNLOCK_MODE = 'loginToUnlock'
SEARCH_MODE = 'search'
CLEAN_CACHE_MODE = 'cleanCache'
DOWNLOAD_ANIME_MODE = 'downloadAnime'

# Empty cache dir when we change the version
profile_dir = xbmc.translatePath(__settings__.getAddonInfo('profile'))
COOKIEFILE = os.path.join(profile_dir, 'cookie-mangas-tv.lwp')
cache_dir = os.path.join(profile_dir, "cache")
versionfile = os.path.join(cache_dir, __version__)
if not os.path.exists(cache_dir):
	os.makedirs(cache_dir)
elif not os.path.exists(versionfile) :
	shutil.rmtree(cache_dir)
	os.makedirs(cache_dir)
	f = open(versionfile, 'w')
	f.close()

class UpdateArgs:

	def __init__(self, args):
		for key, value in args.iteritems():
			if value == 'None':
				args[key] = None
			else:
				args[key] = urllib.unquote_plus(args[key])
		self.__dict__.update(args)

class UI:
	
	modeToContentDict = {CATEGORIE_LIST_MODE: 'movies',
						MOST_VIEWED_MODE : 'tvshows',
						PROMOTED_LIST_MODE: 'tvshows',
						ANIME_LIST_MODE: 'tvshows',
						SHOW_EPISODES_MODE: 'episodes',
						PLAY_VIDEO_MODE: 'episodes',
						LOGIN_TO_UNLOCK_MODE: 'files',
						CLEAN_CACHE_MODE: 'files',
						SEARCH_MODE: 'tvshows',
						DOWNLOAD_ANIME_MODE: 'files' }
	
	def __init__(self):
		self.main = Main(checkMode=False)
		self.browser = Browser(COOKIEFILE)
		self.pagelimit = '100'
		if __settings__.getSetting('page_limit') is not None and __settings__.getSetting('page_limit') != '':
				self.pagelimit = __settings__.getSetting('page_limit')
		self.cache_delay = 24
		if __settings__.getSetting('cache_delay')  is not None and __settings__.getSetting('cache_delay') != '':
			self.cache_delay = int(__settings__.getSetting('cache_delay'))
		if self.main.args.mode is not None:
			xbmcplugin.setContent(int(sys.argv[1]), self.modeToContentDict[self.main.args.mode])
		else:
			xbmcplugin.setContent(int(sys.argv[1]), 'files')
		
	def welcomePage(self):
		self.addItem({'Title': lang(30030), 'mode':CATEGORIE_LIST_MODE, 'url': __site_url__ + "index.php?module=listeMangas"})
		self.addItem({'Title': lang(30031), 'mode': MOST_VIEWED_MODE, 'url': __site_url__ + 'index.php?module=listeMangas&voir=vus&d=1&l=' + str(self.pagelimit)})
		self.addItem({'Title': lang(30032), 'mode': PROMOTED_LIST_MODE, 'url': __site_url__ + 'index.php?module=listeMangas&voir=prom&d=1&l=' + str(self.pagelimit)})
		self.addItem({'Title': lang(30033), 'mode': ANIME_LIST_MODE, 'url': __site_url__ + 'index.php?module=listeMangas&voir=tous&d=1'})
		self.addItem({'Title': lang(30045), 'mode': SEARCH_MODE, 'url': __site_url__ + "index.php?module=listeMangas"})
		self.endofdirectory()

	def __getFromCache(self, main, processFct, addSingleItemFct, dontAddToHierarchy = False):
		listItems = []
		cachefilepath = os.path.join(cache_dir, md5.new(main.args.url).hexdigest())
		if isCacheValid(cachefilepath, max_age=3600 * self.cache_delay):
			cachefile = open(cachefilepath, 'rb')
			listItems = pickle.load(cachefile)
			total = len(listItems)
			for item in listItems:
				addSingleItemFct(item, total)	
		else:
			dialog = xbmcgui.DialogProgress()
			dialog.create("Mangas-TV.com", lang(30034), lang(30035))
			dialog.update(50)
			htmlSource = self.browser.downloadHTML(main.args.url)
			soup = BeautifulSoup(htmlSource)
			dialog.update(100)
			dialog.close()
			processFct(soup, listItems)
			cachefile = open(cachefilepath, 'wb')
			pickle.dump(listItems, cachefile, HIGHEST_PROTOCOL)
			
		self.endofdirectory(sortMethod='title', dontAddToHierarchy=dontAddToHierarchy)

	def showCategories(self, main):
		def __parseCategory(soup, listItems):
			listCategories = soup.find('div', attrs={'id':'vignetteCategoriesTrie'}).findAll('div', attrs={'class':'vignetteCategorie'})
			total = len(listCategories)
			for cat in listCategories:
				thumb = __site_url__ + cat.find('img')['src']
				url = __site_url__ + cat.find('a')['href'] + '&d=1&l=' + str(self.pagelimit)
				title = join(cat.findAll(text=True), '').strip()
				debug("thumb = %s , href = %s, title = %s" % (thumb, url, title))
				item = {'Title': title, 'mode' : ANIME_LIST_MODE, 'url': url, 'category': title, 'Thumb' : thumb}
				infoLabels = { "name": title, "plot": "", "genre": title, "rating" : 0}
				itemTuple = (item, infoLabels)
				listItems.append(itemTuple)
				__addSingleItem(itemTuple, total)
		
		def __addSingleItem(itemTuple, total):
			item, extra = itemTuple
			self.addItem(info=item, extrainfo=extra , total_items=total)
		
		self.__getFromCache(main, __parseCategory, __addSingleItem)
			
	def search(self, main):
		vq = _get_keyboard( heading=lang(30046) )
		
		if ( not vq ): return False, 0
		# we need to set the title to our query
		info("search query = " + vq)
		dialog = xbmcgui.DialogProgress()
		dialog.create("Mangas-TV.com", lang(30034), lang(30035))
		dialog.update(50)

		data = urllib.urlencode({"formAction" : "textRecherche", 'textRecherche' : vq, 'resultLicence': 1, 'submit':'Valider'})
		response = self.browser.opener.open(main.args.url, data)
		htmlsource = unicode(response.read(), 'utf-8', 'replace')
		response.close()
		soup = BeautifulSoup(htmlsource)
		dialog.update(100)
		dialog.close()
		listItems = []
		self.__parseAnimeSeries(soup, listItems);
		self.endofdirectory(sortMethod='title', dontAddToHierarchy=False)
		
		
	def __parseAnimeSeries(self, soup, listItems):
		listArticleManga = soup.findAll('div', attrs={'class':'articleManga'})
		total = len(listArticleManga)
		for articleManga in listArticleManga:
			title = articleManga.find("div", attrs={"class": "nomMangaFr"}).find("a").find(text=True).strip()
			url = __site_url__ + articleManga.find("div", attrs={"class": "nomMangaFr"}).find("a")['href']
			image = __site_url__ + articleManga.find('img', attrs={'class': 'articleMangaImage'})['src']
			desc = articleManga.find('p', attrs={'class': 'articleMangaDescription'}).find(text=True).strip()
			detailManga = articleManga.find("div", attrs={"class": "optionDetailManga"})
			stats = detailManga.findAll('b')
			
			# get genre
			genre = lang(30039)
			genreTable = articleManga.find("td", attrs={"class": "articleMangaContenu"}).find('table')
			if genreTable is not None:
				genreList = genreTable.findAll('td')
				
				genre = ""
				prevGVotes = 0
				for genreTd in genreList:
					genreCandidate = join(genreTd.find("br").findNextSiblings(text=True), '').strip()
					genreCandidate = genreCandidate.replace("\n votes", "")
					gVotes = int(genreTd.find("b").string)	
					if prevGVotes > 0 :
						genre = genre + ', ' + genreCandidate
					else :
						genre = genreCandidate
					prevGVotes = gVotes
			
			nbEpisodes = None
			name = title
			m = re.search("Episodes disponible\(s\): (([0-9]*?)/([0-9a-zA-Z_]*))", str(detailManga))
			if m :
				name = title + " (%s episodes)" % m.group(1)
				nbEpisodes = m.group(2)
				
			infoLabels = { "name": title, "plot": desc, "genre": genre}				
			if nbEpisodes:
				infoLabels['nbepisodes'] = nbEpisodes
			
			rating, votes, views = stats[1].find(text=True), stats[2].find(text=True), stats[3].find(text=True)
			if rating is not None and is_number(rating):
				infoLabels['rating'] = float(rating)
			else : 
				infoLabels['rating'] = 0.0
			if votes is not None and is_number(rating):
				infoLabels['votes'] = long(votes)
			else:
				infoLabels['votes'] = 0
			if views is not None and is_number(rating):
				infoLabels['playcount'] = long(views)
			else:
				infoLabels['playcount'] = 0
			info = {'Title': name, 'mode' : SHOW_EPISODES_MODE, 'url': url , 'Thumb' : image}
			debug('info = %s, infoLabel = %s' % (info, infoLabels))
			item = (info, infoLabels)
			listItems.append(item)
			self.__addAnimeSeriesSingleItem(item, total)
				
	def __addAnimeSeriesSingleItem(self, itemTuple, total):
		item, extra = itemTuple
		self.addItem(info=item, extrainfo=extra, total_items=total)	

	def showAnimeSeries(self, main):
		
		self.__getFromCache(main, self.__parseAnimeSeries, self.__addAnimeSeriesSingleItem)

	def showEpisodes(self, main, dontAddToHierarchy=False):
		def __showEpisodes(soup, listItems):
			ficheManga = soup.find('div', attrs={'id' : 'ficheMangaPublic'})
			episodes = ficheManga.find('div', attrs={'id' : 'episodes'})
			if episodes is None:
				xbmcplugin.setContent(int(sys.argv[1]), 'files')
				infoRestriction = ficheManga.find('center')
				if infoRestriction is not None:
					img = __site_url__ + infoRestriction.find('img')['src']
					info = {'Title': lang(30036), 'mode' : LOGIN_TO_UNLOCK_MODE, 'url' : self.main.args.url , 'Thumb' : img, 'no-url' : True, 'icon2' : self.main.args.icon }
					if self.main.args.__dict__.has_key('icon2'):
						info['icon2'] = self.main.args.icon2 
				else:
					img = __site_url__ + "fichiers/licence.gif"
					info = {'Title': lang(30037), 'mode' : SHOW_EPISODES_MODE, 'url' : self.main.args.url , 'Thumb' : img, 'no-url' : True }
				listItems.append(info)
				__addSingleItem(info, 1)
			else:
				episodesList = soup.find('div', attrs={'id' : 'episodes'}).findAll('a')
				total = len(episodesList)
				for episode in episodesList:
					title = episode.find('a', text=True)
					if title is None:
						continue
					title = title.strip()
					debug('checking %s' % title)
					link = __site_url__ + episode['href']
					debug(link)
					info = {'Title': title, 'mode' : PLAY_VIDEO_MODE, 'url': link, 'Thumb': self.main.args.icon }
					if self.main.args.__dict__.has_key('icon2'):
						info['Thumb'] = self.main.args.icon2
					listItems.append(info)
					__addSingleItem(info, total)
		
		def __addSingleItem(item, total):
			if item.has_key('no-url'):
				self.addItem(info=item, total_items=total)
			else:
				self.addItem(info=item, isFolder=False, total_items=total, addDownloadAction=True)	
		
		self.__getFromCache(main, __showEpisodes, __addSingleItem, dontAddToHierarchy)

	def loginToUnlock(self, main, refererMethod, *extraArgs):
		
		def __openLoginDialog(line1, line2="", line3=""):
			self.resp = xbmcgui.Dialog().yesno(line1, line2, line3)
			if self.resp:
				__settings__.openSettings()
			return not self.resp
				
		if __settings__.getSetting('username') == '' or __settings__.getSetting('password') == '':
			__openLoginDialog(lang(30040), lang(30041), lang(30042))
			removeCookie = False
		elif __settings__.getSetting('username') != __settings__.getSetting('prev_username') or __settings__.getSetting('password') != __settings__.getSetting('prev_password'):
			removeCookie = True
		else:
			removeCookie = False
		
		status = self.browser.login(__settings__, __site_url__ + 'index.php?module=connection', removeCookie)
		if not status:
			stopAskingMe = False
			while not status:
				stopAskingMe = __openLoginDialog(lang(30043), lang(30044))
				if stopAskingMe:
					break
				status = self.browser.login(__settings__, __site_url__ + 'index.php?module=connection', removeCookie)
			
		cachefilepath = os.path.join(cache_dir, md5.new(main.args.url).hexdigest())
		if os.path.exists(cachefilepath):
			os.remove(cachefilepath)
		if extraArgs:
			refererMethod(main, extraArgs[0])
		else:
			refererMethod(main)

	def playVideo(self, main, stop = False):
		
		def __playVideo(link,  title):
			debug("title = %s, link = %s" % (title, link))
			folderName = os.path.sep.join([__settings__.getSetting('download_path'), join(title.split(':')[:-1])]) 
			filename = os.path.sep.join([folderName, link.split('/')[-1:][0]])
			if os.path.exists(filename):
				item = xbmcgui.ListItem(label=title, label2=title, path=filename, iconImage=main.args.icon, thumbnailImage=main.args.icon)
				xbmcplugin.setResolvedUrl(handle=int(sys.argv[1]), succeeded=True, listitem=item)
			else:
				item = xbmcgui.ListItem(label=title, label2=title, path=link, iconImage=main.args.icon, thumbnailImage=main.args.icon)
				xbmcplugin.setResolvedUrl(handle=int(sys.argv[1]), succeeded=True, listitem=item)
		
		self.parseEpisode(main, __playVideo, self.playVideo, stop)
	
	def downloadAnime(self, main, stop = False):
		
		def __downloadFile(link,  title):
			folderName = os.path.sep.join([__settings__.getSetting('download_path'), join(title.split(':')[:-1])]) 
			if not os.path.exists(folderName):
				os.makedirs(folderName)
			filename = os.path.sep.join([folderName, link.split('/')[-1:][0]])
			debug("filename = %s, link = %s" % (filename, link))
			self.browser.downloadFile(link, filename)
		
		self.parseEpisode(main, __downloadFile, self.downloadAnime, stop)
		
	def parseEpisode(self, main, __handleLink, __afterLoginAction, stop = False):
		vidHtml = self.browser.downloadHTML(main.args.url)
		soup = BeautifulSoup(vidHtml)
		lecteurFlash = soup.find('div', attrs={'id':'lecteurFlash'})
		if lecteurFlash:
			jsWithVidLink = lecteurFlash.find('script', attrs={'type':'text/javascript'}).find(text=True)
			m = re.search('url: \'(.+?)\',', jsWithVidLink)
			if m is None:
				dialog = xbmcgui.Dialog()
				dialog.ok("Mangas-TV.com", lang(30038))
				xbmcplugin.endOfDirectory(handle=int(sys.argv[1]), succeeded=False)
			else:
				link = m.group(1)
				title = soup.find('div', attrs={'id':'lecteur'}).h2.string
				__handleLink(link, title)
		elif stop:
			pass
		else:
			self.loginToUnlock(main, __afterLoginAction, True)
			
	def cleanCache(self):
		if os.path.exists(cache_dir):
			shutil.rmtree(cache_dir)
		
	def addItem(self, info, extrainfo=None, isFolder=True, total_items=0, addDownloadAction=False):
		#Defaults in dict. Use 'None' instead of None so it is compatible for quote_plus in parseArgs
		info.setdefault('url', 'None')
		info.setdefault('Thumb', 'None')
		info.setdefault('id', 'None')
		info.setdefault('category', 'None')
		info.setdefault('referer', 'None')
		info.setdefault('Icon', info['Thumb'])
		#create params for xbmcplugin module 
		baseurl = sys.argv[0] + \
			'?url=' + urllib.quote_plus(info['url']) + \
			'&id=' + urllib.quote_plus(info['id']) + \
			'&category=' + urllib.quote_plus(info['category']) + \
			'&referer=' + urllib.quote_plus(info['referer']) + \
			'&icon=' + urllib.quote_plus(info['Thumb'])
		u = baseurl + '&mode=' + urllib.quote_plus(info['mode'])
		if info.has_key('icon2'):
			u = u + "&icon2=" + urllib.quote_plus(info['icon2'])
		#create list item
		li = xbmcgui.ListItem(label=unescapeHTMLchar(info['Title']), iconImage=info['Thumb'], thumbnailImage=info['Thumb'])
		
		if extrainfo != None:
			extra = { "Title":unescapeHTMLchar(extrainfo['name']), "Plot":unescapeHTMLchar(extrainfo['plot']), "Genre":unescapeHTMLchar(extrainfo['genre']), 'Rating':extrainfo['rating']}
			if extrainfo.has_key('nbepisodes'):
				extra['Episode'] = int(extrainfo['nbepisodes'])

			li.setInfo(type="Video", infoLabels=extra)
		
		if not isFolder:
			li.setProperty("IsPlayable", "true")#let xbmc know this can be played, unlike a folder.
		else:
			li.setProperty("IsPlayable", "false")
		cleanCacheUrl = sys.argv[0] + "?mode=" + CLEAN_CACHE_MODE

		ctxMenu = [(lang(30047), 'XBMC.RunPlugin(%s)' % cleanCacheUrl)]		
		if addDownloadAction is True:
			downloadAnimeURL = baseurl + "&mode=%s" % DOWNLOAD_ANIME_MODE
			ctxMenu.append((lang(30048), 'XBMC.RunPlugin(%s)' % downloadAnimeURL))
			
		li.addContextMenuItems(ctxMenu)
		
		debug("url = %s" % u)
		#add item to list
		xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=li, isFolder=isFolder, totalItems=total_items)

	def mostViewed(self, main):
		self.showAnimeSeries(main)
		
	def promoted(self, main):
		self.showAnimeSeries(main)
	
	def endofdirectory(self, sortMethod='none', dontAddToHierarchy = False):
		# set sortmethod to something xbmc can use
		if sortMethod == 'title':
			xbmcplugin.addSortMethod(int(sys.argv[1]), xbmcplugin.SORT_METHOD_LABEL)
			xbmcplugin.addSortMethod(int(sys.argv[1]), xbmcplugin.SORT_METHOD_VIDEO_RATING)
			xbmcplugin.addSortMethod(int(sys.argv[1]), xbmcplugin.SORT_METHOD_GENRE)
		elif sortMethod == 'none':
			xbmcplugin.addSortMethod(int(sys.argv[1]), xbmcplugin.SORT_METHOD_NONE)

		xbmcplugin.endOfDirectory(handle=int(sys.argv[1]), updateListing=dontAddToHierarchy, cacheToDisc=True)

class Main:

	args = None

	def __init__(self, checkMode=True):
		info(sys.argv)
		self.parseArgs()
		if checkMode:
			self.checkMode()

	def parseArgs(self):
		if (sys.argv[2]):
			argsDict = {}
			listParams = sys.argv[2][1:].split('&')
			debug('Parameter list: %s ' % str(listParams))
			for paramPair in listParams:
				key, value = paramPair.split('=')
				argsDict[str(key)] = str(value)
			self.args = UpdateArgs(argsDict)
		else:
			self.args = UpdateArgs({'mode': 'None', 'url': 'None', 'name' : 'None'})

	def checkMode(self):
		mode = self.args.mode
		if mode is None:
			UI().welcomePage()
		elif mode == CATEGORIE_LIST_MODE:
			UI().showCategories(self)
		elif mode == MOST_VIEWED_MODE:
			UI().mostViewed(self)
		elif mode == ANIME_LIST_MODE:
			UI().showAnimeSeries(self)
		elif mode == PROMOTED_LIST_MODE:
			UI().promoted(self)
		elif mode == SEARCH_MODE:
			UI().search(self)
		elif mode == SHOW_EPISODES_MODE:
			UI().showEpisodes(self)
		elif mode == PLAY_VIDEO_MODE:
			UI().playVideo(self)
		elif mode == LOGIN_TO_UNLOCK_MODE:
			ui = UI()
			ui.loginToUnlock(self, ui.showEpisodes, True)
		elif mode == CLEAN_CACHE_MODE:
			UI().cleanCache()
		elif mode == DOWNLOAD_ANIME_MODE:
			UI().downloadAnime(self)
		
