'''
    Copyright (C) 2014-2016 ddurdle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


'''



from BaseHTTPServer import BaseHTTPRequestHandler,HTTPServer

from SocketServer import ThreadingMixIn
import threading
import re
import urllib, urllib2
import sys
import socket
import string
import random

import constants
from resources.lib import engine
from resources.libgui import xbmcplugin
from resources.libgui import settingsdbm


if constants.CONST.DEBUG:

    #debugging
    import hashlib

def id_generator(size=6, chars=string.ascii_uppercase + string.digits):
    return ''.join(random.choice(chars) for _ in range(size))

class ThreadedWebGUIServer(ThreadingMixIn, HTTPServer):
    """Handle requests in a separate thread."""

class WebGUIServer(ThreadingMixIn,HTTPServer):

    def __init__(self, *args, **kw):
        HTTPServer.__init__(self, *args, **kw)
        self.ready = True
        import constants
        self.addon = constants.addon
        self.hide = False
        self.keyvalue = False
        self.saltfile = None
        self.cryptoSalt = None
        self.cryptoPassword = None
        self.logins = {}

    def run(self):
        try:
            self.serve_forever()
        except KeyboardInterrupt:
            pass
        finally:
            # Clean-up server (close socket, etc.)
            self.server_close()

    # set port
    def setPort(self, port):
        self.port = port

    # set DBM
    def setDBM(self, dbm=None):
        if dbm is not None:
            self.dbm = settingsdbm.settingsdbm(dbm)
        else:
            self.dbm.reset()

        # login password?
        try:
            self.username = self.dbm.getSetting('username')
            self.password = self.dbm.getSetting('password')
        except:
            self.username = None
            self.password = None

        try:
            if self.dbm.getSetting('hide') == 'true' and self.password != None:
                self.hide = True
            else:
                self.hide = False
            if self.dbm.getSetting('keyvalue') == 'true':
                self.keyvalue = True
            else:
                self.keyValue = False
        except: pass


        try:
            from resources.lib import encryption

            try:
                self.saltfile = self.dbm.getSetting('saltfile', default='saltfile')
            except:
                self.saltfile = 'saltfile'
                print "No saltfile set, using file \'" + self.saltfile + "\' instead."

            self.encrypt = encryption.encryption(self.saltfile,self.password)
        except:
            self.encrypt = None


        try:
            self.cryptoSalt = self.dbm.getSetting('crypto_salt')
            self.cryptoPassword = self.dbm.getSetting('crypto_password')
        except: pass



class webGUI(BaseHTTPRequestHandler):


    #Handler for the GET requests
    def do_POST(self):




        decryptkeyvalue = self.path
        if re.search(r'kv\=', str(self.path)):
            from resources.lib import encryption

            results = re.search(r'kv\=(.*)$', str(self.path))
            if results:
                keyvalue = str(results.group(1))
                decryptkeyvalue = '/' + self.server.encrypt.decryptString(keyvalue).strip()
                print decryptkeyvalue +"."


        # debug - print headers in log
        headers = str(self.headers)
        print(headers)

        isLoggedIn = self.cookieLogin(self.headers)


        # passed a kill signal?
        if decryptkeyvalue == '/kill':
            if not isLoggedIn and self.server.username is not None:
                content_length = int(self.headers['Content-Length']) # <--- Gets the size of data
                post_data = self.rfile.read(content_length) # <--- Gets the data itself
                #print post_data

                self.send_response(200)
                self.end_headers()
                username = ''
                password = ''
                for r in re.finditer('username\=([^\&]+)' ,
                         post_data, re.DOTALL):
                    username = r.group(1)
                for r in re.finditer('password\=([^\&]+)' ,
                         post_data, re.DOTALL):
                    password = r.group(1)
                if self.server.username == username and self.server.password == password:
                    self.wfile.write("Stopping server...")
                    self.server.ready = False
                    print "Stopping server...\n"
                else:
                    self.wfile.write("Wrong username/password")


            else:
                self.send_response(200)
                self.end_headers()
                self.wfile.write("Stopping server...")
                self.server.ready = False
                print "Stopping server...\n"
            return


        # redirect url to output
        elif re.search(r'/default.py\?mode\=enroll\&default\=false', str(decryptkeyvalue)):
            content_length = int(self.headers['Content-Length']) # <--- Gets the size of data
            post_data = self.rfile.read(content_length) # <--- Gets the data itself
            self.send_response(200)
            self.end_headers()

            for r in re.finditer('client_id\=([^\&]+)\&\client_secret\=([^\&]+)' ,
                     post_data, re.DOTALL):
                client_id = r.group(1)
                client_secret = r.group(2)


                self.wfile.write('<html><body>Two steps away.<br/><br/>  1) Visit this site and then paste the application code in the below form: <a href="https://accounts.google.com/o/oauth2/auth?scope=https://www.googleapis.com/auth/drive&redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=code&client_id='+str(client_id)+'" target="new">Google Authentication</a><br /><br />2) Return back to this tab and provide a nickname and the application code provided in step 1. <form action="/default.py?mode=enroll" method="post">Nickname for account:<br /><input type="text" name="account"><br />Code (copy and paste from step 1):<br /><input type="text" name="code"><br /><form action="default.py?mode=enroll" method="post">Client ID:<br /><input type="text" name="client_id" value="'+str(client_id)+'"><br />Client Secret:<br /><input type="text" name="client_secret" value="'+str(client_secret)+'"><br /><br /> <input type="submit" value="Submit"></form></body></html>')

        # redirect url to output
        elif re.search(r'/save_settings', str(decryptkeyvalue)):
            content_length = int(self.headers['Content-Length']) # <--- Gets the size of data
            post_data = self.rfile.read(content_length) # <--- Gets the data itself
            self.send_response(200)
            self.end_headers()
            print post_data

            for r in re.finditer('\&?([^\=]+)\=([^\&]+)' ,
                     post_data, re.DOTALL):
                key = r.group(1)
                value = r.group(2)
                value = value.replace("%2F",'/')
                value = value.replace("%3F",'?')
                value = value.replace("%26",'&')
                value = value.replace("%5c",'\\')
                value = value.replace("%24",'$')
                value = value.replace("%3A",':')
                value = value.replace('passwrd','password')



                print "saving key, value " + str(key) +str(value)+ "\n"
                self.server.dbm.setSetting(key,value)

            self.wfile.write('<html><body>Changes saved.  You must restart the service or click <a href="/reload">reload</a> to make the changes take in effect.</body></html>')

        elif re.search(r'/settings', str(decryptkeyvalue)):

            if not isLoggedIn and self.server.username is not None:
                content_length = int(self.headers['Content-Length']) # <--- Gets the size of data
                post_data = self.rfile.read(content_length) # <--- Gets the data itself
                #print post_data

                username = ''
                password = ''
                for r in re.finditer('username\=([^\&]+)' ,
                         post_data, re.DOTALL):
                    username = r.group(1)
                for r in re.finditer('password\=([^\&]+)' ,
                         post_data, re.DOTALL):
                    password = r.group(1)
                if not (self.server.username == username and self.server.password == password):
                    self.send_response(200)
                    self.end_headers()
                    self.wfile.write("Wrong username/password")
                    return
            self.send_response(200)
            self.end_headers()

            self.displaySettings()


        # redirect url to output
        elif  re.search(r'/default.py\?mode\=enroll', str(decryptkeyvalue)):
            content_length = int(self.headers['Content-Length']) # <--- Gets the size of data
            post_data = self.rfile.read(content_length) # <--- Gets the data itself
            for r in re.finditer('account\=([^\&]+)\&code=([^\&]+)\&\client_id\=([^\&]+)\&\client_secret\=([^\&]+)' ,
                     post_data, re.DOTALL):
                account = r.group(1)
                client_id = r.group(3)
                client_secret = r.group(4)
                code = r.group(2)
                code = code.replace('%2F','/')


                count = 1
                loop = True
                while loop and count < 10:
                    instanceName = constants.PLUGIN_NAME +str(count)
                    try:
                        username = self.server.addon.getSetting(instanceName+'_username')
                    except:
                        username = None

                    print "USERNAME " + str(username) + "\n"
                    if username == account or username is None:
                        self.server.addon.setSetting(instanceName + '_type', str(3))
                        self.server.addon.setSetting(instanceName + '_code', str(code))
                        self.server.addon.setSetting(instanceName + '_client_id', str(client_id))
                        self.server.addon.setSetting(instanceName + '_client_secret', str(client_secret))
                        self.server.addon.setSetting(instanceName + '_username', str(account))
                        loop = False

                    count = count + 1

                results = re.search(r'\?(.*)$', str(decryptkeyvalue))
                if results:
                    query = str(results.group(1))


                url = 'https://accounts.google.com/o/oauth2/token'
                header = { 'User-Agent' : self.server.addon.getSetting('user_agent')  , 'Content-Type': 'application/x-www-form-urlencoded'}

                req = urllib2.Request(url, 'code='+str(code)+'&client_id='+str(client_id)+'&client_secret='+str(client_secret)+'&redirect_uri=urn:ietf:wg:oauth:2.0:oob&grant_type=authorization_code', header)


                # try login
                try:
                    response = urllib2.urlopen(req)
                except urllib2.URLError, e:
                    if e.code == 403:
                        #login issue
                        self.send_response(200)
                        self.end_headers()
                        self.wfile.write(str(e))
                        return
                    else:
                        self.send_response(200)
                        self.end_headers()
                        self.wfile.write(str(e))
                    return


                response_data = response.read()
                response.close()

                # retrieve authorization token
                for r in re.finditer('\"access_token\"\s?\:\s?\"([^\"]+)\".+?' +
                                 '\"refresh_token\"\s?\:\s?\"([^\"]+)\".+?' ,
                                 response_data, re.DOTALL):
                    accessToken,refreshToken = r.groups()
                    self.server.addon.setSetting(instanceName + '_auth_access_token', str(accessToken))
                    self.server.addon.setSetting(instanceName + '_auth_refresh_token', str(refreshToken))

                    mediaEngine = engine.contentengine()
                    mediaEngine.run(self,  DBM=self.server.dbm, addon=self.server.addon)


                for r in re.finditer('\"error_description\"\s?\:\s?\"([^\"]+)\"',
                                 response_data, re.DOTALL):
                    errorMessage = r.group(1)
                    self.send_response(200)
                    self.end_headers()
                    self.wfile.write(errorMessage)

                return


        elif decryptkeyvalue == '/list' or decryptkeyvalue == '/':

            if not isLoggedIn and self.server.username is not None:
                content_length = int(self.headers['Content-Length']) # <--- Gets the size of data
                post_data = self.rfile.read(content_length) # <--- Gets the data itself
                #print post_data

                username = ''
                password = ''
                for r in re.finditer('username\=([^\&]+)' ,
                         post_data, re.DOTALL):
                    username = r.group(1)
                for r in re.finditer('password\=([^\&]+)' ,
                         post_data, re.DOTALL):
                    password = r.group(1)
                if self.server.username == username and self.server.password == password:
                    loginSession =  id_generator(size=10)
                    self.send_response(200)
                    self.send_header('Set-Cookie', 'login='+str(loginSession))
                    self.server.logins[loginSession] = 1
                    mediaEngine = engine.contentengine()
                    mediaEngine.run(self, DBM=self.server.dbm, addon=self.server.addon)
                else:
                    self.send_response(200)
                    self.end_headers()
                    self.wfile.write("Wrong username/password")

            else:
                mediaEngine = engine.contentengine()
                mediaEngine.run(self, DBM=self.server.dbm, addon=self.server.addon)



        # redirect url to output
        elif self.path == '/enroll?default=false':
            content_length = int(self.headers['Content-Length']) # <--- Gets the size of data
            post_data = self.rfile.read(content_length) # <--- Gets the data itself
            self.send_response(200)
            self.end_headers()

            for r in re.finditer('client_id\=([^\&]+)\&\client_secret\=([^\&]+)' ,
                     post_data, re.DOTALL):
                client_id = r.group(1)
                client_secret = r.group(2)


                self.wfile.write('<html><body>Two steps away.<br/><br/>  1) Visit this site and then paste the application code in the below form: <a href="https://accounts.google.com/o/oauth2/auth?scope=https://www.googleapis.com/auth/drive&redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=code&client_id='+str(client_id)+'" target="new">Google Authentication</a><br /><br />2) Return back to this tab and provide a nickname and the application code provided in step 1. <form action="/enroll" method="post">Nickname for account:<br /><input type="text" name="account"><br />Code (copy and paste from step 1):<br /><input type="text" name="code"><br /><form action="/enroll" method="post">Client ID:<br /><input type="text" name="client_id" value="'+str(client_id)+'"><br />Client Secret:<br /><input type="text" name="client_secret" value="'+str(client_secret)+'"><br /><br /> <input type="submit" value="Submit"></form></body></html>')


        # redirect url to output
        elif self.path == '/enroll':
            content_length = int(self.headers['Content-Length']) # <--- Gets the size of data
            post_data = self.rfile.read(content_length) # <--- Gets the data itself
            self.send_response(200)
            self.end_headers()
            for r in re.finditer('account\=([^\&]+)\&code=([^\&]+)\&\client_id\=([^\&]+)\&\client_secret\=([^\&]+)' ,
                     post_data, re.DOTALL):
                account = r.group(1)
                client_id = r.group(3)
                client_secret = r.group(4)
                code = r.group(2)
                code = code.replace('%2F','/')

                #self.wfile.write('<html><body>account = '+ str(account) + " " + str(client_id) + " " + str(client_secret) + " " + str(code))

                count = 1
                loop = True
                while loop:
                    instanceName = constants.PLUGIN_NAME +str(count)
                    try:
                        username = constants.addon.settings.getSetting(instanceName+'_username')
                    except:
                        username = ''

                    if username == account or username == '':
                        constants.addon.setSetting(instanceName + '_type', str(3))
                        constants.addon.setSetting(instanceName + '_code', str(code))
                        constants.addon.setSetting(instanceName + '_client_id', str(client_id))
                        constants.addon.setSetting(instanceName + '_client_secret', str(client_secret))
                        constants.addon.setSetting(instanceName + '_username', str(account))
                        loop = False

                    count = count + 1



                url = 'https://accounts.google.com/o/oauth2/token'
                header = { 'User-Agent' : constants.addon.getSetting('user_agent')  , 'Content-Type': 'application/x-www-form-urlencoded'}

                req = urllib2.Request(url, 'code='+str(code)+'&client_id='+str(client_id)+'&client_secret='+str(client_secret)+'&redirect_uri=urn:ietf:wg:oauth:2.0:oob&grant_type=authorization_code', header)


                # try login
                try:
                    response = urllib2.urlopen(req)
                except urllib2.URLError, e:
                    if e.code == 403:
                        #login issue
                        self.send_response(200)
                        self.end_headers()
                        self.wfile.write(str(e))
                        return
                    else:
                        self.send_response(200)
                        self.end_headers()
                        self.wfile.write(str(e))
                    return


                response_data = response.read()
                response.close()

                # retrieve authorization token
                for r in re.finditer('\"access_token\"\s?\:\s?\"([^\"]+)\".+?' +
                                 '\"refresh_token\"\s?\:\s?\"([^\"]+)\".+?' ,
                                 response_data, re.DOTALL):
                    accessToken,refreshToken = r.groups()
                    constants.addon.setSetting(instanceName + '_auth_access_token', str(accessToken))
                    constants.addon.setSetting(instanceName + '_auth_refresh_token', str(refreshToken))

                    self.wfile.write('Successfully enrolled account.')
                    self.server.ready = False


                for r in re.finditer('\"error_description\"\s?\:\s?\"([^\"]+)\"',
                                 response_data, re.DOTALL):
                    errorMessage = r.group(1)
                    self.wfile.write(errorMessage)


                return


        # redirect url to output
        elif re.search(r'/play.py', str(decryptkeyvalue)):

            print "TRYING TO SEEK WITH POSR REQUEST\n\n\n"


    def do_HEAD(self):

        # debug - print headers in log
        headers = str(self.headers)
        print(headers)


        print "HEAD HEAD HEAD\n\n"

        # passed a kill signal?
        if self.path == '/kill':
#            self.server.ready = False
            return



        # redirect url to output
        elif re.search(r'/play.py', str(self.path)):

            print "TRYING TO SEEK WITH HEAD REQUEST\n\n\n"


    #Handler for the GET requests
    def do_GET(self):

        decryptkeyvalue = self.path
        if re.search(r'kv\=', str(self.path)):
            from resources.lib import encryption

            results = re.search(r'kv\=(.*)$', str(self.path))
            if results:
                keyvalue = str(results.group(1))
                decryptkeyvalue = '/' + self.server.encrypt.decryptString(keyvalue).strip()
                print decryptkeyvalue +"."



        # debug - print headers in log
        headers = str(self.headers)
        print(headers)


        isLoggedIn = self.cookieLogin(self.headers)

        start = ''
        end = ''
        startOffset = 0
        for r in re.finditer('Range\:\s+bytes\=(\d+)\-' ,
                     headers, re.DOTALL):
          start = int(r.group(1))
          break
        for r in re.finditer('Range\:\s+bytes\=\d+\-(\d+)' ,
                     headers, re.DOTALL):
          end = int(r.group(1))
          break


        # passed a kill signal?
        if decryptkeyvalue == '/kill':
            self.send_response(200)
            self.end_headers()
            if self.server.username is not None:
                self.wfile.write('<html><form action="/kill" method="post">Username: <input type="text" name="username"><br />Password: <input type="password" name="password"><br /><input type="submit" value="Stop Server"></form></html>')
            else:
                self.wfile.write('<html><form action="/kill" method="post"><input type="submit" value="Stop Server"></form></html>')

            #self.server.ready = False
            return


        # redirect url to output
        elif  re.search(r'/default.py\?mode\=enroll\&default\=true', str(decryptkeyvalue)):# or  re.search(r'/default.py\?mode\=enroll', str(decryptkeyvalue)):

            self.send_response(200)
            self.end_headers()

            self.wfile.write('<html><body>Two steps away.<br/><br/>  1) Visit this site and then paste the application code in the below form: <a href="https://accounts.google.com/o/oauth2/auth?scope=https://www.googleapis.com/auth/drive&redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=code&client_id=772521706521-bi11ru1d9h40h1lipvbmp3oddtcgro14.apps.googleusercontent.com" target="new">Google Authentication</a><br /><br />2) Return back to this tab and provide a nickname and the application code provided in step 1. <form action="default.py?mode=enroll" method="post">Nickname for account:<br /><input type="text" name="account"><br />Code (copy and paste from step 1):<br /><input type="text" name="code"><br /><form action="default.py?mode=enroll" method="post">Client ID:<br /><input type="hidden" name="client_id" value="772521706521-bi11ru1d9h40h1lipvbmp3oddtcgro14.apps.googleusercontent.com"><br />Client Secret:<br /><input type="hidden" name="client_secret" value="PgteSoD4uagqHA1_nLERLDx9"><br /><br /></br /> <input type="submit" value="Submit"></form></body></html>')
            return

        # redirect url to output
        elif  re.search(r'/default.py\?mode\=enroll', str(decryptkeyvalue)):

            self.send_response(200)
            self.end_headers()

            self.wfile.write('<html><body>Do you want to use a default client id / client secret or your own client id / client secret?  If you don\'t know what this means, select DEFAULT.<br /> <a href="default.py?mode=enroll&default=true">use default client id / client secret (DEFAULT)</a> <br /><br />OR use your own client id / client secret<br /><br /><form action="default.py?mode=enroll&default=false" method="post">Client ID:<br /><input type="text" name="client_id" value=""><br />Client Secret:<br /><input type="text" name="client_secret" value=""> <br/><input type="submit" value="Submit"></form></body></html>')
            return

        elif  re.search(r'/default.py\?mode\=enroll\&default\=false', str(decryptkeyvalue)):

            self.send_response(200)
            self.end_headers()

            self.wfile.write('<html><body>Two steps away.<br/><br/>  1) Visit this site and then paste the application code in the below form: <a href="https://accounts.google.com/o/oauth2/auth?scope=https://www.googleapis.com/auth/drive&redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=code&client_id=772521706521-bi11ru1d9h40h1lipvbmp3oddtcgro14.apps.googleusercontent.com" target="new">Google Authentication</a><br /><br />2) Return back to this tab and provide a nickname and the application code provided in step 1. <form action="default.py?mode=enroll" method="post">Nickname for account:<br /><input type="text" name="account"><br />Code (copy and paste from step 1):<br /><input type="text" name="code"><br /><br /> <input type="submit" value="Submit"></form></body></html>')
            return


        elif  re.search(r'/settings', str(decryptkeyvalue)):
            self.send_response(200)
            self.end_headers()
            if not isLoggedIn and self.server.username is not None:
                self.wfile.write('<html><form action="/settings" method="post">Username: <input type="text" name="username"><br />Password: <input type="password" name="password"><br /><input type="submit" value="Login"></form></html>')
            else:
                self.displaySettings()

            #self.server.ready = False
            return


        elif  re.search(r'/test', str(decryptkeyvalue)):
            self.send_response(307)
            self.send_header('Location', '')
            self.end_headers()
            return


        elif decryptkeyvalue == '/list' or decryptkeyvalue == '/':
            if not isLoggedIn and self.server.username is not None:
                self.send_response(200)
                self.end_headers()
                self.wfile.write('<html><form action="/list" method="post">Username: <input type="text" name="username"><br />Password: <input type="password" name="password"><br /><input type="submit" value="Login"></form></html>')
            else:
                mediaEngine = engine.contentengine()
                mediaEngine.run(self, DBM=self.server.dbm, addon=self.server.addon)

            #self.server.ready = False
            return

        elif decryptkeyvalue == '/reload':
            self.server.setDBM()
            self.send_response(200)
            self.end_headers()
            if self.server.username is not None:
                self.wfile.write('<html><form action="/list" method="post">Username: <input type="text" name="username"><br />Password: <input type="password" name="password"><br /><input type="submit" value="Login"></form></html>')
            else:
                self.wfile.write('<html><form action="/list" method="post"><input type="submit" value="Login"></form></html>')

            #self.server.ready = False
            return





        # redirect url to output
        elif re.search(r'/play', str(decryptkeyvalue)):
#            self.send_response(200)
#            self.end_headers()
            count = 0
            isEncrypted = False
            results = re.search(r'/play\?count\=(\d+)\&encrypted\=true$', str(decryptkeyvalue))
            #encrypted stream
            if results:
                count = int(results.group(1))
                isEncrypted = True
            #not encrypted stream
            else:
                results = re.search(r'/play\?count\=(\d+)$', str(decryptkeyvalue))
                if results:
                    count = int(results.group(1))

            #self.send_response(200)
            #self.end_headers()
            #xbmcplugin.assignOutputBuffer(self.wfile)
            #cookies = self.headers['Cookie']
            cookie = xbmcplugin.playbackBuffer.playback[count]['cookie']
            url = xbmcplugin.playbackBuffer.playback[count]['url']
            auth = xbmcplugin.playbackBuffer.playback[count]['auth']
            auth = auth.replace("+",' ')

            length=0
            try:
                length = xbmcplugin.playbackBuffer.playback[count]['length']
            except:
                length = 0
                start= ''

            endOffset = 0
            startOffset = 0
            specialEnd = 0

            if isEncrypted:

                from resources.lib import  encryption
                decrypt = encryption.encryption(self.server.cryptoSalt,self.server.cryptoPassword)

                try:
                    if xbmcplugin.playbackBuffer.playback[count]['length'] == -1:
                        return
                except:
                    #for encrypted streams
                    # need to fetch the last 16 bytes to calculate unpadded size
                    if isEncrypted:
                        req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth})
                        try:
                            response = urllib2.urlopen(req)
                        except urllib2.URLError, e:
                            if e.code == 403 or e.code == 401:
                                print "STILL ERROR"+str(e.code)+"\n"
                                return
                            else:
                                return
                        response.close()
                        xbmcplugin.playbackBuffer.playback[count]['length'] =  response.info().getheader('Content-Length')

                        req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth, 'Range': 'bytes='+str(int(xbmcplugin.playbackBuffer.playback[count]['length']) - 16 - 8 )+'-'})
                        try:
                            response = urllib2.urlopen(req)
                        except urllib2.URLError, e:
                            if e.code == 403 or e.code == 401:
                                print "STILL ERROR"+str(e.code)+"\n"
                                return
                            else:
                                return
                        CHUNK = 16 * 1024

                        #originalSize = decrypt.decryptCalculateSizing(response)
                        #print "size " + response.info().getheader('Content-Length') + ' vs ' + str(originalSize) + "\n"
                        #return
                        finalChunkDifference = decrypt.decryptCalculatePadding(response,chunksize=CHUNK)
                        #xbmcplugin.playbackBuffer.playback[count]['length'] = int(xbmcplugin.playbackBuffer.playback[count]['length']) - finalChunkDifference
                        xbmcplugin.playbackBuffer.playback[count]['decryptedlength'] = int(xbmcplugin.playbackBuffer.playback[count]['length']) - finalChunkDifference - 8
                        newEnd = int(xbmcplugin.playbackBuffer.playback[count]['length'])- 1
                        returnLength = int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])

                        if constants.CONST.DEBUG:
                            print "FINAL CHUNK SIZE DIFFERENCE " + str(finalChunkDifference) + "\n"
                            print "length " +  str(xbmcplugin.playbackBuffer.playback[count]['length']) + "\n"
                            print "decryptedlength " +  str(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']) + "\n"

                        response.close()



                #
                # 1) start > 16 bytes, back up to nearest whole chunk of 16
                if ((start != '' and start > 16) and (end == '' or end == int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])-1 )): # or end == (len -1)
                    newEnd = int(xbmcplugin.playbackBuffer.playback[count]['length'])-1
                    offset = (16-(newEnd - start + 8 +1) % 16)
                    newStart = start - offset + 8#0
                    returnLength = int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']) - start
                    skip = 0
                    adjStart = offset #+8
                    adjEnd = 0
                    if constants.CONST.DEBUG:
                        print "[3] S=" + str(start) + ', E=' + str(end) + ', S*='+str(newStart)+ '('+str(adjStart)+') , offset=' +str(offset)+ ' , E*=' +str(newEnd) +'('+str(adjEnd)+'), returnLength='+str(returnLength)+"\n"
                # 2) start = 0, fetch all, return all
                elif ( start == 0 and end != '' and end == int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])-1 ):
                    finalChunkDifference = int(xbmcplugin.playbackBuffer.playback[count]['length']) - int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])
                    newStart = 8 #=0
                    newEnd = int(xbmcplugin.playbackBuffer.playback[count]['length']) -1
                    returnLength = int(xbmcplugin.playbackBuffer.playback[count]['length']) - finalChunkDifference - 8
                    offset = 0
                    adjStart = 0
                    adjEnd = 0
                    if constants.CONST.DEBUG:
                        print "[2] S=" + str(start) + ', E=' + str(end) + ', S*='+str(newStart)+ '('+str(adjStart)+') , offset=' +str(offset)+ ' , E*=' +str(newEnd) +'('+str(adjEnd)+'), returnLength='+str(returnLength)+"\n"
                # staart = 0, end < length -1
                elif ( start == 0 and end > 16 and end <= int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])-1 ):
                    newStart = 8#0
                    offset = (16 - (end - newStart + 1)%16)
                    newEnd = end + offset # +8
                    returnLength = end - start + 1
                    #skip = 8
                    adjStart = 0
                    adjEnd = offset#+8
                    if constants.CONST.DEBUG:
                        print "[4] S=" + str(start) + ', E=' + str(end) + ', S*='+str(newStart)+ '('+str(adjStart)+') , offset=' +str(offset)+ ' , E*=' +str(newEnd) +'('+str(adjEnd)+'), returnLength='+str(returnLength)+"\n"

                #s > 0 e < len -1
                elif (start != '' and start > 16 and end <= int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])-1 ):

                    newStart = start - (start%16) + 8
                    #newStart = start + 8
                    #offset = 16 - (end  - start + 1)%16
                    #newEnd = end + offset + 8
                    newEnd = end + (16- (end%16)) + 8 -1
                    #if newEnd > int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])-1:
                    #    newEnd = end + 8
                    #    newStart = start - offset + 8
                    #    adjStart = offset
                    #    adjEnd = 0
                    #else:
                    #    adjStart = 0
                    #    adjEnd = offset
                    adjStart = start%16
                    adjEnd = 16 - end%16 -1
                    offset = 0
                    returnLength = end - start + 1
                    if constants.CONST.DEBUG:
                        print "[5] S=" + str(start) + ', E=' + str(end) + ', S*='+str(newStart)+ '('+str(adjStart)+') , offset=' +str(offset)+ ' , E*=' +str(newEnd) +'('+str(adjEnd)+'), returnLength='+str(returnLength)+"\n"
                # special case - end < 16 (such as first 2 bytes (apple)
                elif (end < 16):
                    newStart = 8#0
                    newEnd = 15 + 8
                    returnLength = 2
                    adjStart = 0#8
                    adjEnd = 14
                    offset = 0
                    if constants.CONST.DEBUG:
                        print "[1] S=" + str(start) + ', E=' + str(end) + ', S*='+str(newStart)+ '('+str(adjStart)+') , offset=' +str(offset)+ ' , E*=' +str(newEnd) +'('+str(adjEnd)+'), returnLength='+str(returnLength)+"\n"
              #  elif start == "":
              #      newStart = 8#0
              #      adjStart = 0#8
              #      adjEnd = 0
              #      offset = 0
              #      print "[0] S=" + str(start) + ', E=' + str(end) + ', S*='+str(newStart)+ '('+str(adjStart)+') , offset=' +str(offset)+ ", E*=TBD, returnLength=TBD\n"

                else:
                    newStart = 8#0
                    newEnd = int(xbmcplugin.playbackBuffer.playback[count]['length'])- 1
                    returnLength = int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])
                    adjStart = 0#8
                    adjEnd = 0
                    offset = 0
                    if constants.CONST.DEBUG:
                        print "[0] S=" + str(start) + ', E=' + str(end) + ', S*='+str(newStart)+ '('+str(adjStart)+') , offset=' +str(offset)+ ' , E*=' +str(newEnd) +'('+str(adjEnd)+'), returnLength='+str(returnLength)+"\n"


            if start == '' and not isEncrypted:
#                req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth})
                req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth})
            elif isEncrypted:
                req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth, 'Range': 'bytes='+str(newStart)+'-' + str(newEnd)})
            else:
                req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth, 'Range': 'bytes='+str(start)+'-' + str(end)})

            try:
                response = urllib2.urlopen(req)
                try:
                    if xbmcplugin.playbackBuffer.playback[count]['length'] == -1:
                        return
                except:
                    xbmcplugin.playbackBuffer.playback[count]['length'] =  response.info().getheader('Content-Length')

            except urllib2.URLError, e:
                if e.code == 403 or e.code == 401:
                    print "STILL ERROR"+str(e.code)+"\n"
                    return
                else:
                    return


            if start == '':
                self.send_response(200)
                #self.send_header('Content-Length',response.info().getheader('Content-Length'))
                if isEncrypted:
                    self.send_header('Content-Length',xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])
                else:
                    self.send_header('Content-Length',xbmcplugin.playbackBuffer.playback[count]['length'])
            else:
                self.send_response(206)
                if isEncrypted:
                    self.send_header('Content-Length', str(returnLength))
                else:
                    self.send_header('Content-Length', str(int(response.info().getheader('Content-Length'))))

            print str(response.info()) + "\n"
            self.send_header('Content-Type',response.info().getheader('Content-Type'))
            if isEncrypted:
                if end == '':
                    end = int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']) - 1
                if start == '':
                    start = 0
                self.send_header('Content-Range','bytes ' + str(start) + '-' + str(end) + '/' +  str(int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])))
                if constants.CONST.DEBUG:
                    print "SENDING =" + 'bytes ' + str(start) + '-' + str(end) + '/' + str( int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])) + "\n"
                #self.send_header('Content-Range', response.info().getheader('Content-Range'))
                if constants.CONST.DEBUG and response.info().getheader('Content-Range') != None:
                    print "received to process = " + response.info().getheader('Content-Range') + "\n"

            else:
                self.send_header('Content-Range', response.info().getheader('Content-Range'))
                #print "RANGE = " +  response.info().getheader('Content-Range') + "\n"

            self.send_header('Cache-Control',response.info().getheader('Cache-Control'))
            self.send_header('Date',response.info().getheader('Date'))
            self.send_header('Content-type','video/mp4')
            self.send_header('Accept-Ranges','bytes')

            self.end_headers()


            if isEncrypted:

                CHUNK = 16 * 1024
                decrypt.decryptStreamChunk(response,self.wfile, adjStart,adjEnd, chunksize=CHUNK)

            else:
                CHUNK = 16 * 1024
                while True:
                    chunk = response.read(CHUNK)
                    if not chunk:
                        break
                    self.wfile.write(chunk)
                    if constants.CONST.DEBUG:
                        print "HASH = " + str(hashlib.md5(chunk).hexdigest()) + "\n"






            #response_data = response.read()
            response.close()
            return

        elif re.search(r'/play20171201', str(decryptkeyvalue)):
#            self.send_response(200)
#            self.end_headers()
            count = 0
            isEncrypted = False
            results = re.search(r'/play\?count\=(\d+)\&encrypted\=true$', str(decryptkeyvalue))
            #encrypted stream
            if results:
                count = int(results.group(1))
                isEncrypted = True
            #not encrypted stream
            else:
                results = re.search(r'/play\?count\=(\d+)$', str(decryptkeyvalue))
                if results:
                    count = int(results.group(1))

            #self.send_response(200)
            #self.end_headers()
            #xbmcplugin.assignOutputBuffer(self.wfile)
            #cookies = self.headers['Cookie']
            cookie = xbmcplugin.playbackBuffer.playback[count]['cookie']
            url = xbmcplugin.playbackBuffer.playback[count]['url']
            auth = xbmcplugin.playbackBuffer.playback[count]['auth']
            auth = auth.replace("+",' ')

            length=0
            try:
                length = xbmcplugin.playbackBuffer.playback[count]['length']
            except:
                length = 0
                start= ''

            endOffset = 0
            startOffset = 0
            newEnd = end
            specialEnd = 0

            if isEncrypted:

                from resources.lib import  encryption
                decrypt = encryption.encryption(self.server.cryptoSalt,self.server.cryptoPassword)


                #
                # 1) start > 16 bytes, back up to nearest whole chunk of 16
                if (start != '' and start > 16 and end == ''):
                    #start = start - (16 - (end % 16))
                   # startOffset = 16-(( int(length) - start) % 16)+8 ##GOOD
                    startOffset = 16-(( int(length) - start) % 16)+8
                    newEnd = int(xbmcplugin.playbackBuffer.playback[count]['length'])-1
                    print "[1] START=" + str(start) + ', END=' + str(end) + ', length='+str(length)+ ' , startOffset=' +str(startOffset)+ ' , endOffset=' +str(endOffset) +', newEnd='+str(newEnd)+"\n"
                #tested - good**
                # 2) start > 16 bytes, back up to nearest whole chunk of 16, end < end of file
                elif (start != '' and start > 16 and end == int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])-1 ):
                    finalChunkDifference = int(xbmcplugin.playbackBuffer.playback[count]['length']) - int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])

                    #start = start - (16 - (end % 16))
                   # startOffset = 16-(( int(length) - start) % 16)+8 ##GOOD
                    #startOffset = -(( int(end) - start - finalChunkDifference) % 16)
                    startOffset += finalChunkDifference -8
                    newEnd = int(xbmcplugin.playbackBuffer.playback[count]['length'])-1
                    startOffset += 16-(( end - start + 1) % 16)
                    print "[2] START=" + str(start) + ', END=' + str(end) + ', length='+str(length)+ ' , startOffset=' +str(startOffset)+ ' , endOffset=' +str(endOffset) +', newEnd='+str(newEnd)+"\n"

                #tested - good**
                # fetch all, return all
                elif (start == 0 and end == int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])-1 ):
                    finalChunkDifference = int(xbmcplugin.playbackBuffer.playback[count]['length']) - int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']) - 8

                    #start = start - (16 - (end % 16))
                   # startOffset = 16-(( int(length) - start) % 16)+8 ##GOOD
                    startOffset = 0
                    newEnd = int(xbmcplugin.playbackBuffer.playback[count]['length'])-1
                    print "[5] START=" + str(start) + ', END=' + str(end) + ', length='+str(length)+ ' , startOffset=' +str(startOffset)+ ' , endOffset=' +str(endOffset) +', newEnd='+str(newEnd)+"\n"

                #?issue *problems
                elif (start != '' and start > 16 and end != ''):
                    #start = start - (16 - (end % 16))
                    # startOffset = 16-(( int(length) - start) % 16)+8 ##GOOD
                    #startOffset = 16-(( int(end+1) - start) % 16)+8
                    startOffset = 0#8
                    endOffset = 16-(( end - start + 1 +8 ) % 16)
                    newEnd = end + endOffset + 8
                    #specialEnd = endOffset
                    print "[3] START=" + str(start) + ', END=' + str(end) + ', length='+str(length)+ ' , startOffset=' +str(startOffset)+ ' , endOffset=' +str(endOffset) +', newEnd='+str(newEnd)+"\n"
                #tested - good**
                # special case - end < 16 (such as first 2 bytes (apple)
                elif (end < 16):
                    #start = start - (16 - (end % 16))
                   # startOffset = 16-(( int(length) - start) % 16)+8 ##GOOD
                    endOffset = 16 - int(end)
                    newEnd= 15 + 8
                    print "[4] START=" + str(start) + ', END=' + str(end) + ', length='+str(length)+ ' , startOffset=' +str(startOffset)+ ' , endOffset=' +str(endOffset) +', newEnd='+str(newEnd)+"\n"

            if start == '':
#                req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth})
                req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth})
            else:
                req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth, 'Range': 'bytes='+str(int(start- startOffset))+'-' + str(newEnd)})
                #req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth, 'Range': 'bytes='+str(int(start- startOffset))+'-' + str(int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])-1)})

            try:
                response = urllib2.urlopen(req)
            except urllib2.URLError, e:
                if e.code == 403 or e.code == 401:
                    print "STILL ERROR"+str(e.code)+"\n"
                    return
                else:
                    return

            # first fetch (no start specified, or 0)
            if start == '':
                xbmcplugin.playbackBuffer.playback[count]['length'] =  response.info().getheader('Content-Length')
                #for encrypted streams
                # need to fetch the last 16 bytes to calculate unpadded size
                if isEncrypted:
                    response.close()
                    req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth, 'Range': 'bytes='+str(int(xbmcplugin.playbackBuffer.playback[count]['length']) - 16 - 8 )+'-'})
                    try:
                        response = urllib2.urlopen(req)
                    except urllib2.URLError, e:
                        if e.code == 403 or e.code == 401:
                            print "STILL ERROR"+str(e.code)+"\n"
                            return
                        else:
                            return
                    CHUNK = 16 * 1024

                    #originalSize = decrypt.decryptCalculateSizing(response)
                    #print "size " + response.info().getheader('Content-Length') + ' vs ' + str(originalSize) + "\n"
                    #return
                    finalChunkDifference = decrypt.decryptCalculatePadding(response,chunksize=CHUNK)
                    #xbmcplugin.playbackBuffer.playback[count]['length'] = int(xbmcplugin.playbackBuffer.playback[count]['length']) - finalChunkDifference
                    xbmcplugin.playbackBuffer.playback[count]['decryptedlength'] = int(xbmcplugin.playbackBuffer.playback[count]['length']) - finalChunkDifference - 8
                    print "FINAL CHUNK SIZE DIFFERENCE " + str(finalChunkDifference) + "\n"
                    print "length " +  str(xbmcplugin.playbackBuffer.playback[count]['length']) + "\n"
                    print "decryptedlength " +  str(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']) + "\n"
                    req = urllib2.Request(url,  None,  { 'Cookie' : 'DRIVE_STREAM='+ cookie, 'Authorization' : auth})
                    try:
                        response = urllib2.urlopen(req)
                    except urllib2.URLError, e:
                        if e.code == 403 or e.code == 401:
                            print "STILL ERROR"+str(e.code)+"\n"
                            return
                        else:
                            return


            if start == '':
                self.send_response(200)
                #self.send_header('Content-Length',response.info().getheader('Content-Length'))
                if isEncrypted:
                    self.send_header('Content-Length',xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])
                else:
                    self.send_header('Content-Length',xbmcplugin.playbackBuffer.playback[count]['length'])
            else:
                self.send_response(206)
                #self.send_header('Content-Range','bytes ' + str(start) + '-' +str(end))
                #if end == '':
                #    self.send_header('Content-Range','bytes ' + str(start) + '-' +str(int(self.server.length)-1) + '/' +str(int(self.server.length)))
                #else:
                #    self.send_header('Content-Range','bytes ' + str(start) + '-' + str(end) + '/' +str(int(self.server.length)))

                #self.send_header('Content-Range',response.info().getheader('Content-Range'))
                if isEncrypted:
                    if end < 16: # != '':
                        self.send_header('Content-Length', str(int(end - start + 1)-startOffset))
                        print "1) set content-length "+str(int(end - start + 1)-startOffset) + "\n"
                        specialEnd = int(end - start + 1)
                    elif end != '':
                        self.send_header('Content-Length', str(int(end - start + 1)))
                        print "2) set content-length "+str(int(end - start + 1)) + "\n"
                    else:
                        self.send_header('Content-Length', str(int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])+1 - start))
                        print "3) set content-length "+str(int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])+1 - start) + "\n"
                else:
                    self.send_header('Content-Length', str(int(response.info().getheader('Content-Length'))))

            print str(response.info()) + "\n"
            self.send_header('Content-Type',response.info().getheader('Content-Type'))
            if isEncrypted:
                if end == '':
                    end = int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']) - int(startOffset) - 1
                if start == '':
                    start = 0
                #if start > 0:
#               #     self.send_header('Content-Range','bytes ' + str(start) + '-' + str(end) + '/' + str( int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']) - int(startOffset) ))
                #    self.send_header('Content-Range','bytes ' + str(start) + '-' + str(end) + '/' + str( int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])  ))
                #    print "1) set content-range "+ str(start) + '-' + str(end) + '/' + str( int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']) - int(startOffset) )+ "\n"
                #else:
                self.send_header('Content-Range','bytes ' + str(start) + '-' + str(end) + '/' + str(int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength'])) )
                print "2) set content-range "+str(start) + '-' + str(end) + '/' + str(int(xbmcplugin.playbackBuffer.playback[count]['decryptedlength']))+ "\n"

                #self.send_header('Content-Range','bytes ' + str(start) + '-' + str(end) + '/' + str(int(end + 1)))

                #self.send_header('Content-Range', response.info().getheader('Content-Range'))
                if response.info().getheader('Content-Range') != None:
                    print "received to process = " + response.info().getheader('Content-Range') + "\n"

                print "received to process = " + response.info().getheader('Content-Length') + "\n"
            else:
                self.send_header('Content-Range', response.info().getheader('Content-Range'))
                #print "RANGE = " +  response.info().getheader('Content-Range') + "\n"

            self.send_header('Cache-Control',response.info().getheader('Cache-Control'))
            self.send_header('Date',response.info().getheader('Date'))
            self.send_header('Content-type','video/mp4')
            self.send_header('Accept-Ranges','bytes')

            self.end_headers()


            if isEncrypted:

                CHUNK = 16 * 1024
                decrypt.decryptStreamChunk(response,self.wfile, startOffset=startOffset, endOffset=specialEnd, chunksize=CHUNK, end=endOffset)

            else:
                CHUNK = 16 * 1024
                count=0
                hash_md5 = hashlib.md5()
                while True:
                    chunk = response.read(CHUNK)
                    if not chunk:
                        break
                    self.wfile.write(chunk)
                    hash_md5.update(chunk)
                    print "HASH = " + str(hash_md5.hexdigest()) + "\n"






            #response_data = response.read()
            response.close()
            return
        # redirect url to output
        elif re.search(r'/\?', str(decryptkeyvalue)) or re.search(r'/default.py', str(decryptkeyvalue)):
#            self.send_response(200)
#            self.end_headers()

            results = re.search(r'\?(.*)$', str(decryptkeyvalue))
            if results:
                query = str(results.group(1))

            mediaEngine = engine.contentengine()
            mediaEngine.run(self,query, DBM=self.server.dbm, addon=self.server.addon)
            return


        # redirect url to output
        elif self.path == '/enroll':

            self.send_response(200)
            self.end_headers()

            self.wfile.write('<html><body>Do you want to use a default client id / client secret or your own client id / client secret?  If you don\'t know what this means, select DEFAULT.<br /> <a href="/enroll?default=true">use default client id / client secret (DEFAULT)</a> <br /><br />OR use your own client id / client secret<br /><br /><form action="/enroll?default=false" method="post">Client ID:<br /><input type="text" name="client_id" value=""><br />Client Secret:<br /><input type="text" name="client_secret" value=""> <br/><input type="submit" value="Submit"></form></body></html>')
            return

        # redirect url to output
        elif self.path == '/enroll?default=true' or self.path == '/enroll':

            self.send_response(200)
            self.end_headers()

            self.wfile.write('<html><body>Two steps away.<br/><br/>  1) Visit this site and then paste the application code in the below form: <a href="https://accounts.google.com/o/oauth2/auth?scope=https://www.googleapis.com/auth/drive&redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=code&client_id=772521706521-bi11ru1d9h40h1lipvbmp3oddtcgro14.apps.googleusercontent.com" target="new">Google Authentication</a><br /><br />2) Return back to this tab and provide a nickname and the application code provided in step 1. <form action="/enroll" method="post">Nickname for account:<br /><input type="text" name="account"><br />Code (copy and paste from step 1):<br /><input type="text" name="code"><br /><form action="/enroll" method="post">Client ID:<br /><input type="hidden" name="client_id" value="772521706521-bi11ru1d9h40h1lipvbmp3oddtcgro14.apps.googleusercontent.com"><br />Client Secret:<br /><input type="hidden" name="client_secret" value="PgteSoD4uagqHA1_nLERLDx9"><br /><br /></br /> <input type="submit" value="Submit"></form></body></html>')
            return
        elif self.path == '/enroll?default=false':

            self.send_response(200)
            self.end_headers()

            self.wfile.write('<html><body>Two steps away.<br/><br/>  1) Visit this site and then paste the application code in the below form: <a href="https://accounts.google.com/o/oauth2/auth?scope=https://www.googleapis.com/auth/drive&redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=code&client_id=772521706521-bi11ru1d9h40h1lipvbmp3oddtcgro14.apps.googleusercontent.com" target="new">Google Authentication</a><br /><br />2) Return back to this tab and provide a nickname and the application code provided in step 1. <form action="/enroll" method="post">Nickname for account:<br /><input type="text" name="account"><br />Code (copy and paste from step 1):<br /><input type="text" name="code"><br /><br /> <input type="submit" value="Submit"></form></body></html>')
            return

        # redirect url to output
        else:
            # no options
            return


    def displaySettings(self):


            self.wfile.write('<html><form autocomplete="off" action="/save_settings" method="post">')

            self.wfile.write('<h1>Plugin Configuration:</h1>')
            self.wfile.write('<b>Secure Login</b><br />Username <input name="username" type="text" value="'+str(self.server.dbm.getSetting('username',default=''))+'" /><br />')
            self.wfile.write('Password <input name="passwrd" type="text" value="'+str(self.server.dbm.getSetting('password',default=''))+'" /><br />')

            self.wfile.write('<br /><br /><b><i>The following settings affect creating secure URLs:</i></b><br />Hide parameters <select name="hide">')
            if self.server.dbm.getSetting('hide') == 'true':
                self.wfile.write('<option value="true" selected >true</option><option value="false">false</option><br /></select>')
            else:
                self.wfile.write('<option value="true">true</option><option value="false" selected>false</opton><br /></select>')
            self.wfile.write('<br />Generate keyvalue parameters <select name="keyvalue">')
            if self.server.dbm.getSetting('keyvalue') == 'true':
                self.wfile.write('<option value="true" selected >true</option><option value="false">false</option><br /></select>')
            else:
                self.wfile.write('<option value="true">true</option><option value="false" selected>false</opton><br /></select>')

            self.wfile.write('<br />Salt file <input name="saltfile" type="text" value="'+str(self.server.dbm.getSetting('saltfile',default='saltfile'))+'"><sub>[select server path to file]</sub>')

            self.wfile.write('<br /><input type="submit" value="Save" /><h1>Media Configuration:</h1>')

            self.setings = {}
            file = open('./resources/settings.xml', "r")
            print "LOAD SETTINGS\n\n\n"
            for line in file:

                id = ''
                type = ''
                values = ''
                default = ''
                label = ''
                range = ''
                #special override -- display all files within video view
                if id == 'context_video':
                    default = 2
                result = re.search(r'\<setting id\=\"([^\"]+)\" type\=\"([^\"]+)\" values\=\"([^\"]*)\" default\=\"([^\"]*)\" label\=\"(\d+)\" \/\>', str(line))
                if result:
                    id = str(result.group(1))
                    type = str(result.group(2))
                    values = str(result.group(3))
                    default = str(result.group(4))
                    label = str(result.group(5))
                if result is None:
                    result = re.search(r'\<setting id\=\"([^\"]+)\" type\=\"([^\"]+)\"[^/]+label\=\"(\d+)\" default\=\"([^\"]*)\" option\=\"([^\"]*)\" range\=\"([^\"]*)\"[^/]+\/\>\n', str(line))
                    if result:
                        id = str(result.group(1))
                        type = str(result.group(2))
                        default = str(result.group(4))
                        label = str(result.group(3))
                        range = str(result.group(6))
                if result is None:
                    result = re.search(r'\<setting id\=\"([^\"]+)\" type\=\"([^\"]+)\"[^/]+label\=\"(\d+)\" default\=\"([^\"]*)\"([^/]+)\/\>\n', str(line))
                    if result:
                        id = str(result.group(1))
                        type = str(result.group(2))
                        default = str(result.group(4))
                        label = str(result.group(3))

                if result is None:
                    result = re.search(r'\<setting id\=\"([^\"]+)\" type\=\"([^\"]+)\".*?label\=\"(\d+)\" values\=\"([^\"]*)\" default\=\"([^\"]*)\"[^\/]* \/\>\n', str(line))
                    if result:
                        id = str(result.group(1))
                        type = str(result.group(2))
                        default = str(result.group(5))
                        label = str(result.group(3))
                        values = str(result.group(4))

                #<setting label="30205" type="lsep"/>
                if result is None:
                    result = re.search(r'\<setting.*label\=\"(\d+)\" type\=\"lsep\"\/\>\n', str(line))
                    if result:
                        label = str(result.group(1))
                        self.wfile.write(str('<br /><b>' + self.server.addon.getLocalizedString(label)) + '</b><br /> ')
                #    <category label="30196">
                if result is None:
                    result = re.search(r'\<category label\=\"(\d+)\"\>\n', str(line))
                    if result:
                        label = str(result.group(1))
                        self.wfile.write(str('<input type="submit" value="Save" /><h2>' + self.server.addon.getLocalizedString(label)) + '</h2>')

                if result:
                    if id != '':
                        currentValue = self.server.dbm.getSetting(id)
                        if currentValue is None:
                            currentValue = default
                        if type == 'text' or type == 'number':
                            self.wfile.write(str(self.server.addon.getLocalizedString(label)) + ' ('+str(id)+') <input name="'+str(id)+'" type="text" value="'+str(currentValue)+'" /><br />')
                        if type == 'file' or type == 'folder':
                            self.wfile.write(str(self.server.addon.getLocalizedString(label)) + ' ('+str(id)+') <input name="'+str(id)+'" type="text" value="'+str(currentValue)+'" /> <sub>[select server path to '+str(type)+']</sub><br />')
                        elif type == 'labelenum':
                            self.wfile.write(str(self.server.addon.getLocalizedString(label)) + ' ('+str(id)+') <select name="'+str(id)+'"/>')

                            for r in re.finditer('(\d+)(?:\||$)' ,
                                             values, re.DOTALL):
                                if r.group(1) == int(currentValue):
                                    self.wfile.write('<option value="'+str(r.group(1))+'" selected/>'+str(r.group(1)) + '</option>')
                                else:
                                    self.wfile.write('<option value="'+str(r.group(1))+'"/>'+str(r.group(1)) + '</option>')

                            self.wfile.write('</select><br />')
                        elif type == 'enum':
                            self.wfile.write(str(self.server.addon.getLocalizedString(label)) + ' ('+str(id)+') <select name="'+str(id)+'"/>')

                            count = 0
                            for r in re.finditer('([^\|]+)(?:\||$)' ,
                                             values, re.DOTALL):

                                if count == int(currentValue):
                                    self.wfile.write('<option value="'+str(count)+'" selected/>'+str(r.group(1)) + '</option>')
                                else:
                                    self.wfile.write('<option value="'+str(count)+'"/>'+str(r.group(1)) + '</option>')
                                count += 1

                            self.wfile.write('</select><br />')
                        elif type == 'slider':
                            self.wfile.write(str(self.server.addon.getLocalizedString(label)) + ' ('+str(id)+') <select name="'+str(id)+'"/>')

                            for r in re.finditer('(\d+)\,(\d+)\,(\d+)' ,
                                             range, re.DOTALL):

                                min = int(r.group(1))
                                increment = int(r.group(2))
                                max = int(r.group(3))
                                i = min
                                while i < max:

                                    if i == int(currentValue):
                                        self.wfile.write('<option value="'+str(i)+'" selected/>'+str(i) + '</option>')
                                    else:
                                        self.wfile.write('<option value="'+str(i)+'"/>'+str(i) + '</option>')
                                    i = i + increment
                            self.wfile.write('</select><br />')

                        elif type == 'bool':
                            self.wfile.write(str(self.server.addon.getLocalizedString(label)) + ' ('+str(id)+') <select name="'+str(id)+'"/>')
                            if currentValue == 'true':
                                #self.wfile.write(str(self.server.addon.getLocalizedString(label)) + ' ('+str(id)+')<input name="'+str(id)+'" type="checkbox" value="true" checked /><br />')
                                self.wfile.write('<option value="true" selected/>true</option>')
                                self.wfile.write('<option value="false"/>false</option>')
                            else:
                                self.wfile.write('<option value="false" selected/>false</option>')
                                self.wfile.write('<option value="true"/>true</option>')

                            self.wfile.write('</select><br />')
            self.wfile.write('<br /><br /><b><i>The following settings affect path included in STRM files created:</i></b><br /> Protocol <select name="protocol">')
            if self.server.dbm.getSetting('protocol') == 'https://':
                self.wfile.write('<option value="https://" selected >https://</option><option value="http://">http://</option><br /></select>')
            else:
                self.wfile.write('<option value="https://">https://</option><option value="http://" selected>http://</opton><br /></select>')

            self.wfile.write('<br />Hostname <input name="hostname" type="text" value="'+str(self.server.dbm.getSetting('hostname', default=self.get_ip_address()))+'" /><br />')
            self.wfile.write('<br />Port <input name="port" type="text" disabled value="'+str(self.server.dbm.getSetting('port',default=self.server.port))+'" /><br />')

            self.wfile.write('<input type="submit" value="Save" /></form></html>')

    def cookieLogin(headers):

        for r in re.finditer('Cookie\:[^\n]+login\=(\S+)' ,
                     headers, re.DOTALL):
          loginSession = r.group(1)
          try:
              if self.server.logins[loginSession] == 1:
                  isLoggedIn = True
          except:
              isLoggedIn = False

    def get_ip_address(self):
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        s.connect(("8.8.8.8", 80))
        return s.getsockname()[0]