# -*- coding: utf-8 -*-
#Библиотеки, които използват python и Kodi в тази приставка
import re
import sys
import os
import urllib
import urllib2
import json
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon

#Място за дефиниране на константи, които ще се използват няколкократно из отделните модули
__addon_id__= 'plugin.video.dramafever'
__Addon = xbmcaddon.Addon(__addon_id__)
__settings__ = xbmcaddon.Addon(id='plugin.video.dramafever')
sortorder =__settings__.getSetting('order')
if sortorder =='0':
    #print 'Release date'
    sort='recent'
elif sortorder =='1':
    #print 'Popularity'
    sort='popular'
elif sortorder =='2':
    #print 'Rating'
    sort='highest'
else:
    #print 'Alphabetical'
    sort='alphabetical'

sublang =__settings__.getSetting('lang')
if sublang =='0':
    lang='en'
    language = 'English'
elif sublang =='1':
    lang='es'
    language = 'Spanish'
elif sublang =='2':
    lang='pt'
    language = 'Portuguese'
elif sublang =='3':
    lang='chs'
    language = 'Chinese'
else:
    lang='en'
    language = 'English'

searchicon = xbmc.translatePath(__Addon.getAddonInfo('path') + "/resources/search.png")
#ttmlsubs_path = xbmc.translatePath('special://temp/dramafever.English.xml')
#smisubs_path = xbmc.translatePath('special://temp/dramafever.English.smi')
srtsubs_path = xbmc.translatePath('special://temp/dramafever.'+language+'.srt')

UA = 'Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:51.0) Gecko/20100101 Firefox/51.0'

#Избор на клиентско устройство за новата сесия
#req = urllib2.Request('https://dramafevertoken-a.akamaihd.net/api/4/base_url/?consumer_name=android')
#req = urllib2.Request('https://dramafevertoken-a.akamaihd.net/api/4/base_url/?consumer_name=panasonictv')
req = urllib2.Request('https://dramafevertoken-a.akamaihd.net/api/4/base_url/?consumer_name=samsungtv')
req.add_header('User-Agent', 'samsunghas-agent/1.1')
opener = urllib2.build_opener()
f = opener.open(req)
jsonrsp = json.loads(f.read())
#print jsonrsp
#print jsonrsp['base_url']
#print jsonrsp['consumer_secret']
base_url = jsonrsp['base_url']
consumer_secret = jsonrsp['consumer_secret']
#consumer_secret = 'LJmZKSm6rAJ2CCVm' # iOS secret


#Меню с директории в приставката
def CATEGORIES():
        addDir('Search series','search',3,searchicon)
        req = urllib2.Request(base_url+'/api/4/browse/list/?cs='+consumer_secret)
        req.add_header('User-Agent', UA)
        opener = urllib2.build_opener()
        f = opener.open(req)
        jsonrsp = json.loads(f.read())
        #print jsonrsp['value'][0]['title']
        
        for cat in range(0, 3):
            for genre in range(0, len(jsonrsp['value'][cat]['values'])):
                addDir(jsonrsp['value'][cat]['values'][genre]['name'],jsonrsp['value'][cat]['type']+'@'+jsonrsp['value'][cat]['values'][genre]['slug']+'@1',1,'DefaultFolder.png')
        xbmc.executebuiltin("Notification(DramaFever,Welcome to the Hallyu World!,2000)")
        

#Разлистване на заглавията
def TYPE(url):
        type, genre, page = url.split("@")
        currentlisturl = base_url+'/api/4/browse/?cs='+consumer_secret+'&browser_type='+type+'&criteria='+genre+'&page_number='+page+'&page_size=25&order='+sort
        #print currentlisturl
        req = urllib2.Request(currentlisturl)
        req.add_header('User-Agent', UA)
        opener = urllib2.build_opener()
        f = opener.open(req)
        jsonrsp = json.loads(f.read())
        #print jsonrsp
        
        #print 'number of dramas is '+str(len(jsonrsp['value']))
        try:
            for titles in range(0, len(jsonrsp['value'])):
                #try:
                    #print jsonrsp['value'][titles]['name'].encode('ascii','ignore')
                    #print jsonrsp['value'][titles]['id']
                    #print jsonrsp['value'][titles]['imageSmallURL']
                #except:
                    #pass
                try:
                    addDir(jsonrsp['value'][titles]['name'].encode('ascii','ignore'),str(jsonrsp['value'][titles]['id'])+'@'+jsonrsp['value'][titles]['name'].encode('ascii','ignore')+'@'+page,2,jsonrsp['value'][titles]['imageSmallURL'])
                except:
                    pass
            
            #Ако имаме още страници...
            #print jsonrsp['num_pages']
            #print page
            if (jsonrsp['num_pages'] > 1 and int(page) <= jsonrsp['num_pages']-1):
                #print 'page ' + str(int(page)+1)
                urln = type+'@'+genre+'@'+str(int(page)+1)
                addDir('Check out page '+str(int(page)+1)+' of '+str(jsonrsp['num_pages'])+' >>>',urln,1,'DefaultFolder.png')
            
        except:
            #addDir('Go back - there are no results','','',"DefaultFolderBack.png")
            pass
        
#Разлистване на епизодите
def INDEX(url):
        series, name, page = url.split("@")
        currentlisturl = base_url+'/api/4/episode/series/?cs='+consumer_secret+'&page_size=60&series_id='+series+'&page_number='+page
        #print currentlisturl
        req = urllib2.Request(currentlisturl)
        req.add_header('User-Agent', UA)
        opener = urllib2.build_opener()
        f = opener.open(req)
        jsonrsp = json.loads(f.read())        
        #print jsonrsp
        
        try:
            for episodes in range(0, len(jsonrsp['value'])):
                #print 'Episode '+jsonrsp['value'][episodes]['number']
                #print jsonrsp['value'][episodes]['subfile']
                #print jsonrsp['value'][episodes]['duration']
                #print jsonrsp['value'][episodes]['id']
                #print jsonrsp['value'][episodes]['twist_thumb']
                duration = jsonrsp['value'][episodes]['duration'].split(':')
                duration = int(duration[0]) * 3600 + int(duration[1]) * 60 + int(duration[2])
                if len(jsonrsp['value']) ==1:
                    addLink(name,str(jsonrsp['value'][episodes]['number'])+'@'+series+'@'+jsonrsp['value'][episodes]['subfile'],duration,4,jsonrsp['value'][episodes]['twist_thumb'])
                else:
                    addLink(name+' Episode '+str(jsonrsp['value'][episodes]['number']),str(jsonrsp['value'][episodes]['number'])+'@'+series+'@'+jsonrsp['value'][episodes]['subfile'],duration,4,jsonrsp['value'][episodes]['twist_thumb'])
        
            #Ако имаме още страници...
            #print 'Pages Number:' + str(jsonrsp['num_pages'])
            if (jsonrsp['num_pages'] > 1 and int(page) <= jsonrsp['num_pages']-1):
                #print 'page ' + str(int(page)+1)
                INDEX(series+'@'+name+'@'+str(int(page)+1))
        except:
            addDir('Go back - there are no results','','',"DefaultFolderBack.png")


#Търсачка
def SEARCH(url):
        keyb = xbmc.Keyboard('', 'Search')
        keyb.doModal()
        searchText = ''
        if (keyb.isConfirmed()):
            searchText = urllib.quote_plus(keyb.getText())
            searchText=searchText.replace(' ','+')
            
            req = urllib2.Request('https://api.swiftype.com/api/v1/public/engines/suggest.json?q='+searchText+'&engine_key=CywzyscJAHKCwrezfzpN&search_fields[tag][]=title&search_fields[series][]=title^4&search_fields[series][]=alt_title^2')
            req.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            f = opener.open(req)
            jsonrsp = json.loads(f.read())        
            #print jsonrsp
            
            br=0
            for index in range(0, len(jsonrsp['records']['series'])):
                #print jsonrsp['records']['series'][index]['title']
                #print jsonrsp['records']['series'][index]['external_id']
                #print jsonrsp['records']['series'][index]['thumbnail']
                try:
                    cover = 'https://www.dramafever.com'+jsonrsp['records']['series'][index]['thumbnail']
                except:
                    cover = 'DefaultFolder.png'
                addDir(jsonrsp['records']['series'][index]['title'],jsonrsp['records']['series'][index]['external_id']+'@'+jsonrsp['records']['series'][index]['title']+'@1',2,cover)
                br=br+1
            if br==0:
                addDir('Go back - there are no results','','',"DefaultFolderBack.png")




#Зареждане на видео
def PLAY(name,url,iconimage):
        episode, series, srtsubtitles = url.split("@")
        #print base_url+'/api/4/stream/hls_stream/?cs='+consumer_secret+'&series_id='+series+'&number='+episode+'&subs=0&format=srt'
        req = urllib2.Request(base_url+'/api/4/stream/hls_stream/?cs='+consumer_secret+'&series_id='+series+'&number='+episode+'&subs=0&format=srt')
        req.add_header('User-Agent', UA)
        opener = urllib2.build_opener()
        f = opener.open(req)
        jsonrsp = json.loads(f.read())
        #print jsonrsp
        #print jsonrsp['stream']
        #print jsonrsp['subfile_sami']
        
        #Ако официалното API не върне stream, ще се използва WEB API
        if jsonrsp['stream']=="":
            req2 = urllib2.Request(base_url+'/amp/episode/feed.json?guid='+series+'.'+episode+'&hd=True')
            req2.add_header('User-Agent', UA)
            opener2 = urllib2.build_opener()
            f2 = opener.open(req2)
            jsonrsp2 = json.loads(f2.read())
            #print jsonrsp2['channel']['item']['media-group']['media-content'][1]['@attributes']['url']
            jsonrsp['stream'] = jsonrsp2['channel']['item']['media-group']['media-content'][1]['@attributes']['url']
        
        #Изтегляме официалните субтитри за епизода в TTML формат и ги конвертираме към SRT
        try:
            reqs = urllib2.Request(base_url+'/amp/episode/feed.json?guid='+series+'.'+episode+'&hd=False')
            reqs.add_header('User-Agent', UA)
            opener = urllib2.build_opener()
            s = opener.open(reqs)
            jsonrsps = json.loads(s.read())
            #print  jsonrsps['channel']['item']['media-group']['media-subTitle'][2]['@attributes']['href']
            
            for index in range(0, len(jsonrsps['channel']['item']['media-group']['media-subTitle'])):
                #print jsonrsps['channel']['item']['media-group']['media-subTitle'][index]['@attributes']['lang']
                #print jsonrsps['channel']['item']['media-group']['media-subTitle'][index]['@attributes']['href']
                if jsonrsps['channel']['item']['media-group']['media-subTitle'][index]['@attributes']['lang'] == language:
                    #print '[dramafever]>> my subtitles are '+ jsonrsps['channel']['item']['media-group']['media-subTitle'][index]['@attributes']['lang'] + ' ' + jsonrsps['channel']['item']['media-group']['media-subTitle'][index]['@attributes']['href']

                    req = urllib2.Request(jsonrsps['channel']['item']['media-group']['media-subTitle'][index]['@attributes']['href'])
                    req.add_header('User-Agent', UA)
                    response = urllib2.urlopen(req)
                    data=response.read()
                    response.close()
                    
                    subs = re.compile('<p[^>]+begin="([^"]+)\D(\d+)"[^>]+end="([^"]+)\D(\d+)"[^>]*>([\w\W]+?)</p>').findall(data)
                    row = 0
                    buffer = ''
                    for sub in subs:
                        #print sub
                        row = row + 1
                        buffer += str(row) +'\n'
                        buffer += "%s,%03d" % (sub[0], int(sub[1])) + ' --> ' + "%s,%03d" % (sub[2], int(sub[3])) + '\n'
                        buffer += urllib.unquote_plus(sub[4]).replace('<br/>','\n').replace('<br />','\n').replace("\r\n", "").replace("&lt;", "<").replace("&gt;", ">").replace("\n    ","").strip()
                        buffer += '\n\n'
                    #print 'buffer '+buffer
                    sub = 'true'
                    #print srtsubs_path
                    with open(srtsubs_path, "w") as subfile:
                        subfile.write(buffer)
            #Генерира грешка, за да задейства използването на английски субтитри, ако няма налични на избраният език
            if sub != 'true':
                raise Exception()
                    
        except:
            try:
                #Изтегляме редакторските английски SRT субтитри във временна директория
                subfile = urllib.URLopener()
                subfile.retrieve(srtsubtitles, srtsubs_path)
                sub = 'true'
                #print srtsubs_path
            except:
                sub = 'false'
                #print '[dramafever]>> This video has no subtitles !'
        
        #Възпроизвеждане на видеото
        li = xbmcgui.ListItem(iconImage=iconimage, thumbnailImage=iconimage, path=jsonrsp['stream']+'|User-Agent=stagefright')
        li.setInfo('video', { 'title': name })
        xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, xbmcgui.ListItem(path = jsonrsp['stream']+'|User-Agent=stagefright'))
        
        #Задаване на субтитри, ако има такива или изключването им
        if sub=='true':
            while not xbmc.Player().isPlaying():
                xbmc.sleep(1000) #wait until video is being played
                xbmc.Player().setSubtitles(srtsubs_path)
        else:
            xbmc.Player().showSubtitles(False)
            #if os.path.isfile(srtsubs_path):
               #os.unlink(srtsubs_path)
                #os.unlink(xbmc.translatePath('special://temp/dramafever.English.srt'))
        





#Модул за добавяне на отделно заглавие и неговите атрибути към съдържанието на показваната в Kodi директория - НЯМА НУЖДА ДА ПРОМЕНЯТЕ НИЩО ТУК
def addLink(name,url,vd,mode,iconimage):
        u=sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&name="+urllib.quote_plus(name)
        ok=True
        liz=xbmcgui.ListItem(name, iconImage="DefaultFolder.png", thumbnailImage=iconimage)
        liz.setInfo( type="Video", infoLabels={ "Title": name } )
        liz.addStreamInfo('video', { 'duration': vd, 'Width': 480 })
        liz.setProperty("IsPlayable" , "true")
        ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=False)
        return ok

#Модул за добавяне на отделна директория и нейните атрибути към съдържанието на показваната в Kodi директория - НЯМА НУЖДА ДА ПРОМЕНЯТЕ НИЩО ТУК
def addDir(name,url,mode,iconimage):
        u=sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&name="+urllib.quote_plus(name)
        ok=True
        liz=xbmcgui.ListItem(name, iconImage="DefaultFolder.png", thumbnailImage=iconimage)
        liz.setInfo( type="Video", infoLabels={ "Title": name } )
        ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=True)
        return ok


#НЯМА НУЖДА ДА ПРОМЕНЯТЕ НИЩО ТУК
def get_params():
        param=[]
        paramstring=sys.argv[2]
        if len(paramstring)>=2:
                params=sys.argv[2]
                cleanedparams=params.replace('?','')
                if (params[len(params)-1]=='/'):
                        params=params[0:len(params)-2]
                pairsofparams=cleanedparams.split('&')
                param={}
                for i in range(len(pairsofparams)):
                        splitparams={}
                        splitparams=pairsofparams[i].split('=')
                        if (len(splitparams))==2:
                                param[splitparams[0]]=splitparams[1]
                                
        return param



params=get_params()
url=None
name=None
iconimage=None
mode=None

try:
        url=urllib.unquote_plus(params["url"])
except:
        pass
try:
        name=urllib.unquote_plus(params["name"])
except:
        pass
try:
        name=urllib.unquote_plus(params["iconimage"])
except:
        pass
try:
        mode=int(params["mode"])
except:
        pass


#Списък на отделните подпрограми/модули в тази приставка - трябва напълно да отговаря на кода отгоре
if mode==None or url==None or len(url)<1:
        print ""
        CATEGORIES()
    
elif mode==1:
        print ""+url
        TYPE(url)

elif mode==2:
        print ""+url
        INDEX(url)

elif mode==3:
        print ""+url
        SEARCH(url)

elif mode==4:
        print ""+url
        PLAY(name,url,iconimage)


xbmcplugin.endOfDirectory(int(sys.argv[1]))
