# -*- coding: utf-8 -*-

import urllib2,urllib,json
import re,os
from urlparse import urlparse
import base64
import cookielib

BASEURL= "https://api.dailymotion.com"
TIMEOUT = 10
UA='Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.97 Safari/537.36'

languages= {'Argentina': 'ar_ES', 'Australia': 'au_EN', 'Belgie (NL)': 'be_NL', 'Belgique (FR)': 'be_FR', 'Brasil': 'br_PT', 'Canada (English)': 'ca_EN', 'Canada (Francais)': 'ca_FR', 'China': 'cn_ZH',
 'Deutschland': 'de_DE', 'Espana (CA)': 'es_CA', 'Espana (ES)': 'es_ES', 'France': 'fr_FR', 'Greece': 'gr_EL', 'India': 'in_EN', 'International': 'en_EN', 'Ireland': 'ie_EN', 'Israel (HE)': 'he_HE',
 'Italia': 'it_IT', 'Japan': 'jp_JP', 'Maroc': 'ma_FR', 'Mexico': 'mx_ES', 'Nederland': 'nl_NL', 'Oesterreich': 'at_DE', 'Polska': 'pl_PL', 'Portugal': 'pt_PT', 'Romania': 'ro_RO', 'Russia': 'ru_RU',
 'Schweiz (DE)': 'ch_DE', 'Suisse (FR)': 'ch_FR', 'Svizzera (IT)': 'ch_IT', 'Tunisie': 'tn_FR', 'Turkiye': 'tr_TR', 'United Kingdom': 'en_GB', 'United States': 'en_US', 'Viet Nam': 'vn_VI'}			

itemsPerPage='50'
language='pl_PL'

GATE='http://invisiblesurf.review/index.php?q='
GATE=''


def getUrl(url,data=None,cookies=None):
    if GATE:
        url = GATE+base64.b64encode(url)+'&hl=ed'
    req = urllib2.Request(url,data)
    req.add_header('User-Agent', UA)
    if cookies:
        req.add_header("Cookie", cookies)
    try:
        response = urllib2.urlopen(req,timeout=TIMEOUT)
        link = response.read()
        response.close()
    except:
        link=''
    return link



def getContent(user='raulespert',type='videos',sort='recent',page='1',id='x4a5zj'):
    nextPage=False
    prevPage=False
    data={}
    page = str(page)
    if   type =='live':
         url = BASEURL+"/user/"+user+"/videos?flags=live_onair&fields=id,duration,title,onair,private,thumbnail_240_url"
    elif type =='videos':
        url = BASEURL+"/user/"+user+"/videos?fields=description,duration,duration_formatted,id,onair,private,owner.username,taken_time,thumbnail_240_url,title,views_total&sort="+sort+"&limit="+itemsPerPage+"&localization="+language+"&page="+page
    elif type =='playlists':
        url = BASEURL+"/user/"+user+"/playlists?fields=id,uri,name,description,videos_total,thumbnail_240_url&sort="+sort+"&limit="+itemsPerPage+"&localization="+language+"&page="+page
    elif type =='playlist':        
        url = BASEURL+"/playlist/"+id+"/videos?fields=description,duration_formatted,id,owner.username,taken_time,thumbnail_240_url,title,views_total&sort=recent&limit="+itemsPerPage+"&localization="+language+"&page="+page
    elif type == 'channels':
        url = BASEURL+"/channels?localization="+language
    elif type == 'channel':
        url = BASEURL+"/videos?fields=description,duration_formatted,id,owner.username,owner.screenname,taken_time,thumbnail_240_url,title,views_total&channel="+id+"&sort="+sort+"&limit="+itemsPerPage+"&localization="+language+"&page="+page
    elif type == 'search_video':
        url = BASEURL+"/videos?fields=description,duration_formatted,id,owner.username,owner.screenname,taken_time,thumbnail_240_url,title,views_total&search="+id+"&sort=relevance&limit="+itemsPerPage+"&localization="+language+"&page="+page
    elif type == 'search_user':
        url = BASEURL+"/users?fields=id,username,screenname,avatar_large_url,views_total,videos_total,playlists_total,status,description,avatar_720_url,cover_url&search="+id+"&sort=relevance&limit="+itemsPerPage+"&localization="+language+"&page="+page
    elif type == 'get_user':
        url= BASEURL+"/user/"+user+"?fields=id,username,screenname,avatar_large_url,views_total,videos_total,playlists_total,status,description,avatar_720_url,cover_url"
    try:
        content = getUrl(url)
        data = json.loads(content)
        if data.has_key('list'):
            L = data.get('list',[])
        else:
            L=[data]
    except:
        data = {}
        L=[]
   
    nextPage = {'user':user,'type':type,'sort':sort,'id':id,'page':int(page)+1} if data.get('has_more',False) else False
    prevPage = {'user':user,'type':type,'sort':sort,'id':id,'page':int(page)-1} if data.get('page',False)>1 else False
    return (L,(prevPage,nextPage))    


def getVideoLinks(media_id='x4r4uoo'):
    content = getUrl('http://www.dailymotion.com/embed/video/%s' % media_id)
    srcs=re.compile('"(1080|720|480|380)":(\[{[^\]]*\])',re.DOTALL).findall(content)
    out=[]
    for quality,links in srcs:
        #print links
        url=''
        for type,href in re.compile('"type":"(.*?)","url":"(.*?)"').findall(links):
            if 'video' in type:
                url= href 
                break
        if url:        
            if GATE:
                url = GATE+base64.b64encode(url.replace('\\',''))+'&hl=ed'
            out.append({'label':quality,'url':url.replace('\\','')}) 
        
    if not out:
        srcs=re.compile('"(auto)":\[{"type":"(.*?)","url":"(.*?)"}\]',re.DOTALL).findall(content)
        for quality,type,url in srcs:
            print url
            m3u = getUrl(url.replace('\\','')+ '&redirect=0')
            if '#EXTM3U' in m3u:
                qq=re.compile('NAME="(.*?)"\n(.*?)\n').findall(m3u)
                for label,url in qq:
                    out.append({'label':label,'url':url})    
            else:
                burl = m3u.split('live.isml')[0]+'live.isml/'
                m3u2 = getUrl(url.replace('\\',''))
                if '#EXTM3U' in m3u2:
                    qq=re.compile('RESOLUTION=(.*?)\n(.*?)\n').findall(m3u2)
                    for label,pp in qq:
                        out.append({'label':label,'url':burl+pp})  
    return out
    
# media_id='x4nrxj6'
# def getVideoLinks(media_id='x4k8k7'):
#     content = getUrl('http://www.dailymotion.com/embed/video/%s' % media_id)
#     srcs=re.compile('"(1080|720|480|380)":\[{"type":"(.*?)","url":"(.*?)"}\]',re.DOTALL).findall(content)
#     #srcs=re.compile('"(auto)":\[{"type":"(.*?)","url":"(.*?)"}\]',re.DOTALL).findall(content)
#     out=[]
#     for quality,type,url in srcs:
#         if GATE:
#             url = GATE+base64.b64encode(url.replace('\\',''))+'&hl=ed'
#         out.append({'label':quality,'url':url.replace('\\','')}) 
#         
#     if not out:
#         srcs=re.compile('"(auto)":\[{"type":"(.*?)","url":"(.*?)"}\]',re.DOTALL).findall(content)
#         for quality,type,url in srcs:
#             m3u = getUrl(url.replace('\\','')+ '&redirect=0')
#             if '#EXTM3U' in m3u:
#                 qq=re.compile('NAME="(.*?)"\n(.*?)\n').findall(m3u)
#                 for label,url in qq:
#                     out.append({'label':label,'url':url})    
#             else:
#                 burl = m3u.split('live.isml')[0]+'live.isml/'
#                 m3u2 = getUrl(url.replace('\\',''))
#                 if '#EXTM3U' in m3u2:
#                     qq=re.compile('RESOLUTION=(.*?)\n(.*?)\n').findall(m3u2)
#                     for label,pp in qq:
#                         out.append({'label':label,'url':burl+pp})  
#                 #out.append({'label':'auto','url':m3u+'&events(live-1474037409)/live-audio=128000-video=700000.m3u8?vbegin=1451606400'}) 
#     return out

def getUserInfo(user='abcd-channel'):
    url='https://api.dailymotion.com/user/'+user+"?fields=id,username,screenname,avatar_large_url,views_total,videos_total,playlists_total,status,description,avatar_720_url,cover_url"
    try:
        content = getUrl(url)
        data = json.loads(content)
    except:
        data={}
    return data    

def ReadUsers(fname=r'D:\users.json'):
    jdata = ReadJsonFile(fname)
    if not jdata:
        _add_defaultUsers(fname,ulist=['Ekstraklasa','abcd-channel','2015newhit','md7racingteam','DokumentyPL','stargazerrr'])
        jdata = ReadJsonFile(fname)
    return jdata

def parseUsers(jdata):
    out=[]
    for data in jdata:
        out.append(parseOneUser(data))
    return out     

def  parseOneUser(data,addkey=False):
    title = '%s [videos:[COLOR blue][B]%d[/B][/COLOR] playlists:[COLOR blue][B]%d[/B][/COLOR]]'%(data.get('screenname','?'),data.get('videos_total',-1),data.get('playlists_total',-1))
    one = {'img':data.get('avatar_720_url'),
                    'fanart':data.get('cover_url'),
                    'plot': data.get('description','').replace('<br />','\n') if data.get('description','') else '',
                    'title':title,
                    'user':data.get('username'),
                    'screenname':data.get('screenname'),
                    'playlists_total':data.get('playlists_total'),
                    'videos_total':data.get('videos_total'),
                    }
    if addkey: one['_skip']=False 
    return one
    
def _add_defaultUsers(fname,ulist):
    jdata=[]
    for user in ulist:
        uinfo = getUserInfo(user)
        if uinfo: jdata.append(uinfo)
    WriteJsonFile(jdata,fname)

def addUser_fromData(data,fname):
    jdata = ReadJsonFile(fname)
    jdata.append(data)
    WriteJsonFile(jdata,fname)    
    
def removeUser(user,fname):
    jdata = ReadJsonFile(fname)
    to_remove=[] 
    for i in xrange(len(jdata)):
        #print jdata[i].get('username')
        if user in jdata[i].get('username'):
            to_remove.append(i)
    if to_remove:
        for i in reversed(to_remove):
            jdata.pop(i)        
        WriteJsonFile(jdata,fname)    
        return True
    else:
        return False
        
def refreshUser(user,fname):
    upd={}
    jdata = ReadJsonFile(fname)
    for data in jdata:
        if user in data.get('username'):
            #print 'refreshUser', data.get('username')
            data.update(getUserInfo(user))
            upd=parseOneUser(data)
            WriteJsonFile(jdata,fname)
            break;
    return upd
    
def ReadJsonFile(fname):
    content = '[]'
    if fname.startswith('http'):
        content = getUrl(fname)
    elif os.path.exists(fname):    # local content
        with open(fname,'r') as f:
            content = f.read()
            if not content:
                content ='[]'
    data=json.loads(content)
    return data

def WriteJsonFile(jdata,jfilename):
    with open(jfilename, 'w') as outfile:
       json.dump(jdata, outfile, indent=2, sort_keys=True)
