# -*- coding: utf-8 -*-

import sys,re,os
import urllib,urllib2
import urlparse
import xbmc,xbmcgui,xbmcaddon
import xbmcplugin
import urlresolver
import json
import check

import resources.lib.dmu as dmu
#import resources.lib.strings as strings

base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = urlparse.parse_qs(sys.argv[2][1:])
my_addon        = xbmcaddon.Addon()
addonName       = my_addon.getAddonInfo('name')
addonName_id     = my_addon.getAddonInfo('id')

PATH        = my_addon.getAddonInfo('path')
DATAPATH    = xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES   = PATH+'/resources/'

FANART=None

DMUSERS    = os.path.join(DATAPATH,'dmUsers.json')
#DMUSERS    =r'D:\users.json'

my_addon.setSetting('set','set')
dmu.language = dmu.languages.get(my_addon.getSetting('language'),'en_EN')
dmu.itemsPerPage = my_addon.getSetting('itemsPerPage')


## COMMON Functions

def translation(id):
    return my_addon.getLocalizedString(id).encode('utf-8')

def slan(string_id):
    try:
        return my_addon.getLocalizedString(strings.STRINGS[string_id]).encode('utf-8', 'ignore')
    except Exception as e:
        print 'Failed String Lookup: %s (%s)' % (string_id, e)
    return string_id
    
    
def addLinkItem(name, url, mode, params=1, iconimage='DefaultFolder.png', infoLabels={}, IsPlayable=True,fanart=FANART,itemcount=1,contextmenu=None):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'params':params})
    liz = xbmcgui.ListItem(name,)
    art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
    art=dict(zip(art_keys,[iconimage for x in art_keys]))
    art['fanart'] = infoLabels.get('fanart',fanart) 
    liz.setArt(art)
    if not infoLabels: infoLabels={"title": name}
    liz.setInfo(type="video", infoLabels=infoLabels)
    if IsPlayable: liz.setProperty('IsPlayable', 'true')

    if contextmenu:
        contextMenuItems=contextmenu
        liz.addContextMenuItems(contextMenuItems, replaceItems=False) 
               
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    return ok



def addDir(name,ex_link=None, params=1, mode='folder',iconImage='DefaultFolder.png', infoLabels={}, fanart=FANART,contextmenu=None):
    url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'params' : params})

    li = xbmcgui.ListItem(name)
    art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
    art=dict(zip(art_keys,[iconImage for x in art_keys]))
    art['fanart'] = infoLabels.get('fanart',fanart) 
    li.setArt(art)
    
    if infoLabels: li.setInfo(type="video", infoLabels=infoLabels)

    if contextmenu:
        contextMenuItems=contextmenu
        li.addContextMenuItems(contextMenuItems, replaceItems=False) 

    xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")

def encoded_dict(in_dict):
    out_dict = {}
    for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            # Must be encoded in UTF-8
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
    
def build_url(query):
    return base_url + '?' + urllib.urlencode(encoded_dict(query))
 
def getLinks(ex_link):
    linksL = dmu.getVideoLinks(ex_link)
    stream_url=''
    
    if len(linksL):
        if len(linksL)>1:
            lables = [x.get('label') for x in linksL]
            maxVideoQuality = [0,1,'1080','720','480','360'][int(my_addon.getSetting("maxVideoQuality"))]
            print 'maxVideoQuality',maxVideoQuality
            if  maxVideoQuality==0:
                s = xbmcgui.Dialog().select(translation(30024),lables)
            elif maxVideoQuality==1:
                s = len(lables)-1
            else:
                s = lables.index(maxVideoQuality) if maxVideoQuality in lables else len(lables)-1
        else:
            s=0
        #print 's',s
        stream_url=linksL[s].get('url') if s>-1 else ''
        host=linksL[s].get('label') if s>-1 else ''  
    
    print stream_url
    #xbmcgui.Dialog().ok('',stream_url)
    if stream_url:
        xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
    else:
        xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))

def getDM_Users():
    jdata = dmu.ReadJsonFile(DMUSERS)
    if not jdata:
        yes = xbmcgui.Dialog().yesno(translation(30021),translation(30022),translation(30023))
        if yes:
            dmu._add_defaultUsers(DMUSERS,ulist=['esa','abcd-channel','2015newhit','DokumentyPL','abcd2015'])
            jdata = dmu.ReadJsonFile(DMUSERS)
    
    if len(jdata)>0:
        data = dmu.parseUsers(jdata)
        for one in data:
            contextMenu=[(translation(30001),'RunPlugin(%s)'%build_url({'mode': 'REFRESH', 'ex_link' : one.get('user'), 'params':one})),
                        (translation(30002),'RunPlugin(%s)'%build_url({'mode': 'REMOVE', 'ex_link' : one.get('user'), 'params':one}))]
            addDir(name=one.get('title'),ex_link=one.get('user'),params=one, mode='userFolder',iconImage=one.get('img'),infoLabels=one,contextmenu=contextMenu)    

def userFolder(user,data):
    if my_addon.getSetting("autoRefres") == 'true' and '_skip' not in data:  # refresh only form local json file 
        data = dmu.refreshUser(user,DMUSERS)
    else:
        data = eval(data)
    img= data.get('img')
    title = '[COLOR blue]%s[/COLOR]'%data.get('screenname','')
    fanart = data.get('fanart','')
    Npl=str(data.get('playlists_total','?'))
    Nv=str(data.get('videos_total','?'))
    #addDir(name=title+" Live",ex_link=user,params={'user':user,'type':'live','sort':'recent','page':'1'}, mode='getVideos',iconImage=img,fanart=fanart)
    addDir(name=title+" Videos ([COLOR blue]"+Nv+"[/COLOR])",ex_link=user,params={'user':user,'type':'videos','sort':'recent','page':'1'}, mode='getVideos',iconImage=img,fanart=fanart)
    addDir(name=title+" Popular ([COLOR blue]"+Nv+"[/COLOR])",ex_link=user,params={'user':user,'type':'videos','sort':'visited','page':'1'}, mode='getVideos',iconImage=img,fanart=fanart)
    addDir(name=title+" Playlists ([COLOR blue]"+Npl+"[/COLOR])",ex_link=user,params={'user':user,'type':'playlists','sort':'alpha','page':'1'}, mode='getVideos',iconImage=img,fanart=fanart)

## ######################
## MAIN
## ######################
            
mode = args.get('mode', None)
fname = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
params = args.get('params',[{}])[0]

xbmcplugin.setContent(addon_handle, 'movies')

## Read Settings



if mode is None:
    getDM_Users()
    show_Add = True if my_addon.getSetting("show_AddUser") == 'true' else False
    show_Cat = True if my_addon.getSetting("show_Categories") == 'true' else False
    show_SeV = True if my_addon.getSetting("show_Search_V")  == 'true' else False
    show_SeU = True if my_addon.getSetting("show_Search_U")  == 'true' else False
    show_Set = True if my_addon.getSetting("show_Settings") == 'true' else False
    if show_Add: addLinkItem(name=translation(30003), url='', mode='ADDUSER', iconimage=RESOURCES+'dmusersAdd.png', IsPlayable=False)
    if show_Cat: addDir(name=translation(30004),ex_link='',params={'user':'','type':'channels','sort':'recent','page':'1'}, infoLabels={'plot':translation(30050)}, mode='getVideos',iconImage=RESOURCES+'dm.png',fanart='')
    if show_SeV: addDir(name=translation(30005),ex_link='',params={}, mode='search_video',infoLabels={'plot':translation(30050)},iconImage=RESOURCES+'dmvideo.png',fanart='')
    if show_SeU: addDir(name=translation(30006),ex_link='',params={}, mode='search_user',infoLabels={'plot':translation(30050)},iconImage=RESOURCES+'dmusersSearch.png',fanart='')
    if show_Set: addLinkItem(name=translation(30020), url='', mode='Opcje', iconimage=RESOURCES+'dmSettings.png',IsPlayable=False,fanart='')
    
elif mode[0] == 'userFolder':
    userFolder(ex_link,params)

elif mode[0] == 'Opcje':
    my_addon.openSettings()  
    xbmc.executebuiltin('XBMC.Container.Refresh')   

elif mode[0] =='getLinks':
    getLinks(ex_link)


elif mode[0] =='getVideos':
    print 'getVideos',params
    params = eval(params)
    goback=None
    if params.has_key('goback'):
        goback = params.pop('goback')
        goback =eval(goback.get('params')[0])
    Litems,pagination = dmu.getContent(**params)
    items=len(Litems)
    
    if pagination[0]: addLinkItem(name=translation(30007), url=ex_link, mode='__page__', params=pagination[0], IsPlayable=False)
        
    for f in Litems:
        f['plot']=f.get('description','').replace('<br />','\n') if f.get('description') else ''
        if params['type']=='playlists':
            title = '%s ([COLOR blue]%s[/COLOR])'%(f.get('name',''),str(f.get('videos_total','')))
            addDir(name=title,ex_link=params['user'],params={'user':params['user'],'type':'playlist','sort':'recent','page':'1','id':f.get('id','')}, mode='getVideos',iconImage=f.get('thumbnail_240_url')) 
        elif params['type']=='channels':
            addDir(name=f.get('name',''),ex_link='',params={'user':'','type':'channel','sort':'recent','page':'1','id':f.get('id','')}, mode='getVideos',iconImage=f.get('thumbnail_240_url')) 
        elif params['type']=='search_user' or params['type']=='get_user':
            one = dmu.parseOneUser(f,True)
            contextMenu=[(translation(30009),'RunPlugin(%s)'%build_url({'mode': 'ADDUSER', 'ex_link' : f.get('username',''), 'params':{}}))]
            addDir(name=one.get('title'),ex_link=one.get('user'),params=one, mode='userFolder',iconImage=one.get('img'),infoLabels=one,contextmenu=contextMenu)
        else:
            f['code']= f.get('duration_formatted','')
            f['code']='[COLOR lightgreen]onAir[/COLOR]' if f.get('onair',False) else f['code']
            contextMenu = None
            if f.has_key('owner.screenname'): 
                f['title'] += ' [COLOR blue] %s[/COLOR]'%f.get('owner.screenname','')
                contextMenu=[(translation(30009),'RunPlugin(%s)'%build_url({'mode': 'ADDUSER', 'ex_link' : f.get('owner.username',''), 'params':{}})),
                             (translation(30010),'RunPlugin(%s)'%build_url({'mode': 'get_user', 'ex_link' : f.get('owner.username',''), 'params':{'goback':args}}))]
            addLinkItem(name=f.get('title'), url=f.get('id'), mode='getLinks', iconimage=f.get('thumbnail_240_url'), infoLabels=f, IsPlayable=True,itemcount=items,fanart=f.get('img'),contextmenu=contextMenu)
            
    if pagination[1]: addLinkItem(name=translation(30008), url=ex_link, mode='__page__', params=pagination[1], IsPlayable=False)
    if goback: addLinkItem(name=translation(30011), url='', mode='__page__', params=goback, IsPlayable=False) 
    
elif mode[0] == '__page__':
    url = build_url({'mode': 'getVideos', 'foldername': '', 'ex_link' : ex_link, 'params': params})
    xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)

elif mode[0].startswith('search_'):
    if ex_link == '':
        msg = translation(30012) if 'video' in mode[0] else translation(30013)
        title = xbmcgui.Dialog().input(msg, type=xbmcgui.INPUT_ALPHANUM)
    else:
        title = ex_link
    if title:
        url = build_url({'mode': 'getVideos', 'foldername': '', 'ex_link' : '', 'params': {'user':'','type':mode[0],'sort':'relevant','page':'1','id':title.replace(" ", "+")}})
        xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)    

elif mode[0] == 'Opcje':
    my_addon.openSettings()   

elif mode[0] == 'REMOVE':
    params = eval(params)
    yes = xbmcgui.Dialog().yesno(params.get('screenname'),translation(30014),'username %s'%params.get('user'))
    if yes:
        dmu.removeUser(params.get('user'),DMUSERS)
    xbmc.executebuiltin('XBMC.Container.Refresh')
    
elif mode[0] == 'REFRESH':
    params = eval(params)
    dmu.refreshUser(params.get('user'),DMUSERS)
    xbmc.executebuiltin('XBMC.Container.Refresh')

elif mode[0] == 'get_user':
    params = eval(params)
    url = build_url({'mode': 'getVideos', 'foldername': '', 'ex_link' : '', 'params': {'user':ex_link,'type':'get_user','sort':'relevant','page':'1','id':'',
    'goback':params.get('goback','')}})
    xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)

elif mode[0] == 'ADDUSER':
    if ex_link=='':
        user = xbmcgui.Dialog().input(translation(30015), type=xbmcgui.INPUT_ALPHANUM)    
    else:
        user = ex_link
    data = dmu.getUserInfo(user)
    #print data
    if data.has_key('screenname'):
        yes= xbmcgui.Dialog().yesno(translation(30016), 
                'Name: [B]%s[/B]  (status: %s)'%(data.get('screenname'),data.get('status')),
                'Views :[B]%d[/B]'%data.get('views_total'),
                'Videos/Playlists : [B]%d[/B]/[B]%d[/B]'%(data.get('videos_total'),data.get('playlists_total')))
        if yes: 
            dmu.addUser_fromData(data,DMUSERS)
            xbmc.executebuiltin('XBMC.Container.Refresh')
    else:
        xbmcgui.Dialog().ok(translation(30017)+' [COLOR red][I]%s[/I][/COLOR]'%user,translation(30018),'http://www.dailymotion.com/[B]USER[/B]') 
        
elif mode[0] == 'folder':
    pass

else:
    xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))        

xbmcplugin.endOfDirectory(addon_handle)

