import os, xbmc, xbmcaddon

#########################################################
### User Edit Variables #################################
#########################################################
ADDON_ID       = xbmcaddon.Addon().getAddonInfo('id')
ADDONTITLE     = 'RAiZ Tv Wizard'
EXCLUDES       = [ADDON_ID, 'repository.raiztv']
# Text File with build info in it.
BUILDFILE      = 'http://raiztv.co.uk/Wizard/wizard.txt'
# How often you would list it to check for build updates in days
# 0 being every startup of kodi
UPDATECHECK    = 0
# Text File with apk info in it.
APKFILE        = 'http://raiztv.co.uk/Wizard/apk.txt'

# Dont need to edit just here for icons stored locally
HOME           = xbmc.translatePath('special://home/')
PLUGIN         = os.path.join(HOME,     'addons',    ADDON_ID)
ART            = os.path.join(PLUGIN,   'resources', 'art')

#########################################################
### THEMING MENU ITEMS ##################################
#########################################################
# If you want to use locally stored icons the place them in the Resources/Art/
# folder of the wizard then use os.path.join(ART, 'imagename.png')
# do not place quotes around os.path.join
# Example:  ICONMAINT     = os.path.join(ART, 'mainticon.png')
#           ICONSETTINGS  = 'http://aftermathwizard.net/repo/wizard/settings.png'
# Leave as http:// for default icon
ICONMAINT      = 'http://raiztv.co.uk/Wizard/wizardimages/maintenance.png'
ICONBUILDS     = 'http://raiztv.co.uk/Wizard/wizardimages/builds.png'
ICONCONTACT    = 'http://raiztv.co.uk/Wizard/wizardimages/contact.png'
ICONSAVE       = 'http://raiztv.co.uk/Wizard/wizardimages/savedata.png'
ICONTRAKT      = 'http://raiztv.co.uk/Wizard/trakt.jpg'
ICONREAL       = 'http://'
ICONLOGIN      = 'http://'
ICONAPK        = 'http://raiztv.co.uk/Wizard/wizardimages/apki.png'
ICONSETTINGS   = 'http://raiztv.co.uk/Wizard/wizardimages/settings.png'
# Hide the ====== seperators 'Yes' or 'No'
HIDESPACERS    = 'No'                                                                    

# You can edit these however you want, just make sure that you have a %s in each of the
# THEME's so it grabs the text from the menu item
COLOR1         = 'gold'
COLOR2         = 'silver'
# Primary menu items   / %s is the menu item and is required
THEME1         = '[COLOR '+COLOR1+'][RAiZ Tv Wizard][/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'    
# Build Names          / %s is the menu item and is required
THEME2         = '[COLOR '+COLOR2+']%s[/COLOR]'                                          
# Alternate items      / %s is the menu item and is required
THEME3         = '[COLOR '+COLOR1+']%s[/COLOR]'                                          
# Current Build Header / %s is the menu item and is required
THEME4         = '[COLOR '+COLOR1+']Current Build:[/COLOR] [COLOR '+COLOR2+']%s[/COLOR]' 
# Current Theme Header / %s is the menu item and is required
THEME5         = '[COLOR '+COLOR1+']Current Theme:[/COLOR] [COLOR '+COLOR2+']%s[/COLOR]' 

# Message for Contact Page
# Enable 'Contact' menu item 'Yes' hide or 'No' dont hide
HIDECONTACT    = 'No'                                                                    
# You can add \n to do line breaks
CONTACT        = 'Thank you for choosing RAiZ Tv.\nContact us on facebook at http://facebook.com/groups/raiztv'
#########################################################

#########################################################
### AUTO UPDATE #########################################
########## FOR THOSE WITH NO REPO #######################
# Enable Auto Update 'Yes' or 'No'
AUTOUPDATE     = 'Yes'                                                                    
# Url to wizard version
WIZARDFILE     = 'http://raiztv.co.uk/Wizard/wizard.txt'                          
#########################################################

#########################################################
### AUTO INSTALL ########################################
########## REPO IF NOT INSTALLED ########################
# Enable Auto Install 'Yes' or 'No'
AUTOINSTALL    = 'No'                                                                    
# Addon ID for the repository
REPOID         = 'repository.raiztv'
# Url to Addons.xml file in your repo folder(this is so we can get the latest version)
REPOADDONXML   = 'http://repo.raiztv.co.uk/files/addons.xml'
# Url to folder zip is located in
REPOZIPURL     = 'http://repo.raiztv.co.uk/'
#########################################################

#########################################################
### NOTIFICATION WINDOW##################################
#########################################################
# Enable Notification screen Yes or No
ENABLE         = 'Yes'
# Url to notification file
NOTIFICATION   = 'http://raiztv.co.uk/Wizard/notify.txt'
# Use either 'Text' or 'Image'
HEADERTYPE     = 'Text'
# Font size of header
FONTHEADER     = 'Font14'
HEADERMESSAGE  = 'RAiZ Tv Wizard'
# url to image if using Image 424x180
HEADERIMAGE    = ''
# Font for Notification Window
FONTSETTINGS   = 'Font13'
# Background for Notification Window
BACKGROUND     = 'http://raiztv.co.uk/Wizard/Splash.png'
#########################################################