# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
import re
import sys
import urlparse
import operator
import inspect
import traceback

from os import path
from routes import RoutesContainer
from exception import KodiousException


class navigator(object):
    def __init__(self):
        self._modules = {}
        self._routes = RoutesContainer()
        self._defaultRule = False

        try:
            args = sys.argv[2].lstrip('?')
        except:
            args = ''
            pass
        self._params = dict( urlparse.parse_qsl( args ))
        pass


    def route(self, rule, options=None):
        def decorator(method_ref):
            try:
                root = inspect.getouterframes( inspect.currentframe() )[-1][4].pop()
                if root.find('.loadModules') < 0:
                    return method_ref
            except:
                return method_ref

            if inspect.isfunction( method_ref ):
                try:
                    module = inspect.currentframe(1)
                    module_name = module.f_code.co_name
                    module_filepath = module.f_code.co_filename
                    method_name = method_ref.func_code.co_name
                    method_argcount = method_ref.func_code.co_argcount

                    route = self._routes.add(rule, method_name, method_argcount, module_name, module_filepath)

                    if (options and options.get('default', None)):
                        self._defaultRule = route.id
                except:
                    KodiousException().handle()

                class KodiousModuleMethodWrapper():
                    def __init__(self, ref):
                        self._ref = ref

                    def execute(self, cls, **kwargs):
                        try:
                            return self._ref(cls, **kwargs)
                        except:
                            KodiousException(module=cls).handle()

                    # TODO: Fix so module can work standalone

                return KodiousModuleMethodWrapper(method_ref)

        return decorator


    def _dispatch(self, params):
        current_route = params.get('route', self._defaultRule)
        if ('route' in params):
            del params['route']

        # finds the rule attributes from route name
        action = self._routes.find(current_route)

        if not action: return

        # update the arguments values
        action.updateArgsValues( params )

        return action


    def _getModuleNames(self, modulePath, ignore=[]):
        if not os.path.isabs(modulePath):
            modulePath = os.path.join(os.path.dirname( inspect.getouterframes( inspect.currentframe() )[-1][0].f_code.co_filename ), modulePath )

        module_realpath = path.realpath( modulePath )
        module_re = re.compile('^([^\.]+)\.py$', flags=re.IGNORECASE)
        files = os.listdir( module_realpath )

        if not isinstance(ignore, list):
            ignore = list(ignore)

        modules = []
        for filename in files:
            try:
                module_name = module_re.match( filename ).group(1)
            except AttributeError:
                continue

            if (module_name == '__init__') or (module_name in ignore): continue

            modules.append( module_name )
            pass

        return modules


    def loadModules(self, modulesPath, ignore=[]):
        self._modulesPath = modulesPath
        modules = self._getModuleNames(modulesPath, ignore)

        for module_name in modules:
            try:
                module = __import__(modulesPath.replace('/', '.') + '.' + module_name, globals(), locals(), ['*'])

                self._modules.update({ module_name: module })
            except:
                KodiousException().handle()

        pass


    def run(self):
        route = self._dispatch( self._params )

        if (route):
            try:
                instance = getattr( self._modules[ route.moduleFilename ], route.moduleName )( )
                getattr(instance, route.methodName).execute(instance, **route.methodArgs)
            except:
                KodiousException().handle()

        elif (route == False):
            KodiousException('No default route rule found!').handle()
        else:
            KodiousException('Route action not found!').handle()

