# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
import xbmc_mock
import json as json_lib

from . import ClassWrapper
from ..utils.xml2dict import XML2DICT


class __Addon(object):
    def __init__(self, id=None):
        self._addon_id = id

        addonxml = os.path.join( os.getcwd(), 'addon.xml' )

        self.addonDict = XML2DICT()
        self.addonDict.loadXml( addonxml )
        self.addonDict.parseXml()

        language_xml = os.path.join( os.getcwd(), 'resources', 'language', 'english', 'strings.xml')

        self.langDict = XML2DICT()
        self.langDict.loadXml( language_xml )
        self.langDict.parseXml()


    def getSetting(self, _id):
        settings_xml = os.path.join( xbmc_mock.translatePath( self.getAddonInfo('profile')), 'settings.xml')

        settingDict = XML2DICT()
        settingDict.loadXml( settings_xml )
        settingDict.parseXml()

        result = None
        try: result = settingDict.find({'tag': 'setting', 'attr': {'name': 'id', 'value': _id}})[0]['setting']['attributes']['value']
        except: pass
        try: result = str( unicode( result ).encode('utf-8'))
        except: pass

        return result


    def openSettings(self):
        return


    def getAddonInfo(self, id):
        '''
        Returns the value of an addon property as a string.
     
        id : string - id of the property that the module needs to access.

        *Note, choices are (author, changelog, description, disclaimer, fanart. icon, id, name, path,
        profile, stars, summary, type, version)
        example:
            - version = self.Addon.getAddonInfo('version')
        '''
        try:
            config_file = os.path.join( os.getcwd(), '.kodious' )
            with open(config_file, 'r+') as f:
                config_data = f.read()
        except IOError:
            config_data = '{}'

        configs = json_lib.loads(config_data)

        properties = [
            'author', 'changelog', 'description', 'disclaimer',
            'fanart', 'icon', 'id', 'name', 'path', 'profile', 'stars', 'summary',
            'type', 'version'
        ]

        addonDict = self.addonDict
        addonAttrs = addonDict.find({'tag': 'addon'})[0]['addon']['attributes']

        _info = {
            'id': addonAttrs['id'],
            'name': addonAttrs['name'],
            'version': addonAttrs['version'],
            'author': addonAttrs['provider-name'],
            'type': addonDict.find([{'tag': 'extension'}, {'tag': 'provides'}])[0]['provides']['childs'][0],
            'path': configs['addon_path'],
            'profile': 'special://profile/addon_data/' + addonAttrs['id'],
        }
        assert id in properties, '%s is not a valid property.' % id
        return _info.get(id, 'Unavailable')


    def getLocalizedString(self, _id):
        try:
            return self.langDict.find({'tag': 'string', 'attr': {'name': 'id', 'value': _id}})[0]['string']['childs'][0].encode('utf-8')
        except:
            return 'Unavailable item'

Addon = ClassWrapper(__Addon, 'xbmcaddon.Addon')