# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import inspect
import traceback

from kodi import xbmc
from kodi import CLI_MODE

from module import AddonModule


class KodiousException(Exception):
    def __init__(self, message=None, module=None):
        full_message = message

        if (not message):
            if CLI_MODE:
                full_message = traceback.format_exc()
                message = full_message
            else:
                try:
                    full_message = traceback.format_exc()
                    lines = full_message.splitlines()
                    message = '\n'.join( [ '- ' + x.strip() for x in lines[-4:]] ).replace('/', ' /')
                except:
                    message = 'Unknown error occured, please contact the developer for help!'

        Exception.__init__(self, message)
        self._full_message = full_message
        self._message = message
        self._module = module
        self._cli = CLI_MODE


    def getMessage(self):
        return self._message


    def getFullMessage(self):
        return self._full_message


    def handle(self):
        if self._cli:
            print self.getFullMessage()

        else:
            xbmc.log( self.getFullMessage(), xbmc.LOGERROR )

            if isinstance(self._module, AddonModule):
                self._module.view.dialog.ok( self.getMessage(), 'Error' )
