# -*- coding: utf-8 -*-
import requests
import json
import urllib
from xbmcswift2 import Plugin, xbmcplugin, xbmcgui, xbmc, actions
from bs4 import BeautifulSoup


plugin = Plugin()


@plugin.cached(TTL=60*24)
def get_json():
    req = requests.get('http://nirelbaz.com/kodi/data/playlists.json')
    return json.loads(req.text)


def make_favorite_ctx(parent_title, item_title):
    label = u'הוסף לפלייליסטים שלי'
    new_url = plugin.url_for('add_to_favorites', parent_title=parent_title.encode('UTF-8'), item_title=item_title.encode('UTF-8'))
    return (label, actions.background(new_url))


def make_unfavorite_ctx(title):
    label = u'הסר מהפלייליסטים שלי'
    new_url = plugin.url_for('remove_from_favorites', title=title.encode('UTF-8'))
    return (label, actions.update_view(new_url))


@plugin.route('/')
def index():
    """
    Shows channels list
    :return:
    """
    favorites = plugin.get_storage('favorites')
    categories = []

    # Add user's favorites category:
    if len(favorites.keys()) > 0:
        bg_image = 'special://home/addons/{0}/resources/media/favorites.jpg'.format(plugin.id)
        categories.append({
            'label': u'\u2764 רשימת הפלייליסטים המועדפים שלי',
            'icon': bg_image,
            'thumbnail': bg_image,
            'path': plugin.url_for('show_favorites'),
            'is_playable': False,
            'properties': {
                'Fanart_Image': bg_image
            }
        })

    # Add native items
    for index, category in enumerate(get_json()):
        try:
            bg_image = urllib.quote(category['bgImage'], safe=':/?=')
        except:
            bg_image = plugin.addon.getAddonInfo('fanart')
            pass

        categories.append({
            'label': u'{0} - {1}'.format(category['title'].upper(), category['slogan']),
            'icon': bg_image,
            'thumbnail': bg_image,
            'path': plugin.url_for('show_playlists', index=index),
            'is_playable': False,
            'properties': {
                'Fanart_Image': bg_image,
                'Artist_Description': category['slogan']
            }
        })


    return categories


@plugin.route('/channels/<index>/playlists')
def show_playlists(index):
    """
    Shows playlists in a channel
    :param index: Channel index
    :return:
    """
    favorites = plugin.get_storage('favorites')
    playlists = []
    show_songs = plugin.get_setting('show_songs', bool)

    for idx, playlist in enumerate(get_json()[int(index)]['playlists']):
        try:
            bg_image = urllib.quote(playlist['bgImage'], safe=':/?=')
        except:
            bg_image = plugin.addon.getAddonInfo('fanart')
            pass

        playlists.append({
            'label': u'{0} - {1}'.format(playlist['title'].upper(), playlist['slogan']),
            'icon': bg_image,
            'thumbnail': bg_image,
            'path': plugin.url_for('show_songs', channel_index=index, playlist_index=idx)
                if show_songs else urllib.quote(playlist['songs'][0]['url'], safe=':/?='),
            'context_menu': [
                make_favorite_ctx(get_json()[int(index)]['title'], playlist['title']),
                (u'עזאם - איתור שירים', actions.update_view(plugin.url_for('show_current_song')))
            ],
            # 'replace_context_menu': True,
            'is_playable': False if show_songs else True,
            'properties': {
                'poster': bg_image,
                'thumb': bg_image,
                'fanart': bg_image,
                'Fanart_Image': bg_image,
                'mimetype': 'audio/mpeg',

            },
            'info': {
                'Title': playlist['title'],
                'Artist': playlist['slogan'],
                'Artist_Description': playlist['slogan']
            }
        })
    return plugin.finish(playlists)

@plugin.route('/channels/<channel_index>/playlists/<playlist_index>')
def show_songs(channel_index, playlist_index):
    songs = []
    playlist = get_json()[int(channel_index)]['playlists'][int(playlist_index)]
    try:
        bg_image = urllib.quote(playlist['bgImage'], safe=':/?=')
    except:
        bg_image = plugin.addon.getAddonInfo('fanart')
        pass

    # auto play playlist:
    li = xbmcgui.ListItem(playlist['title'], playlist['slogan'], bg_image)
    li.setArt({'thumb': bg_image, 'fanart': bg_image})
    li.setInfo('music', {'Title': playlist['title'], 'Artist': playlist['slogan']})
    li.setProperty('mimetype', 'audio/mpeg')
    li.setProperty('IsPlayable', 'true')
    li.setInfo('music', {
        'Title': playlist['title'],
        'Artist': playlist['slogan'],
        'Artist_Description': playlist['slogan']
    })
    xbmc.Player().play(urllib.quote(playlist['songs'][0]['url'], safe=':/?='), li)

    for idx, song in enumerate(playlist['songs']):
        songs.append({
            'label': u'{0}'.format(song['title']),
            'icon': song['icon'],
            'thumbnail': song['icon'],
            'path': plugin.url_for('play_song', channel_index=channel_index, playlist_index=playlist_index,
                                   song_index=idx),

            'context_menu': [
                (u'עזאם - איתור שירים', actions.update_view(plugin.url_for('show_current_song')))
            ],
            # 'replace_context_menu': True,
            'properties': {
                'poster': bg_image,
                'thumb': bg_image,
                'fanart': bg_image,
                'Fanart_Image': bg_image,
                'mimetype': 'audio/mpeg',

            },
            'info': {
                'Title': playlist['title'],
                'Artist': playlist['slogan'],
                'Artist_Description': playlist['slogan']
            }
        })
    return plugin.finish(songs)

@plugin.route('/channels/<channel_index>/playlists/<playlist_index>/songs/<song_index>')
def play_song(channel_index, playlist_index, song_index):
    playlist = get_json()[int(channel_index)]['playlists'][int(playlist_index)]
    song = playlist['songs'][int(song_index)]
    try:
        bg_image = urllib.quote(playlist['bgImage'], safe=':/?=')
    except:
        bg_image = plugin.addon.getAddonInfo('fanart')
        pass

    li = xbmcgui.ListItem(playlist['title'], playlist['slogan'], bg_image)
    li.setArt({'thumb': bg_image, 'fanart': bg_image})
    li.setInfo('music', {'Title': playlist['title'], 'Artist': playlist['slogan']})
    li.setProperty('mimetype', 'audio/mpeg')
    li.setProperty('IsPlayable', 'true')
    li.setInfo('music', {
        'Title': playlist['title'],
        'Artist': playlist['slogan'],
        'Artist_Description': playlist['slogan']
    })

    xbmc.Player().seekTime(song['seconds'])

@plugin.route('/show_favorites')
def show_favorites():
    favorites = plugin.get_storage('favorites')
    playlists = []

    for playlist in favorites.items():
        bg_image = urllib.quote(playlist[1]['icon'], safe=':/?=')
        playlists.append({
            'label': playlist[1]['title'] + ' - ' + playlist[1]['slogan'],
            'icon': bg_image,
            'thumbnail': bg_image,
            'path': urllib.quote(playlist[1]['audio'], safe=':/?='),
            'is_playable': True,
            'context_menu': [
                make_unfavorite_ctx(playlist[1]['title']),
                (u'עזאם - איתור שירים', actions.update_view(plugin.url_for('show_current_song')))
            ],
            # 'replace_context_menu': True,
            'properties': {
                'poster': bg_image,
                'thumb': bg_image,
                'fanart': bg_image,
                'Fanart_Image': bg_image,
                'mimetype': 'audio/mpeg',

            },
            'info': {
                'Title': playlist[1]['title'],
                'Artist': playlist[1]['slogan'],
                'Artist_Description': playlist[1]['slogan']
            }
        })
    return plugin.finish(playlists)


@plugin.route('/favorites/add/<parent_title>/<item_title>')
def add_to_favorites(parent_title, item_title):
    favorites = plugin.get_storage('favorites')
    if not favorites.get(item_title.decode('UTF-8')):
        channel = [item for item in get_json() if item['title'] == parent_title.decode('UTF-8')][0]
        playlist = [item for item in channel['playlists'] if item['title'] == item_title.decode('UTF-8')][0]

        favorites[item_title.decode('UTF-8')] = {
            'title': playlist['title'],
            'slogan': playlist['slogan'],
            'icon': urllib.quote(playlist['bgImage'], safe=':/?='),
            'audio': playlist['songs'][0]['url']
        }

        plugin.notify('הפלייליסט התווסף לרשימת המועדפים')


@plugin.route('/favorites/remove/<title>')
def remove_from_favorites(title):
    favorites = plugin.get_storage('favorites')
    favorites.pop(title.decode('UTF-8'))
    plugin.redirect(plugin.url_for('index'))
    plugin.notify('הפלייליסט הוסר מרשימת המועדפים')


@plugin.route('/azam')
def show_current_song():
    current_song = xbmc.Player().getPlayingFile()
    last_item = None
    url = ''

    if not xbmc.Player().isPlaying():
        plugin.notify('נגן המוזיקה אינו פעיל כרגע')
        return None

    if xbmc.Player().getPlayingFile().find('http://99sets.livecdn.biz/99sets') < 0:
        plugin.notify('השיר המתנגן אינו חלק מההרחבה')
        return None

    current_time = xbmc.Player().getTime()
    for category in get_json():
        if url:
            break
        for playlist in category['playlists']:
            if urllib.quote(playlist['songs'][0]['url'], safe=':/?=') == current_song:
                url = playlist['url']
                break
    if url:
        r = requests.get(url)
        if r.status_code == 200:
            soup = BeautifulSoup(r.content, 'html5lib')
            for item in soup.find_all("td", attrs={"class": "SetsPlaylistDesc", "valign": "center"}):
                if current_time < calc_fractional_seconds(item.get_text()):
                    break
                last_item = item

    if not last_item:
        plugin.notify('לא נמצא פרטי השיר')
        return None

    content = last_item.parent.find_all('td')
    image = content[3].find('img').get('src').encode('utf-8')
    plugin.notify(content[1].get_text().encode('utf-8'), content[2].get_text().encode('utf-8'), 8000, image[image.find('http'):])

    return None


def calc_fractional_seconds(time_label):
    time = time_label.split(':')
    return int(time[0]) * 3600 + int(time[1]) * 60 + int(time[2])


if __name__ == '__main__':
    plugin.run()
    xbmcplugin.setContent(plugin.handle, 'audio')
