# just to get a boot warning to shut up
touch /etc/resolv.conf

# make libvirtd listen on the external interfaces
sed -i -e 's/^#\(LIBVIRTD_ARGS="--listen"\).*/\1/' \
   /etc/sysconfig/libvirtd

# set up qemu daemon to allow outside VNC connections
sed -i -e 's/^[[:space:]]*#[[:space:]]*\(vnc_listen = "0.0.0.0"\).*/\1/' \
   /etc/libvirt/qemu.conf
# set up libvirtd to listen on TCP (for kerberos)
sed -i -e "s/^[[:space:]]*#[[:space:]]*\(listen_tcp\)\>.*/\1 = 1/" \
   -e "s/^[[:space:]]*#[[:space:]]*\(listen_tls\)\>.*/\1 = 0/" \
   /etc/libvirt/libvirtd.conf

if [ -x "/etc/sysconfig/anyterm" ]; then
    cat >> /etc/sysconfig/anyterm << \EOF_anyterm
    ANYTERM_CMD="sudo /usr/bin/virsh console %p"
    ANYTERM_LOCAL_ONLY=false
EOF_anyterm

    # permit it to run the virsh console
    echo "anyterm ALL=NOPASSWD: /usr/bin/virsh console *" >> /etc/sudoers
fi

if [ -x "/usr/libexec/qemu-kvm" ]; then
    echo "qemu-kvm is in /usr/libexec/qemu-kvm... thanks CentOS. Symlinking this"
    ln -s /usr/libexec/qemu-kvm /usr/bin/kvm
    ln -s /usr/libexec/qemu-kvm /usr/bin/qemu-kvm
fi

if [ -x "lib/systemd/system/" ]; then    # configure anyterm
    rm -rf /etc/systemd/system/default.target
    ln -sf /lib/systemd/system/multi-user.target /etc/systemd/system/default.target

    # setup ovirt-firstboot multi-user dependency
    cat >> /lib/systemd/system/ovirt-firstboot.service << \EOF_firstboot
    [Unit]
    Description=firstboot configuration program (text mode)
    After=plymouth-quit.service
    Before=getty@tty1.service

    [Service]
    Environment=RUNLEVEL=3
    ExecStartPre=-/bin/plymouth quit
    ExecStart=/etc/init.d/ovirt-firstboot start
    TimeoutSec=0
    RemainAfterExit=yes
    Type=oneshot
    SysVStartPriority=99
    StandardInput=tty-force

    [Install]
    WantedBy=multi-user.target
EOF_firstboot

    systemctl enable ovirt-firstboot.service >/dev/null 2>&1
    chkconfig --del ovirt-firstboot
else
    echo "NO SYSTEMD: using chkconfig for starting ovirt-firstboot"
    chkconfig --del ovirt-firstboot
    chkconfig --del ovirt-post
    sed -i "5i# chkconfig: 2345 97 03" /etc/init.d/ovirt-post
    sed -i "s/# chkconfig: 2345 99 01/# chkconfig: 2345 98 02/g" /etc/init.d/ovirt-firstboot
    chkconfig --add ovirt-firstboot
    chkconfig --add ovirt-post
    # Hack to make python-sqlalchemy0.7 working on centos. seriously this sucks
    mv /usr/lib64/python2.6/site-packages/SQLAlchemy-0.7.3-py2.6-linux-$(uname -m).egg/sqlalchemy /usr/lib64/python2.6/site-packages/
fi

echo "Configuring IPTables"
# here, we need to punch the appropriate holes in the firewall
cat > /etc/sysconfig/iptables << \EOF
# oVirt automatically generated firewall configuration
*filter
:INPUT ACCEPT [0:0]
:FORWARD ACCEPT [0:0]
:OUTPUT ACCEPT [0:0]
-A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT
-A INPUT -p icmp -j ACCEPT
-A INPUT -i lo -j ACCEPT
# SSH
-A INPUT -p tcp --dport 22 -j ACCEPT
# guest consoles
-A INPUT -p tcp -m multiport --dports 5634:6166 -j ACCEPT
# migration
-A INPUT -p tcp -m multiport --dports 49152:49216 -j ACCEPT
# snmp
-A INPUT -p udp --dport 161 -j ACCEPT
#
-A INPUT -j REJECT --reject-with icmp-host-prohibited
-A FORWARD -m physdev ! --physdev-is-bridged -j REJECT --reject-with icmp-host-prohibited
# archipel
-A INPUT -p tcp --dport 5222 -j ACCEPT
-A INPUT -p tcp --dport 6900:6999 -j ACCEPT
COMMIT
EOF
# configure IPv6 firewall, default is all ACCEPT
cat > /etc/sysconfig/ip6tables << \EOF
# oVirt automatically generated firewall configuration
*filter
:INPUT ACCEPT [0:0]
:FORWARD ACCEPT [0:0]
:OUTPUT ACCEPT [0:0]
-A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT
-A INPUT -p ipv6-icmp -j ACCEPT
-A INPUT -i lo -j ACCEPT
# SSH
-A INPUT -p tcp --dport 22 -j ACCEPT
# guest consoles
-A INPUT -p tcp -m multiport --dports 5634:6166 -j ACCEPT
# migration
-A INPUT -p tcp -m multiport --dports 49152:49216 -j ACCEPT
# snmp
-A INPUT -p udp --dport 161 -j ACCEPT
# unblock ipv6 dhcp response
-A INPUT -p udp --dport 546 -j ACCEPT
-A INPUT -j REJECT --reject-with icmp6-adm-prohibited
-A FORWARD -m physdev ! --physdev-is-bridged -j REJECT --reject-with icmp6-adm-prohibited
# archipel
-A INPUT -p tcp --dport 5222 -j ACCEPT
-A INPUT -p tcp --dport 6900:6999 -j ACCEPT
COMMIT
EOF

python -m compileall /usr/share/virt-manager

#Add some upstream specific rwtab entries
cat >> /etc/rwtab.d/ovirt << \EOF_rwtab_ovirt2
dirs    /root/.virt-manager
dirs    /admin/.virt-manager
EOF_rwtab_ovirt2

# create .virt-manager directories for readonly root
mkdir -p /root/.virt-manager /home/admin/.virt-manager

echo "Configuring SELinux"
# custom module for node specific rules
mkdir /tmp/SELinux
cd /tmp/SELinux
cat > ovirt.te << \EOF_OVIRT_TE
module ovirt 1.0;
require {
    type initrc_t;
    type initrc_tmp_t;
    type mount_t;
    type setfiles_t;
    type shadow_t;
    type unconfined_t;
    class file { append mounton open getattr read execute ioctl lock entrypoint };
    class fd { use };
    class process { sigchld signull transition noatsecure siginh rlimitinh getattr };
    class fifo_file { getattr open read write append lock ioctl };
    class filesystem getattr;
    class dir { getattr search open read lock ioctl };
    class socket { read write };
    class tcp_socket { read write };
    class udp_socket { read write };
    class rawip_socket { read write };
    class netlink_socket { read write };
    class packet_socket { read write };
    class unix_stream_socket { read write create ioctl getattr lock setattr append bind connect getopt setopt shutdown connectto };
    class unix_dgram_socket { read write };
    class appletalk_socket { read write };
    class netlink_route_socket { read write };
    class netlink_firewall_socket { read write };
    class netlink_tcpdiag_socket { read write };
    class netlink_nflog_socket { read write };
    class netlink_xfrm_socket { read write };
    class netlink_selinux_socket { read write };
    class netlink_audit_socket { read write };
    class netlink_ip6fw_socket { read write };
    class netlink_dnrt_socket { read write };
    class netlink_kobject_uevent_socket { read write };
    class tun_socket { read write };
    class chr_file { getattr read write append ioctl lock open };
    class lnk_file { getattr read };
    class sock_file { getattr write open append };
}
allow mount_t shadow_t:file mounton;
allow setfiles_t initrc_tmp_t:file append;
type ovirt_exec_t;
init_daemon_domain(unconfined_t,ovirt_exec_t)
EOF_OVIRT_TE
cat > ovirt.fc << \EOF_OVIRT_FC
/etc/rc\.d/init\.d/ovirt-firstboot             -- gen_context(system_u:object_r:ovirt_exec_t)
/etc/rc\.d/init\.d/ovirt-post             -- gen_context(system_u:object_r:ovirt_exec_t)
EOF_OVIRT_FC
make NAME=targeted -f /usr/share/selinux/devel/Makefile
semodule -v -i ovirt.pp
cd /
rm -rf /tmp/SELinux

# Archipel
echo "[ARCHIPEL] Reactivating the root account"
passwd -uf root

echo "[ARCHIPEL] Creating the /vm and /stateless folders"
mkdir -p /vm
mkdir -p /stateless


echo "[ARCHIPEL] Updating the archipel config file to be in stateless mode"
cat > /etc/archipel/archipel.conf <<EOF_archipelconf
[GLOBAL]
stateless_node = True
EOF_archipelconf

echo "[ARCHIPEL] Update the archipe init.d file"
sed -i "s/# Required-Start:.*/# Required-Start: ovirt-firstboot/g" /etc/init.d/archipel
sed -i "/# Required-Stop:.*/d" /etc/init.d/archipel
sed -i "/# Should-Stop:.*/d" /etc/init.d/archipel
sed -i "/# Default-Start:.*/d" /etc/init.d/archipel
sed -i "/# Default-Stop:.*/d" /etc/init.d/archipel

/sbin/service zfs-fuse stop 2>/dev/null
