/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.apache.jcp.xml.dsig.internal.dom.BaseStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMX509IssuerSerial;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMX509Data
extends BaseStructure
implements X509Data {
    private final List<Object> content;
    private CertificateFactory cf;

    public DOMX509Data(List<?> content) {
        if (content == null) {
            throw new NullPointerException("content cannot be null");
        }
        ArrayList contentCopy = new ArrayList(content);
        if (contentCopy.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        int size = contentCopy.size();
        for (int i = 0; i < size; ++i) {
            Object x509Type = contentCopy.get(i);
            if (x509Type instanceof String) {
                new X500Principal((String)x509Type);
                continue;
            }
            if (x509Type instanceof byte[] || x509Type instanceof X509Certificate || x509Type instanceof X509CRL || x509Type instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid X509Data type");
        }
        this.content = Collections.unmodifiableList(contentCopy);
    }

    public DOMX509Data(Element xdElem) throws MarshalException {
        ArrayList<Object> newContent = new ArrayList<Object>();
        for (Node firstChild = xdElem.getFirstChild(); firstChild != null; firstChild = firstChild.getNextSibling()) {
            if (firstChild.getNodeType() != 1) continue;
            Element childElem = (Element)firstChild;
            String localName = childElem.getLocalName();
            String namespace = childElem.getNamespaceURI();
            if ("X509Certificate".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                newContent.add(this.unmarshalX509Certificate(childElem));
                continue;
            }
            if ("X509IssuerSerial".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                newContent.add(new DOMX509IssuerSerial(childElem));
                continue;
            }
            if ("X509SubjectName".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                newContent.add(childElem.getFirstChild().getNodeValue());
                continue;
            }
            if ("X509SKI".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                String content = XMLUtils.getFullTextChildrenFromElement(childElem);
                newContent.add(XMLUtils.decode(content));
                continue;
            }
            if ("X509CRL".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                newContent.add(this.unmarshalX509CRL(childElem));
                continue;
            }
            newContent.add(new DOMStructure(childElem));
        }
        this.content = Collections.unmodifiableList(newContent);
    }

    public List<Object> getContent() {
        return this.content;
    }

    public static void marshal(XmlWriter xwriter, X509Data x509Data, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        xwriter.writeStartElement(dsPrefix, "X509Data", "http://www.w3.org/2000/09/xmldsig#");
        List<?> content = x509Data.getContent();
        int size = content.size();
        for (int i = 0; i < size; ++i) {
            Object object = content.get(i);
            if (object instanceof X509Certificate) {
                DOMX509Data.marshalCert(xwriter, (X509Certificate)object, dsPrefix);
                continue;
            }
            if (object instanceof XMLStructure) {
                xwriter.marshalStructure((XMLStructure)object, dsPrefix, context);
                continue;
            }
            if (object instanceof byte[]) {
                DOMX509Data.marshalSKI(xwriter, (byte[])object, dsPrefix);
                continue;
            }
            if (object instanceof String) {
                DOMX509Data.marshalSubjectName(xwriter, (String)object, dsPrefix);
                continue;
            }
            if (!(object instanceof X509CRL)) continue;
            DOMX509Data.marshalCRL(xwriter, (X509CRL)object, dsPrefix);
        }
        xwriter.writeEndElement();
    }

    private static void marshalSKI(XmlWriter xwriter, byte[] skid, String dsPrefix) {
        xwriter.writeTextElement(dsPrefix, "X509SKI", "http://www.w3.org/2000/09/xmldsig#", XMLUtils.encodeToString(skid));
    }

    private static void marshalSubjectName(XmlWriter xwriter, String name, String dsPrefix) {
        xwriter.writeTextElement(dsPrefix, "X509SubjectName", "http://www.w3.org/2000/09/xmldsig#", name);
    }

    private static void marshalCert(XmlWriter xwriter, X509Certificate cert, String dsPrefix) throws MarshalException {
        try {
            byte[] encoded = cert.getEncoded();
            xwriter.writeTextElement(dsPrefix, "X509Certificate", "http://www.w3.org/2000/09/xmldsig#", XMLUtils.encodeToString(encoded));
        }
        catch (CertificateEncodingException e) {
            throw new MarshalException("Error encoding X509Certificate", e);
        }
    }

    private static void marshalCRL(XmlWriter xwriter, X509CRL crl, String dsPrefix) throws MarshalException {
        try {
            byte[] encoded = crl.getEncoded();
            xwriter.writeTextElement(dsPrefix, "X509CRL", "http://www.w3.org/2000/09/xmldsig#", XMLUtils.encodeToString(encoded));
        }
        catch (CRLException e) {
            throw new MarshalException("Error encoding X509CRL", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509Certificate unmarshalX509Certificate(Element elem) throws MarshalException {
        try (ByteArrayInputStream bs = this.unmarshalBase64Binary(elem);){
            X509Certificate x509Certificate = (X509Certificate)this.cf.generateCertificate(bs);
            return x509Certificate;
        }
        catch (CertificateException e) {
            throw new MarshalException("Cannot create X509Certificate", e);
        }
        catch (IOException e) {
            throw new MarshalException("Error closing stream", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509CRL unmarshalX509CRL(Element elem) throws MarshalException {
        try (ByteArrayInputStream bs = this.unmarshalBase64Binary(elem);){
            X509CRL x509CRL = (X509CRL)this.cf.generateCRL(bs);
            return x509CRL;
        }
        catch (CRLException e) {
            throw new MarshalException("Cannot create X509CRL", e);
        }
        catch (IOException e) {
            throw new MarshalException("Error closing stream", e);
        }
    }

    private ByteArrayInputStream unmarshalBase64Binary(Element elem) throws MarshalException {
        try {
            if (this.cf == null) {
                this.cf = CertificateFactory.getInstance("X.509");
            }
            String content = XMLUtils.getFullTextChildrenFromElement(elem);
            return new ByteArrayInputStream(XMLUtils.decode(content));
        }
        catch (CertificateException e) {
            throw new MarshalException("Cannot create CertificateFactory", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X509Data)) {
            return false;
        }
        X509Data oxd = (X509Data)o;
        List<?> ocontent = oxd.getContent();
        int size = this.content.size();
        if (size != ocontent.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Object x = this.content.get(i);
            Object ox = ocontent.get(i);
            if (!(x instanceof byte[] ? !(ox instanceof byte[]) || !Arrays.equals((byte[])x, (byte[])ox) : !x.equals(ox))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.content.hashCode();
        return result;
    }
}

