/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import io.reactivex.Flowable;
import io.reactivex.internal.functions.Functions;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Features;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.EvictionType;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.TransactionalStoreInterceptor;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.async.AdvancedAsyncCacheLoader;
import org.infinispan.persistence.async.AdvancedAsyncCacheWriter;
import org.infinispan.persistence.async.AsyncCacheLoader;
import org.infinispan.persistence.async.AsyncCacheWriter;
import org.infinispan.persistence.async.State;
import org.infinispan.persistence.factory.CacheStoreFactoryRegistry;
import org.infinispan.persistence.internal.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.FlagAffectedStore;
import org.infinispan.persistence.spi.LocalOnlyCacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.persistence.spi.StoreUnavailableException;
import org.infinispan.persistence.spi.TransactionalCacheWriter;
import org.infinispan.persistence.support.AdvancedSingletonCacheWriter;
import org.infinispan.persistence.support.BatchModification;
import org.infinispan.persistence.support.ComposedSegmentedLoadWriteStore;
import org.infinispan.persistence.support.DelegatingCacheLoader;
import org.infinispan.persistence.support.DelegatingCacheWriter;
import org.infinispan.persistence.support.SingletonCacheWriter;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.reactivestreams.Publisher;

public class PersistenceManagerImpl
implements PersistenceManager {
    private static final Log log = org.infinispan.util.logging.LogFactory.getLog(PersistenceManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    private Configuration configuration;
    @Inject
    private GlobalConfiguration globalConfiguration;
    @Inject
    private ComponentRef<AdvancedCache<Object, Object>> cache;
    @Inject
    private StreamingMarshaller m;
    @Inject
    private TransactionManager transactionManager;
    @Inject
    private TimeService timeService;
    @Inject
    @ComponentName(value="org.infinispan.executors.persistence")
    private ScheduledExecutorService persistenceExecutor;
    @Inject
    private ByteBufferFactory byteBufferFactory;
    @Inject
    private MarshalledEntryFactory marshalledEntryFactory;
    @Inject
    private CacheStoreFactoryRegistry cacheStoreFactoryRegistry;
    @Inject
    private ComponentRef<InternalExpirationManager<Object, Object>> expirationManager;
    @Inject
    private CacheNotifier cacheNotifier;
    @Inject
    private KeyPartitioner keyPartitioner;
    @Inject
    private Transport transport;
    @GuardedBy(value="storesMutex")
    private final List<CacheLoader> loaders = new ArrayList<CacheLoader>();
    @GuardedBy(value="storesMutex")
    private final List<CacheWriter> nonTxWriters = new ArrayList<CacheWriter>();
    @GuardedBy(value="storesMutex")
    private final List<TransactionalCacheWriter> txWriters = new ArrayList<TransactionalCacheWriter>();
    private final Semaphore publisherSemaphore = new Semaphore(Integer.MAX_VALUE);
    private final ReadWriteLock storesMutex = new ReentrantReadWriteLock();
    @GuardedBy(value="storesMutex")
    private final Map<Object, StoreStatus> storeStatuses = new HashMap<Object, StoreStatus>();
    private AdvancedPurgeListener<Object, Object> advancedListener;
    private final Callable<Semaphore> publisherSemaphoreCallable = Functions.justCallable((Object)this.publisherSemaphore);
    private volatile boolean enabled;
    private volatile boolean clearOnStop;
    private boolean preloaded;
    private Future availabilityFuture;
    private volatile StoreUnavailableException unavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Start
    public void start() {
        this.advancedListener = new AdvancedPurgeListener(this.expirationManager.wired());
        this.preloaded = false;
        this.enabled = this.configuration.persistence().usingStores();
        if (!this.enabled) {
            return;
        }
        try {
            this.createLoadersAndWriters();
            Transaction xaTx = null;
            if (this.transactionManager != null) {
                xaTx = this.transactionManager.suspend();
            }
            this.storesMutex.writeLock().lock();
            try {
                HashSet undelegated = new HashSet();
                this.nonTxWriters.forEach(w -> this.startWriter((CacheWriter)w, undelegated));
                this.txWriters.forEach(w -> this.startWriter((CacheWriter)w, undelegated));
                this.loaders.forEach(l -> this.startLoader((CacheLoader)l, undelegated));
                this.pollStoreAvailability();
                long interval = this.configuration.persistence().availabilityInterval();
                this.availabilityFuture = this.persistenceExecutor.scheduleAtFixedRate(this::pollStoreAvailability, interval, interval, TimeUnit.MILLISECONDS);
            }
            finally {
                if (xaTx != null) {
                    this.transactionManager.resume(xaTx);
                }
                this.storesMutex.writeLock().unlock();
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to start cache loaders", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollStoreAvailability() {
        this.storesMutex.writeLock().lock();
        try {
            boolean availabilityChanged = false;
            boolean failureDetected = false;
            for (StoreStatus status : this.storeStatuses.values()) {
                if (status.availabilityChanged()) {
                    availabilityChanged = true;
                }
                if (!availabilityChanged || status.availability || failureDetected) continue;
                failureDetected = true;
                this.unavailableException = new StoreUnavailableException(String.format("Store %s is unavailable", status.store));
                this.cacheNotifier.notifyPersistenceAvailabilityChanged(false);
            }
            if (!failureDetected && availabilityChanged) {
                this.unavailableException = null;
                this.cacheNotifier.notifyPersistenceAvailabilityChanged(true);
            }
        }
        finally {
            this.storesMutex.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop
    public void stop() {
        this.storesMutex.writeLock().lock();
        this.publisherSemaphore.acquireUninterruptibly(Integer.MAX_VALUE);
        try {
            if (this.clearOnStop) {
                this.clearAllStores(PersistenceManager.AccessMode.BOTH);
            }
            HashSet undelegated = new HashSet();
            Consumer<CacheWriter> stopWriters = writer -> {
                writer.stop();
                if (writer instanceof DelegatingCacheWriter) {
                    CacheWriter actual = this.undelegate((CacheWriter)writer);
                    actual.stop();
                    undelegated.add(actual);
                } else {
                    undelegated.add(writer);
                }
            };
            if (this.availabilityFuture != null) {
                this.availabilityFuture.cancel(true);
            }
            this.nonTxWriters.forEach(stopWriters);
            this.nonTxWriters.clear();
            this.txWriters.forEach(stopWriters);
            this.txWriters.clear();
            for (CacheLoader l : this.loaders) {
                CacheLoader actual;
                if (!undelegated.contains(l)) {
                    l.stop();
                }
                if (!(l instanceof DelegatingCacheLoader) || undelegated.contains(actual = this.undelegate(l))) continue;
                actual.stop();
            }
            this.loaders.clear();
            this.preloaded = false;
        }
        finally {
            this.publisherSemaphore.release(Integer.MAX_VALUE);
            this.storesMutex.writeLock().unlock();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void checkStoreAvailability() {
        if (!this.enabled) {
            return;
        }
        if (this.unavailableException != null) {
            throw this.unavailableException;
        }
    }

    @Override
    public boolean isAvailable() {
        if (!this.enabled) {
            return false;
        }
        return this.unavailableException == null;
    }

    @Override
    public boolean isPreloaded() {
        return this.preloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preload() {
        if (!this.enabled) {
            return;
        }
        AdvancedCacheLoader preloadCl = null;
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                if (!this.getStoreConfig(l).preload()) continue;
                if (!(l instanceof AdvancedCacheLoader)) {
                    throw new PersistenceException("Cannot preload from cache loader '" + l.getClass().getName() + "' as it doesn't implement '" + AdvancedCacheLoader.class.getName() + "'");
                }
                preloadCl = (AdvancedCacheLoader)l;
                if (preloadCl instanceof AdvancedAsyncCacheLoader) {
                    preloadCl = (AdvancedCacheLoader)((AdvancedAsyncCacheLoader)preloadCl).undelegate();
                }
                break;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        if (preloadCl == null) {
            return;
        }
        long start = this.timeService.time();
        long maxEntries = this.getMaxEntries();
        AtomicInteger loadedEntries = new AtomicInteger(0);
        AdvancedCache<Object, Object> flaggedCache = this.getCacheForStateInsertion();
        Long insertAmount = (Long)Flowable.fromPublisher(preloadCl.publishEntries(null, true, true)).take(maxEntries).doOnNext(me -> {
            Metadata metadata = me.getMetadata() != null ? ((InternalMetadataImpl)me.getMetadata()).actual() : null;
            this.preloadKey(flaggedCache, me.getKey(), me.getValue(), metadata);
        }).count().blockingGet();
        this.preloaded = insertAmount < maxEntries;
        log.debugf("Preloaded %d keys in %s", loadedEntries.get(), Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
    }

    @Override
    public void disableStore(String storeType) {
        if (this.enabled) {
            boolean noMoreStores;
            this.storesMutex.writeLock().lock();
            this.publisherSemaphore.acquireUninterruptibly(Integer.MAX_VALUE);
            try {
                this.removeCacheLoader(storeType, this.loaders);
                this.removeCacheWriter(storeType, this.nonTxWriters);
                this.removeCacheWriter(storeType, this.txWriters);
                boolean bl = noMoreStores = this.loaders.isEmpty() && this.nonTxWriters.isEmpty() && this.txWriters.isEmpty();
                if (!noMoreStores) {
                    this.pollStoreAvailability();
                }
            }
            finally {
                this.publisherSemaphore.release(Integer.MAX_VALUE);
                this.storesMutex.writeLock().unlock();
            }
            if (noMoreStores) {
                this.availabilityFuture.cancel(true);
                AsyncInterceptorChain chain = this.cache.wired().getAsyncInterceptorChain();
                CacheLoaderInterceptor loaderInterceptor = chain.findInterceptorExtending(CacheLoaderInterceptor.class);
                if (loaderInterceptor == null) {
                    log.persistenceWithoutCacheLoaderInterceptor();
                } else {
                    chain.removeInterceptor(loaderInterceptor.getClass());
                }
                DDAsyncInterceptor writerInterceptor = chain.findInterceptorExtending(CacheWriterInterceptor.class);
                if (writerInterceptor == null) {
                    writerInterceptor = chain.findInterceptorWithClass(TransactionalStoreInterceptor.class);
                    if (writerInterceptor == null) {
                        log.persistenceWithoutCacheWriteInterceptor();
                    } else {
                        chain.removeInterceptor(writerInterceptor.getClass());
                    }
                } else {
                    chain.removeInterceptor(writerInterceptor.getClass());
                }
                this.enabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> getStores(Class<T> storeClass) {
        this.storesMutex.readLock().lock();
        try {
            HashSet result = new HashSet();
            for (CacheLoader l : this.loaders) {
                CacheLoader real = this.undelegate(l);
                if (!storeClass.isInstance(real)) continue;
                result.add(storeClass.cast(real));
            }
            Consumer<CacheWriter> getWriters = writer -> {
                CacheWriter real = this.undelegate((CacheWriter)writer);
                if (storeClass.isInstance(real)) {
                    result.add(storeClass.cast(real));
                }
            };
            this.nonTxWriters.forEach(getWriters);
            this.txWriters.forEach(getWriters);
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getStoresAsString() {
        this.storesMutex.readLock().lock();
        try {
            HashSet<String> loaderTypes = new HashSet<String>(this.loaders.size());
            for (CacheLoader cacheLoader : this.loaders) {
                loaderTypes.add(this.undelegate(cacheLoader).getClass().getName());
            }
            for (CacheWriter cacheWriter : this.nonTxWriters) {
                loaderTypes.add(this.undelegate(cacheWriter).getClass().getName());
            }
            for (CacheWriter cacheWriter : this.txWriters) {
                loaderTypes.add(this.undelegate(cacheWriter).getClass().getName());
            }
            HashSet<String> hashSet = loaderTypes;
            return hashSet;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeExpired() {
        if (!this.enabled) {
            return;
        }
        long start = -1L;
        try {
            if (trace) {
                log.trace("Purging cache store of expired entries");
                start = this.timeService.time();
            }
            this.storesMutex.readLock().lock();
            try {
                this.checkStoreAvailability();
                Consumer<CacheWriter> purgeWriter = writer -> {
                    if (this.getStoreConfig(writer).shared() && !this.transport.isCoordinator()) {
                        return;
                    }
                    if (writer instanceof AdvancedCacheExpirationWriter) {
                        ((AdvancedCacheExpirationWriter)writer).purge((Executor)this.persistenceExecutor, this.advancedListener);
                    } else if (writer instanceof AdvancedCacheWriter) {
                        ((AdvancedCacheWriter)writer).purge(this.persistenceExecutor, this.advancedListener);
                    }
                };
                this.nonTxWriters.forEach(purgeWriter);
                this.txWriters.forEach(purgeWriter);
            }
            finally {
                this.storesMutex.readLock().unlock();
            }
            if (trace) {
                log.tracef("Purging cache store completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
            }
        }
        catch (Exception e) {
            log.exceptionPurgingDataContainer(e);
        }
    }

    @Override
    public void clearAllStores(Predicate<? super StoreConfiguration> predicate) {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            Consumer<CacheWriter> clearWriter = writer -> {
                if (writer instanceof AdvancedCacheWriter && predicate.test(this.getStoreConfig(writer))) {
                    ((AdvancedCacheWriter)writer).clear();
                }
            };
            this.nonTxWriters.forEach(clearWriter);
            this.txWriters.forEach(clearWriter);
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFromAllStores(Object key, int segment, Predicate<? super StoreConfiguration> predicate) {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            boolean removed = false;
            for (CacheWriter w : this.nonTxWriters) {
                if (!predicate.test(this.getStoreConfig(w))) continue;
                if (w instanceof SegmentedAdvancedLoadWriteStore) {
                    removed |= ((SegmentedAdvancedLoadWriteStore)w).delete(segment, key);
                    continue;
                }
                removed |= w.delete(key);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> AdvancedCacheLoader<K, V> getFirstAdvancedCacheLoader(Predicate<? super StoreConfiguration> predicate) {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader loader : this.loaders) {
                if (!predicate.test(this.getStoreConfig(loader)) || !(loader instanceof AdvancedCacheLoader)) continue;
                AdvancedCacheLoader advancedCacheLoader = (AdvancedCacheLoader)loader;
                return advancedCacheLoader;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> SegmentedAdvancedLoadWriteStore<K, V> getFirstSegmentedStore(Predicate<? super StoreConfiguration> predicate) {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                StoreConfiguration storeConfiguration;
                if (!(l instanceof SegmentedAdvancedLoadWriteStore) || (storeConfiguration = this.getStoreConfig(l)) == null || !storeConfiguration.segmented() || !predicate.test(storeConfiguration)) continue;
                SegmentedAdvancedLoadWriteStore segmentedAdvancedLoadWriteStore = (SegmentedAdvancedLoadWriteStore)l;
                return segmentedAdvancedLoadWriteStore;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        return null;
    }

    @Override
    public <K, V> Publisher<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        AdvancedCacheLoader advancedCacheLoader = this.getFirstAdvancedCacheLoader(predicate);
        if (advancedCacheLoader != null) {
            return Flowable.using(this.publisherSemaphoreCallable, semaphore -> {
                semaphore.acquire();
                return advancedCacheLoader.publishEntries(filter, fetchValue, fetchMetadata);
            }, Semaphore::release);
        }
        return Flowable.empty();
    }

    @Override
    public <K, V> Publisher<MarshalledEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        SegmentedAdvancedLoadWriteStore segmentedStore = this.getFirstSegmentedStore(predicate);
        if (segmentedStore != null) {
            return Flowable.using(this.publisherSemaphoreCallable, semaphore -> {
                semaphore.acquire();
                return segmentedStore.publishEntries(segments, filter, fetchValue, fetchMetadata);
            }, Semaphore::release);
        }
        return this.publishEntries(PersistenceUtil.combinePredicate(segments, this.keyPartitioner, filter), fetchValue, fetchMetadata, predicate);
    }

    @Override
    public <K> Publisher<K> publishKeys(Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        AdvancedCacheLoader advancedCacheLoader = this.getFirstAdvancedCacheLoader(predicate);
        if (advancedCacheLoader != null) {
            return Flowable.using(this.publisherSemaphoreCallable, semaphore -> {
                semaphore.acquire();
                return advancedCacheLoader.publishKeys(filter);
            }, Semaphore::release);
        }
        return Flowable.empty();
    }

    @Override
    public <K> Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        SegmentedAdvancedLoadWriteStore segmentedStore = this.getFirstSegmentedStore(predicate);
        if (segmentedStore != null) {
            return Flowable.using(this.publisherSemaphoreCallable, semaphore -> {
                semaphore.acquire();
                return segmentedStore.publishKeys(segments, filter);
            }, Semaphore::release);
        }
        return this.publishKeys(PersistenceUtil.combinePredicate(segments, this.keyPartitioner, filter), predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshalledEntry loadFromAllStores(Object key, boolean localInvocation, boolean includeStores) {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            for (CacheLoader l : this.loaders) {
                MarshalledEntry load;
                if (!this.allowLoad(l, localInvocation, includeStores) || (load = l.load(key)) == null) continue;
                MarshalledEntry marshalledEntry = load;
                return marshalledEntry;
            }
            Iterator<CacheLoader> iterator = null;
            return iterator;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshalledEntry loadFromAllStores(Object key, int segment, boolean localInvocation, boolean includeStores) {
        this.storesMutex.readLock().lock();
        try {
            MarshalledEntry load;
            this.checkStoreAvailability();
            for (CacheLoader l : this.loaders) {
                if (!this.allowLoad(l, localInvocation, includeStores) || !(l instanceof SegmentedAdvancedLoadWriteStore) || (load = ((SegmentedAdvancedLoadWriteStore)l).load(segment, key)) == null) continue;
                MarshalledEntry marshalledEntry = load;
                return marshalledEntry;
            }
            for (CacheLoader l : this.loaders) {
                if (!this.allowLoad(l, localInvocation, includeStores) || (load = l.load(key)) == null) continue;
                MarshalledEntry marshalledEntry = load;
                return marshalledEntry;
            }
            Iterator<CacheLoader> iterator = null;
            return iterator;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    private boolean allowLoad(CacheLoader loader, boolean localInvocation, boolean includeStores) {
        return !(!localInvocation && this.isLocalOnlyLoader(loader) || !includeStores && loader instanceof CacheWriter);
    }

    private boolean isLocalOnlyLoader(CacheLoader loader) {
        if (loader instanceof LocalOnlyCacheLoader) {
            return true;
        }
        if (loader instanceof DelegatingCacheLoader) {
            CacheLoader unwrappedLoader = ((DelegatingCacheLoader)loader).undelegate();
            return unwrappedLoader instanceof LocalOnlyCacheLoader;
        }
        return false;
    }

    @Override
    public void writeToAllNonTxStores(MarshalledEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate) {
        this.writeToAllNonTxStores(marshalledEntry, segment, predicate, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToAllNonTxStores(MarshalledEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate, long flags) {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            this.nonTxWriters.stream().filter(writer -> !(writer instanceof FlagAffectedStore) || ((FlagAffectedStore)FlagAffectedStore.class.cast(writer)).shouldWrite(flags)).filter(writer -> predicate.test(this.getStoreConfig(writer))).forEach(writer -> {
                if (writer instanceof SegmentedAdvancedLoadWriteStore) {
                    ((SegmentedAdvancedLoadWriteStore)writer).write(segment, marshalledEntry);
                } else {
                    writer.write(marshalledEntry);
                }
            });
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBatchToAllNonTxStores(Iterable<MarshalledEntry> entries, Predicate<? super StoreConfiguration> predicate, long flags) {
        if (!entries.iterator().hasNext()) {
            return;
        }
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            this.nonTxWriters.stream().filter(writer -> !(writer instanceof FlagAffectedStore) || ((FlagAffectedStore)FlagAffectedStore.class.cast(writer)).shouldWrite(flags)).filter(writer -> predicate.test(this.getStoreConfig(writer))).forEach(writer -> writer.writeBatch(entries));
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBatchFromAllNonTxStores(Iterable<Object> keys, Predicate<? super StoreConfiguration> predicate, long flags) {
        if (!keys.iterator().hasNext()) {
            return;
        }
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            this.nonTxWriters.stream().filter(writer -> predicate.test(this.getStoreConfig(writer))).forEach(writer -> writer.deleteBatch(keys));
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareAllTxStores(Transaction transaction, BatchModification batchModification, Predicate<? super StoreConfiguration> predicate) throws PersistenceException {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            for (CacheWriter cacheWriter : this.txWriters) {
                if (!predicate.test(this.getStoreConfig(cacheWriter)) && !this.configuration.clustering().cacheMode().equals((Object)CacheMode.LOCAL)) continue;
                TransactionalCacheWriter txWriter = (TransactionalCacheWriter)this.undelegate(cacheWriter);
                txWriter.prepareWithModifications(transaction, batchModification);
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    @Override
    public void commitAllTxStores(Transaction transaction, Predicate<? super StoreConfiguration> predicate) {
        this.performOnAllTxStores(predicate, writer -> writer.commit(transaction));
    }

    @Override
    public void rollbackAllTxStores(Transaction transaction, Predicate<? super StoreConfiguration> predicate) {
        this.performOnAllTxStores(predicate, writer -> writer.rollback(transaction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdvancedCacheLoader getStateTransferProvider() {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            for (CacheLoader l : this.loaders) {
                StoreConfiguration storeConfiguration = this.getStoreConfig(l);
                if (!storeConfiguration.fetchPersistentState() || storeConfiguration.shared()) continue;
                AdvancedCacheLoader advancedCacheLoader = (AdvancedCacheLoader)l;
                return advancedCacheLoader;
            }
            Iterator<CacheLoader> iterator = null;
            return iterator;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(Predicate<? super StoreConfiguration> predicate) {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            for (CacheLoader l : this.loaders) {
                StoreConfiguration storeConfiguration = this.getStoreConfig(l);
                if (!predicate.test(storeConfiguration) || !(l instanceof AdvancedCacheLoader)) continue;
                int n = ((AdvancedCacheLoader)l).size();
                return n;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(IntSet segments) {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            for (CacheLoader l : this.loaders) {
                StoreConfiguration storeConfiguration;
                if (!(l instanceof SegmentedAdvancedLoadWriteStore) || (storeConfiguration = this.getStoreConfig(l)) == null || !storeConfiguration.segmented()) continue;
                int n = ((SegmentedAdvancedLoadWriteStore)l).size(segments);
                return n;
            }
            long count = (Long)Flowable.fromPublisher(this.publishKeys(segments, null, PersistenceManager.AccessMode.BOTH)).count().blockingGet();
            if (count > Integer.MAX_VALUE) {
                int n = Integer.MAX_VALUE;
                return n;
            }
            int n = (int)count;
            return n;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    @Override
    public void setClearOnStop(boolean clearOnStop) {
        this.clearOnStop = clearOnStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSegments(IntSet segments) {
        boolean allSegmented = true;
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader loader : this.loaders) {
                if (!PersistenceManager.AccessMode.PRIVATE.test(this.getStoreConfig(loader))) continue;
                if (loader instanceof SegmentedAdvancedLoadWriteStore) {
                    ((SegmentedAdvancedLoadWriteStore)loader).addSegments(segments);
                    continue;
                }
                if (!(loader instanceof CacheWriter)) continue;
                allSegmented = false;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        return allSegmented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSegments(IntSet segments) {
        boolean allSegmented = true;
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader loader : this.loaders) {
                if (!PersistenceManager.AccessMode.PRIVATE.test(this.getStoreConfig(loader))) continue;
                if (loader instanceof SegmentedAdvancedLoadWriteStore) {
                    ((SegmentedAdvancedLoadWriteStore)loader).removeSegments(segments);
                    continue;
                }
                if (!(loader instanceof CacheWriter)) continue;
                allSegmented = false;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        return allSegmented;
    }

    public List<CacheLoader> getAllLoaders() {
        this.storesMutex.readLock().lock();
        try {
            ArrayList<CacheLoader> arrayList = new ArrayList<CacheLoader>(this.loaders);
            return arrayList;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    public List<CacheWriter> getAllWriters() {
        this.storesMutex.readLock().lock();
        try {
            ArrayList<CacheWriter> arrayList = new ArrayList<CacheWriter>(this.nonTxWriters);
            return arrayList;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    public List<CacheWriter> getAllTxWriters() {
        this.storesMutex.readLock().lock();
        try {
            ArrayList<CacheWriter> arrayList = new ArrayList<CacheWriter>(this.txWriters);
            return arrayList;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    private void createLoadersAndWriters() {
        Features features = this.globalConfiguration.features();
        for (StoreConfiguration cfg : this.configuration.persistence().stores()) {
            Object bareInstance;
            if (cfg.segmented()) {
                if (!features.isAvailable("data-segmentation")) {
                    throw LogFactory.getLog(MethodHandles.lookup().lookupClass()).featureDisabled("data-segmentation");
                }
                bareInstance = cfg instanceof AbstractSegmentedStoreConfiguration ? new ComposedSegmentedLoadWriteStore((AbstractSegmentedStoreConfiguration)cfg) : this.cacheStoreFactoryRegistry.createInstance(cfg);
            } else {
                bareInstance = this.cacheStoreFactoryRegistry.createInstance(cfg);
            }
            StoreConfiguration processedConfiguration = this.cacheStoreFactoryRegistry.processStoreConfiguration(cfg);
            CacheWriter writer = this.createCacheWriter(bareInstance);
            CacheLoader loader = this.createCacheLoader(bareInstance);
            writer = this.postProcessWriter(processedConfiguration, writer);
            loader = this.postProcessReader(processedConfiguration, writer, loader);
            InitializationContextImpl ctx = new InitializationContextImpl(processedConfiguration, this.cache.wired(), this.keyPartitioner, this.m, this.timeService, this.byteBufferFactory, this.marshalledEntryFactory, this.persistenceExecutor);
            this.initializeLoader(processedConfiguration, loader, ctx);
            this.initializeWriter(processedConfiguration, writer, ctx);
            this.initializeBareInstance(bareInstance, ctx);
        }
    }

    private CacheLoader postProcessReader(StoreConfiguration cfg, CacheWriter writer, CacheLoader loader) {
        if (cfg.async().enabled() && loader != null && writer != null) {
            loader = this.createAsyncLoader(loader, (AsyncCacheWriter)writer);
        }
        return loader;
    }

    private CacheWriter postProcessWriter(StoreConfiguration cfg, CacheWriter writer) {
        if (writer != null) {
            if (cfg.ignoreModifications()) {
                writer = null;
            } else if (cfg.singletonStore().enabled()) {
                writer = this.createSingletonWriter(cfg, writer);
            } else if (cfg.async().enabled()) {
                writer = this.createAsyncWriter(writer);
            }
        }
        return writer;
    }

    private CacheLoader createAsyncLoader(CacheLoader loader, AsyncCacheWriter asyncWriter) {
        AtomicReference<State> state = asyncWriter.getState();
        loader = loader instanceof AdvancedCacheLoader ? new AdvancedAsyncCacheLoader(loader, state) : new AsyncCacheLoader(loader, state);
        return loader;
    }

    private SingletonCacheWriter createSingletonWriter(StoreConfiguration cfg, CacheWriter writer) {
        return writer instanceof AdvancedCacheWriter ? new AdvancedSingletonCacheWriter(writer, cfg.singletonStore()) : new SingletonCacheWriter(writer, cfg.singletonStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeWriter(StoreConfiguration cfg, CacheWriter writer, InitializationContextImpl ctx) {
        if (writer != null) {
            if (writer instanceof DelegatingCacheWriter) {
                writer.init(ctx);
            }
            this.storesMutex.writeLock().lock();
            try {
                if (this.undelegate(writer) instanceof TransactionalCacheWriter && cfg.transactional()) {
                    if (this.configuration.transaction().transactionMode().isTransactional()) {
                        this.txWriters.add((TransactionalCacheWriter)writer);
                    } else {
                        this.nonTxWriters.add(writer);
                    }
                } else {
                    this.nonTxWriters.add(writer);
                }
                this.storeStatuses.put(writer, new StoreStatus(writer, cfg));
            }
            finally {
                this.storesMutex.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLoader(StoreConfiguration cfg, CacheLoader loader, InitializationContextImpl ctx) {
        if (loader != null) {
            if (loader instanceof DelegatingCacheLoader) {
                loader.init(ctx);
            }
            this.storesMutex.writeLock().lock();
            try {
                this.loaders.add(loader);
                this.storeStatuses.put(loader, new StoreStatus(loader, cfg));
            }
            finally {
                this.storesMutex.writeLock().unlock();
            }
        }
    }

    private void initializeBareInstance(Object instance, InitializationContextImpl ctx) {
        if (instance instanceof CacheWriter) {
            ((CacheWriter)instance).init(ctx);
        } else {
            ((CacheLoader)instance).init(ctx);
        }
    }

    private CacheLoader createCacheLoader(Object instance) {
        return instance instanceof CacheLoader ? (CacheLoader)instance : null;
    }

    private CacheWriter createCacheWriter(Object instance) {
        return instance instanceof CacheWriter ? (CacheWriter)instance : null;
    }

    protected AsyncCacheWriter createAsyncWriter(CacheWriter writer) {
        return writer instanceof AdvancedCacheWriter ? new AdvancedAsyncCacheWriter(writer) : new AsyncCacheWriter(writer);
    }

    private CacheLoader undelegate(CacheLoader l) {
        return l instanceof DelegatingCacheLoader ? ((DelegatingCacheLoader)l).undelegate() : l;
    }

    private CacheWriter undelegate(CacheWriter w) {
        return w instanceof DelegatingCacheWriter ? ((DelegatingCacheWriter)w).undelegate() : w;
    }

    private void startWriter(CacheWriter writer, Set<Lifecycle> undelegated) {
        this.startStore(writer.getClass().getName(), () -> {
            if (writer instanceof DelegatingCacheWriter) {
                CacheWriter actual = this.undelegate(writer);
                actual.start();
                undelegated.add(actual);
            } else {
                undelegated.add(writer);
            }
            writer.start();
            if (this.getStoreConfig(writer).purgeOnStartup()) {
                if (!(writer instanceof AdvancedCacheWriter)) {
                    throw new PersistenceException("'purgeOnStartup' can only be set on stores implementing " + AdvancedCacheWriter.class.getName());
                }
                ((AdvancedCacheWriter)writer).clear();
            }
        });
    }

    private void startLoader(CacheLoader loader, Set<Lifecycle> undelegated) {
        CacheLoader delegate = this.undelegate(loader);
        boolean startInstance = !undelegated.contains(loader);
        boolean startDelegate = loader instanceof DelegatingCacheLoader && !undelegated.contains(delegate);
        this.startStore(loader.getClass().getName(), () -> {
            if (startInstance) {
                loader.start();
            }
            if (startDelegate) {
                delegate.start();
            }
        });
    }

    private void startStore(String storeName, Runnable runnable) {
        int connectionAttempts = this.configuration.persistence().connectionAttempts();
        int connectionInterval = this.configuration.persistence().connectionInterval();
        for (int i = 0; i < connectionAttempts; ++i) {
            try {
                runnable.run();
                return;
            }
            catch (Exception e) {
                if (i + 1 < connectionAttempts) {
                    log.debugf("Exception encountered for store %s on startup attempt %d, retrying ...", storeName, i);
                    if (connectionInterval <= 0) continue;
                    try {
                        Thread.sleep(connectionInterval);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        log.debugf("Thread interrupted for store %s on startup attempt %d, cancelling ...", storeName, i);
                        return;
                    }
                }
                throw log.storeStartupAttemptsExceeded(storeName, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdvancedCache<Object, Object> getCacheForStateInsertion() {
        ArrayList<Flag> flags = new ArrayList<Flag>(Arrays.asList(Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK, Flag.IGNORE_RETURN_VALUES, Flag.SKIP_CACHE_STORE, Flag.SKIP_LOCKING, Flag.SKIP_XSITE_BACKUP));
        boolean hasShared = false;
        this.storesMutex.readLock().lock();
        try {
            for (CacheWriter w : this.nonTxWriters) {
                if (!this.getStoreConfig(w).shared()) continue;
                hasShared = true;
                break;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        if (hasShared) {
            if (this.indexShareable()) {
                flags.add(Flag.SKIP_INDEXING);
            }
        } else {
            flags.add(Flag.SKIP_INDEXING);
        }
        return this.cache.wired().withFlags(flags.toArray(new Flag[flags.size()]));
    }

    private boolean indexShareable() {
        return this.configuration.indexing().indexShareable();
    }

    private long getMaxEntries() {
        if (this.configuration.memory().isEvictionEnabled() && this.configuration.memory().evictionType() == EvictionType.COUNT) {
            return this.configuration.memory().size();
        }
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadKey(AdvancedCache<Object, Object> cache, Object key, Object value, Metadata metadata) {
        Transaction transaction = this.suspendIfNeeded();
        boolean success = false;
        try {
            try {
                this.beginIfNeeded();
                cache.put(key, value, metadata);
                success = true;
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to preload!", e);
            }
            finally {
                this.commitIfNeeded(success);
            }
        }
        finally {
            this.resumeIfNeeded(transaction);
        }
    }

    private void resumeIfNeeded(Transaction transaction) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null && transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private Transaction suspendIfNeeded() {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                return this.transactionManager.suspend();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
        return null;
    }

    private void beginIfNeeded() {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                this.transactionManager.begin();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private void commitIfNeeded(boolean success) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                if (success) {
                    this.transactionManager.commit();
                } else {
                    this.transactionManager.rollback();
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    public StreamingMarshaller getMarshaller() {
        return this.m;
    }

    private void removeCacheLoader(String storeType, Collection<CacheLoader> collection) {
        Iterator<CacheLoader> it = collection.iterator();
        while (it.hasNext()) {
            CacheLoader loader = it.next();
            this.doRemove(it, storeType, loader, this.undelegate(loader));
        }
    }

    private void removeCacheWriter(String storeType, Collection<? extends CacheWriter> collection) {
        Iterator<? extends CacheWriter> it = collection.iterator();
        while (it.hasNext()) {
            CacheWriter writer = it.next();
            this.doRemove(it, storeType, writer, this.undelegate(writer));
        }
    }

    private void doRemove(Iterator<? extends Lifecycle> it, String storeType, Lifecycle wrapper, Lifecycle actual) {
        if (actual.getClass().getName().equals(storeType)) {
            wrapper.stop();
            if (actual != wrapper) {
                actual.stop();
            }
            it.remove();
            this.storeStatuses.remove(wrapper);
        }
    }

    private void performOnAllTxStores(Predicate<? super StoreConfiguration> predicate, Consumer<TransactionalCacheWriter> action) {
        this.storesMutex.readLock().lock();
        try {
            this.checkStoreAvailability();
            this.txWriters.stream().filter(writer -> predicate.test(this.getStoreConfig(writer))).forEach(action);
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreConfiguration getStoreConfig(Object store) {
        this.storesMutex.readLock().lock();
        try {
            StoreStatus status = this.storeStatuses.get(store);
            StoreConfiguration storeConfiguration = status == null ? null : status.config;
            return storeConfiguration;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    class StoreStatus {
        final Object store;
        final StoreConfiguration config;
        volatile boolean availability = true;

        StoreStatus(Object store, StoreConfiguration config) {
            this.store = store;
            this.config = config;
        }

        boolean availabilityChanged() {
            boolean oldAvailability = this.availability;
            try {
                this.availability = this.store instanceof CacheWriter ? ((CacheWriter)this.store).isAvailable() : ((CacheLoader)this.store).isAvailable();
            }
            catch (Throwable t) {
                log.debugf("Error encountered when calling isAvailable on %s: %s", this.store, t);
                this.availability = false;
            }
            return oldAvailability != this.availability;
        }
    }

    private static class AdvancedPurgeListener<K, V>
    implements AdvancedCacheExpirationWriter.ExpirationPurgeListener<K, V> {
        private final InternalExpirationManager<K, V> expirationManager;

        private AdvancedPurgeListener(InternalExpirationManager<K, V> expirationManager) {
            this.expirationManager = expirationManager;
        }

        @Override
        public void marshalledEntryPurged(MarshalledEntry<K, V> entry) {
            this.expirationManager.handleInStoreExpiration(entry);
        }

        @Override
        public void entryPurged(K key) {
            this.expirationManager.handleInStoreExpiration(key);
        }
    }
}

