/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.DelegatingMessageFactory;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.NegotiationMessage;

public abstract class MessageFactory {
    private static final Logger log = Logger.getLogger(MessageFactory.class);
    private static final String NTLM_MESSAGE_FACTORY_NAME = "org.jboss.security.negotiation.ntlm.NTLMMessageFactory";
    private static final String SPNEGO_MESSAGE_FACTORY_NAME = "org.jboss.security.negotiation.spnego.SPNEGOMessageFactory";
    private static final String KERBEROS_MESSAGE_FACTORY_NAME = "org.jboss.security.negotiation.spnego.KerberosMessageFactory";
    private static final Class<MessageFactory> NTLM_MESSAGE_FACTORY = MessageFactory.loadClass("org.jboss.security.negotiation.ntlm.NTLMMessageFactory");
    private static final Class<MessageFactory> SPNEGO_MESSAGE_FACTORY = MessageFactory.loadClass("org.jboss.security.negotiation.spnego.SPNEGOMessageFactory");
    private static final Class<MessageFactory> KERBEROS_MESSAGE_FACTORY = MessageFactory.loadClass("org.jboss.security.negotiation.spnego.KerberosMessageFactory");

    private static Class<MessageFactory> loadClass(String classname) {
        Class<MessageFactory> clazz;
        block4: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = null;
            try {
                clazz = classLoader.loadClass(classname);
            }
            catch (Exception e) {
                try {
                    classLoader = MessageFactory.class.getClassLoader();
                    clazz = classLoader.loadClass(classname);
                }
                catch (Exception e2) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace((Object)("Unable to load class '" + classname + "'"), (Throwable)e2);
                }
            }
        }
        return clazz;
    }

    public static MessageFactory newInstance() throws NegotiationException {
        MessageFactory ntlm = MessageFactory.newInstance(NTLM_MESSAGE_FACTORY);
        MessageFactory spnego = MessageFactory.newInstance(SPNEGO_MESSAGE_FACTORY);
        MessageFactory kerberos = MessageFactory.newInstance(KERBEROS_MESSAGE_FACTORY);
        ArrayList<MessageFactory> delegates = new ArrayList<MessageFactory>(3);
        if (ntlm != null) {
            delegates.add(ntlm);
        }
        if (spnego != null) {
            delegates.add(spnego);
        }
        if (kerberos != null) {
            delegates.add(kerberos);
        }
        if (delegates.size() == 1) {
            return (MessageFactory)delegates.get(0);
        }
        if (delegates.size() > 1) {
            return new DelegatingMessageFactory(delegates);
        }
        throw new IllegalStateException("No MessageFactories available to instantiate");
    }

    private static MessageFactory newInstance(Class<MessageFactory> clazz) throws NegotiationException {
        MessageFactory response = null;
        if (clazz != null) {
            try {
                response = clazz.newInstance();
            }
            catch (Exception e) {
                throw new NegotiationException("Unable to instantiate '" + clazz.getName() + "'", e);
            }
        }
        return response;
    }

    public abstract boolean accepts(InputStream var1) throws IOException;

    public abstract NegotiationMessage createMessage(InputStream var1) throws IOException;
}

