/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.AbstractTableManager;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.util.logging.LogFactory;

class SQLiteTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(SQLiteTableManager.class, Log.class);

    SQLiteTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    @Override
    public boolean isUpsertSupported() {
        return super.isUpsertSupported() && (this.metaData.getMajorVersion() >= 4 || this.metaData.getMajorVersion() >= 3 && this.metaData.getMinorVersion() >= 9);
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = this.metaData.isSegmentedDisabled() ? String.format("INSERT OR REPLACE INTO %s (%s, %s, %s) VALUES (?, ?, ?)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName()) : String.format("INSERT OR REPLACE INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
        }
        return this.upsertRowSql;
    }
}

