/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.query.dsl.impl.AbstractFacet;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.facet.Facet;

public class DiscreteFacetRequest
extends FacetingRequestImpl {
    DiscreteFacetRequest(String name, String fieldName) {
        super(name, fieldName);
    }

    @Override
    public Class<?> getFacetValueType() {
        return String[].class;
    }

    @Override
    public Facet createFacet(FacetMetadata facetMetadata, String value, int count) {
        return new SimpleFacet(this.getFacetingName(), this.getFieldName(), facetMetadata.getSourceField().getAbsoluteName(), value, count);
    }

    static class SimpleFacet
    extends AbstractFacet {
        SimpleFacet(String facetingName, String facetFieldName, String sourceFieldName, String value, int count) {
            super(facetingName, facetFieldName, sourceFieldName, value, count);
        }

        @Override
        public Query getFacetQuery() {
            return new TermQuery(new Term(this.getSourceFieldName(), this.getValue()));
        }
    }
}

