/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public class PingOperation
extends HotRodOperation<PingResult>
implements ChannelOperation {
    private static final Log log = LogFactory.getLog(PingOperation.class);
    private static final boolean trace = log.isTraceEnabled();
    private final boolean releaseChannel;

    public PingOperation(Codec codec, AtomicInteger topologyId, Configuration cfg, byte[] cacheName, ChannelFactory channelFactory, boolean releaseChannel) {
        super((short)23, (short)24, codec, 0, cfg, cacheName, topologyId, channelFactory);
        this.releaseChannel = releaseChannel;
    }

    @Override
    public void invoke(Channel channel) {
        this.sendHeaderAndRead(channel);
        if (this.releaseChannel) {
            this.releaseChannel(channel);
        }
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }

    @Override
    public CompletableFuture<PingResult> execute() {
        throw new UnsupportedOperationException("Cannot execute directly");
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (!HotRodConstants.isSuccess(status)) {
            String hexStatus = Integer.toHexString(status);
            if (trace) {
                log.tracef("Unknown response status: %s", hexStatus);
            }
            throw new InvalidResponseException("Unexpected response status: " + hexStatus);
        }
        this.complete(HotRodConstants.hasCompatibility(status) ? PingResult.SUCCESS_WITH_COMPAT : PingResult.SUCCESS);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof HotRodClientException && cause.getMessage().contains("CacheNotFoundException")) {
            this.complete(PingResult.CACHE_DOES_NOT_EXIST);
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    public static enum PingResult {
        SUCCESS,
        SUCCESS_WITH_COMPAT,
        CACHE_DOES_NOT_EXIST,
        FAIL;


        public boolean isSuccess() {
            return this == SUCCESS || this == SUCCESS_WITH_COMPAT;
        }

        public boolean hasCompatibility() {
            return this == SUCCESS_WITH_COMPAT;
        }
    }
}

