/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.group.Node;

public class LocalCommandDispatcher<C>
implements CommandDispatcher<C> {
    private final C context;
    private final Node node;
    private final Executor executor;

    public LocalCommandDispatcher(Node node, C context, Executor executor) {
        this.node = node;
        this.context = context;
        this.executor = executor;
    }

    public C getContext() {
        return this.context;
    }

    public <R> CompletionStage<R> executeOnMember(Command<R, ? super C> command, Node member) throws CommandDispatcherException {
        if (!this.node.equals(this.node)) {
            throw new IllegalArgumentException(member.getName());
        }
        return CompletableFuture.supplyAsync(new CommandTask<R, C>(command, this.context), this.executor);
    }

    public <R> Map<Node, CompletionStage<R>> executeOnGroup(Command<R, ? super C> command, Node ... excludedMembers) throws CommandDispatcherException {
        if (excludedMembers != null && Arrays.asList(excludedMembers).contains(this.node)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.node, this.executeOnMember(command, this.node));
    }

    public void close() {
    }

    private static class CommandTask<R, C>
    implements Supplier<R> {
        private final C context;
        private final Command<R, C> command;

        CommandTask(Command<R, C> command, C context) {
            this.command = command;
            this.context = context;
        }

        @Override
        public R get() {
            try {
                return (R)this.command.execute(this.context);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }
    }
}

