/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.action.ActionListener;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.remoting.inboundhandler.action.BaseLockingAction;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.locks.PendingLockListener;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.concurrent.locks.PendingLockPromise;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;

public class PendingTxAction
extends BaseLockingAction
implements PendingLockListener {
    private final PendingLockManager pendingLockManager;
    private final CompletableFuture<Void> notifier;
    private volatile PendingLockPromise pendingLockPromise;

    public PendingTxAction(PendingLockManager pendingLockManager, ClusteringDependentLogic clusteringDependentLogic) {
        super(clusteringDependentLogic);
        this.pendingLockManager = pendingLockManager;
        this.notifier = new CompletableFuture();
    }

    @Override
    protected ActionStatus checking(ActionState state) {
        PendingLockPromise promise = this.pendingLockPromise;
        if (promise != null && promise.isReady() && this.cas(BaseLockingAction.InternalState.CHECKING, BaseLockingAction.InternalState.MAKE_READY)) {
            if (promise.hasTimedOut()) {
                this.cas(BaseLockingAction.InternalState.MAKE_READY, BaseLockingAction.InternalState.CANCELED);
                return ActionStatus.CANCELED;
            }
            state.updateTimeout(promise.getRemainingTimeout());
            this.cas(BaseLockingAction.InternalState.MAKE_READY, BaseLockingAction.InternalState.READY);
            return ActionStatus.READY;
        }
        return ActionStatus.NOT_READY;
    }

    @Override
    protected ActionStatus init(ActionState state) {
        PendingLockPromise promise;
        if (!this.cas(BaseLockingAction.InternalState.INIT, BaseLockingAction.InternalState.CHECKING)) {
            return ActionStatus.NOT_READY;
        }
        TxInvocationContext<?> context = this.createContext(state);
        if (context == null) {
            this.cas(BaseLockingAction.InternalState.CHECKING, BaseLockingAction.InternalState.CANCELED);
            return ActionStatus.CANCELED;
        }
        long timeout = state.getTimeout();
        List<Object> keysToLock = this.getAndUpdateFilteredKeys(state);
        if (keysToLock.isEmpty()) {
            this.cas(BaseLockingAction.InternalState.CHECKING, BaseLockingAction.InternalState.READY);
            return ActionStatus.READY;
        }
        RemoteLockCommand command = (RemoteLockCommand)state.getCommand();
        if (command instanceof PrepareCommand && ((PrepareCommand)command).isRetriedCommand()) {
            ((AbstractCacheTransaction)context.getCacheTransaction()).cleanupBackupLocks();
            keysToLock.removeAll(context.getLockedKeys());
        }
        if (command instanceof LockControlCommand) {
            ((AbstractCacheTransaction)context.getCacheTransaction()).removeBackupLocks(((LockControlCommand)command).getKeys());
            keysToLock.removeAll(context.getLockedKeys());
        }
        PendingLockPromise pendingLockPromise = promise = keysToLock.size() == 1 ? this.pendingLockManager.checkPendingTransactionsForKey(context, keysToLock.get(0), timeout, TimeUnit.MILLISECONDS) : this.pendingLockManager.checkPendingTransactionsForKeys(context, keysToLock, timeout, TimeUnit.MILLISECONDS);
        if (promise.isReady()) {
            this.cas(BaseLockingAction.InternalState.CHECKING, BaseLockingAction.InternalState.READY);
            return ActionStatus.READY;
        }
        this.pendingLockPromise = promise;
        if (!promise.isReady()) {
            promise.addListener(this);
        }
        return this.check(state);
    }

    @Override
    public void addListener(ActionListener listener) {
        this.notifier.thenRun(listener::onComplete);
    }

    @Override
    public void onReady() {
        this.notifier.complete(null);
    }

    private TxInvocationContext<?> createContext(ActionState state) {
        RemoteLockCommand command = (RemoteLockCommand)state.getCommand();
        if (command instanceof TransactionalRemoteLockCommand) {
            return ((TransactionalRemoteLockCommand)command).createContext();
        }
        return null;
    }
}

